/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.marshal;

import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.UnicodeValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.expr.Expr;
import com.caucho.quercus.marshal.Marshal;

public class UnicodeValueMarshal
extends Marshal {
    public static final Marshal MARSHAL = new UnicodeValueMarshal();

    public boolean isReadOnly() {
        return true;
    }

    public boolean isValue() {
        return true;
    }

    public Object marshal(Env env, Expr expr, Class expectedClass) {
        return expr.eval(env).toUnicodeValue(env);
    }

    public Object marshal(Env env, Value value, Class expectedClass) {
        return value.toUnicodeValue(env);
    }

    public Value unmarshal(Env env, Object value) {
        if (value instanceof UnicodeValue) {
            return (UnicodeValue)value;
        }
        if (value instanceof Value) {
            return ((Value)value).toUnicodeValue(env);
        }
        return env.createString(String.valueOf(value));
    }

    protected int getMarshalingCostImpl(Value argValue) {
        return argValue.toUnicodeValueMarshalCost();
    }

    public Class getExpectedClass() {
        return UnicodeValue.class;
    }
}

