/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.program;

import com.caucho.quercus.Location;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.FieldVisibility;
import com.caucho.quercus.env.ObjectValue;
import com.caucho.quercus.env.QuercusClass;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.env.Var;
import com.caucho.quercus.expr.Expr;
import com.caucho.quercus.function.AbstractFunction;
import com.caucho.quercus.program.ClassDef;
import com.caucho.quercus.program.ClassField;
import com.caucho.quercus.program.Function;
import com.caucho.quercus.program.InstanceInitializer;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InterpretedClassDef
extends ClassDef
implements InstanceInitializer {
    protected boolean _isAbstract;
    protected boolean _isInterface;
    protected boolean _isTrait;
    protected boolean _isFinal;
    protected boolean _hasPublicMethods;
    protected boolean _hasProtectedMethods;
    protected boolean _hasPrivateMethods;
    private boolean _isTopScope;
    protected final HashMap<StringValue, AbstractFunction> _functionMap = new HashMap();
    protected final LinkedHashMap<StringValue, ClassField> _fieldMap = new LinkedHashMap();
    protected final LinkedHashMap<StringValue, ClassDef.StaticFieldEntry> _staticFieldMap = new LinkedHashMap();
    protected final HashMap<StringValue, Expr> _constMap = new HashMap();
    protected AbstractFunction _constructor;
    protected AbstractFunction _destructor;
    protected AbstractFunction _getField;
    protected AbstractFunction _setField;
    protected AbstractFunction _isset;
    protected AbstractFunction _unset;
    protected AbstractFunction _call;
    protected AbstractFunction _callStatic;
    protected AbstractFunction _invoke;
    protected AbstractFunction _toString;
    protected int _parseIndex;
    protected String _comment;

    public InterpretedClassDef(Location location, String name, String parentName, String[] ifaceList, int index) {
        this(location, name, parentName, ifaceList, ClassDef.NULL_STRING_ARRAY, index);
    }

    public InterpretedClassDef(Location location, String name, String parentName, String[] ifaceList, String[] traitList, int index) {
        super(location, name, parentName, ifaceList, traitList);
        this._parseIndex = index;
    }

    public InterpretedClassDef(String name, String parentName, String[] ifaceList, String[] traitList) {
        this(null, name, parentName, ifaceList, traitList, 0);
    }

    public InterpretedClassDef(String name, String parentName, String[] ifaceList) {
        this(null, name, parentName, ifaceList, ClassDef.NULL_STRING_ARRAY, 0);
    }

    public void setAbstract(boolean isAbstract) {
        this._isAbstract = isAbstract;
    }

    @Override
    public boolean isAbstract() {
        return this._isAbstract;
    }

    public void setInterface(boolean isInterface) {
        this._isInterface = isInterface;
    }

    @Override
    public boolean isInterface() {
        return this._isInterface;
    }

    public void setTrait(boolean isTrait) {
        this._isTrait = isTrait;
    }

    @Override
    public boolean isTrait() {
        return this._isTrait;
    }

    public void setFinal(boolean isFinal) {
        this._isFinal = isFinal;
    }

    @Override
    public boolean isFinal() {
        return this._isFinal;
    }

    public boolean hasPublicMethods() {
        return this._hasPublicMethods;
    }

    public boolean hasProtectedMethods() {
        return this._hasProtectedMethods;
    }

    public boolean hasPrivateMethods() {
        return this._hasPrivateMethods;
    }

    public boolean isTopScope() {
        return this._isTopScope;
    }

    public void setTopScope(boolean isTopScope) {
        this._isTopScope = isTopScope;
    }

    public String getCompilationName() {
        String name = this.getName();
        name = name.replace("__", "___");
        name = name.replace("\\", "__");
        return name + "_" + this._parseIndex;
    }

    public String getCompilationInstanceName() {
        return "q_cl_" + this.getCompilationName();
    }

    @Override
    public void initClassMethods(QuercusClass cl, String bindingClassName) {
        cl.addInitializer(this);
        if (this._constructor != null) {
            cl.setConstructor(this._constructor);
        }
        if (this._destructor != null) {
            cl.setDestructor(this._destructor);
            cl.addMethod(cl.getModuleContext().createString("__destruct"), this._destructor);
        }
        if (this._getField != null) {
            cl.setFieldGet(this._getField);
        }
        if (this._setField != null) {
            cl.setFieldSet(this._setField);
        }
        if (this._call != null) {
            cl.setCall(this._call);
        }
        if (this._callStatic != null) {
            cl.setCallStatic(this._callStatic);
        }
        if (this._invoke != null) {
            cl.setInvoke(this._invoke);
        }
        if (this._toString != null) {
            cl.setToString(this._toString);
        }
        if (this._isset != null) {
            cl.setIsset(this._isset);
        }
        if (this._unset != null) {
            cl.setUnset(this._unset);
        }
        for (Map.Entry<StringValue, AbstractFunction> entry : this._functionMap.entrySet()) {
            StringValue funName = entry.getKey();
            AbstractFunction fun = entry.getValue();
            if (fun.isTraitMethod()) {
                cl.addTraitMethod(bindingClassName, funName, fun);
                continue;
            }
            cl.addMethod(funName, fun);
        }
    }

    @Override
    public void initClassFields(QuercusClass cl, String declaringClassName) {
        Object field;
        if (this.isTrait()) {
            for (Map.Entry<StringValue, ClassField> entry : this._fieldMap.entrySet()) {
                field = entry.getValue();
                cl.addTraitField((ClassField)field);
            }
        } else {
            for (Map.Entry<StringValue, ClassField> entry : this._fieldMap.entrySet()) {
                field = entry.getValue();
                cl.addField((ClassField)field);
            }
        }
        if (this.isTrait()) {
            for (Map.Entry<StringValue, Object> entry : this._staticFieldMap.entrySet()) {
                field = (ClassDef.StaticFieldEntry)entry.getValue();
                cl.addStaticTraitFieldExpr(declaringClassName, entry.getKey(), ((ClassDef.StaticFieldEntry)field).getValue());
            }
        } else {
            String className = this.getName();
            for (Map.Entry<StringValue, ClassDef.StaticFieldEntry> entry : this._staticFieldMap.entrySet()) {
                ClassDef.StaticFieldEntry field2 = entry.getValue();
                cl.addStaticFieldExpr(className, entry.getKey(), field2.getValue());
            }
        }
        for (Map.Entry<StringValue, Object> entry : this._constMap.entrySet()) {
            cl.addConstant(entry.getKey(), (Expr)entry.getValue());
        }
    }

    public void setConstructor(AbstractFunction fun) {
        this._constructor = fun;
    }

    @Override
    public AbstractFunction getCall() {
        return this._call;
    }

    @Override
    public AbstractFunction getCallStatic() {
        return this._callStatic;
    }

    public void addFunction(StringValue name, Function fun) {
        this._functionMap.put(name, fun);
        if (fun.isPublic()) {
            this._hasPublicMethods = true;
        }
        if (fun.isProtected()) {
            this._hasProtectedMethods = true;
        }
        if (fun.isPrivate()) {
            this._hasPrivateMethods = true;
        }
        if (name.equalsString("__construct")) {
            this._constructor = fun;
        } else if (name.equalsString("__destruct")) {
            this._destructor = fun;
        } else if (name.equalsString("__get")) {
            this._getField = fun;
        } else if (name.equalsString("__set")) {
            this._setField = fun;
        } else if (name.equalsString("__call")) {
            this._call = fun;
        } else if (name.equalsString("__callStatic")) {
            this._callStatic = fun;
        } else if (name.equalsString("__invoke")) {
            this._invoke = fun;
        } else if (name.equalsString("__toString")) {
            this._toString = fun;
        } else if (name.equalsString("__isset")) {
            this._isset = fun;
        } else if (name.equalsString("__unset")) {
            this._unset = fun;
        } else if (name.equalsStringIgnoreCase(this.getName()) && this._constructor == null) {
            this._constructor = fun;
        }
    }

    public void addStaticValue(Value name, Expr value) {
        this._staticFieldMap.put(name.toStringValue(), new ClassDef.StaticFieldEntry(value));
    }

    public void addStaticValue(Value name, Expr value, String comment) {
        this._staticFieldMap.put(name.toStringValue(), new ClassDef.StaticFieldEntry(value, comment));
    }

    public void addConstant(StringValue name, Expr value) {
        this._constMap.put(name, value);
    }

    @Override
    public Expr findConstant(String name) {
        return this._constMap.get(name);
    }

    public void addClassField(StringValue name, Expr value, FieldVisibility visibility, String comment) {
        ClassField field = new ClassField(name, this.getName(), value, visibility, comment, this.isTrait());
        this._fieldMap.put(name, field);
    }

    public ClassField getClassField(StringValue name) {
        ClassField field = this._fieldMap.get(name);
        return field;
    }

    public boolean isDeclaredField(StringValue name) {
        return this._fieldMap.get(name) != null;
    }

    public void init(Env env) {
        QuercusClass qClass = env.getClass(this.getName());
        for (Map.Entry<StringValue, ClassDef.StaticFieldEntry> entry : this._staticFieldMap.entrySet()) {
            StringValue name = entry.getKey();
            ClassDef.StaticFieldEntry field = entry.getValue();
            Var var = qClass.getStaticFieldVar(env, name);
            var.set(field.getValue().eval(env).copy());
        }
    }

    @Override
    public void initInstance(Env env, Value value) {
        ObjectValue object = (ObjectValue)value;
        for (Map.Entry<StringValue, ClassField> entry : this._fieldMap.entrySet()) {
            ClassField field = entry.getValue();
            object.initField(env, field);
        }
        if (this._destructor != null) {
            env.addObjectCleanup(object);
        }
    }

    @Override
    public AbstractFunction findConstructor() {
        return this._constructor;
    }

    public void setComment(String comment) {
        this._comment = comment;
    }

    @Override
    public String getComment() {
        return this._comment;
    }

    @Override
    public String getFieldComment(StringValue name) {
        ClassField field = this._fieldMap.get(name);
        if (field != null) {
            return field.getComment();
        }
        return null;
    }

    @Override
    public String getStaticFieldComment(StringValue name) {
        ClassDef.StaticFieldEntry field = this._staticFieldMap.get(name);
        if (field != null) {
            return field.getComment();
        }
        return null;
    }

    @Override
    public Set<Map.Entry<StringValue, ClassField>> fieldSet() {
        return this._fieldMap.entrySet();
    }

    public ClassField getField(StringValue name) {
        return this._fieldMap.get(name);
    }

    @Override
    public Set<Map.Entry<StringValue, ClassDef.StaticFieldEntry>> staticFieldSet() {
        return this._staticFieldMap.entrySet();
    }

    @Override
    public Set<Map.Entry<StringValue, AbstractFunction>> functionSet() {
        return this._functionMap.entrySet();
    }

    public AbstractFunction getFunction(StringValue name) {
        return this._functionMap.get(name);
    }

    public HashMap<StringValue, AbstractFunction> getFunctionMap() {
        return this._functionMap;
    }
}

