/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.util;

import com.caucho.util.CacheListener;
import com.caucho.util.LruListener;
import com.caucho.util.Primes;
import com.caucho.util.SyncCacheListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicBoolean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LruCache<K, V> {
    private static final Object NULL = new Object();
    private static final Object MISMATCH = new Object();
    private int _capacity;
    private int _capacity1;
    private final CacheItem<K, V>[] _entries;
    private final Object[] _locks;
    private int _prime;
    private boolean _isEnableListeners = true;
    private final Object _lruLock = new Object();
    private int _size1;
    private CacheItem<K, V> _head1;
    private CacheItem<K, V> _tail1;
    private int _size2;
    private CacheItem<K, V> _head2;
    private CacheItem<K, V> _tail2;
    private final int _lruTimeout;
    private final AtomicBoolean _isLruTailRemove = new AtomicBoolean();
    private volatile int _lruCounter;
    private boolean _isEnableStatistics;
    private volatile long _hitCount;
    private volatile long _missCount;

    public LruCache(int initialCapacity) {
        this(initialCapacity, false);
    }

    public LruCache(int initialCapacity, boolean isStatistics) {
        int capacity;
        for (capacity = 16; capacity < 2 * initialCapacity; capacity *= 2) {
        }
        this._entries = new CacheItem[capacity];
        this._prime = Primes.getBiggestPrime(this._entries.length);
        this._locks = new Object[(this._entries.length >> 3) + 1];
        for (int i = 0; i < this._locks.length; ++i) {
            this._locks[i] = new Object();
        }
        this._capacity = initialCapacity;
        this._capacity1 = this._capacity / 2;
        this._lruTimeout = this._capacity > 32 ? this._capacity / 8 : 1;
        this._isEnableStatistics = isStatistics;
    }

    public void setEnableListeners(boolean isEnable) {
        this._isEnableListeners = isEnable;
    }

    public void setEnableStatistics(boolean isEnable) {
        this._isEnableStatistics = isEnable;
    }

    public int size() {
        return this._size1 + this._size2;
    }

    public int getCapacity() {
        return this._capacity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        int i;
        if (this._size1 == 0 && this._size2 == 0) {
            return;
        }
        ArrayList<CacheListener> listeners = null;
        for (i = this._entries.length - 1; i >= 0; --i) {
            Object lock;
            Object object = lock = this.getLock(i);
            synchronized (object) {
                CacheItem<K, V> item = this._entries[i];
                this._entries[i] = null;
                if (this._isEnableListeners) {
                    while (item != null) {
                        this.removeLruItem(item);
                        if (item._value instanceof CacheListener) {
                            if (listeners == null) {
                                listeners = new ArrayList<CacheListener>();
                            }
                            listeners.add((CacheListener)item._value);
                        }
                        item = item._nextHash;
                    }
                }
                continue;
            }
        }
        int n = i = listeners != null ? listeners.size() - 1 : -1;
        while (i >= 0) {
            CacheListener listener = (CacheListener)listeners.get(i);
            listener.removeEvent();
            --i;
        }
    }

    public V get(K key) {
        Object okey = key;
        if (okey == null) {
            okey = NULL;
        }
        int hash = (okey.hashCode() & Integer.MAX_VALUE) % this._prime;
        CacheItem<K, V> item = this._entries[hash];
        while (item != null) {
            Object itemKey = item._key;
            if (itemKey == okey || itemKey.equals(okey)) {
                this.updateLru(item);
                if (this._isEnableStatistics) {
                    ++this._hitCount;
                }
                return item._value;
            }
            item = item._nextHash;
        }
        if (this._isEnableStatistics) {
            ++this._missCount;
        }
        return null;
    }

    public V put(K key, V value) {
        V oldValue = this.compareAndPut(null, key, value, false);
        return oldValue;
    }

    public V putIfNew(K key, V value) {
        V oldValue = this.compareAndPut(null, key, value, true);
        if (oldValue != null) {
            return oldValue;
        }
        return value;
    }

    public boolean compareAndPut(V testValue, K key, V value) {
        V result = this.compareAndPut(testValue, key, value, true);
        return testValue == result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private V compareAndPut(V testValue, K key, V value, boolean isCompare) {
        Object lock;
        Object okey = key;
        if (okey == null) {
            okey = NULL;
        }
        this.removeLru();
        int hash = (okey.hashCode() & Integer.MAX_VALUE) % this._prime;
        Object oldValue = null;
        Object object = lock = this.getLock(hash);
        synchronized (object) {
            CacheItem<Object, V> item = this._entries[hash];
            while (item != null) {
                if (okey == item._key || okey.equals(item._key)) {
                    this.updateLru(item);
                    oldValue = item._value;
                    if (isCompare && testValue != oldValue) {
                        return oldValue;
                    }
                    item._value = value;
                    if (value != oldValue) break;
                    oldValue = null;
                    break;
                }
                item = item._nextHash;
            }
            if (isCompare && testValue != oldValue) {
                return null;
            }
            if (item == null) {
                CacheItem<K, V> next = this._entries[hash];
                item = new CacheItem<Object, V>(okey, value);
                Object object2 = this._lruLock;
                synchronized (object2) {
                    assert (item._hitCount == 1);
                    this._lruCounter = this._lruCounter + 1 & 0x3FFFFFFF;
                    ++this._size1;
                    item._lruCounter = -(this._lruTimeout + 16);
                    item._nextLru = this._head1;
                    if (this._head1 != null) {
                        this._head1._prevLru = item;
                    }
                    this._head1 = item;
                    if (this._tail1 == null) {
                        this._tail1 = item;
                    }
                }
                item._nextHash = next;
                this._entries[hash] = item;
                return null;
            }
            if (this._isEnableListeners && oldValue instanceof SyncCacheListener) {
                ((SyncCacheListener)oldValue).syncRemoveEvent();
            }
        }
        if (this._isEnableListeners && oldValue instanceof CacheListener) {
            ((CacheListener)oldValue).removeEvent();
        }
        return oldValue;
    }

    private void updateLru(CacheItem<K, V> item) {
        long lruCounter = this._lruCounter;
        long itemCounter = item._lruCounter;
        long delta = lruCounter - itemCounter & 0x3FFFFFFFL;
        if ((long)this._lruTimeout < delta || delta < 0L) {
            this.updateLruImpl(item);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateLruImpl(CacheItem<K, V> item) {
        Object object = this._lruLock;
        synchronized (object) {
            item._lruCounter = this._lruCounter = this._lruCounter + 1 & 0x3FFFFFFF;
            CacheItem prevLru = item._prevLru;
            CacheItem nextLru = item._nextLru;
            if (item._hitCount <= 0) {
                return;
            }
            if (item._hitCount++ == 1) {
                item._prevLru = null;
                item._nextLru = this._head2;
                if (prevLru != null) {
                    prevLru._nextLru = nextLru;
                } else {
                    assert (this._head1 == item);
                    this._head1 = nextLru;
                }
                if (nextLru != null) {
                    nextLru._prevLru = prevLru;
                } else {
                    assert (this._tail1 == item);
                    this._tail1 = prevLru;
                }
                if (this._head2 != null) {
                    this._head2._prevLru = item;
                } else {
                    assert (this._tail2 == null);
                    this._tail2 = item;
                }
                this._head2 = item;
                --this._size1;
                ++this._size2;
            } else {
                assert (item._hitCount > 1);
                if (item == this._head2) {
                    return;
                }
                item._prevLru = null;
                item._nextLru = this._head2;
                prevLru._nextLru = nextLru;
                this._head2._prevLru = item;
                this._head2 = item;
                if (nextLru != null) {
                    nextLru._prevLru = prevLru;
                } else {
                    assert (this._tail2 == item);
                    this._tail2 = prevLru;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeLru() {
        int overflow = this._size1 + this._size2 - this._capacity;
        if (overflow >= 0 && this._isLruTailRemove.compareAndSet(false, true)) {
            try {
                while (overflow >= 0 && this.removeTail()) {
                    --overflow;
                }
                Object var3_2 = null;
                this._isLruTailRemove.set(false);
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                this._isLruTailRemove.set(false);
                throw throwable;
            }
        }
    }

    public boolean removeTail() {
        CacheItem<K, V> tail = null;
        if (this._capacity1 <= this._size1) {
            tail = this._tail1;
        }
        if (tail == null && (tail = this._tail2) == null && (tail = this._tail1) == null) {
            return false;
        }
        Object oldValue = tail._value;
        if (oldValue instanceof LruListener) {
            ((LruListener)oldValue).lruEvent();
        }
        V value = this.remove(tail._key);
        return true;
    }

    public boolean removeLongestTail() {
        CacheItem<K, V> tail = this._size1 <= this._size2 ? this._tail2 : this._tail1;
        if (tail == null) {
            return false;
        }
        Object oldValue = tail._value;
        if (oldValue instanceof LruListener) {
            ((LruListener)oldValue).lruEvent();
        }
        V value = this.remove(tail._key);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V remove(K key) {
        Object okey = key;
        if (okey == null) {
            okey = NULL;
        }
        int hash = (okey.hashCode() & Integer.MAX_VALUE) % this._prime;
        Object lock = this.getLock(hash);
        V value = null;
        Object object = lock;
        synchronized (object) {
            CacheItem<K, V> prevItem = null;
            CacheItem<K, V> item = this._entries[hash];
            while (item != null) {
                if (item._key == okey || item._key.equals(okey)) {
                    this.removeLruItem(item);
                    CacheItem nextHash = item._nextHash;
                    if (prevItem != null) {
                        prevItem._nextHash = nextHash;
                    } else {
                        assert (this._entries[hash] == item);
                        this._entries[hash] = nextHash;
                    }
                    value = item._value;
                    break;
                }
                prevItem = item;
                item = item._nextHash;
            }
            if (this._isEnableListeners && value instanceof SyncCacheListener) {
                ((SyncCacheListener)value).syncRemoveEvent();
            }
        }
        if (this._isEnableListeners && value instanceof CacheListener) {
            ((CacheListener)value).removeEvent();
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeLruItem(CacheItem<K, V> item) {
        Object object = this._lruLock;
        synchronized (object) {
            this._lruCounter = this._lruCounter + 1 & 0x3FFFFFFF;
            CacheItem prevLru = item._prevLru;
            CacheItem nextLru = item._nextLru;
            item._prevLru = null;
            item._nextLru = null;
            int hitCount = item._hitCount;
            item._hitCount = -1;
            if (hitCount <= 0) {
                return;
            }
            if (hitCount == 1) {
                --this._size1;
                if (prevLru != null) {
                    prevLru._nextLru = nextLru;
                } else {
                    assert (this._head1 == item);
                    this._head1 = nextLru;
                }
                if (nextLru != null) {
                    nextLru._prevLru = prevLru;
                } else {
                    assert (this._tail1 == item);
                    this._tail1 = prevLru;
                }
            } else {
                --this._size2;
                if (prevLru != null) {
                    prevLru._nextLru = nextLru;
                } else {
                    assert (this._head2 == item);
                    this._head2 = nextLru;
                }
                if (nextLru != null) {
                    nextLru._prevLru = prevLru;
                } else {
                    assert (this._tail2 == item);
                    this._tail2 = prevLru;
                }
            }
        }
    }

    private Object getLock(int hash) {
        return this._locks[hash >> 3];
    }

    public Iterator<K> keys() {
        KeyIterator iter = new KeyIterator(this);
        iter.init(this);
        return iter;
    }

    public Iterator<K> keys(Iterator<K> oldIter) {
        KeyIterator iter = (KeyIterator)oldIter;
        iter.init(this);
        return oldIter;
    }

    public Iterator<V> values() {
        ValueIterator iter = new ValueIterator(this);
        iter.init(this);
        return iter;
    }

    public Iterator<V> values(Iterator<V> oldIter) {
        ValueIterator iter = (ValueIterator)oldIter;
        iter.init(this);
        return oldIter;
    }

    public Iterator<Entry<K, V>> iterator() {
        return new EntryIterator();
    }

    public long getHitCount() {
        return this._hitCount;
    }

    public long getMissCount() {
        return this._missCount;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class EntryIterator
    implements Iterator<Entry<K, V>>,
    Entry<K, V> {
        private int _i = -1;

        EntryIterator() {
        }

        @Override
        public boolean hasNext() {
            int i;
            CacheItem[] entries = LruCache.this._entries;
            int length = entries.length;
            for (i = this._i + 1; i < length && entries[i] == null; ++i) {
            }
            this._i = i - 1;
            return i < length;
        }

        @Override
        public Entry<K, V> next() {
            int i;
            CacheItem[] entries = LruCache.this._entries;
            int length = entries.length;
            for (i = this._i + 1; i < length && entries[i] == null; ++i) {
            }
            this._i = i;
            if (this._i < length) {
                return this;
            }
            return null;
        }

        @Override
        public K getKey() {
            if (this._i < LruCache.this._entries.length) {
                CacheItem entry = LruCache.this._entries[this._i];
                if (entry == null) {
                    return null;
                }
                if (entry._key == NULL) {
                    return null;
                }
                return entry._key;
            }
            return null;
        }

        @Override
        public V getValue() {
            if (this._i < LruCache.this._entries.length) {
                CacheItem entry = LruCache.this._entries[this._i];
                return entry != null ? (Object)entry._value : null;
            }
            return null;
        }

        @Override
        public void remove() {
            CacheItem entry;
            if (this._i < LruCache.this._entries.length && (entry = LruCache.this._entries[this._i]) != null) {
                LruCache.this.remove(entry._key);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Entry<K, V> {
        public K getKey();

        public V getValue();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ValueIterator<K, V>
    implements Iterator<V> {
        private LruCache<K, V> _cache;
        private CacheItem<K, V> _item;
        private boolean _isHead1;

        ValueIterator(LruCache<K, V> cache) {
            this.init(cache);
        }

        void init(LruCache<K, V> cache) {
            this._cache = cache;
            this._item = ((LruCache)this._cache)._head2;
            this._isHead1 = false;
            if (this._item == null) {
                this._item = ((LruCache)this._cache)._head1;
                this._isHead1 = true;
            }
        }

        @Override
        public boolean hasNext() {
            return this._item != null;
        }

        @Override
        public V next() {
            CacheItem<K, V> entry = this._item;
            if (this._item != null) {
                this._item = this._item._nextLru;
            }
            if (this._item == null && !this._isHead1) {
                this._isHead1 = true;
                this._item = ((LruCache)this._cache)._head1;
            }
            if (entry != null) {
                return entry._value;
            }
            return null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class KeyIterator<K, V>
    implements Iterator<K> {
        private LruCache<K, V> _cache;
        private CacheItem<K, V> _item;
        private boolean _isHead1;

        KeyIterator(LruCache<K, V> cache) {
            this.init(cache);
        }

        void init(LruCache<K, V> cache) {
            this._cache = cache;
            this._item = ((LruCache)this._cache)._head2;
            this._isHead1 = false;
            if (this._item == null) {
                this._item = ((LruCache)this._cache)._head1;
                this._isHead1 = true;
            }
        }

        @Override
        public boolean hasNext() {
            return this._item != null;
        }

        @Override
        public K next() {
            CacheItem<K, V> entry = this._item;
            if (this._item != null) {
                this._item = this._item._nextLru;
            }
            if (this._item == null && !this._isHead1) {
                this._isHead1 = true;
                this._item = ((LruCache)this._cache)._head1;
            }
            if (entry != null) {
                return entry._key;
            }
            return null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class CacheItem<K, V> {
        volatile CacheItem<K, V> _nextHash;
        CacheItem<K, V> _prevLru;
        CacheItem<K, V> _nextLru;
        volatile int _lruCounter;
        final K _key;
        V _value;
        int _index;
        int _hitCount = 1;

        CacheItem(K key, V value) {
            if (key == null) {
                throw new NullPointerException();
            }
            this._key = key;
            this._value = value;
        }
    }
}

