/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xml;

import com.caucho.vfs.Depend;
import com.caucho.vfs.Path;
import com.caucho.xml.CauchoDocument;
import com.caucho.xml.QAbstractNode;
import com.caucho.xml.QAttr;
import com.caucho.xml.QCdata;
import com.caucho.xml.QComment;
import com.caucho.xml.QDOMException;
import com.caucho.xml.QDOMImplementation;
import com.caucho.xml.QDeepNodeList;
import com.caucho.xml.QDocumentFragment;
import com.caucho.xml.QDocumentType;
import com.caucho.xml.QElement;
import com.caucho.xml.QEntity;
import com.caucho.xml.QEntityReference;
import com.caucho.xml.QName;
import com.caucho.xml.QProcessingInstruction;
import com.caucho.xml.QText;
import com.caucho.xml.QUnescapedText;
import com.caucho.xml.SerializedXml;
import com.caucho.xml.XmlPrinter;
import com.caucho.xml.XmlUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMConfiguration;
import org.w3c.dom.DOMErrorHandler;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Entity;
import org.w3c.dom.EntityReference;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.w3c.dom.TypeInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QDocument
extends QDocumentFragment
implements CauchoDocument {
    QDOMImplementation _implementation;
    QDocumentType _dtd;
    QElement _element;
    HashMap<String, String> _attributes;
    String _encoding = "UTF-8";
    String _version;
    private String _systemId;
    private String _documentURI;
    private HashMap<String, String> _namespaces;
    private transient HashMap<NameKey, QName> _nameCache = new HashMap();
    private transient NameKey _nameKey = new NameKey();
    private transient ArrayList<Path> _depends;
    private transient ArrayList<Depend> _dependList;
    int _changeCount;
    String _rootFilename;
    private boolean _standalone;

    public QDocument() {
        this._implementation = new QDOMImplementation();
        this._owner = this;
    }

    public QDocument(DocumentType docType) {
        this._owner = this;
        this.setDoctype(docType);
    }

    public QDocument(QDOMImplementation impl) {
        this._implementation = impl;
        this._owner = this;
    }

    void setAttribute(String name, String value) {
        if (name.equals("version")) {
            this._version = value;
        } else if (name.equals("encoding")) {
            this._encoding = value;
        } else {
            if (this._attributes == null) {
                this._attributes = new HashMap();
            }
            this._attributes.put(name, value);
        }
    }

    public String getRootFilename() {
        return this._rootFilename;
    }

    public void setRootFilename(String filename) {
        this._rootFilename = filename;
    }

    public void setSystemId(String systemId) {
        this._systemId = systemId;
    }

    public String getSystemId() {
        return this._systemId;
    }

    @Override
    public String getBaseURI() {
        return this.getSystemId();
    }

    @Override
    public Document getOwnerDocument() {
        return null;
    }

    @Override
    public DOMConfiguration getDomConfig() {
        return null;
    }

    @Override
    public boolean isSupported(String feature, String version) {
        return this._owner.getImplementation().hasFeature(feature, version);
    }

    @Override
    public String getNodeName() {
        return "#document";
    }

    @Override
    public short getNodeType() {
        return 9;
    }

    protected Node copyNode(QDocument newNode, boolean deep) {
        newNode._dtd = this._dtd;
        newNode._element = this._element;
        return newNode;
    }

    @Override
    public Node cloneNode(boolean deep) {
        QDocument newDoc = new QDocument();
        newDoc._implementation = this._implementation;
        newDoc._dtd = this._dtd;
        if (this._attributes != null) {
            newDoc._attributes = (HashMap)this._attributes.clone();
        }
        newDoc._encoding = this._encoding;
        newDoc._version = this._version;
        if (this._namespaces != null) {
            newDoc._namespaces = (HashMap)this._namespaces.clone();
        }
        if (deep) {
            for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
                newDoc.appendChild(newDoc.importNode(node, true));
            }
        }
        return newDoc;
    }

    @Override
    Node importNode(QDocument doc, boolean deep) {
        return null;
    }

    @Override
    public Node importNode(Node node, boolean deep) {
        if (node == null) {
            return null;
        }
        switch (node.getNodeType()) {
            case 1: {
                return this.importElement((Element)node, deep);
            }
            case 2: {
                Attr attr = (Attr)node;
                QName name = this.createName(attr.getNamespaceURI(), attr.getNodeName());
                QAttr newAttr = new QAttr(name, attr.getNodeValue());
                newAttr._owner = this;
                return newAttr;
            }
            case 3: {
                QText newText = new QText(node.getNodeValue());
                newText._owner = this;
                return newText;
            }
            case 4: {
                QCdata newCData = new QCdata(node.getNodeValue());
                newCData._owner = this;
                return newCData;
            }
            case 5: {
                QEntityReference newER = new QEntityReference(node.getNodeName());
                newER._owner = this;
                return newER;
            }
            case 6: {
                Entity oldEntity = (Entity)node;
                QEntity newEntity = new QEntity(oldEntity.getNodeName(), oldEntity.getNodeValue(), oldEntity.getPublicId(), oldEntity.getSystemId());
                newEntity._owner = this;
                return newEntity;
            }
            case 7: {
                QProcessingInstruction newPI = new QProcessingInstruction(node.getNodeName(), node.getNodeValue());
                newPI._owner = this;
                return newPI;
            }
            case 8: {
                QComment newComment = new QComment(node.getNodeValue());
                newComment._owner = this;
                return newComment;
            }
            case 11: {
                return this.importFragment((DocumentFragment)node, deep);
            }
        }
        throw new UnsupportedOperationException(String.valueOf(node));
    }

    private Element importElement(Element elt, boolean deep) {
        QElement newElt = new QElement(this.createName(elt.getNamespaceURI(), elt.getNodeName()));
        QElement oldElt = null;
        if (elt instanceof QElement) {
            oldElt = (QElement)elt;
        }
        newElt._owner = this;
        if (oldElt != null) {
            newElt._filename = oldElt._filename;
            newElt._line = oldElt._line;
        }
        NamedNodeMap attrs = elt.getAttributes();
        int len = attrs.getLength();
        for (int i = 0; i < len; ++i) {
            Attr attr = (Attr)attrs.item(i);
            newElt.setAttributeNode((Attr)this.importNode(attr, deep));
        }
        if (!deep) {
            return newElt;
        }
        for (Node node = elt.getFirstChild(); node != null; node = node.getNextSibling()) {
            newElt.appendChild(this.importNode(node, true));
        }
        return newElt;
    }

    private DocumentFragment importFragment(DocumentFragment elt, boolean deep) {
        QDocumentFragment newFrag = new QDocumentFragment();
        newFrag._owner = this;
        if (!deep) {
            return newFrag;
        }
        for (Node node = elt.getFirstChild(); node != null; node = node.getNextSibling()) {
            newFrag.appendChild(this.importNode(node, true));
        }
        return newFrag;
    }

    @Override
    public DocumentType getDoctype() {
        return this._dtd;
    }

    public void setDoctype(DocumentType dtd) {
        QDocumentType qdtd;
        this._dtd = qdtd = (QDocumentType)dtd;
        if (qdtd != null) {
            qdtd._owner = this;
        }
    }

    public String getEncoding() {
        if (this._encoding == null) {
            return null;
        }
        return this._encoding;
    }

    @Override
    public DOMImplementation getImplementation() {
        return this._implementation;
    }

    @Override
    public Element getDocumentElement() {
        return this._element;
    }

    public void setDocumentElement(Element elt) {
        this._element = (QElement)elt;
    }

    @Override
    public Element createElement(String tagName) throws DOMException {
        if (!this.isNameValid(tagName)) {
            throw new QDOMException(5, "illegal tag `" + tagName + "'");
        }
        QElement elt = new QElement(this.createName(null, tagName));
        elt._owner = this;
        return elt;
    }

    @Override
    public Element createElementNS(String namespaceURI, String name) throws DOMException {
        QName qname = this.createName(namespaceURI, name);
        this.validateName(qname);
        this.addNamespace(qname);
        QElement elt = new QElement(qname);
        elt._owner = this;
        return elt;
    }

    public void validateName(QName qname) throws DOMException {
        String prefix = qname.getPrefix();
        String namespaceURI = qname.getNamespaceURI();
        if (qname.getPrefix() != "") {
            if (prefix == "xml" && namespaceURI != "http://www.w3.org/XML/1998/namespace") {
                throw new DOMException(14, L.l("`xml' prefix expects namespace uri 'http://www.w3.org/XML/1998/namespace'"));
            }
            if (prefix != "" && prefix != null && namespaceURI == null) {
                throw new DOMException(14, L.l("`{0}' prefix expects a namespace uri", (Object)prefix));
            }
        }
    }

    @Override
    public Element createElement(String prefix, String local, String url) throws DOMException {
        QName name = new QName(prefix, local, url);
        this.addNamespace(name);
        QElement elt = new QElement(name);
        elt._owner = this;
        return elt;
    }

    public Element createElementByName(QName name) throws DOMException {
        QElement elt = new QElement(name);
        elt._owner = this;
        return elt;
    }

    @Override
    public DocumentFragment createDocumentFragment() {
        QDocumentFragment frag = new QDocumentFragment();
        frag._owner = this;
        return frag;
    }

    @Override
    public Text createTextNode(String data) {
        if (data == null) {
            data = "";
        }
        QText text = new QText(data);
        text._owner = this;
        return text;
    }

    @Override
    public Text createUnescapedTextNode(String data) {
        if (data == null) {
            data = "";
        }
        QUnescapedText text = new QUnescapedText(data);
        text._owner = this;
        return text;
    }

    @Override
    public Comment createComment(String data) {
        if (data == null) {
            data = "";
        }
        QComment comment = new QComment(data);
        comment._owner = this;
        return comment;
    }

    @Override
    public CDATASection createCDATASection(String data) {
        if (data == null) {
            data = "";
        }
        QCdata cdata = new QCdata(data);
        cdata._owner = this;
        return cdata;
    }

    @Override
    public ProcessingInstruction createProcessingInstruction(String target, String data) throws DOMException {
        if (target == null || target.length() == 0) {
            throw new QDOMException(5, L.l("Empty processing instruction name.  The processing instruction syntax is: <?name ... ?>"));
        }
        if (!this.isNameValid(target)) {
            throw new QDOMException(5, L.l("`{0}' is an invalid processing instruction name.  The processing instruction syntax is: <?name ... ?>", (Object)target));
        }
        if (data == null) {
            data = "";
        }
        QProcessingInstruction pi = new QProcessingInstruction(target, data);
        pi._owner = this;
        return pi;
    }

    public Attr createAttribute(String name, String value) throws DOMException {
        if (!this.isNameValid(name)) {
            throw new QDOMException(5, "illegal attribute `" + name + "'");
        }
        if (value == null) {
            value = "";
        }
        QAttr attr = new QAttr(new QName(null, name, null), value);
        attr._owner = this;
        return attr;
    }

    @Override
    public Attr createAttribute(String name) throws DOMException {
        return this.createAttribute(name, null);
    }

    @Override
    public Attr createAttribute(String prefix, String local, String url) throws DOMException {
        QName name = new QName(prefix, local, url);
        if (url != null && !url.equals("")) {
            this.addNamespace(prefix, url);
        }
        QAttr attr = new QAttr(name, null);
        attr._owner = this;
        return attr;
    }

    @Override
    public Attr createAttributeNS(String namespaceURI, String qualifiedName) throws DOMException {
        QName qname = this.createName(namespaceURI, qualifiedName);
        this.validateName(qname);
        this.addNamespace(qname);
        QAttr attr = new QAttr(qname, null);
        attr._owner = this;
        return attr;
    }

    public QName createName(String uri, String name) {
        this._nameKey.init(name, uri);
        QName qName = this._nameCache.get(this._nameKey);
        if (qName != null) {
            return qName;
        }
        if (uri == null) {
            qName = new QName(null, name, null);
        } else {
            String local;
            String prefix;
            int p = name.indexOf(58);
            if (p < 0) {
                prefix = null;
                local = name;
            } else {
                prefix = name.substring(0, p);
                local = name.substring(p + 1);
            }
            qName = new QName(prefix, local, uri);
        }
        this._nameCache.put(new NameKey(name, uri), qName);
        return qName;
    }

    public Attr createAttribute(QName name, String value) throws DOMException {
        String url = name.getNamespace();
        if (url != null && url != "") {
            this.addNamespace(name.getPrefix(), url);
        }
        QAttr attr = new QAttr(name, value);
        attr._owner = this;
        return attr;
    }

    @Override
    public EntityReference createEntityReference(String name) throws DOMException {
        if (!this.isNameValid(name)) {
            throw new QDOMException(5, "illegal entityReference `" + name + "'");
        }
        QEntityReference er = new QEntityReference(name);
        er._owner = this;
        return er;
    }

    @Override
    public NodeList getElementsByTagName(String name) {
        if (this._element == null) {
            return new QDeepNodeList(null, null, null);
        }
        return new QDeepNodeList(this._element, this._element, new QElement.TagPredicate(name));
    }

    @Override
    public NodeList getElementsByTagNameNS(String uri, String name) {
        if (this._element == null) {
            return new QDeepNodeList(null, null, null);
        }
        return new QDeepNodeList(this._element, this._element, new QElement.NSTagPredicate(uri, name));
    }

    @Override
    public Element getElementById(String name) {
        Node node = this._element;
        while (node != null) {
            Element elt;
            String id;
            if (node instanceof Element && name.equals(id = (elt = (Element)node).getAttribute("id"))) {
                return elt;
            }
            node = XmlUtil.getNext(node);
        }
        return null;
    }

    public static Document create() {
        QDocument doc = new QDocument();
        doc._masterDoc = doc;
        return doc;
    }

    void setAttributes(HashMap<String, String> attributes) {
        this._attributes = attributes;
    }

    @Override
    public Node appendChild(Node newChild) throws DOMException {
        if (newChild instanceof Element) {
            this._element = (QElement)newChild;
        }
        return super.appendChild(newChild);
    }

    @Override
    public Node removeChild(Node oldChild) throws DOMException {
        Node value = super.removeChild(oldChild);
        if (oldChild == this._element) {
            this._element = null;
        }
        return value;
    }

    public void addNamespace(QName qname) {
        this.addNamespace(qname.getPrefix(), qname.getNamespaceURI());
    }

    public void addNamespace(String prefix, String url) {
        String old;
        if (url == null || url.length() == 0 || "http://www.w3.org/2000/xmlns/".equals(url) || "http://www.w3.org/XML/1998/namespace".equals(url)) {
            return;
        }
        if (prefix == null) {
            prefix = "";
        }
        if (this._namespaces == null) {
            this._namespaces = new HashMap();
        }
        if ((old = this._namespaces.get(prefix)) == null) {
            this._namespaces.put(prefix, url.intern());
        }
    }

    @Override
    public HashMap<String, String> getNamespaces() {
        return this._namespaces;
    }

    public String getNamespace(String prefix) {
        if (this._namespaces == null) {
            return null;
        }
        return this._namespaces.get(prefix);
    }

    public Iterator<String> getNamespaceKeys() {
        if (this._namespaces == null) {
            return null;
        }
        return this._namespaces.keySet().iterator();
    }

    @Override
    public Object getProperty(String name) {
        if (name.equals("caucho.depends")) {
            return this._depends;
        }
        return null;
    }

    public ArrayList<Path> getDependList() {
        return this._depends;
    }

    @Override
    public ArrayList<Depend> getDependencyList() {
        return this._dependList;
    }

    @Override
    public void setProperty(String name, Object value) {
        if (name.equals("caucho.depends")) {
            this._depends = (ArrayList)value;
        }
    }

    public String getActualEncoding() {
        throw new UnsupportedOperationException();
    }

    public void setActualEncoding(String actualEncoding) {
        throw new UnsupportedOperationException();
    }

    public void setEncoding(String encoding) {
        throw new UnsupportedOperationException();
    }

    public boolean getStandalone() {
        return this._standalone;
    }

    public void setStandalone(boolean standalone) {
        this._standalone = true;
    }

    @Override
    public String getXmlVersion() {
        return this._version;
    }

    @Override
    public void setXmlVersion(String version) throws DOMException {
        this._version = version;
    }

    @Override
    public void setXmlStandalone(boolean value) throws DOMException {
    }

    public TypeInfo getSchemaTypeInfo() {
        return null;
    }

    @Override
    public String getXmlEncoding() {
        return null;
    }

    @Override
    public String getInputEncoding() {
        return null;
    }

    @Override
    public boolean getXmlStandalone() throws DOMException {
        return false;
    }

    @Override
    public boolean getStrictErrorChecking() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setStrictErrorChecking(boolean strictErrorChecking) {
        throw new UnsupportedOperationException();
    }

    public DOMErrorHandler getErrorHandler() {
        throw new UnsupportedOperationException();
    }

    public void setErrorHandler(DOMErrorHandler errorHandler) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getDocumentURI() {
        return this._documentURI;
    }

    @Override
    public void setDocumentURI(String documentURI) {
        this._documentURI = documentURI;
    }

    @Override
    public Node adoptNode(Node source) throws DOMException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void normalizeDocument() {
        throw new UnsupportedOperationException();
    }

    public boolean canSetNormalizationFeature(String name, boolean state) {
        throw new UnsupportedOperationException();
    }

    public void setNormalizationFeature(String name, boolean state) throws DOMException {
        throw new UnsupportedOperationException();
    }

    public boolean getNormalizationFeature(String name) throws DOMException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Node renameNode(Node n, String namespaceURI, String name) throws DOMException {
        throw new UnsupportedOperationException();
    }

    public void addDepend(Path path) {
        if (path == null) {
            return;
        }
        if (this._depends == null) {
            this._depends = new ArrayList();
        }
        if (!this._depends.contains(path)) {
            this._depends.add(path);
            if (this._dependList == null) {
                this._dependList = new ArrayList();
            }
            this._dependList.add(new Depend(path));
        }
    }

    public boolean isModified() {
        if (this._dependList == null) {
            return false;
        }
        for (int i = 0; i < this._dependList.size(); ++i) {
            Depend depend = this._dependList.get(i);
            if (!depend.isModified()) continue;
            return true;
        }
        return false;
    }

    @Override
    void print(XmlPrinter os) throws IOException {
        os.startDocument(this);
        if (this._namespaces != null) {
            for (String prefix : this._namespaces.keySet()) {
                String url = this._namespaces.get(prefix);
                if (prefix.equals("")) {
                    os.attribute(null, prefix, "xmlns", url);
                    continue;
                }
                os.attribute(null, prefix, "xmlns:" + prefix, url);
            }
        }
        if (this.getFirstChild() == null) {
            os.printHeader(null);
        }
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            ((QAbstractNode)node).print(os);
            if (!os.isPretty()) continue;
            os.println();
        }
        os.endDocument();
    }

    @Override
    public String toString() {
        String topElt;
        String string = topElt = this._element == null ? "XXX:top" : this._element.getNodeName();
        if (this._dtd == null) {
            return "Document[" + topElt + "]";
        }
        if (this._dtd.getPublicId() != null && this._dtd.getSystemId() != null) {
            return "Document[" + topElt + " PUBLIC '" + this._dtd.getPublicId() + "' '" + this._dtd.getSystemId() + "']";
        }
        if (this._dtd._publicId != null) {
            return "Document[" + topElt + " PUBLIC '" + this._dtd.getPublicId() + "']";
        }
        if (this._dtd.getSystemId() != null) {
            return "Document[" + topElt + " SYSTEM '" + this._dtd.getSystemId() + "']";
        }
        return "Document[" + topElt + "]";
    }

    private Object writeReplace() {
        return new SerializedXml(this);
    }

    static class NameKey {
        String _qName;
        String _url;

        NameKey() {
        }

        NameKey(String qName, String url) {
            this.init(qName, url);
        }

        void init(String qName, String url) {
            if (qName == null) {
                throw new NullPointerException();
            }
            if (url == null) {
                url = "";
            }
            this._qName = qName;
            this._url = url;
        }

        public int hashCode() {
            return 65521 * this._url.hashCode() + this._qName.hashCode();
        }

        public boolean equals(Object b) {
            if (!(b instanceof NameKey)) {
                return false;
            }
            NameKey key = (NameKey)b;
            return this._qName.equals(key._qName) && this._url.equals(key._url);
        }
    }
}

