/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance;

import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.lang.reflect.Method;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.TableHeaderUI;
import javax.swing.plaf.UIResource;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import org.jvnet.lafwidget.animation.FadeKind;
import org.jvnet.lafwidget.animation.FadeState;
import org.jvnet.lafwidget.utils.LookUtils;
import org.jvnet.substance.SubstanceImageCreator;
import org.jvnet.substance.SubstanceTableHeaderUI;
import org.jvnet.substance.SubstanceTableUI;
import org.jvnet.substance.theme.SubstanceTheme;
import org.jvnet.substance.utils.ComponentState;
import org.jvnet.substance.utils.SubstanceCoreUtilities;
import org.jvnet.substance.utils.SubstanceFadeUtilities;
import org.jvnet.substance.utils.SubstanceSizeUtils;
import org.jvnet.substance.utils.SubstanceThemeUtilities;

public class SubstanceDefaultTableHeaderCellRenderer
extends DefaultTableCellRenderer
implements UIResource {
    private static Method tableGetRowSorterMethod;
    private static Method rowSorterGetSortKeysMethod;
    private static Method rowSorterSortKeyGetSortOrderMethod;
    private static Method rowSorterSortKeyGetColumnMethod;

    public SubstanceDefaultTableHeaderCellRenderer() {
        this.setHorizontalAlignment(0);
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (table == null) {
            this.setBorder(DefaultTableCellRenderer.noFocusBorder);
            this.setValue(value);
            this.setOpaque(false);
            return this;
        }
        if (table.getTableHeader() == null) {
            return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }
        JTableHeader tableHeader = table.getTableHeader();
        TableHeaderUI tableHeaderUI = tableHeader.getUI();
        if (tableHeaderUI instanceof SubstanceTableHeaderUI) {
            SubstanceTableHeaderUI ui = (SubstanceTableHeaderUI)tableHeaderUI;
            ComponentState state = ui.getColumnState(column);
            ComponentState prevState = ui.getPrevColumnState(column);
            SubstanceTheme theme = SubstanceThemeUtilities.getTheme(tableHeader, state);
            Color color = SubstanceCoreUtilities.getInterpolatedForegroundColor(tableHeader, Integer.valueOf(column), theme, state, prevState, FadeKind.SELECTION, FadeKind.ROLLOVER);
            super.setForeground(color);
        } else {
            super.setForeground(table.getForeground());
        }
        SubstanceCoreUtilities.applyStripedBackground(table, row, this);
        if (tableHeader.getFont() != null) {
            this.setFont(tableHeader.getFont());
        } else {
            this.setFont(table.getFont());
        }
        SubstanceTableUI.TableColumnId cellFocusId = new SubstanceTableUI.TableColumnId(column);
        FadeState focusState = SubstanceFadeUtilities.getFadeState((Component)table, cellFocusId, FadeKind.FOCUS);
        Insets regInsets = SubstanceSizeUtils.getTableCellRendererInsets(SubstanceSizeUtils.getComponentFontSize(table));
        this.setBorder(new EmptyBorder(regInsets.top, regInsets.left, regInsets.bottom, regInsets.right));
        this.setValue(value);
        this.setOpaque(false);
        this.setEnabled(tableHeader.isEnabled() && table.isEnabled());
        try {
            Object rowSorter;
            this.setIcon(null);
            if (LookUtils.IS_JAVA_6_OR_LATER && (rowSorter = tableGetRowSorterMethod.invoke((Object)table, new Object[0])) != null) {
                this.setHorizontalTextPosition(10);
                List sortKeys = (List)rowSorterGetSortKeysMethod.invoke(rowSorter, new Object[0]);
                Icon sortIcon = null;
                SubstanceTheme theme = null;
                if (tableHeaderUI instanceof SubstanceTableHeaderUI) {
                    SubstanceTableHeaderUI ui = (SubstanceTableHeaderUI)tableHeaderUI;
                    ComponentState state = ui.getColumnState(column);
                    theme = SubstanceThemeUtilities.getTheme(tableHeader, state);
                } else {
                    theme = SubstanceThemeUtilities.getTheme(tableHeader);
                }
                Object sortKey0 = sortKeys.get(0);
                int sortColumn = (Integer)rowSorterSortKeyGetColumnMethod.invoke(sortKey0, new Object[0]);
                if (sortKeys.size() > 0 && sortColumn == table.convertColumnIndexToModel(column)) {
                    String sortOrderString = rowSorterSortKeyGetSortOrderMethod.invoke(sortKey0, new Object[0]).toString();
                    if (sortOrderString.indexOf("ASCENDING") >= 0) {
                        sortIcon = SubstanceImageCreator.getArrowIcon(SubstanceSizeUtils.getComponentFontSize(tableHeader), 1, theme);
                    } else if (sortOrderString.indexOf("DESCENDING") >= 0) {
                        sortIcon = SubstanceImageCreator.getArrowIcon(SubstanceSizeUtils.getComponentFontSize(tableHeader), 5, theme);
                    }
                    this.setIcon(sortIcon);
                }
            }
        }
        catch (Exception exc) {
            this.setIcon(null);
        }
        return this;
    }

    public static boolean isColumnSorted(JTable table, int columnIndex) {
        try {
            Object rowSorter;
            if (LookUtils.IS_JAVA_6_OR_LATER && (rowSorter = tableGetRowSorterMethod.invoke((Object)table, new Object[0])) != null) {
                List sortKeys = (List)rowSorterGetSortKeysMethod.invoke(rowSorter, new Object[0]);
                Object sortKey0 = sortKeys.get(0);
                int sortColumn = (Integer)rowSorterSortKeyGetColumnMethod.invoke(sortKey0, new Object[0]);
                if (sortKeys.size() > 0 && sortColumn == table.convertColumnIndexToModel(columnIndex)) {
                    String sortOrderString = rowSorterSortKeyGetSortOrderMethod.invoke(sortKey0, new Object[0]).toString();
                    if (sortOrderString.indexOf("ASCENDING") >= 0) {
                        return true;
                    }
                    return true;
                }
            }
            return false;
        }
        catch (Exception exc) {
            return false;
        }
    }

    static {
        if (LookUtils.IS_JAVA_6_OR_LATER) {
            try {
                Class<?> rowSorterSortKeyClass;
                tableGetRowSorterMethod = JTable.class.getDeclaredMethod("getRowSorter", new Class[0]);
                Class<?> rowSorterClass = Class.forName("javax.swing.RowSorter");
                if (rowSorterClass != null) {
                    rowSorterGetSortKeysMethod = rowSorterClass.getDeclaredMethod("getSortKeys", new Class[0]);
                }
                if ((rowSorterSortKeyClass = Class.forName("javax.swing.RowSorter$SortKey")) != null) {
                    rowSorterSortKeyGetSortOrderMethod = rowSorterSortKeyClass.getDeclaredMethod("getSortOrder", new Class[0]);
                    rowSorterSortKeyGetColumnMethod = rowSorterSortKeyClass.getDeclaredMethod("getColumn", new Class[0]);
                }
            }
            catch (Exception exc) {
                tableGetRowSorterMethod = null;
                rowSorterGetSortKeysMethod = null;
                rowSorterSortKeyGetSortOrderMethod = null;
                rowSorterSortKeyGetColumnMethod = null;
            }
        }
    }
}

