/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicBorders;
import javax.swing.plaf.basic.BasicFormattedTextFieldUI;
import javax.swing.text.Element;
import javax.swing.text.FieldView;
import javax.swing.text.Highlighter;
import javax.swing.text.View;
import org.jvnet.lafwidget.animation.FadeStateListener;
import org.jvnet.substance.SubstanceBorder;
import org.jvnet.substance.text.SubstanceFieldView;
import org.jvnet.substance.text.SubstanceHighlighter;
import org.jvnet.substance.utils.SubstanceCoreUtilities;
import org.jvnet.substance.utils.SubstanceSizeUtils;

public class SubstanceFormattedTextFieldUI
extends BasicFormattedTextFieldUI {
    protected FadeStateListener substanceFadeStateListener;
    protected JFormattedTextField textField;
    protected PropertyChangeListener substancePropertyChangeListener;

    public static ComponentUI createUI(JComponent c) {
        return new SubstanceFormattedTextFieldUI(c);
    }

    public SubstanceFormattedTextFieldUI(JComponent c) {
        this.textField = (JFormattedTextField)c;
    }

    protected void installListeners() {
        super.installListeners();
        this.substanceFadeStateListener = new FadeStateListener(this.textField, null, null);
        this.substanceFadeStateListener.registerListeners(false);
        this.substancePropertyChangeListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if ("font".equals(evt.getPropertyName())) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            SubstanceFormattedTextFieldUI.this.textField.updateUI();
                        }
                    });
                }
            }
        };
        this.textField.addPropertyChangeListener(this.substancePropertyChangeListener);
    }

    protected void uninstallListeners() {
        this.substanceFadeStateListener.unregisterListeners();
        this.substanceFadeStateListener = null;
        this.textField.removePropertyChangeListener(this.substancePropertyChangeListener);
        this.substancePropertyChangeListener = null;
        super.uninstallListeners();
    }

    protected void installDefaults() {
        super.installDefaults();
        Border b = this.textField.getBorder();
        if (b == null || b instanceof UIResource) {
            BorderUIResource.CompoundBorderUIResource newB = new BorderUIResource.CompoundBorderUIResource(new SubstanceBorder(SubstanceSizeUtils.getTextBorderInsets(SubstanceSizeUtils.getComponentFontSize(this.textField))), new BasicBorders.MarginBorder());
            this.textField.setBorder(newB);
        }
    }

    public View create(Element elem) {
        View superResult = super.create(elem);
        if (superResult instanceof FieldView) {
            return new SubstanceFieldView(elem);
        }
        return superResult;
    }

    protected Highlighter createHighlighter() {
        return new SubstanceHighlighter();
    }

    protected void paintSafely(Graphics _g) {
        Graphics2D dummy = (Graphics2D)_g.create(0, 0, 0, 0);
        super.paintSafely(dummy);
        dummy.dispose();
        SubstanceCoreUtilities.paintTextComponent(_g, this.textField, this.getRootView(this.textField), this.getVisibleEditorRect());
    }
}

