/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicMenuItemUI;
import org.jvnet.lafwidget.animation.FadeStateListener;
import org.jvnet.substance.SubstanceMenu;
import org.jvnet.substance.utils.SubstanceCoreUtilities;
import org.jvnet.substance.utils.SubstanceSizeUtils;
import org.jvnet.substance.utils.menu.MenuUtilities;

public class SubstanceMenuItemUI
extends BasicMenuItemUI
implements SubstanceMenu {
    protected FadeStateListener substanceFadeStateListener;
    protected MenuUtilities.MenuPropertyListener substanceMenuPropertyListener;
    protected PropertyChangeListener substancePropertyListener;

    public static ComponentUI createUI(JComponent c) {
        return new SubstanceMenuItemUI();
    }

    protected void installListeners() {
        super.installListeners();
        this.substanceMenuPropertyListener = new MenuUtilities.MenuPropertyListener(this.menuItem);
        this.substanceMenuPropertyListener.install();
        this.substanceFadeStateListener = new FadeStateListener(this.menuItem, this.menuItem.getModel(), SubstanceCoreUtilities.getFadeCallback(this.menuItem, this.menuItem.getModel(), true, false, this.menuItem));
        this.substanceFadeStateListener.registerListeners();
        this.substancePropertyListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if ("model".equals(evt.getPropertyName())) {
                    if (SubstanceMenuItemUI.this.substanceFadeStateListener != null) {
                        SubstanceMenuItemUI.this.substanceFadeStateListener.unregisterListeners();
                    }
                    SubstanceMenuItemUI.this.substanceFadeStateListener = new FadeStateListener(SubstanceMenuItemUI.this.menuItem, SubstanceMenuItemUI.this.menuItem.getModel(), SubstanceCoreUtilities.getFadeCallback(SubstanceMenuItemUI.this.menuItem, SubstanceMenuItemUI.this.menuItem.getModel(), true, false, SubstanceMenuItemUI.this.menuItem));
                    SubstanceMenuItemUI.this.substanceFadeStateListener.registerListeners();
                }
            }
        };
        this.menuItem.addPropertyChangeListener(this.substancePropertyListener);
    }

    protected void installDefaults() {
        super.installDefaults();
        this.defaultTextIconGap = SubstanceSizeUtils.getTextIconGap(SubstanceSizeUtils.getComponentFontSize(this.menuItem));
    }

    protected void uninstallListeners() {
        this.substanceMenuPropertyListener.uninstall();
        this.substanceMenuPropertyListener = null;
        this.menuItem.removePropertyChangeListener(this.substancePropertyListener);
        this.substancePropertyListener = null;
        this.substanceFadeStateListener.unregisterListeners();
        this.substanceFadeStateListener = null;
        super.uninstallListeners();
    }

    public JMenuItem getAssociatedMenuItem() {
        return this.menuItem;
    }

    public Font getAcceleratorFont() {
        return this.acceleratorFont;
    }

    public Icon getArrowIcon() {
        return this.arrowIcon;
    }

    public Icon getCheckIcon() {
        return null;
    }

    public int getDefaultTextIconGap() {
        return this.defaultTextIconGap;
    }

    protected Dimension getPreferredMenuItemSize(JComponent c, Icon checkIcon, Icon arrowIcon, int defaultTextIconGap) {
        Dimension superDim = super.getPreferredMenuItemSize(c, checkIcon, arrowIcon, defaultTextIconGap);
        return new Dimension(MenuUtilities.getPreferredWidth(this.menuItem), superDim.height);
    }

    protected void paintMenuItem(Graphics g, JComponent c, Icon checkIcon, Icon arrowIcon, Color background, Color foreground, int defaultTextIconGap) {
        MenuUtilities.paintMenuItem(g, this.menuItem, checkIcon, arrowIcon, defaultTextIconGap);
    }
}

