/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashSet;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JSpinner;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicSpinnerUI;
import org.jvnet.lafwidget.animation.FadeKind;
import org.jvnet.lafwidget.animation.FadeStateListener;
import org.jvnet.lafwidget.animation.FadeTracker;
import org.jvnet.lafwidget.animation.FadeTrackerAdapter;
import org.jvnet.substance.SubstanceBorder;
import org.jvnet.substance.SubstanceImageCreator;
import org.jvnet.substance.theme.SubstanceTheme;
import org.jvnet.substance.utils.SubstanceConstants;
import org.jvnet.substance.utils.SubstanceCoreUtilities;
import org.jvnet.substance.utils.SubstanceSizeUtils;
import org.jvnet.substance.utils.SubstanceSpinnerButton;
import org.jvnet.substance.utils.icon.TransitionAwareIcon;

public class SubstanceSpinnerUI
extends BasicSpinnerUI {
    protected PropertyChangeListener substancePropertyChangeListener;
    protected FadeStateListener substanceFadeStateListener;
    protected SubstanceSpinnerButton nextButton;
    protected SubstanceSpinnerButton prevButton;

    public static ComponentUI createUI(JComponent c) {
        return new SubstanceSpinnerUI();
    }

    protected Component createNextButton() {
        this.nextButton = new SubstanceSpinnerButton(this.spinner, 1);
        this.nextButton.setFont(this.spinner.getFont());
        this.nextButton.setName("Spinner.nextButton");
        TransitionAwareIcon icon = new TransitionAwareIcon(this.nextButton, new TransitionAwareIcon.Delegate(){

            public Icon getThemeIcon(SubstanceTheme theme) {
                int fontSize = SubstanceSizeUtils.getComponentFontSize(SubstanceSpinnerUI.this.spinner);
                return SubstanceImageCreator.getArrowIcon(SubstanceSizeUtils.getSpinnerArrowIconWidth(fontSize), SubstanceSizeUtils.getSpinnerArrowIconHeight(fontSize), SubstanceSizeUtils.getArrowStrokeWidth(fontSize), 1, theme);
            }
        });
        this.nextButton.setIcon(this.spinner, icon);
        int spinnerButtonSize = SubstanceSizeUtils.getSpinnerButtonWidth(SubstanceSizeUtils.getComponentFontSize(this.spinner));
        this.nextButton.setPreferredSize(new Dimension(spinnerButtonSize, spinnerButtonSize));
        this.nextButton.setMinimumSize(new Dimension(5, 5));
        HashSet<SubstanceConstants.Side> openSides = new HashSet<SubstanceConstants.Side>();
        openSides.add(SubstanceConstants.Side.BOTTOM);
        openSides.add(SubstanceConstants.Side.TOP);
        openSides.add(SubstanceConstants.Side.RIGHT);
        this.nextButton.putClientProperty("substancelaf.buttonopenSide", openSides);
        this.installNextButtonListeners(this.nextButton);
        return this.nextButton;
    }

    protected Component createPreviousButton() {
        this.prevButton = new SubstanceSpinnerButton(this.spinner, 5);
        this.prevButton.setFont(this.spinner.getFont());
        this.prevButton.setName("Spinner.previousButton");
        TransitionAwareIcon icon = new TransitionAwareIcon(this.prevButton, new TransitionAwareIcon.Delegate(){

            public Icon getThemeIcon(SubstanceTheme theme) {
                int fontSize = SubstanceSizeUtils.getComponentFontSize(SubstanceSpinnerUI.this.spinner);
                return SubstanceImageCreator.getArrowIcon(SubstanceSizeUtils.getSpinnerArrowIconWidth(fontSize), SubstanceSizeUtils.getSpinnerArrowIconHeight(fontSize), SubstanceSizeUtils.getArrowStrokeWidth(fontSize), 5, theme);
            }
        });
        this.prevButton.setIcon(this.spinner, icon);
        int spinnerButtonSize = SubstanceSizeUtils.getSpinnerButtonWidth(SubstanceSizeUtils.getComponentFontSize(this.prevButton));
        this.prevButton.setPreferredSize(new Dimension(spinnerButtonSize, spinnerButtonSize));
        this.prevButton.setMinimumSize(new Dimension(5, 5));
        HashSet<SubstanceConstants.Side> openSides = new HashSet<SubstanceConstants.Side>();
        openSides.add(SubstanceConstants.Side.TOP);
        openSides.add(SubstanceConstants.Side.BOTTOM);
        openSides.add(SubstanceConstants.Side.RIGHT);
        this.prevButton.putClientProperty("substancelaf.buttonopenSide", openSides);
        this.installPreviousButtonListeners(this.prevButton);
        return this.prevButton;
    }

    protected void installDefaults() {
        Border b;
        JFormattedTextField tf;
        super.installDefaults();
        JComponent editor = this.spinner.getEditor();
        if (editor != null && editor instanceof JSpinner.DefaultEditor && (tf = ((JSpinner.DefaultEditor)editor).getTextField()) != null) {
            int fontSize = SubstanceSizeUtils.getComponentFontSize(this.spinner);
            Insets ins = SubstanceSizeUtils.getSpinnerTextBorderInsets(fontSize);
            tf.setBorder(new EmptyBorder(ins.top, ins.left, ins.bottom, ins.right));
            tf.setFont(this.spinner.getFont());
        }
        if ((b = this.spinner.getBorder()) == null || b instanceof UIResource) {
            this.spinner.setBorder(new SubstanceBorder(SubstanceSizeUtils.getSpinnerBorderInsets(SubstanceSizeUtils.getComponentFontSize(this.spinner))));
        }
    }

    protected void installListeners() {
        super.installListeners();
        this.substancePropertyChangeListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                JFormattedTextField tf;
                JComponent editor;
                if ("editor".equals(evt.getPropertyName())) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            JFormattedTextField tf;
                            if (SubstanceSpinnerUI.this.substanceFadeStateListener != null) {
                                SubstanceSpinnerUI.this.substanceFadeStateListener.unregisterListeners();
                                SubstanceSpinnerUI.this.substanceFadeStateListener = null;
                            }
                            if (SubstanceSpinnerUI.this.spinner == null) {
                                return;
                            }
                            JComponent editor = SubstanceSpinnerUI.this.spinner.getEditor();
                            if (editor != null && editor instanceof JSpinner.DefaultEditor && (tf = ((JSpinner.DefaultEditor)editor).getTextField()) != null) {
                                Insets ins = SubstanceSizeUtils.getSpinnerTextBorderInsets(SubstanceSizeUtils.getComponentFontSize(SubstanceSpinnerUI.this.spinner));
                                tf.setBorder(new EmptyBorder(ins.top, ins.left, ins.bottom, ins.right));
                                SubstanceSpinnerUI.this.substanceFadeStateListener = new FadeStateListener(tf, null, new FadeTrackerAdapter(){

                                    public void fadeEnded(FadeKind fadeKind) {
                                        if (SubstanceSpinnerUI.this.spinner != null) {
                                            SubstanceSpinnerUI.this.spinner.repaint();
                                        }
                                    }

                                    public void fadePerformed(FadeKind fadeKind, float fadeCycle10) {
                                        if (SubstanceSpinnerUI.this.spinner != null) {
                                            SubstanceSpinnerUI.this.spinner.repaint();
                                        }
                                    }
                                });
                                SubstanceSpinnerUI.this.substanceFadeStateListener.registerListeners();
                            }
                        }
                    });
                }
                if ("font".equals(evt.getPropertyName())) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            SubstanceSpinnerUI.this.spinner.updateUI();
                        }
                    });
                }
                if ("background".equals(evt.getPropertyName()) && (editor = SubstanceSpinnerUI.this.spinner.getEditor()) != null && editor instanceof JSpinner.DefaultEditor && (tf = ((JSpinner.DefaultEditor)editor).getTextField()) != null && tf.getBackground() instanceof UIResource) {
                    tf.setBackground(SubstanceSpinnerUI.this.spinner.getBackground());
                }
            }
        };
        this.spinner.addPropertyChangeListener(this.substancePropertyChangeListener);
        JComponent editor = this.spinner.getEditor();
        if (editor != null && editor instanceof JSpinner.DefaultEditor) {
            JFormattedTextField tf = ((JSpinner.DefaultEditor)editor).getTextField();
            this.substanceFadeStateListener = new FadeStateListener(tf, null, new FadeTrackerAdapter(){

                public void fadeEnded(FadeKind fadeKind) {
                    if (SubstanceSpinnerUI.this.spinner != null) {
                        SubstanceSpinnerUI.this.spinner.repaint();
                    }
                }

                public void fadePerformed(FadeKind fadeKind, float fadeCycle10) {
                    if (SubstanceSpinnerUI.this.spinner != null) {
                        SubstanceSpinnerUI.this.spinner.repaint();
                    }
                }
            });
            this.substanceFadeStateListener.registerListeners();
        }
    }

    protected void uninstallListeners() {
        if (this.substanceFadeStateListener != null) {
            this.substanceFadeStateListener.unregisterListeners();
            this.substanceFadeStateListener = null;
        }
        this.spinner.removePropertyChangeListener(this.substancePropertyChangeListener);
        this.substancePropertyChangeListener = null;
        super.uninstallListeners();
    }

    public void paint(Graphics g, JComponent c) {
        super.paint(g, c);
        if (SubstanceSpinnerUI.hasFocus(this.spinner) || FadeTracker.getInstance().isTracked(this.spinner, FadeKind.FOCUS)) {
            this.paintFocus(g, this.spinner.getEditor().getBounds());
        }
    }

    private static boolean hasFocus(Component comp) {
        if (comp.hasFocus()) {
            return true;
        }
        if (comp instanceof Container) {
            Container cont = (Container)comp;
            for (int i = 0; i < cont.getComponentCount(); ++i) {
                Component child = cont.getComponent(i);
                if (!SubstanceSpinnerUI.hasFocus(child)) continue;
                return true;
            }
        }
        return false;
    }

    protected void paintFocus(Graphics g, Rectangle bounds) {
    }

    public Dimension getPreferredSize(JComponent c) {
        Dimension nextD = this.nextButton.getPreferredSize();
        Dimension previousD = this.prevButton.getPreferredSize();
        Dimension editorD = this.spinner.getEditor().getPreferredSize();
        Dimension size = new Dimension(editorD.width, editorD.height);
        size.width += Math.max(nextD.width, previousD.width);
        Insets insets = this.spinner.getInsets();
        size.width += insets.left + insets.right;
        size.height += insets.top + insets.bottom;
        return size;
    }

    public void update(Graphics g, JComponent c) {
        SubstanceCoreUtilities.paintTextCompBackground(g, c);
        this.paint(g, c);
    }

    protected LayoutManager createLayout() {
        return new SpinnerLayoutManager();
    }

    protected class SpinnerLayoutManager
    implements LayoutManager {
        protected SpinnerLayoutManager() {
        }

        public void addLayoutComponent(String name, Component comp) {
        }

        public void removeLayoutComponent(Component comp) {
        }

        public Dimension minimumLayoutSize(Container parent) {
            return this.preferredLayoutSize(parent);
        }

        public Dimension preferredLayoutSize(Container parent) {
            Dimension nextD = SubstanceSpinnerUI.this.nextButton.getPreferredSize();
            Dimension previousD = SubstanceSpinnerUI.this.prevButton.getPreferredSize();
            Dimension editorD = SubstanceSpinnerUI.this.spinner.getEditor().getPreferredSize();
            editorD.height = (editorD.height + 1) / 2 * 2;
            Dimension size = new Dimension(editorD.width, editorD.height);
            size.width += Math.max(nextD.width, previousD.width);
            Insets insets = parent.getInsets();
            size.width += insets.left + insets.right;
            size.height += insets.top + insets.bottom;
            return size;
        }

        public void layoutContainer(Container parent) {
            int buttonsX;
            int editorWidth;
            int editorX;
            int width = parent.getWidth();
            int height = parent.getHeight();
            Insets insets = parent.getInsets();
            Dimension nextD = SubstanceSpinnerUI.this.nextButton.getPreferredSize();
            Dimension previousD = SubstanceSpinnerUI.this.prevButton.getPreferredSize();
            int buttonsWidth = Math.max(nextD.width, previousD.width);
            int editorHeight = height - (insets.top + insets.bottom);
            Insets buttonInsets = SubstanceSizeUtils.getSpinnerArrowButtonInsets(SubstanceSizeUtils.getComponentFontSize(SubstanceSpinnerUI.this.spinner));
            if (buttonInsets == null) {
                buttonInsets = insets;
            }
            if (parent.getComponentOrientation().isLeftToRight()) {
                editorX = insets.left;
                editorWidth = width - insets.left - buttonsWidth - buttonInsets.right;
                buttonsX = width - buttonsWidth - buttonInsets.right;
            } else {
                buttonsX = buttonInsets.left;
                editorX = buttonsX + buttonsWidth;
                editorWidth = width - buttonInsets.left - buttonsWidth - insets.right;
            }
            int nextY = buttonInsets.top;
            int nextHeight = height / 2 + height % 2 - nextY;
            int previousY = buttonInsets.top + nextHeight;
            int previousHeight = height - previousY - buttonInsets.bottom;
            SubstanceSpinnerUI.this.spinner.getEditor().setBounds(editorX, insets.top, editorWidth, editorHeight);
            SubstanceSpinnerUI.this.nextButton.setBounds(buttonsX, nextY, buttonsWidth, nextHeight);
            SubstanceSpinnerUI.this.prevButton.setBounds(buttonsX, previousY, buttonsWidth, previousHeight);
        }
    }
}

