/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicBorders;
import javax.swing.plaf.basic.BasicTextAreaUI;
import javax.swing.text.Element;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import javax.swing.text.PlainView;
import javax.swing.text.View;
import javax.swing.text.WrappedPlainView;
import org.jvnet.lafwidget.animation.FadeStateListener;
import org.jvnet.substance.SubstanceBorder;
import org.jvnet.substance.text.SubstanceHighlighter;
import org.jvnet.substance.text.SubstancePlainView;
import org.jvnet.substance.text.SubstanceWrappedPlainView;
import org.jvnet.substance.utils.SubstanceCoreUtilities;
import org.jvnet.substance.utils.SubstanceSizeUtils;

public class SubstanceTextAreaUI
extends BasicTextAreaUI {
    protected FadeStateListener substanceFadeStateListener;
    protected JTextArea textArea;
    protected PropertyChangeListener substancePropertyChangeListener;

    public static ComponentUI createUI(JComponent c) {
        return new SubstanceTextAreaUI(c);
    }

    public SubstanceTextAreaUI(JComponent c) {
        this.textArea = (JTextArea)c;
    }

    protected void installListeners() {
        super.installListeners();
        this.substanceFadeStateListener = new FadeStateListener(this.textArea, null, null);
        this.substanceFadeStateListener.registerListeners(false);
        this.substancePropertyChangeListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if ("font".equals(evt.getPropertyName())) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            SubstanceTextAreaUI.this.textArea.updateUI();
                        }
                    });
                }
            }
        };
        this.textArea.addPropertyChangeListener(this.substancePropertyChangeListener);
    }

    protected void uninstallListeners() {
        this.substanceFadeStateListener.unregisterListeners();
        this.substanceFadeStateListener = null;
        this.textArea.removePropertyChangeListener(this.substancePropertyChangeListener);
        this.substancePropertyChangeListener = null;
        super.uninstallListeners();
    }

    protected void installDefaults() {
        super.installDefaults();
        Border b = this.textArea.getBorder();
        if (b == null || b instanceof UIResource) {
            BorderUIResource.CompoundBorderUIResource newB = new BorderUIResource.CompoundBorderUIResource(new SubstanceBorder(SubstanceSizeUtils.getTextBorderInsets(SubstanceSizeUtils.getComponentFontSize(this.textArea))), new BasicBorders.MarginBorder());
            this.textArea.setBorder(newB);
        }
    }

    protected Highlighter createHighlighter() {
        return new SubstanceHighlighter();
    }

    public View create(Element elem) {
        View superResult = super.create(elem);
        if (superResult instanceof PlainView) {
            return new SubstancePlainView(elem);
        }
        if (superResult instanceof WrappedPlainView) {
            return new SubstanceWrappedPlainView(elem, ((JTextArea)this.getComponent()).getWrapStyleWord());
        }
        return superResult;
    }

    protected void modelChanged() {
        super.modelChanged();
        JTextComponent component = this.getComponent();
        View currView = this.getRootView(component);
        Element defaultRootElement = component.getDocument().getDefaultRootElement();
        if (currView instanceof PlainView) {
            this.setView(new SubstancePlainView(defaultRootElement));
        }
        if (currView instanceof WrappedPlainView) {
            this.setView(new SubstanceWrappedPlainView(defaultRootElement, ((JTextArea)this.getComponent()).getWrapStyleWord()));
        }
    }

    protected void paintSafely(Graphics _g) {
        Graphics2D dummy = (Graphics2D)_g.create(0, 0, 0, 0);
        super.paintSafely(dummy);
        dummy.dispose();
        SubstanceCoreUtilities.paintTextComponent(_g, this.textArea, this.getRootView(this.textArea), this.getVisibleEditorRect());
    }
}

