/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance.utils;

import java.awt.Component;
import java.util.Set;
import org.jvnet.lafwidget.animation.FadeKind;
import org.jvnet.lafwidget.animation.FadeState;
import org.jvnet.lafwidget.animation.FadeTracker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubstanceFadeUtilities {
    public static Component getTracked(FadeKind fadeKind, Component ... comps) {
        FadeTracker tracker = FadeTracker.getInstance();
        Component result = null;
        float highest = -1.0f;
        for (Component comp : comps) {
            float fade10;
            if (!tracker.isTracked(comp, fadeKind) || !((fade10 = tracker.getFade10(comp, fadeKind)) > highest)) continue;
            result = comp;
            highest = fade10;
        }
        return result;
    }

    public static FadeState getFadeStateWithHighestFadeCycle(FadeKind fadeKind, Component ... comps) {
        FadeTracker tracker = FadeTracker.getInstance();
        FadeState result = null;
        float highest = -1.0f;
        for (Component comp : comps) {
            FadeState curr = tracker.getFadeState(comp, fadeKind);
            if (curr == null || !(curr.getFadePosition() > highest)) continue;
            result = curr;
            highest = curr.getFadePosition();
        }
        return result;
    }

    public static FadeState getFadeState(Component comp, FadeKind ... fadeKinds) {
        FadeTracker tracker = FadeTracker.getInstance();
        for (FadeKind fadeKind : fadeKinds) {
            try {
                FadeState result = tracker.getFadeState(comp, fadeKind);
                if (result == null) continue;
                return result;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return null;
    }

    public static FadeState getFadeState(Component comp, Comparable<?> comparable, FadeKind ... fadeKinds) {
        FadeTracker tracker = FadeTracker.getInstance();
        for (FadeKind fadeKind : fadeKinds) {
            FadeState result = tracker.getFadeState(comp, comparable, fadeKind);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public static void cancelFades(Set<Long> initiatedFadeSequences) {
        FadeTracker fadeTrackerInstance = FadeTracker.getInstance();
        for (long fadeId : initiatedFadeSequences) {
            fadeTrackerInstance.cancelFadeInstance(fadeId);
        }
    }
}

