/*
 * Decompiled with CFR 0.152.
 */
package invoicexpluginemail;

import it.tnx.commons.cu;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class EmailAddress {
    private String email;
    private String nome;

    public EmailAddress(String email, String nome) {
        this.email = email;
        this.nome = nome;
    }

    public String toString() {
        return this.getEmail();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EmailAddress)) {
            return false;
        }
        EmailAddress email2 = (EmailAddress)obj;
        return email2.getEmail() != null && this.getEmail() != null && email2.getEmail().equalsIgnoreCase(this.getEmail());
    }

    public int hashCode() {
        return (cu.s((Object)this.getEmail()) + cu.s((Object)this.getNome())).hashCode();
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getNome() {
        return this.nome;
    }

    public void setNome(String nome) {
        this.nome = nome;
    }

    public static EmailAddress parse(String email) {
        if (email.indexOf("<") > 0 && email.indexOf(">") > 0) {
            String tmpemail = StringUtils.substringAfter((String)email, (String)"<");
            tmpemail = StringUtils.substringBefore((String)tmpemail, (String)">");
            tmpemail = StringUtils.trim((String)tmpemail);
            String nome = StringUtils.substringBefore((String)email, (String)"<");
            nome = StringUtils.trim((String)nome);
            return new EmailAddress(tmpemail, nome);
        }
        return new EmailAddress(email, null);
    }

    static String toStringFull(List<EmailAddress> to, String sep) {
        String out = "";
        for (EmailAddress emailaddr : to) {
            out = out + emailaddr.toStringFull() + sep;
        }
        if (StringUtils.isNotBlank((String)out)) {
            out = StringUtils.chop((String)out);
        }
        return out;
    }

    String toStringFull() {
        if (StringUtils.isBlank((String)this.nome)) {
            return this.email;
        }
        return this.nome + " <" + this.email + ">";
    }
}

