/*
 * Decompiled with CFR 0.152.
 */
package invoicexpluginemail;

import invoicexpluginemail.Email;
import it.tnx.commons.SwingUtils;
import it.tnx.commons.cu;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Worker;
import javafx.embed.swing.JFXPanel;
import javafx.event.EventHandler;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebEvent;
import javafx.scene.web.WebView;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.apache.commons.lang.StringUtils;
import org.jdesktop.layout.GroupLayout;

public class JPanelBodyHtml
extends JPanel {
    private WebView tinymceview;
    private Email email;
    private boolean ready = false;
    String htmlContent = null;
    String prebody = null;
    String postbody = null;
    private JFXPanel jfxpanel;

    public JPanelBodyHtml() {
        this.initComponents();
        this.createScene();
    }

    private void createScene() {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                JPanelBodyHtml.this.tinymceview = this.getWebView();
                Scene scene = new Scene((Parent)JPanelBodyHtml.this.tinymceview);
                JPanelBodyHtml.this.jfxpanel.setScene(scene);
                JPanelBodyHtml.this.tinymceview.getEngine().load("http://server.invoicex.it/tinymce/");
            }

            private WebView getWebView() {
                WebView view = new WebView();
                final WebEngine engine = view.getEngine();
                engine.setOnStatusChanged((EventHandler)new EventHandler<WebEvent<String>>(){

                    public void handle(final WebEvent<String> event) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                System.out.println("webengine status changed: " + (String)event.getData());
                            }
                        });
                    }
                });
                engine.locationProperty().addListener((ChangeListener)new ChangeListener<String>(){

                    public void changed(ObservableValue<? extends String> ov, String oldValue, final String newValue) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                System.out.println("webengine location changed: " + newValue);
                            }
                        });
                    }
                });
                engine.getLoadWorker().workDoneProperty().addListener((ChangeListener)new ChangeListener<Number>(){

                    public void changed(ObservableValue<? extends Number> observableValue, Number oldValue, final Number newValue) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                System.out.println("webengine progressbar = " + newValue.intValue());
                            }
                        });
                    }
                });
                engine.getLoadWorker().exceptionProperty().addListener((ChangeListener)new ChangeListener<Throwable>(){

                    public void changed(ObservableValue<? extends Throwable> o, Throwable old, final Throwable value) {
                        System.out.println("webengine exceptionProperty changed: old:" + old + " new:" + value);
                        if (engine.getLoadWorker().getState() == Worker.State.FAILED) {
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    JOptionPane.showMessageDialog(JPanelBodyHtml.this, value != null ? engine.getLocation() + "\n" + value.getMessage() : engine.getLocation() + "\nUnexpected error.", "Loading error...", 0);
                                }
                            });
                        }
                    }
                });
                return view;
            }
        });
    }

    private void initComponents() {
        this.jfxpanel = new JFXPanel();
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jfxpanel, -1, 467, Short.MAX_VALUE));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jfxpanel, -1, 314, Short.MAX_VALUE));
    }

    public void getHtmlContent() {
        this.getHtmlContent(null);
    }

    public void getHtmlContent(final Runnable runlater) {
        Runnable run = new Runnable(){

            @Override
            public void run() {
                if (JPanelBodyHtml.this.getEmail() != null) {
                    JPanelBodyHtml.this.htmlContent = cu.s((Object)JPanelBodyHtml.this.tinymceview.getEngine().executeScript("tinyMCE.activeEditor.getContent({format : 'raw'})"));
                    JPanelBodyHtml.this.getEmail().setCorpo(JPanelBodyHtml.this.prebody + "<body>" + JPanelBodyHtml.this.htmlContent + "</body>" + JPanelBodyHtml.this.postbody);
                } else {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SwingUtils.showErrorMessage((Component)JPanelBodyHtml.this, (String)"Errore: getEmail null");
                        }
                    });
                }
                if (runlater != null) {
                    SwingUtilities.invokeLater(runlater);
                }
            }
        };
        Platform.runLater((Runnable)run);
    }

    public void setHtmlContent(final String html) {
        this.prebody = "";
        if (html.indexOf("<body>") >= 0) {
            this.prebody = StringUtils.substringBefore((String)html, (String)"<body>");
        }
        this.postbody = "";
        if (html.indexOf("</body>") >= 0) {
            this.postbody = StringUtils.substringAfterLast((String)html, (String)"</body>");
        }
        Runnable run = new Runnable(){

            @Override
            public void run() {
                String html2 = StringUtils.replace((String)html, (String)"'", (String)"\\'");
                html2 = StringUtils.replace((String)html2, (String)"\n", (String)"");
                JPanelBodyHtml.this.tinymceview.getEngine().executeScript("tinyMCE.activeEditor.setContent('" + html2 + "', {format : 'raw'})");
            }
        };
        Platform.runLater((Runnable)run);
    }

    public Email getEmail() {
        return this.email;
    }

    public void setEmail(Email email) {
        this.email = email;
    }

    public boolean isReady() {
        if (this.ready) {
            return true;
        }
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                if (JPanelBodyHtml.this.tinymceview.getEngine().getLoadWorker().getState() == Worker.State.SUCCEEDED) {
                    JPanelBodyHtml.this.setReady(true);
                }
            }
        });
        return false;
    }

    public void setReady(boolean ready) {
        this.ready = ready;
    }
}

