/*
 * Decompiled with CFR 0.152.
 */
package invoicexplugininvoicex;

import java.awt.Component;
import java.awt.HeadlessException;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import javafx.application.Platform;
import javafx.embed.swing.JFXPanel;
import javafx.stage.DirectoryChooser;
import javafx.stage.FileChooser;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.filechooser.FileSystemView;

public class NativeJFileChooserFx
extends JFileChooser {
    public static final boolean FX_AVAILABLE = true;
    private List<File> currentFiles;
    private FileChooser fileChooser;
    private File currentFile;
    private DirectoryChooser directoryChooser;

    public NativeJFileChooserFx() {
        this.initFxFileChooser(null);
    }

    public NativeJFileChooserFx(String currentDirectoryPath) {
        super(currentDirectoryPath);
        this.initFxFileChooser(new File(currentDirectoryPath));
    }

    public NativeJFileChooserFx(File currentDirectory) {
        super(currentDirectory);
        this.initFxFileChooser(currentDirectory);
    }

    public NativeJFileChooserFx(FileSystemView fsv) {
        super(fsv);
        this.initFxFileChooser(fsv.getDefaultDirectory());
    }

    public NativeJFileChooserFx(File currentDirectory, FileSystemView fsv) {
        super(currentDirectory, fsv);
        this.initFxFileChooser(currentDirectory);
    }

    public NativeJFileChooserFx(String currentDirectoryPath, FileSystemView fsv) {
        super(currentDirectoryPath, fsv);
        this.initFxFileChooser(new File(currentDirectoryPath));
    }

    @Override
    public int showOpenDialog(final Component parent) throws HeadlessException {
        final CountDownLatch latch = new CountDownLatch(1);
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                if (parent != null) {
                    parent.setEnabled(false);
                }
                if (NativeJFileChooserFx.this.isDirectorySelectionEnabled()) {
                    NativeJFileChooserFx.this.currentFile = NativeJFileChooserFx.this.directoryChooser.showDialog(null);
                } else if (NativeJFileChooserFx.this.isMultiSelectionEnabled()) {
                    NativeJFileChooserFx.this.currentFiles = NativeJFileChooserFx.this.fileChooser.showOpenMultipleDialog(null);
                } else {
                    NativeJFileChooserFx.this.currentFile = NativeJFileChooserFx.this.fileChooser.showOpenDialog(null);
                }
                latch.countDown();
            }
        });
        try {
            latch.await();
        }
        catch (InterruptedException ex) {
            throw new RuntimeException(ex);
        }
        finally {
            if (parent != null) {
                parent.setEnabled(true);
            }
        }
        if (this.isMultiSelectionEnabled()) {
            if (this.currentFiles != null) {
                return 0;
            }
            return 1;
        }
        if (this.currentFile != null) {
            return 0;
        }
        return 1;
    }

    @Override
    public int showSaveDialog(final Component parent) throws HeadlessException {
        final CountDownLatch latch = new CountDownLatch(1);
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                if (parent != null) {
                    parent.setEnabled(false);
                }
                if (NativeJFileChooserFx.this.isDirectorySelectionEnabled()) {
                    NativeJFileChooserFx.this.currentFile = NativeJFileChooserFx.this.directoryChooser.showDialog(null);
                } else {
                    NativeJFileChooserFx.this.currentFile = NativeJFileChooserFx.this.fileChooser.showSaveDialog(null);
                }
                latch.countDown();
            }
        });
        try {
            latch.await();
        }
        catch (InterruptedException ex) {
            throw new RuntimeException(ex);
        }
        finally {
            if (parent != null) {
                parent.setEnabled(true);
            }
        }
        if (this.currentFile != null) {
            return 0;
        }
        return 1;
    }

    @Override
    public int showDialog(Component parent, String approveButtonText) {
        return this.showOpenDialog(parent);
    }

    @Override
    public File[] getSelectedFiles() {
        if (this.currentFiles == null) {
            return null;
        }
        return this.currentFiles.toArray(new File[this.currentFiles.size()]);
    }

    @Override
    public File getSelectedFile() {
        return this.currentFile;
    }

    @Override
    public void setSelectedFiles(File[] selectedFiles) {
        if (selectedFiles == null || selectedFiles.length == 0) {
            this.currentFiles = null;
        } else {
            this.setSelectedFile(selectedFiles[0]);
            this.currentFiles = new ArrayList<File>(Arrays.asList(selectedFiles));
        }
    }

    @Override
    public void setSelectedFile(File file) {
        this.currentFile = file;
        if (file != null) {
            if (file.isDirectory()) {
                this.fileChooser.setInitialDirectory(file.getAbsoluteFile());
                if (this.directoryChooser != null) {
                    this.directoryChooser.setInitialDirectory(file.getAbsoluteFile());
                }
            } else if (file.isFile()) {
                this.fileChooser.setInitialDirectory(file.getParentFile());
                this.fileChooser.setInitialFileName(file.getName());
                if (this.directoryChooser != null) {
                    this.directoryChooser.setInitialDirectory(file.getParentFile());
                }
            }
        }
    }

    @Override
    public void setFileSelectionMode(int mode) {
        super.setFileSelectionMode(mode);
        if (mode == 1) {
            if (this.directoryChooser == null) {
                this.directoryChooser = new DirectoryChooser();
            }
            this.setSelectedFile(this.currentFile);
            this.setDialogTitle(this.getDialogTitle());
        }
    }

    @Override
    public void setDialogTitle(String dialogTitle) {
        this.fileChooser.setTitle(dialogTitle);
        if (this.directoryChooser != null) {
            this.directoryChooser.setTitle(dialogTitle);
        }
    }

    @Override
    public String getDialogTitle() {
        return this.fileChooser.getTitle();
    }

    @Override
    public void changeToParentDirectory() {
        File parentDir = this.fileChooser.getInitialDirectory().getParentFile();
        if (parentDir.isDirectory()) {
            this.fileChooser.setInitialDirectory(parentDir);
            if (this.directoryChooser != null) {
                this.directoryChooser.setInitialDirectory(parentDir);
            }
        }
    }

    @Override
    public void addChoosableFileFilter(FileFilter filter) {
        super.addChoosableFileFilter(filter);
        if (filter == null) {
            return;
        }
        if (filter.getClass().equals(FileNameExtensionFilter.class)) {
            FileNameExtensionFilter f = (FileNameExtensionFilter)filter;
            ArrayList<String> ext = new ArrayList<String>();
            for (String extension : f.getExtensions()) {
                ext.add(extension.replaceAll("^\\*?\\.?(.*)$", "*.$1"));
            }
            this.fileChooser.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter(f.getDescription(), ext));
        }
    }

    @Override
    public void setAcceptAllFileFilterUsed(boolean bool) {
        boolean differs = this.isAcceptAllFileFilterUsed() ^ bool;
        super.setAcceptAllFileFilterUsed(bool);
        if (!differs) {
            return;
        }
        if (bool) {
            this.fileChooser.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter("All files", new String[]{"*.*"}));
        } else {
            Iterator it = this.fileChooser.getExtensionFilters().iterator();
            while (it.hasNext()) {
                FileChooser.ExtensionFilter filter = (FileChooser.ExtensionFilter)it.next();
                if (filter.getExtensions().size() != 1 || !filter.getExtensions().contains("*.*")) continue;
                it.remove();
            }
        }
    }

    private void initFxFileChooser(File currentFile) {
        this.fileChooser = new FileChooser();
        this.currentFile = currentFile;
        this.setSelectedFile(currentFile);
    }

    static {
        JFXPanel jFXPanel = new JFXPanel();
    }
}

