/*
 * Decompiled with CFR 0.152.
 */
package invoicexplugininvoicex.abicab;

import au.com.bytecode.opencsv.CSVReader;
import it.tnx.Zip;
import it.tnx.commons.DateUtils;
import it.tnx.commons.cu;
import it.tnx.commons.dbu;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;

public class MakeUpdate {
    private static final Map<String, String> ABBREVIAZIONI = new HashMap<String, String>();

    public static void main(String[] args) throws FileNotFoundException, IOException, SQLException {
        String[] line;
        String nomeBanca = "Cassa di Risparmio di Firenze";
        String abbreviazione = MakeUpdate.abbrevia(nomeBanca);
        System.out.println("Abbreviazione di " + nomeBanca + ": " + abbreviazione);
        nomeBanca = "Unicredit Group";
        abbreviazione = MakeUpdate.abbrevia(nomeBanca);
        System.out.println("Abbreviazione di " + nomeBanca + ": " + abbreviazione);
        nomeBanca = "Banco BPM";
        abbreviazione = MakeUpdate.abbrevia(nomeBanca);
        System.out.println("Abbreviazione di " + nomeBanca + ": " + abbreviazione);
        File ftababi = new File("C:\\lavori\\tnx\\private\\Invoicex_altro\\abicab\\2025-02-14_ATTIVITA.csv");
        CSVReader csvr = new CSVReader((Reader)new FileReader(ftababi), ';', '\"', 1);
        int contarighetotali = 0;
        while ((line = csvr.readNext()) != null) {
            ++contarighetotali;
        }
        System.out.println("contarighetotali abi = " + contarighetotali);
        File ftababicab = new File("C:\\lavori\\tnx\\private\\Invoicex_altro\\abicab\\2025-02-17_SUCCURSALI_BANCHE.csv");
        csvr = new CSVReader((Reader)new FileReader(ftababicab), ';', '\"', 1);
        contarighetotali = 0;
        while ((line = csvr.readNext()) != null) {
            ++contarighetotali;
        }
        System.out.println("contarighetotali cab = " + contarighetotali);
        csvr = new CSVReader((Reader)new FileReader(ftababi), ';', '\"', 1);
        int rigan = 0;
        String abi = "";
        int conta = 0;
        File outabi = new File("C:\\lavori\\tnx\\private\\Invoicex_altro\\abicab\\outabi.sql");
        FileWriter outabiw = new FileWriter(outabi);
        File outcab = new File("C:\\lavori\\tnx\\private\\Invoicex_altro\\abicab\\outcab.sql");
        FileWriter outcabw = new FileWriter(outcab);
        while ((line = csvr.readNext()) != null) {
            if (++rigan % 100 == 0) {
                String string = 100 * rigan / contarighetotali + "% [" + abi + "]";
            }
            try {
                String[] campi = line;
                String sql = "replace into banche_abi set ";
                String fine = campi[12];
                Date dataFine = cu.toDate((Object)fine);
                String tipo = campi[5];
                abi = campi[1];
                abi = StringUtils.left((String)abi, (int)5);
                if ((abi = String.format("%05d", cu.i0((Object)abi))).equals("00000") || !tipo.equals("ATTIVITA BANCARIA") || !fine.equals("9999-12-31") && DateUtils.getYear((Date)dataFine) <= 2000) continue;
                ++conta;
                String abbr = MakeUpdate.abbrevia(campi[2]);
                String sqlc = " abi = " + dbu.sql((Object)abi);
                sqlc = sqlc + ", nome = " + dbu.sql((Object)abbr);
                sqlc = sqlc + ", nome_esteso = " + dbu.sql((Object)campi[2]);
                sqlc = sqlc + ", data_fine = " + dbu.sql((Object)(DateUtils.getYear((Date)dataFine) == 9999 ? null : dataFine));
                sql = sql + sqlc;
                if (abbr.length() <= 8 || abbr.length() > 30) {
                    System.out.println("sqlc = " + sql + "\n");
                }
                IOUtils.write((String)(sql + "\n"), (Writer)outabiw);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        csvr = new CSVReader((Reader)new FileReader(ftababicab), ';', '\"', 1);
        String sql = "replace into banche_cab (abi, cab, indirizzo, cap) values ";
        String sqlrep = "";
        String sqldel = "";
        while ((line = csvr.readNext()) != null) {
            ++rigan;
            try {
                String[] campi = line;
                String fine = campi[8];
                Date dataFine = cu.toDate((Object)fine);
                abi = campi[2];
                abi = StringUtils.left((String)abi, (int)5);
                abi = String.format("%05d", cu.i0((Object)abi));
                String cab = campi[4];
                cab = StringUtils.left((String)cab, (int)5);
                cab = String.format("%05d", cu.i0((Object)cab));
                String indirizzo = campi[11];
                String cap = campi[12];
                if (abi.equals("00000") || cab.equals("00000") || !fine.equals("9999-12-31") && DateUtils.getYear((Date)dataFine) <= 2020) continue;
                ++conta;
                String sqlc = "(" + dbu.sql((Object)abi);
                sqlc = sqlc + "," + dbu.sql((Object)cab);
                sqlc = sqlc + "," + dbu.sql((Object)indirizzo);
                sqlc = sqlc + "," + dbu.sql((Object)cap);
                sqlc = sqlc + ")";
                if (conta % 100 != 0) continue;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        if (conta % 100 != 0) {
            // empty if block
        }
        outabiw.close();
        outcabw.close();
        Zip.createZip((String)outabi.getAbsolutePath(), (String)(outabi.getAbsolutePath() + ".zip"));
        Zip.createZip((String)outcab.getAbsolutePath(), (String)(outcab.getAbsolutePath() + ".zip"));
        System.out.println("conta = " + conta);
        String test = "BANCA PATAVINA CREDITO COOPERATVO DI SANT'ELENA E PIOVE DI SACCO, SOCIETA' COOPERATIVA";
        System.out.println(MakeUpdate.abbrevia(test));
        test = "BANCA DI CREDITO COOPERATIVO - CASSA RURALE ED ARTIGIANA 'MARIA SS. DI GULFI' DI CHIARAMONTE GULFI (RG)";
        System.out.println(MakeUpdate.abbrevia(test));
        test = "KARNTNER SPARKASSE AKTIENGESELLSCHAFT";
        System.out.println(MakeUpdate.abbrevia(test));
    }

    public static String abbrevia(String nomeBanca) {
        if (ABBREVIAZIONI.containsKey(nomeBanca)) {
            return ABBREVIAZIONI.get(nomeBanca);
        }
        nomeBanca = StringUtils.substringBefore((String)nomeBanca, (String)" - ");
        nomeBanca = StringUtils.substringBefore((String)nomeBanca, (String)", ");
        nomeBanca = StringUtils.substringBefore((String)nomeBanca, (String)"-BANCA");
        nomeBanca = StringUtils.substringBefore((String)nomeBanca, (String)"-CREDITO");
        nomeBanca = StringUtils.substringBefore((String)nomeBanca, (String)"-CASSA");
        nomeBanca = StringUtils.replace((String)nomeBanca, (String)" -", (String)"");
        nomeBanca = StringUtils.replace((String)nomeBanca, (String)",", (String)"");
        nomeBanca = StringUtils.replace((String)nomeBanca, (String)" SOCIETA' COOPERATIVA PER AZIONI A RESPONSABILITA' LIMITATA", (String)"");
        nomeBanca = StringUtils.replace((String)nomeBanca, (String)" SOCIETA' COOPERATIVA PER AZIONI", (String)"");
        nomeBanca = StringUtils.replace((String)nomeBanca, (String)" SOCIETA' COOPERATIVA", (String)"");
        nomeBanca = StringUtils.replace((String)nomeBanca, (String)" SOCIETA'COOPERATIVA", (String)"");
        nomeBanca = StringUtils.replace((String)nomeBanca, (String)" SOCIETA' PER AZIONI", (String)"");
        nomeBanca = StringUtils.replace((String)nomeBanca, (String)"CREDITO COOPERATIVO SOCIETA' COOPERATIVA", (String)"");
        nomeBanca = StringUtils.replace((String)nomeBanca, (String)" A RESPONSABILITA' LIMITATA", (String)"");
        nomeBanca = StringUtils.replace((String)nomeBanca, (String)" IN AMMINISTRAZIONE STRAORDINARIA", (String)"");
        nomeBanca = StringUtils.replace((String)nomeBanca, (String)" IN LIQUIDAZIONE COATTA AMMINISTRATIVA", (String)"");
        nomeBanca = StringUtils.replace((String)nomeBanca, (String)" RESPONSABILITA' LIMITATA", (String)"");
        nomeBanca = StringUtils.replace((String)nomeBanca, (String)" IN LIQUIDAZIONE", (String)"");
        nomeBanca = StringUtils.replace((String)nomeBanca, (String)"BANCA DI CREDITO COOPERATIVO ", (String)"BANCA ");
        nomeBanca = StringUtils.replace((String)nomeBanca, (String)" - S.P.A.", (String)"");
        nomeBanca = StringUtils.replace((String)nomeBanca, (String)" - SPA", (String)"");
        nomeBanca = StringUtils.replace((String)nomeBanca, (String)" S.P.A.", (String)"");
        nomeBanca = StringUtils.chomp((String)nomeBanca, (String)" SPA");
        nomeBanca = StringUtils.replace((String)nomeBanca, (String)" S.C.", (String)"");
        nomeBanca = StringUtils.replace((String)nomeBanca, (String)" CREDITO COOPERATIVO S. C. IN L.C.A.", (String)"");
        nomeBanca = StringUtils.replace((String)nomeBanca, (String)"  BANCA DI CREDITO COOPERATIVO", (String)"");
        nomeBanca = StringUtils.chomp((String)nomeBanca, (String)"-");
        nomeBanca = StringUtils.chomp((String)nomeBanca, (String)",");
        nomeBanca = StringUtils.trim((String)nomeBanca);
        if ((nomeBanca = StringUtils.substringBefore((String)nomeBanca, (String)" (")).indexOf("ABBREVIATO ") >= 0) {
            nomeBanca = StringUtils.substringAfter((String)nomeBanca, (String)"ABBREVIATO ");
        }
        if (nomeBanca.indexOf("IN BREVE ") >= 0) {
            nomeBanca = StringUtils.substringAfter((String)nomeBanca, (String)"IN BREVE ");
        }
        if (nomeBanca.indexOf("O IN FORMA ABBREVIATA ") >= 0) {
            nomeBanca = StringUtils.substringAfter((String)nomeBanca, (String)"O IN FORMA ABBREVIATA ");
        }
        if (nomeBanca.indexOf("IN FORMA ABBREVIATA ") >= 0) {
            nomeBanca = StringUtils.substringAfter((String)nomeBanca, (String)"IN FORMA ABBREVIATA ");
        }
        return nomeBanca;
    }

    public static String padLeftZeros(String input) {
        int lunghezza = input.length();
        if (lunghezza < 5) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < 5 - lunghezza; ++i) {
                sb.append('0');
            }
            sb.append(input);
            return sb.toString();
        }
        return input;
    }

    static {
        ABBREVIAZIONI.put("Credito Emiliano", "Credem");
        ABBREVIAZIONI.put("Cassa di Risparmio di Firenze", "CR Firenze");
    }
}

