/*
 * Decompiled with CFR 0.152.
 */
package invoicexplugininvoicex.xmlpa;

import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.gson.Gson;
import gestioneFatture.main;
import invoicexplugininvoicex.Main;
import invoicexplugininvoicex.allegati.AllegatiUtil;
import invoicexplugininvoicex.allegati.SmbUtil;
import invoicexplugininvoicex.dropbox.DropboxInit;
import invoicexplugininvoicex.dropbox.DropboxUtil;
import invoicexplugininvoicex.xmlpa.ExportXmlEsito;
import invoicexplugininvoicex.xmlpa.Input;
import invoicexplugininvoicex.xmlpa.JInternalFrameExportXmlPa3;
import invoicexplugininvoicex.xmlpa.JPanelMsgEnasarcoVecchioModo;
import invoicexplugininvoicex.xu;
import it.tnx.Db;
import it.tnx.Util;
import it.tnx.Zip;
import it.tnx.commons.DateUtils;
import it.tnx.commons.DbUtils;
import it.tnx.commons.FileUtils;
import it.tnx.commons.FormatUtils;
import it.tnx.commons.SwingUtils;
import it.tnx.commons.SystemUtils;
import it.tnx.commons.cu;
import it.tnx.commons.dbu;
import it.tnx.commons.fu;
import it.tnx.invoicex.InvoicexUtil;
import it.tnx.invoicex.gui.JDialogProgress;
import it.tnx.invoicex.iu;
import it.tnx.invoicex2.fe.Sdi;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.Frame;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import javax.swing.JDialog;
import javax.swing.JInternalFrame;
import javax.swing.JOptionPane;
import javax.swing.JTextArea;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Highlighter;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import org.jdesktop.swingworker.SwingWorker;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.SAXParseException;

public class ExportXmlPa3 {
    String vIdTrasmittenteIdPaese = "";
    String vIdTrasmittenteIdCodice = "";
    String vProgressivoInvio = "";
    String vProgressivoInvioB36 = "";
    String vFormatoTrasmissione = "SDI10";
    String vCodiceDestinatario = "";
    String vPec;
    String vContattiTrasmittenteTelefono = "";
    String vContattiTrasmittenteEmail = "";
    String vCedenteIdPaese = "";
    String vCedenteIdCodice = "";
    String vCedenteCodiceFiscale = "";
    String vDenominazione = "";
    String vTitolo = "";
    String vCognome = "";
    String vNome = "";
    String vRegimeFiscale = "";
    String vIndirizzo = "";
    String vCAP = "";
    String vComune = "";
    String vProvincia = "";
    String vNazione = "";
    String vRiferimento = "";
    String vEmail = "";
    String vTelefono = "";
    String vFax = "";
    String vCedenteReaUfficio = "";
    String vCedenteReaNumero = "";
    String vCedenteReaCapitaleSociale = "";
    String vCedenteReaSocioUnico = "";
    String vCedenteReaStatoLiquidazione = "";
    Document document = DocumentHelper.createDocument();
    Element root = null;
    List<Map> fatture = null;
    Map destinatari = null;
    String ver = "1.3";
    public String lastFileGen;
    private boolean acquisto = false;
    private boolean auto_fattura_vendita = false;
    String tabt = "test_fatt";

    public ExportXmlPa3(List<Map> fatture, Map destinatari, boolean acquisto, boolean auto_fattura_vendita) {
        this.fatture = fatture;
        this.destinatari = destinatari;
        this.acquisto = acquisto;
        this.auto_fattura_vendita = auto_fattura_vendita;
        if (acquisto) {
            this.tabt = "test_fatt_acquisto";
        }
    }

    public void export(JDialog parent) throws InterruptedException, ExecutionException {
        this.export((Component)parent);
    }

    public void export(final Component parent) throws InterruptedException, ExecutionException {
        final ExportXmlEsito esito = new ExportXmlEsito();
        esito.fatture_generate = 0;
        String msg = "";
        block0: for (Map fattura : this.fatture) {
            List ive = (List)fattura.get("totali_iva");
            if (ive.size() <= 1 || cu.d0(fattura.get("totaleRivalsa")) != 0.0) {
                // empty if block
            }
            if (cu.d0(fattura.get("totale_ritenuta")) != 0.0 && StringUtils.isBlank((String)cu.s(((Map)fattura.get("datipa")).get("dg_dr_tipo_ritenuta")))) {
                msg = msg + "La fattura " + fattura.get("serie") + fattura.get("numero") + " non pu\u00f2 essere esportata perch\u00e8 ha la ritenuta ma non \u00e8 specificato il 'Tipo ritenuta' nei dati 'Fattura Elettronica'\n";
            }
            if (cu.d0(fattura.get("totale_ritenuta2")) != 0.0 && StringUtils.isBlank((String)cu.s(((Map)fattura.get("datipa")).get("dg_dr_tipo_ritenuta2")))) {
                msg = msg + "La fattura " + fattura.get("serie") + fattura.get("numero") + " non pu\u00f2 essere esportata perch\u00e8 ha la ritenuta (altra) ma non \u00e8 specificato il 'Tipo ritenuta' nei dati 'Fattura Elettronica'\n";
            }
            if (cu.d0(fattura.get("totaleRivalsa")) != 0.0 && StringUtils.isBlank((String)cu.s(((Map)fattura.get("datipa")).get("dg_dcp_tipo_cassa")))) {
                msg = msg + "La fattura " + fattura.get("serie") + fattura.get("numero") + " non pu\u00f2 essere esportata perch\u00e8 ha la rivalsa ma non \u00e8 specificato il 'Tipo cassa' nei dati 'Fattura Elettronica'\n";
            }
            if (cu.d0(fattura.get("totale_ritenuta")) != 0.0 && StringUtils.isBlank((String)cu.s(((Map)fattura.get("datipa")).get("dg_dr_causale_pagamento")))) {
                msg = msg + "La fattura " + fattura.get("serie") + fattura.get("numero") + " non pu\u00f2 essere esportata perch\u00e8 ha la ritenuta ma non \u00e8 specificato la 'Causale pagamento' nei dati 'Fattura Elettronica'\n";
            }
            if (cu.d0(fattura.get("totale_ritenuta2")) != 0.0 && StringUtils.isBlank((String)cu.s(((Map)fattura.get("datipa")).get("dg_dr_causale_pagamento2")))) {
                msg = msg + "La fattura " + fattura.get("serie") + fattura.get("numero") + " non pu\u00f2 essere esportata perch\u00e8 ha la ritenuta (altra) ma non \u00e8 specificato la 'Causale pagamento' nei dati 'Fattura Elettronica'\n";
            }
            for (Map riga : (List)fattura.get("righe")) {
                if (cu.d0(riga.get("perc_iva")) != 0.0 || !cu.sIsBlank(riga.get("codice_natura_xmlpa"))) continue;
                msg = msg + "La fattura " + fattura.get("serie") + fattura.get("numero") + " non pu\u00f2 essere esportata perch\u00e8 ha una riga con IVA 0% senza specificare la Natura, vai in Anagrafiche > Codici IVA ed assegna la natura al codice IVA " + riga.get("iva") + "\n";
                continue block0;
            }
        }
        if (StringUtils.isNotBlank((String)msg)) {
            SwingUtils.mouse_def((Component)parent);
            if (parent instanceof JInternalFrameExportXmlPa3) {
                ((JInternalFrameExportXmlPa3)parent).myGlassPane.setVisible(false);
            }
            SwingUtils.showErrorMessage((Component)parent, (String)("Problema durante l'esportazione\n" + msg), (String)"Errore", (boolean)true);
            return;
        }
        JDialogProgress tmpWait = null;
        tmpWait = parent instanceof JDialog ? new JDialogProgress((Dialog)((JDialog)parent), false) : new JDialogProgress((Frame)main.getPadreFrame(), false);
        final JDialogProgress wait = tmpWait;
        wait.setLocationRelativeTo(parent);
        wait.progressbar.setMaximum(this.fatture.size());
        wait.progressbar.setValue(1);
        wait.progressbar.setIndeterminate(false);
        wait.setVisible(true);
        SwingWorker w = new SwingWorker(){
            Map lastFattura = null;

            protected Object doInBackground() throws Exception {
                Iterator<Map> iterator = ExportXmlPa3.this.fatture.iterator();
                while (iterator.hasNext()) {
                    Map fattura;
                    this.lastFattura = fattura = iterator.next();
                    this.publish(new Object[]{esito.fatture_generate + 1});
                    Map destinatario = (Map)ExportXmlPa3.this.destinatari.get(fattura.get("id"));
                    boolean pubblico = cu.b(destinatario.get("xmlpa_flag_pa"));
                    String nomecampodest = pubblico ? "xmlpa_codice_ufficio" : "xmlpa_codice_dest";
                    ExportXmlPa3.this.vCodiceDestinatario = cu.s(destinatario.get(nomecampodest)).toUpperCase();
                    ExportXmlPa3.this.vPec = cu.s(destinatario.get("email_pec"));
                    ExportXmlPa3.this.vRiferimento = cu.s(destinatario.get("xmlpa_riferimento"));
                    ExportXmlPa3.this.document = DocumentHelper.createDocument();
                    ExportXmlPa3.this.root = ExportXmlPa3.this.document.addElement("ns2:FatturaElettronica");
                    ExportXmlPa3.this.vFormatoTrasmissione = pubblico ? "FPA12" : "FPR12";
                    ExportXmlPa3.this.root.addAttribute("versione", ExportXmlPa3.this.vFormatoTrasmissione);
                    ExportXmlPa3.this.root.addAttribute("xmlns:ns2", "http://ivaservizi.agenziaentrate.gov.it/docs/xsd/fatture/v1.2");
                    Object ret = ExportXmlPa3.this.exportSingolaFattura(ExportXmlPa3.this.root, pubblico, destinatario, fattura, (JInternalFrame)parent, esito);
                    if (ret instanceof ExportXmlEsito) {
                        return ret;
                    }
                    String filename = null;
                    String charset = "UTF-8";
                    StringWriter xml_utf8_w = new StringWriter();
                    try {
                        ExportXmlPa3.this.checkRinominaDirFatturePa();
                        String path = JInternalFrameExportXmlPa3.getPathFECustom();
                        File exportDir = new File(path);
                        exportDir.mkdirs();
                        filename = path + File.separator + ExportXmlPa3.this.vIdTrasmittenteIdPaese + ExportXmlPa3.this.vIdTrasmittenteIdCodice + "_" + (ExportXmlPa3.this.vProgressivoInvio != null ? ExportXmlPa3.this.vProgressivoInvio : ExportXmlPa3.this.vProgressivoInvioB36) + ".xml";
                        OutputFormat format = OutputFormat.createPrettyPrint();
                        Sdi sdi = Sdi.getNew();
                        String provider = cu.s(sdi.param.get("provider"));
                        if (StringUtils.isBlank((String)provider)) {
                            charset = "ISO-8859-1";
                        }
                        format.setEncoding(charset);
                        XMLWriter writer = new XMLWriter((Writer)new OutputStreamWriter((OutputStream)new FileOutputStream(filename), charset), format);
                        writer.write(ExportXmlPa3.this.document);
                        writer.close();
                        format.setEncoding("UTF-8");
                        XMLWriter writer_utf8 = new XMLWriter((Writer)xml_utf8_w, format);
                        writer_utf8.write(ExportXmlPa3.this.document);
                        writer_utf8.close();
                        ExportXmlPa3.this.document.clearContent();
                        ExportXmlPa3.this.document = null;
                        System.runFinalization();
                        Thread.sleep(50L);
                        System.gc();
                        Thread.sleep(50L);
                        ExportXmlPa3.this.lastFileGen = filename;
                        List allegati = (List)fattura.get("allegati");
                        Validator validator = null;
                        SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
                        String pathXsd = "/invoicexplugininvoicex/xmlpa/";
                        factory.setResourceResolver(new LSResourceResolver(){

                            @Override
                            public LSInput resolveResource(String type, String namespaceURI, String publicId, String systemId, String baseURI) {
                                System.out.println("/invoicexplugininvoicex/xmlpa/" + systemId);
                                String name = StringUtils.substringAfterLast((String)systemId, (String)"/");
                                if (StringUtils.isEmpty((String)name)) {
                                    name = systemId;
                                }
                                System.out.println("name = " + name);
                                InputStream resourceAsStream = this.getClass().getResourceAsStream("/invoicexplugininvoicex/xmlpa/" + name);
                                return new Input(publicId, systemId, resourceAsStream);
                            }
                        });
                        Source[] schemaFileSources = new Source[]{new StreamSource(((Object)((Object)this)).getClass().getResource("/invoicexplugininvoicex/xmlpa/Schema_VFPR12_29052020.xsd").toString())};
                        Schema schema = factory.newSchema(schemaFileSources);
                        validator = schema.newValidator();
                        System.out.println("validazione = " + filename);
                        validator.validate(new StreamSource(new File(filename)));
                        esito.filenames.add(filename);
                    }
                    catch (SAXParseException saxpe) {
                        return saxpe;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        return e;
                    }
                    try {
                        String xml = FileUtils.readContent((File)new File(filename));
                        try {
                            dbu.tryExecQuery((Connection)gestioneFatture.Db.getConn(), (String)("insert ignore into " + ExportXmlPa3.this.tabt + "_xmlpa set id_fattura = " + dbu.sql(fattura.get("id"))), (boolean)false);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        if (!charset.equals("UTF-8")) {
                            // empty if block
                        }
                        String sql = "";
                        sql = ExportXmlPa3.this.acquisto ? "update " + ExportXmlPa3.this.tabt + "_xmlpa  set file_xml_gen = " + dbu.sql((Object)xml_utf8_w.toString()) + " , file_xml_nome_gen = " + dbu.sql((Object)new File(filename).getName()) + " , file_xml_ts_gen = CURRENT_TIMESTAMP , file_xml_prog_gen = " + dbu.sql((Object)ExportXmlPa3.this.vProgressivoInvio) + " , file_xml_prog_gen_b36 = " + dbu.sql((Object)ExportXmlPa3.this.vProgressivoInvioB36) + " where id_fattura = " + dbu.sql(fattura.get("id")) : "update " + ExportXmlPa3.this.tabt + "_xmlpa  set file_xml = " + dbu.sql((Object)xml_utf8_w.toString()) + " , file_xml_nome = " + dbu.sql((Object)new File(filename).getName()) + " , file_xml_ts = CURRENT_TIMESTAMP , file_xml_prog = " + dbu.sql((Object)ExportXmlPa3.this.vProgressivoInvio) + " , file_xml_prog_b36 = " + dbu.sql((Object)ExportXmlPa3.this.vProgressivoInvioB36) + " where id_fattura = " + dbu.sql(fattura.get("id"));
                        System.out.println("sql = " + sql);
                        dbu.tryExecQuery((Connection)Db.getConn(), (String)sql);
                    }
                    catch (Exception e) {
                        return e;
                    }
                    if (ExportXmlPa3.this.vProgressivoInvioB36 != null) {
                        ExportXmlPa3.this.vProgressivoInvioB36 = Integer.toString(Integer.parseInt(ExportXmlPa3.this.vProgressivoInvioB36, 36) + 1, 36).toUpperCase();
                        ExportXmlPa3.this.vProgressivoInvioB36 = StringUtils.leftPad((String)ExportXmlPa3.this.vProgressivoInvioB36, (int)5, (char)'0');
                        ExportXmlPa3.this.vProgressivoInvio = null;
                    } else {
                        ExportXmlPa3.this.vProgressivoInvio = StringUtils.leftPad((String)cu.s((Object)(cu.i((Object)ExportXmlPa3.this.vProgressivoInvio) + 1)), (int)5, (char)'0');
                        ExportXmlPa3.this.vProgressivoInvioB36 = null;
                    }
                    if (ExportXmlPa3.this.vProgressivoInvio != null && cu.i((Object)ExportXmlPa3.this.vProgressivoInvio) == 100000) {
                        ExportXmlPa3.this.vProgressivoInvioB36 = StringUtils.leftPad((String)cu.s((Object)Integer.toString(100000, 36)).toUpperCase(), (int)5, (char)'0');
                        ExportXmlPa3.this.vProgressivoInvio = null;
                    }
                    Integer n = esito.fatture_generate;
                    ExportXmlEsito exportXmlEsito = esito;
                    Integer n2 = exportXmlEsito.fatture_generate = Integer.valueOf(exportXmlEsito.fatture_generate + 1);
                }
                esito.ret = true;
                return esito;
            }

            protected void process(List chunks) {
                for (Object o2 : chunks) {
                    Integer i = cu.i(o2);
                    wait.labStatus.setText(cu.s((Object)i) + "/" + ExportXmlPa3.this.fatture.size());
                    wait.progressbar.setValue(i);
                }
            }

            protected void done() {
                SwingUtils.mouse_def((Component)parent);
                wait.setVisible(false);
                if (parent instanceof JInternalFrameExportXmlPa3) {
                    ((JInternalFrameExportXmlPa3)parent).myGlassPane.setVisible(false);
                }
                Object ret = null;
                try {
                    ret = this.get();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (ret instanceof ExportXmlEsito) {
                    ExportXmlEsito esito2 = (ExportXmlEsito)ret;
                    if (esito2.ret) {
                        try {
                            HashMap<String, Object> r = new HashMap<String, Object>();
                            if (ExportXmlPa3.this.vProgressivoInvio != null) {
                                r.put("progressivo", cu.s((Object)(cu.i((Object)ExportXmlPa3.this.vProgressivoInvio) - 1)));
                            } else {
                                r.put("progressivob36", StringUtils.leftPad((String)Integer.toString(Integer.parseInt(ExportXmlPa3.this.vProgressivoInvioB36, 36) - 1, 36).toUpperCase(), (int)5, (char)'0'));
                            }
                            r.put("progressivo_ts", new Timestamp(System.currentTimeMillis()));
                            String sql = "update export_xml_pa_parametri set " + DbUtils.prepareSqlFromMap(r);
                            System.out.println("sql = " + sql);
                            DbUtils.tryExecQuery((Connection)Db.getConn(), (String)sql);
                        }
                        catch (Exception e) {
                            SwingUtils.showExceptionMessage((Component)parent, (Exception)e);
                        }
                        iu.aggiornaElenchiFatture();
                        File f = new File(esito2.filenames.get(0));
                        boolean aprire = false;
                        if (esito2.filenames.size() > 1) {
                            String strfiles = "";
                            int contafiles = 0;
                            for (String filename : esito2.filenames) {
                                strfiles = strfiles + new File(filename).getName() + "\n";
                                if (++contafiles <= 5) continue;
                                strfiles = strfiles + "...\n";
                                strfiles = strfiles + new File(esito2.filenames.get(esito2.filenames.size() - 1)).getName() + "\n";
                                break;
                            }
                            aprire = SwingUtils.showYesNoMessage((Component)parent, (String)("Generati " + esito2.filenames.size() + " file\nFile generati:\n" + strfiles + "\nVuoi aprire la cartella con i file generati ?"), (String)"Esportazione completata");
                        } else {
                            aprire = SwingUtils.showYesNoMessage((Component)parent, (String)("Generato il file " + f.getName() + " contenente " + esito2.fatture_generate + " " + (esito2.fatture_generate > 1 ? "fatture" : "fattura") + "\nVuoi aprire la cartella con il file generato ?"), (String)"Esportazione completata");
                        }
                        if (aprire) {
                            try {
                                Main.myOpenFolderSelectFile(f);
                            }
                            catch (IOException ex) {
                                SwingUtils.showExceptionMessage((Component)parent, (Exception)ex);
                            }
                        }
                        return;
                    }
                    if (esito2.ex != null) {
                        SwingUtils.showExceptionMessage((Component)parent, (Exception)esito2.ex);
                    } else {
                        SwingUtils.showErrorMessage((Component)parent, (String)"Errore durante la creazione del file", (boolean)true);
                    }
                } else if (ret instanceof SAXParseException) {
                    SAXParseException saxpe = (SAXParseException)ret;
                    JOptionPane optionPane = new JOptionPane();
                    boolean showFile = true;
                    String text = "";
                    int textToHighlightStart = 0;
                    int textToHighlightStop = 0;
                    try {
                        if (showFile) {
                            List lines = IOUtils.readLines((Reader)new FileReader(new File(ExportXmlPa3.this.lastFileGen)));
                            for (int i = 1; i <= 20; ++i) {
                                try {
                                    String line;
                                    int iline = i - 10 + saxpe.getLineNumber();
                                    if (iline <= 0) continue;
                                    if (iline == saxpe.getLineNumber()) {
                                        textToHighlightStart = text.length();
                                    }
                                    if ((line = (String)lines.get(iline - 1)).length() > 120) {
                                        line = line.substring(0, 120) + "... linea troncata perch\u00e8 troppo lunga";
                                    }
                                    text = text + iline + ": " + line + "\n";
                                    if (iline != saxpe.getLineNumber()) continue;
                                    textToHighlightStop = text.length();
                                    continue;
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                            }
                        } else {
                            text = "File non visualizzabile perch\u00e8 contiene allegati";
                        }
                        JTextArea textArea = new JTextArea(text);
                        textArea.setFont(new Font("Monospaced", 0, main.def_font.getSize()));
                        textArea.setEditable(false);
                        if (showFile) {
                            Highlighter highlighter = textArea.getHighlighter();
                            DefaultHighlighter.DefaultHighlightPainter painter = new DefaultHighlighter.DefaultHighlightPainter(Color.yellow);
                            highlighter.addHighlight(textToHighlightStart, textToHighlightStop, painter);
                        }
                        optionPane.setMessage(new Object[]{"Fattura " + this.lastFattura.get("serie") + "" + this.lastFattura.get("numero") + " del " + DateUtils.formatDateIta((Date)cu.toDate(this.lastFattura.get("data"))) + "\nErrore: " + saxpe.getMessage(), "alla riga " + saxpe.getLineNumber(), textArea});
                        optionPane.setMessageType(0);
                        optionPane.setOptionType(2);
                        JDialog dialog = optionPane.createDialog(parent, "Errore di validazione - " + ExportXmlPa3.this.lastFileGen);
                        dialog.setVisible(true);
                    }
                    catch (Exception ex) {
                        SwingUtils.showExceptionMessage((Component)parent, (Exception)ex);
                    }
                } else {
                    SwingUtils.showErrorMessage((Component)parent, (String)("Problema durante l'esportazione\n" + cu.s((Object)ret)), (String)"Errore", (boolean)true);
                }
            }
        };
        w.execute();
    }

    private String getTipoDocumento(Map fattura) {
        String fe_tipo_doc = null;
        if (fattura.containsKey("datipa") && fattura.get("datipa") != null) {
            Map datipa = (Map)fattura.get("datipa");
            fe_tipo_doc = cu.s(datipa.get("fe_tipo_doc"));
        }
        if (StringUtils.isBlank(fe_tipo_doc)) {
            if (cu.i0(fattura.get("tipo_fattura")) == 3) {
                return "TD04";
            }
            return "TD01";
        }
        return fe_tipo_doc;
    }

    private String getIdPaeseDestinatario(Map destinatario) {
        return this.getIdPaeseDaSigla(cu.s(destinatario.get("paese")));
    }

    private String getIdPaeseDaSigla(String sigla) {
        if (StringUtils.isNotBlank((String)sigla)) {
            return sigla.toUpperCase();
        }
        return "IT";
    }

    private String getTipoRif(String tipo) {
        HashMap<String, String> tipi = new HashMap<String, String>();
        tipi.put("OA", "DatiOrdineAcquisto");
        tipi.put("CNT", "DatiContratto");
        tipi.put("CNV", "DatiConvenzione");
        tipi.put("R", "DatiRicezione");
        tipi.put("FC", "DatiFattureCollegate");
        return (String)tipi.get(tipo);
    }

    /*
     * WARNING - void declaration
     */
    private Object exportSingolaFattura(Element root, boolean pubblico, Map destinatario, Map fattura, JInternalFrame parent, ExportXmlEsito esito) {
        block340: {
            double checkTotaleRighe = 0.0;
            double checkTotaleImponibileRigheSconti = 0.0;
            double checkTotaleImponibileRighe = 0.0;
            double checkTotaleRiepilogo = 0.0;
            double checkTotaleImponibileRiepilogo = 0.0;
            double checkTotaleDocumento = 0.0;
            double checkTotalePagamento = 0.0;
            boolean forzatura = false;
            boolean includi_rivalsa_in_iva = false;
            boolean includi_rivalsa_in_ritenuta = false;
            boolean sottrai_rivalsa_tot_da_pagare = false;
            try {
                String string;
                String da_ddt_raggr;
                double sconto_bonus;
                double importo_ritenuta;
                Element DatiRitenuta;
                Map parametri;
                Element CessionarioIdFiscaleIVA;
                Element ContattiTrasmittente;
                forzatura = cu.b(fattura.get("forzatura"));
                boolean prezzi_ivati = cu.toBoolean(fattura.get("prezzi_ivati"));
                boolean split_payment = false;
                Map datipa = new HashMap();
                if (fattura.containsKey("datipa") && fattura.get("datipa") != null) {
                    try {
                        datipa = (Map)fattura.get("datipa");
                        split_payment = cu.toBoolean(datipa.get("split_payment"));
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                includi_rivalsa_in_ritenuta = !cu.sIsBlank(fattura.get("includi_rivalsa_in_imp_ritenuta")) ? cu.toBoolean(fattura.get("includi_rivalsa_in_imp_ritenuta")) : true;
                includi_rivalsa_in_iva = !cu.sIsBlank(fattura.get("includi_rivalsa_in_iva")) ? cu.toBoolean(fattura.get("includi_rivalsa_in_iva")) : true;
                sottrai_rivalsa_tot_da_pagare = !cu.sIsBlank(fattura.get("sottrai_rivalsa")) ? cu.toBoolean(fattura.get("sottrai_rivalsa")) : false;
                String tipo_cassa = cu.s(datipa.get("dg_dcp_tipo_cassa"));
                boolean enasarco = false;
                boolean enasarco_vecchio_modo = false;
                if (tipo_cassa.equals("TC07") && !includi_rivalsa_in_iva && sottrai_rivalsa_tot_da_pagare) {
                    enasarco_vecchio_modo = true;
                    String numero = (StringUtils.isBlank((String)cu.s(fattura.get("serie"))) ? "" : cu.s(fattura.get("serie")) + "/") + cu.s(fattura.get("numero"));
                    JPanelMsgEnasarcoVecchioModo panMessage = new JPanelMsgEnasarcoVecchioModo();
                    panMessage.lab1.setText(StringUtils.replace((String)panMessage.lab1.getText(), (String)"#numero#", (String)numero));
                    int ret = JOptionPane.showConfirmDialog(parent, panMessage, "Attenzione", 0);
                    if (ret == 1) {
                        esito.ret = false;
                        esito.fatture_generate = 0;
                        esito.ex = new Exception("Generazione annullata per rivalsa Enasarco");
                        return esito;
                    }
                }
                Element FatturaElettronicaHeader = root.addElement("FatturaElettronicaHeader");
                Element DatiTrasmissione = FatturaElettronicaHeader.addElement("DatiTrasmissione");
                Element IdTrasmittente = DatiTrasmissione.addElement("IdTrasmittente");
                Sdi sdi = Sdi.getNew();
                String provider = cu.s(sdi.param.get("provider"));
                if (provider.equalsIgnoreCase("Aruba")) {
                    xu.add(IdTrasmittente, "IdPaese", "IT");
                    xu.add(IdTrasmittente, "IdCodice", "01879020517");
                } else {
                    xu.add(IdTrasmittente, "IdPaese", this.vIdTrasmittenteIdPaese);
                    xu.add(IdTrasmittente, "IdCodice", this.vIdTrasmittenteIdCodice);
                }
                if (this.vProgressivoInvio != null) {
                    xu.add(DatiTrasmissione, "ProgressivoInvio", this.vProgressivoInvio);
                } else {
                    xu.add(DatiTrasmissione, "ProgressivoInvio", this.vProgressivoInvioB36);
                }
                this.vFormatoTrasmissione = pubblico ? "FPA12" : "FPR12";
                xu.add(DatiTrasmissione, "FormatoTrasmissione", this.vFormatoTrasmissione);
                xu.add(DatiTrasmissione, "CodiceDestinatario", this.vCodiceDestinatario);
                if (provider.equalsIgnoreCase("Aruba")) {
                    ContattiTrasmittente = DatiTrasmissione.addElement("ContattiTrasmittente");
                    xu.addssr(ContattiTrasmittente, "Telefono", "05750505");
                    xu.addssr(ContattiTrasmittente, "Email", "info@arubapec.it");
                } else if (!cu.sIsBlank((Object)this.vContattiTrasmittenteTelefono) || !cu.sIsBlank((Object)this.vContattiTrasmittenteEmail)) {
                    ContattiTrasmittente = DatiTrasmissione.addElement("ContattiTrasmittente");
                    xu.addssr(ContattiTrasmittente, "Telefono", this.vContattiTrasmittenteTelefono);
                    xu.addssr(ContattiTrasmittente, "Email", this.vContattiTrasmittenteEmail);
                }
                if (this.vCodiceDestinatario.equals("0000000") && StringUtils.isNotBlank((String)this.vPec)) {
                    xu.add(DatiTrasmissione, "PECDestinatario", this.vPec);
                }
                String tipoDocTD = this.getTipoDocumento(fattura);
                Element CedentePrestatore = FatturaElettronicaHeader.addElement("CedentePrestatore");
                Element DatiAnagrafici = CedentePrestatore.addElement("DatiAnagrafici");
                Element IdFiscaleIVA = DatiAnagrafici.addElement("IdFiscaleIVA");
                xu.add(IdFiscaleIVA, "IdPaese", this.vCedenteIdPaese);
                xu.add(IdFiscaleIVA, "IdCodice", cu.s((Object)this.vCedenteIdCodice).toUpperCase());
                if (!tipoDocTD.equalsIgnoreCase("TD17") && !tipoDocTD.equalsIgnoreCase("TD18") && !tipoDocTD.equalsIgnoreCase("TD19") && StringUtils.isNotBlank((String)this.vCedenteCodiceFiscale)) {
                    Element CodiceFiscale = DatiAnagrafici.addElement("CodiceFiscale");
                    CodiceFiscale.setText(cu.s((Object)this.vCedenteCodiceFiscale).toUpperCase());
                }
                Element Anagrafica = DatiAnagrafici.addElement("Anagrafica");
                xu.addssr(Anagrafica, "Denominazione", this.vDenominazione);
                if (cu.sIsBlank((Object)this.vDenominazione)) {
                    xu.addssr(Anagrafica, "Nome", this.vNome);
                    xu.addssr(Anagrafica, "Cognome", this.vCognome);
                    if (!(!cu.sIsBlank((Object)this.vTitolo) || cu.sIsBlank((Object)this.vNome) && cu.sIsBlank((Object)this.vCognome))) {
                        xu.add(Anagrafica, "Titolo", "Sig.");
                    } else {
                        xu.addssr(Anagrafica, "Titolo", this.vTitolo);
                    }
                }
                xu.add(DatiAnagrafici, "RegimeFiscale", this.vRegimeFiscale);
                Element Sede = CedentePrestatore.addElement("Sede");
                xu.add(Sede, "Indirizzo", this.vIndirizzo);
                if (!(tipoDocTD.equalsIgnoreCase("TD17") || tipoDocTD.equalsIgnoreCase("TD18") || tipoDocTD.equalsIgnoreCase("TD19"))) {
                    xu.add(Sede, "CAP", this.vCAP);
                } else {
                    xu.add(Sede, "CAP", "00000");
                }
                xu.add(Sede, "Comune", this.vComune);
                if (this.vNazione.toUpperCase().equals("IT")) {
                    xu.add(Sede, "Provincia", this.vProvincia.toUpperCase());
                }
                xu.add(Sede, "Nazione", this.vNazione.toUpperCase());
                try {
                    String testrea = "";
                    testrea = testrea + this.vCedenteReaUfficio;
                    testrea = testrea + this.vCedenteReaNumero;
                    testrea = testrea + this.vCedenteReaCapitaleSociale;
                    if (StringUtils.isNotBlank((String)testrea)) {
                        Element IscrizioneREA = CedentePrestatore.addElement("IscrizioneREA");
                        xu.addssr(IscrizioneREA, "Ufficio", this.vCedenteReaUfficio.toUpperCase());
                        xu.addssr(IscrizioneREA, "NumeroREA", this.vCedenteReaNumero);
                        xu.addssr(IscrizioneREA, "CapitaleSociale", this.vCedenteReaCapitaleSociale);
                        xu.addssr(IscrizioneREA, "SocioUnico", this.vCedenteReaSocioUnico);
                        xu.addssr(IscrizioneREA, "StatoLiquidazione", this.vCedenteReaStatoLiquidazione);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (StringUtils.isNotBlank((String)this.vEmail) || StringUtils.isNotBlank((String)this.vTelefono) || StringUtils.isNotBlank((String)this.vFax)) {
                    Element Contatti = CedentePrestatore.addElement("Contatti");
                    xu.addssr(Contatti, "Telefono", this.vTelefono);
                    xu.addssr(Contatti, "Fax", this.vFax);
                    xu.addssr(Contatti, "Email", this.vEmail);
                }
                xu.addssr(CedentePrestatore, "RiferimentoAmministrazione", this.vRiferimento);
                Element CessionarioCommittente = FatturaElettronicaHeader.addElement("CessionarioCommittente");
                Element CessionarioDatiAnagrafici = CessionarioCommittente.addElement("DatiAnagrafici");
                if (StringUtils.isBlank((String)cu.s(destinatario.get("piva_cfiscale"))) && StringUtils.isBlank((String)cu.s(destinatario.get("cfiscale"))) && !this.getIdPaeseDestinatario(destinatario).equalsIgnoreCase("IT")) {
                    CessionarioIdFiscaleIVA = CessionarioDatiAnagrafici.addElement("IdFiscaleIVA");
                    xu.add(CessionarioIdFiscaleIVA, "IdPaese", this.getIdPaeseDestinatario(destinatario));
                    String cfiscale_piva_recipient = "";
                    if (!cu.sIsBlank(destinatario.get("ragione_sociale"))) {
                        cfiscale_piva_recipient = StringUtils.left((String)cu.s((Object)("@" + destinatario.get("ragione_sociale"))).toUpperCase(), (int)28);
                    } else {
                        xu.add(CessionarioIdFiscaleIVA, "IdCodice", StringUtils.left((String)cu.s((Object)("@" + cu.s(destinatario.get("cognome")) + "_" + cu.s(destinatario.get("nome")))).toUpperCase(), (int)28));
                        cfiscale_piva_recipient = StringUtils.left((String)cu.s((Object)("@" + cu.s(destinatario.get("cognome")) + " " + cu.s(destinatario.get("nome")))).toUpperCase(), (int)28);
                    }
                    xu.add(CessionarioIdFiscaleIVA, "IdCodice", cfiscale_piva_recipient);
                } else {
                    if (StringUtils.isNotBlank((String)cu.s(destinatario.get("piva_cfiscale")))) {
                        CessionarioIdFiscaleIVA = CessionarioDatiAnagrafici.addElement("IdFiscaleIVA");
                        String idPaese = this.getIdPaeseDestinatario(destinatario).toUpperCase();
                        String idPaeseInPIva = StringUtils.left((String)cu.s(destinatario.get("piva_cfiscale")).toUpperCase(), (int)2);
                        String piva = cu.s(destinatario.get("piva_cfiscale")).toUpperCase();
                        if (idPaese.equalsIgnoreCase(idPaeseInPIva)) {
                            piva = StringUtils.right((String)piva, (int)(piva.length() - 2));
                        } else if (idPaeseInPIva.startsWith("IT")) {
                            idPaese = "IT";
                            piva = StringUtils.right((String)piva, (int)(piva.length() - 2));
                        }
                        String idPaesePIva = cu.s(destinatario.get("piva_idpaese")).toUpperCase();
                        if (StringUtils.isNotBlank((String)idPaesePIva)) {
                            idPaese = idPaesePIva;
                        }
                        xu.add(CessionarioIdFiscaleIVA, "IdPaese", idPaese);
                        xu.add(CessionarioIdFiscaleIVA, "IdCodice", piva);
                    }
                    if (StringUtils.isNotBlank((String)cu.s(destinatario.get("cfiscale")))) {
                        xu.add(CessionarioDatiAnagrafici, "CodiceFiscale", cu.s(destinatario.get("cfiscale")).toUpperCase());
                    }
                }
                Element CessionarioAnagrafica = CessionarioDatiAnagrafici.addElement("Anagrafica");
                if (!cu.s(destinatario.get("persona_fisica")).equalsIgnoreCase("S") || this.auto_fattura_vendita) {
                    xu.add(CessionarioAnagrafica, "Denominazione", cu.s(destinatario.get("ragione_sociale")));
                } else {
                    xu.add(CessionarioAnagrafica, "Nome", cu.s(destinatario.get("nome")));
                    xu.add(CessionarioAnagrafica, "Cognome", cu.s(destinatario.get("cognome")));
                    if (!cu.sIsBlank(destinatario.get("cede_titolo"))) {
                        xu.add(CessionarioAnagrafica, "Titolo", cu.s(destinatario.get("cede_titolo")));
                    } else {
                        xu.add(CessionarioAnagrafica, "Titolo", "Sig.");
                    }
                }
                Element CessionarioSede = CessionarioCommittente.addElement("Sede");
                xu.add(CessionarioSede, "Indirizzo", cu.s(destinatario.get("indirizzo")));
                if (cu.sIsBlank(destinatario.get("cap")) || cu.s(destinatario.get("cap")).length() != 5 && !this.getIdPaeseDestinatario(destinatario).equalsIgnoreCase("IT")) {
                    if (StringUtils.isNumeric((String)cu.s(destinatario.get("cap"))) && cu.s(destinatario.get("cap")).length() <= 5) {
                        xu.add(CessionarioSede, "CAP", StringUtils.leftPad((String)cu.s(destinatario.get("cap")), (int)5, (String)"0"));
                    } else {
                        xu.add(CessionarioSede, "CAP", "00000");
                    }
                } else {
                    xu.add(CessionarioSede, "CAP", cu.s(destinatario.get("cap")));
                }
                xu.add(CessionarioSede, "Comune", cu.s(destinatario.get("localita")));
                if (this.getIdPaeseDestinatario(destinatario).toUpperCase().equals("IT")) {
                    xu.addssr(CessionarioSede, "Provincia", cu.s(destinatario.get("provincia")).toUpperCase());
                }
                xu.add(CessionarioSede, "Nazione", this.getIdPaeseDestinatario(destinatario).toUpperCase());
                if (!cu.sIsBlank(destinatario.get("stab_orga_indirizzo")) && !cu.sIsBlank(destinatario.get("stab_orga_localita"))) {
                    Element CessionarioStabOrg = CessionarioCommittente.addElement("StabileOrganizzazione");
                    xu.add(CessionarioStabOrg, "Indirizzo", cu.s(destinatario.get("stab_orga_indirizzo")));
                    if (cu.sIsBlank(destinatario.get("stab_orga_cap")) || cu.s(destinatario.get("stab_orga_cap")).length() != 5 && !this.getIdPaeseDaSigla(cu.s(destinatario.get("stab_orga_paese"))).equalsIgnoreCase("IT")) {
                        if (StringUtils.isNumeric((String)cu.s(destinatario.get("stab_orga_cap"))) && cu.s(destinatario.get("stab_orga_cap")).length() <= 5) {
                            xu.add(CessionarioStabOrg, "CAP", StringUtils.leftPad((String)cu.s(destinatario.get("stab_orga_cap")), (int)5, (String)"0"));
                        } else {
                            xu.add(CessionarioStabOrg, "CAP", "00000");
                        }
                    } else {
                        xu.add(CessionarioStabOrg, "CAP", cu.s(destinatario.get("stab_orga_cap")));
                    }
                    xu.add(CessionarioStabOrg, "Comune", cu.s(destinatario.get("stab_orga_localita")));
                    if (this.getIdPaeseDaSigla(cu.s(destinatario.get("stab_orga_paese"))).toUpperCase().equals("IT")) {
                        xu.addssr(CessionarioStabOrg, "Provincia", cu.s(destinatario.get("stab_orga_provincia")).toUpperCase());
                    }
                    xu.add(CessionarioStabOrg, "Nazione", this.getIdPaeseDaSigla(cu.s(destinatario.get("stab_orga_paese"))).toUpperCase());
                }
                if (!cu.sIsBlank(destinatario.get("rapp_fisc_piva_cfiscale"))) {
                    Element CessionarioRappFisc = CessionarioCommittente.addElement("RappresentanteFiscale");
                    Element CessionarioRappFiscIdFiscaleIVA = CessionarioRappFisc.addElement("IdFiscaleIVA");
                    xu.add(CessionarioRappFiscIdFiscaleIVA, "IdPaese", this.getIdPaeseDaSigla(cu.s(destinatario.get("rapp_fisc_piva_idpaese"))));
                    xu.add(CessionarioRappFiscIdFiscaleIVA, "IdCodice", cu.s(destinatario.get("rapp_fisc_piva_cfiscale")));
                    if (!cu.sIsBlank(destinatario.get("rapp_fisc_rag_soc"))) {
                        xu.add(CessionarioRappFisc, "Denominazione", cu.s(destinatario.get("rapp_fisc_rag_soc")));
                    } else {
                        xu.add(CessionarioRappFisc, "Nome", cu.s(destinatario.get("rapp_fisc_cognome")));
                        xu.add(CessionarioRappFisc, "Cognome", cu.s(destinatario.get("rapp_fisc_nome")));
                    }
                }
                if (!cu.sIsBlank((parametri = ((JInternalFrameExportXmlPa3)parent).export_xml_pa_parametri).get("terzo_int_denominazione"))) {
                    Element TerzoIntermediarioOSoggettoEmittente = FatturaElettronicaHeader.addElement("TerzoIntermediarioOSoggettoEmittente");
                    Element TerzoIntermediarioOSoggettoEmittenteDatiAnagrafici = TerzoIntermediarioOSoggettoEmittente.addElement("DatiAnagrafici");
                    if (StringUtils.isNotBlank((String)cu.s(parametri.get("terzo_int_p_iva")))) {
                        Element TerzoIntermediarioOSoggettoEmittenteIdFiscaleIVA = TerzoIntermediarioOSoggettoEmittenteDatiAnagrafici.addElement("IdFiscaleIVA");
                        xu.add(TerzoIntermediarioOSoggettoEmittenteIdFiscaleIVA, "IdPaese", this.getIdPaeseDaSigla(cu.s(parametri.get("terzo_int_id_paese"))));
                        xu.add(TerzoIntermediarioOSoggettoEmittenteIdFiscaleIVA, "IdCodice", cu.s(parametri.get("terzo_int_p_iva")).toUpperCase());
                    }
                    if (StringUtils.isNotBlank((String)cu.s(parametri.get("terzo_int_c_fiscale")))) {
                        xu.add(TerzoIntermediarioOSoggettoEmittenteDatiAnagrafici, "CodiceFiscale", cu.s(parametri.get("terzo_int_c_fiscale")).toUpperCase());
                    }
                    Element TerzoIntermediarioOSoggettoEmittenteAnagrafica = TerzoIntermediarioOSoggettoEmittenteDatiAnagrafici.addElement("Anagrafica");
                    xu.add(TerzoIntermediarioOSoggettoEmittenteAnagrafica, "Denominazione", cu.s(parametri.get("terzo_int_denominazione")));
                }
                if (!cu.sIsBlank(parametri.get("sogg_emit"))) {
                    xu.add(FatturaElettronicaHeader, "SoggettoEmittente", cu.s(parametri.get("sogg_emit")));
                }
                HashSet<String> aliquoteIvaRighe = new HashSet<String>();
                HashSet<String> aliquoteIva = new HashSet<String>();
                for (Map riga : (List)fattura.get("righe")) {
                    Double aliquota = cu.d(riga.get("perc_iva"));
                    String natura = cu.s(riga.get("codice_natura_xmlpa"));
                    aliquoteIvaRighe.add(fu.ne22(riga.get("perc_iva")) + "|" + cu.s(riga.get("codice_natura_xmlpa")));
                }
                Element FatturaElettronicaBody = root.addElement("FatturaElettronicaBody");
                Element DatiGenerali = FatturaElettronicaBody.addElement("DatiGenerali");
                Element DatiGeneraliDocumento = DatiGenerali.addElement("DatiGeneraliDocumento");
                xu.add(DatiGeneraliDocumento, "TipoDocumento", tipoDocTD);
                xu.add(DatiGeneraliDocumento, "Divisa", "EUR");
                xu.add(DatiGeneraliDocumento, "Data", FormatUtils.formatMysqlDate(fattura.get("data")));
                String fe_formato_numerazione = cu.s(((JInternalFrameExportXmlPa3)parent).export_xml_pa_parametri.get("fe_formato_numerazione"));
                String fe_separatore_numero_anno = cu.s(((JInternalFrameExportXmlPa3)parent).export_xml_pa_parametri.get("fe_separatore_numero_anno"));
                String numero = (StringUtils.isBlank((String)cu.s(fattura.get("serie"))) ? "" : cu.s(fattura.get("serie")) + "/") + cu.s(fattura.get("numero"));
                if (fe_formato_numerazione.equals("serie/numero/anno con quattro cifre") || fe_formato_numerazione.equals("serie/numero/anno con due cifre")) {
                    numero = numero + (fe_separatore_numero_anno.length() == 0 ? "/" : fe_separatore_numero_anno);
                    numero = fe_formato_numerazione.equals("serie/numero/anno con quattro cifre") ? numero + DateUtils.getYear((Date)cu.toDate(fattura.get("data"))) : numero + StringUtils.right((String)cu.s((Object)DateUtils.getYear((Date)cu.toDate(fattura.get("data")))), (int)2);
                }
                xu.add(DatiGeneraliDocumento, "Numero", numero);
                if (cu.d0(fattura.get("aliquota_ritenuta")) != 0.0 && fattura.containsKey("datipa") && fattura.get("datipa") != null) {
                    try {
                        DatiRitenuta = DatiGeneraliDocumento.addElement("DatiRitenuta");
                        xu.addssr(DatiRitenuta, "TipoRitenuta", datipa.get("dg_dr_tipo_ritenuta"));
                        importo_ritenuta = cu.d0(fattura.get("totale_ritenuta"));
                        if (forzatura) {
                            importo_ritenuta = cu.d0(fattura.get("forzatura_importo_ritenuta"));
                        }
                        xu.addssr(DatiRitenuta, "ImportoRitenuta", fu.ne22((Object)Util.round((double)importo_ritenuta, (int)2)));
                        if (cu.d0(fattura.get("aliquota_ritenuta_xml")) != 0.0) {
                            xu.addssr(DatiRitenuta, "AliquotaRitenuta", fu.ne25(fattura.get("aliquota_ritenuta_xml")));
                        } else {
                            xu.addssr(DatiRitenuta, "AliquotaRitenuta", fu.ne25(fattura.get("aliquota_ritenuta")));
                        }
                        xu.addssr(DatiRitenuta, "CausalePagamento", datipa.get("dg_dr_causale_pagamento"));
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                }
                if (cu.d0(fattura.get("aliquota_ritenuta2")) != 0.0 && fattura.containsKey("datipa") && fattura.get("datipa") != null) {
                    try {
                        DatiRitenuta = DatiGeneraliDocumento.addElement("DatiRitenuta");
                        xu.addssr(DatiRitenuta, "TipoRitenuta", datipa.get("dg_dr_tipo_ritenuta2"));
                        importo_ritenuta = cu.d0(fattura.get("totale_ritenuta2"));
                        if (forzatura) {
                            importo_ritenuta = cu.d0(fattura.get("forzatura_importo_ritenuta2"));
                        }
                        xu.addssr(DatiRitenuta, "ImportoRitenuta", fu.ne22((Object)Util.round((double)importo_ritenuta, (int)2)));
                        if (cu.d0(fattura.get("aliquota_ritenuta_xml2")) != 0.0) {
                            xu.addssr(DatiRitenuta, "AliquotaRitenuta", fu.ne25(fattura.get("aliquota_ritenuta_xml2")));
                        } else {
                            xu.addssr(DatiRitenuta, "AliquotaRitenuta", fu.ne25(fattura.get("aliquota_ritenuta2")));
                        }
                        xu.addssr(DatiRitenuta, "CausalePagamento", datipa.get("dg_dr_causale_pagamento2"));
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                }
                if (cu.toBoolean(fattura.get("bollo_presente"))) {
                    try {
                        Element DatiBollo = DatiGeneraliDocumento.addElement("DatiBollo");
                        xu.addssr(DatiBollo, "BolloVirtuale", "SI");
                        if (pubblico) {
                            xu.addssr(DatiBollo, "ImportoBollo", fu.ne25((Object)Util.round((double)2.0, (int)2)));
                        } else {
                            xu.addssr(DatiBollo, "ImportoBollo", fu.ne25((Object)Util.round((double)cu.d0(fattura.get("marca_da_bollo")), (int)2)));
                        }
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                }
                if (!enasarco && cu.d0(fattura.get("rivalsaInpsPerc")) != 0.0 && fattura.containsKey("datipa") && fattura.get("datipa") != null) {
                    try {
                        Element DatiCassaPrevidenziale = DatiGeneraliDocumento.addElement("DatiCassaPrevidenziale");
                        xu.addssr(DatiCassaPrevidenziale, "TipoCassa", datipa.get("dg_dcp_tipo_cassa"));
                        xu.addssr(DatiCassaPrevidenziale, "AlCassa", fu.ne25(fattura.get("rivalsaInpsPerc")));
                        double importo_rivalsa = cu.d0(fattura.get("totaleRivalsa"));
                        if (forzatura) {
                            importo_rivalsa = cu.d0(fattura.get("forzatura_importo_rivalsa"));
                        }
                        xu.addssr(DatiCassaPrevidenziale, "ImportoContributoCassa", fu.ne22((Object)Util.round((double)importo_rivalsa, (int)2)));
                        double imponibile_rivalsa = 0.0;
                        if (cu.d0(fattura.get("imponibile_rivalsa")) != 0.0) {
                            imponibile_rivalsa = cu.d0(fattura.get("imponibile_rivalsa"));
                        } else {
                            double rivalsa = Util.round((double)cu.d0(fattura.get("totaleRivalsa")), (int)2);
                            if (cu.d0(fattura.get("rivalsaInpsPerc")) != 0.0) {
                                imponibile_rivalsa = rivalsa * 100.0 / cu.d0(fattura.get("rivalsaInpsPerc"));
                            }
                        }
                        xu.addssr(DatiCassaPrevidenziale, "ImponibileCassa", fu.ne22((Object)Util.round((double)imponibile_rivalsa, (int)2)));
                        Double iva_std = null;
                        String codiceIvaSpeseRivalsa = cu.s(fattura.get("codiceIvaSpeseRivalsa"));
                        if (StringUtils.isBlank((String)codiceIvaSpeseRivalsa)) {
                            Date data = cu.toDate(fattura.get("data"));
                            codiceIvaSpeseRivalsa = InvoicexUtil.getIvaSpesePerData((Date)data, (String)"codiceIvaSpeseRivalsa");
                            if (!dbu.containRows((Connection)Db.getConn(), (String)("select codice from codici_iva where codice = " + dbu.sql((Object)codiceIvaSpeseRivalsa)))) {
                                iva_std = 22.0;
                                if (data != null && data.before(DateUtils.getOnlyDate((int)2011, (int)9, (int)17))) {
                                    iva_std = 20.0;
                                } else if (data != null && data.before(DateUtils.getOnlyDate((int)2013, (int)10, (int)1))) {
                                    iva_std = 21.0;
                                }
                                String aliquotaToFind = fu.ne22((Object)iva_std) + "|";
                                for (Object e : aliquoteIvaRighe) {
                                    String aliquotak = cu.s(e);
                                    boolean trovato = false;
                                    if (aliquotak.equalsIgnoreCase(aliquotaToFind)) {
                                        trovato = true;
                                        break;
                                    }
                                    if (trovato) continue;
                                    aliquoteIva.add(aliquotaToFind);
                                }
                            }
                        }
                        Map ivaRivalsa = null;
                        try {
                            ivaRivalsa = (Map)dbu.getListMap((Connection)Db.getConn(), (String)("select * from codici_iva where codice = " + dbu.sql((Object)codiceIvaSpeseRivalsa)), (boolean)false, (boolean)true, (Long)5000L).get(0);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        if (includi_rivalsa_in_iva) {
                            if (ivaRivalsa != null) {
                                xu.add(DatiCassaPrevidenziale, "AliquotaIVA", fu.ne22(ivaRivalsa.get("percentuale")));
                            } else {
                                xu.add(DatiCassaPrevidenziale, "AliquotaIVA", fu.ne22(iva_std));
                            }
                        } else {
                            xu.add(DatiCassaPrevidenziale, "AliquotaIVA", fu.ne22((Object)0.0));
                        }
                        if (includi_rivalsa_in_ritenuta) {
                            xu.addssr(DatiCassaPrevidenziale, "Ritenuta", "SI");
                        }
                        if (includi_rivalsa_in_iva) {
                            if (ivaRivalsa != null) {
                                if (StringUtils.isNotBlank((String)cu.s(ivaRivalsa.get("codice_natura_xmlpa")))) {
                                    xu.add(DatiCassaPrevidenziale, "Natura", cu.s(ivaRivalsa.get("codice_natura_xmlpa")));
                                }
                                aliquoteIva.add(fu.ne22(ivaRivalsa.get("percentuale")) + "|" + cu.s(ivaRivalsa.get("codice_natura_xmlpa")));
                            }
                        } else {
                            xu.add(DatiCassaPrevidenziale, "Natura", "N2");
                            aliquoteIva.add(fu.ne22((Object)0.0) + "|N2");
                        }
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                }
                boolean sconto_a_importo = false;
                boolean sconto_a_importo_iva = false;
                if (cu.d0(fattura.get("sconto")) != 0.0) {
                    sconto_a_importo = false;
                    sconto_a_importo_iva = true;
                }
                System.out.println("aliquota:" + cu.d0(fattura.get("aliquota_ritenuta")));
                System.out.println("aliquota:" + cu.d0(fattura.get("aliquota_ritenuta2")));
                System.out.println("contains dati pa:" + fattura.containsKey("datipa"));
                System.out.println("cu.d0(fattura.get(\"totale_da_pagare\")):" + cu.d0(fattura.get("totale_da_pagare")));
                double ImportoTotaleDocumento = 0.0;
                String dg_dr_totale_da_esportare = cu.s(((JInternalFrameExportXmlPa3)parent).export_xml_pa_parametri.get("dg_dr_totale_da_esportare"));
                if (dg_dr_totale_da_esportare.trim().length() == 0) {
                    dg_dr_totale_da_esportare = "lordo";
                }
                if ((cu.d0(fattura.get("aliquota_ritenuta")) != 0.0 || cu.d0(fattura.get("aliquota_ritenuta2")) != 0.0) && fattura.containsKey("datipa") && fattura.get("datipa") != null && cu.d0(fattura.get("totale_da_pagare")) != 0.0) {
                    checkTotaleDocumento = Util.round((double)cu.d0(fattura.get("totale_da_pagare")), (int)2);
                    ImportoTotaleDocumento = dg_dr_totale_da_esportare.equalsIgnoreCase("netto") ? cu.d0(fattura.get("totale_da_pagare")) : (this.acquisto ? cu.d0(fattura.get("importo")).doubleValue() : cu.d0(fattura.get("totale")).doubleValue());
                } else {
                    ImportoTotaleDocumento = this.acquisto ? cu.d0(fattura.get("importo")).doubleValue() : cu.d0(fattura.get("totale")).doubleValue();
                    checkTotaleDocumento = Util.round((double)ImportoTotaleDocumento, (int)2);
                }
                if (forzatura) {
                    ImportoTotaleDocumento = dg_dr_totale_da_esportare.equalsIgnoreCase("netto") ? cu.d0(fattura.get("forzatura_totale_da_pagare")).doubleValue() : cu.d0(fattura.get("forzatura_totale")).doubleValue();
                }
                if ((sconto_bonus = cu.d0(fattura.get("sconto_ecobonus")).doubleValue()) != 0.0) {
                    Element ScontoMaggiorazione = DatiGeneraliDocumento.addElement("ScontoMaggiorazione");
                    xu.add(ScontoMaggiorazione, "Tipo", "SC");
                    xu.add(ScontoMaggiorazione, "Importo", fu.ne25((Object)Util.round((double)sconto_bonus, (int)2)));
                }
                xu.add(DatiGeneraliDocumento, "ImportoTotaleDocumento", fu.ne25((Object)Util.round((double)ImportoTotaleDocumento, (int)2)));
                if (fattura.containsKey("datipa") && fattura.get("datipa") != null) {
                    try {
                        Element DatiContratto;
                        Map rif_amazon;
                        xu.addssr(DatiGeneraliDocumento, "Causale", datipa.get("dg_causale"));
                        if ((main.fileIni.getValue("db", "nome_database", "").indexOf("toysforyou") >= 0 || main.debug) && (rif_amazon = (Map)fattura.get("rif_amazon")) != null) {
                            int contarighe = 0;
                            for (Map.Entry entry : rif_amazon.entrySet()) {
                                ++contarighe;
                                Map riga_rif = (Map)entry.getValue();
                                System.out.println(riga_rif.get("riga") + " " + riga_rif.get("riferimento"));
                                if (cu.sIsBlank(riga_rif.get("riferimento"))) continue;
                                Element DatiContratto2 = DatiGenerali.addElement("DatiOrdineAcquisto");
                                xu.addssr(DatiContratto2, "RiferimentoNumeroLinea", contarighe);
                                xu.addssr(DatiContratto2, "IdDocumento", riga_rif.get("riferimento"));
                            }
                        }
                        boolean nuoviCampiMultipli = false;
                        String dg_riferimenti_json = cu.s(datipa.get("dg_riferimenti_json"));
                        Object listRif = null;
                        if (StringUtils.isNotBlank((String)dg_riferimenti_json)) {
                            try {
                                System.out.println("dg_riferimenti_json = " + dg_riferimenti_json);
                                try {
                                    listRif = new Gson().fromJson(dg_riferimenti_json, List.class);
                                    if (listRif != null) {
                                        nuoviCampiMultipli = true;
                                    }
                                }
                                catch (Exception exception) {
                                    exception.printStackTrace();
                                }
                                Iterator iterator = listRif.iterator();
                                while (iterator.hasNext()) {
                                    Map m = (Map)iterator.next();
                                    String tipoRif = this.getTipoRif(cu.s(m.get("dg_tipo_rif_ordine")));
                                    DatiContratto = DatiGenerali.addElement(tipoRif);
                                    xu.addssr(DatiContratto, "RiferimentoNumeroLinea", m.get("dg_rif_riferimentonumerolinea"));
                                    xu.addssr(DatiContratto, "IdDocumento", m.get("dg_rif_iddocumento"));
                                    Date data = cu.toDateIta(m.get("dg_rif_data"));
                                    if (data != null) {
                                        xu.addssr(DatiContratto, "Data", FormatUtils.formatMysqlDate((Object)data));
                                    }
                                    xu.addssr(DatiContratto, "NumItem", m.get("dg_rif_numitem"));
                                    xu.addssr(DatiContratto, "CodiceCommessaConvenzione", m.get("dg_rif_codicecommessaconvenzione"));
                                    xu.addssr(DatiContratto, "CodiceCUP", m.get("dg_rif_codicecup"));
                                    xu.addssr(DatiContratto, "CodiceCIG", m.get("dg_rif_codicecig"));
                                }
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                            }
                        }
                        if (!nuoviCampiMultipli) {
                            boolean bl;
                            boolean bl2 = false;
                            String testrif = "";
                            for (Object k : datipa.keySet()) {
                                if (!cu.s(k).startsWith("dg_rif_")) continue;
                                testrif = testrif + cu.s(datipa.get(k));
                            }
                            if (StringUtils.isNotBlank((String)testrif) && StringUtils.isNotBlank((String)cu.s(datipa.get("dg_tipo_rif_ordine")))) {
                                bl = true;
                                String tipoRif = this.getTipoRif(cu.s(datipa.get("dg_tipo_rif_ordine")));
                                DatiContratto = DatiGenerali.addElement(tipoRif);
                                xu.addssr(DatiContratto, "RiferimentoNumeroLinea", datipa.get("dg_rif_riferimentonumerolinea"));
                                xu.addssr(DatiContratto, "IdDocumento", datipa.get("dg_rif_iddocumento"));
                                xu.addssr(DatiContratto, "Data", datipa.get("dg_rif_data"));
                                xu.addssr(DatiContratto, "NumItem", datipa.get("dg_rif_numitem"));
                                xu.addssr(DatiContratto, "CodiceCommessaConvenzione", datipa.get("dg_rif_codicecommessaconvenzione"));
                                xu.addssr(DatiContratto, "CodiceCUP", datipa.get("dg_rif_codicecup"));
                                xu.addssr(DatiContratto, "CodiceCIG", datipa.get("dg_rif_codicecig"));
                            }
                            if (!bl) {
                                String testdoa = "";
                                for (Object k : datipa.keySet()) {
                                    if (!cu.s(k).startsWith("dg_doa_")) continue;
                                    testdoa = testdoa + cu.s(datipa.get(k));
                                }
                                if (StringUtils.isNotBlank((String)testdoa)) {
                                    Element DatiOrdineAcquisto = DatiGenerali.addElement("DatiOrdineAcquisto");
                                    xu.addssr(DatiOrdineAcquisto, "RiferimentoNumeroLinea", datipa.get("dg_doa_riferimentonumerolinea"));
                                    xu.addssr(DatiOrdineAcquisto, "IdDocumento", datipa.get("dg_doa_iddocumento"));
                                    xu.addssr(DatiOrdineAcquisto, "Data", datipa.get("dg_doa_data"));
                                    xu.addssr(DatiOrdineAcquisto, "NumItem", datipa.get("dg_doa_numitem"));
                                    xu.addssr(DatiOrdineAcquisto, "CodiceCommessaConvenzione", datipa.get("dg_doa_codicecommessaconvenzione"));
                                    xu.addssr(DatiOrdineAcquisto, "CodiceCUP", datipa.get("dg_doa_codicecup"));
                                    xu.addssr(DatiOrdineAcquisto, "CodiceCIG", datipa.get("dg_doa_codicecig"));
                                }
                                String testdc = "";
                                for (Object k : datipa.keySet()) {
                                    if (!cu.s(k).startsWith("dg_dc_")) continue;
                                    testdc = testdc + cu.s(datipa.get(k));
                                }
                                if (StringUtils.isNotBlank((String)testdc)) {
                                    Element DatiContratto3 = DatiGenerali.addElement("DatiContratto");
                                    xu.addssr(DatiContratto3, "RiferimentoNumeroLinea", datipa.get("dg_dc_riferimentonumerolinea"));
                                    xu.addssr(DatiContratto3, "IdDocumento", datipa.get("dg_dc_iddocumento"));
                                    xu.addssr(DatiContratto3, "Data", datipa.get("dg_dc_data"));
                                    xu.addssr(DatiContratto3, "NumItem", datipa.get("dg_dc_numitem"));
                                    xu.addssr(DatiContratto3, "CodiceCommessaConvenzione", datipa.get("dg_dc_codicecommessaconvenzione"));
                                    xu.addssr(DatiContratto3, "CodiceCUP", datipa.get("dg_dc_codicecup"));
                                    xu.addssr(DatiContratto3, "CodiceCIG", datipa.get("dg_dc_codicecig"));
                                }
                            }
                        }
                        if (cu.i(fattura.get("id_fatt_acq")) != null) {
                            Element element = DatiGenerali.addElement("DatiFattureCollegate");
                            Map dati = InvoicexUtil.getSerieNumeroAnnoDataIntEst((String)Db.TIPO_DOCUMENTO_FATTURA_RICEVUTA, (Integer)cu.i(fattura.get("id_fatt_acq")));
                            xu.addssr(element, "IdDocumento", cu.s(dati.get("serie_doc")) + cu.s(dati.get("numero_doc")));
                            xu.addssr(element, "Data", FormatUtils.formatMysqlDate(dati.get("data_doc")));
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                int contarighe = 0;
                HashMap datiddt = new HashMap();
                for (Map map : (List)fattura.get("righe")) {
                    ++contarighe;
                    String[] daddt = cu.i(map.get("da_ddt"));
                    if (daddt == null) continue;
                    if (!datiddt.containsKey(daddt)) {
                        datiddt.put(daddt, new ArrayList());
                    }
                    ((List)datiddt.get(daddt)).add(contarighe);
                }
                if (datiddt.size() == 0 && StringUtils.isNotBlank((String)(da_ddt_raggr = cu.s(fattura.get("da_ddt_raggr"))))) {
                    String[] stringArray;
                    for (String id : stringArray = StringUtils.split((String)da_ddt_raggr, (char)',')) {
                        datiddt.put(cu.i((Object)id), null);
                    }
                }
                boolean ddtpresenti = false;
                if (datiddt.size() > 0) {
                    for (Integer ddtn : datiddt.keySet()) {
                        try {
                            ArrayList listddt = DbUtils.getListMap((Connection)Db.getConn(), (String)("select serie,numero,data from test_ddt where id = " + ddtn), (boolean)false);
                            String serieddt = cu.s(((Map)listddt.get(0)).get("serie"));
                            String numeroddt = cu.s(((Map)listddt.get(0)).get("numero"));
                            Date dataddt = cu.toDate(((Map)listddt.get(0)).get("data"));
                            String sdataddt = null;
                            sdataddt = FormatUtils.formatMysqlDate((Object)dataddt);
                            if (StringUtils.isNotBlank((String)numeroddt)) {
                                ddtpresenti = true;
                            }
                        }
                        catch (Exception listddt) {
                            // empty catch block
                        }
                        if (datiddt.size() <= 1 || datiddt.get(ddtn) == null) continue;
                        for (Integer rifl : (List)datiddt.get(ddtn)) {
                            ddtpresenti = true;
                        }
                    }
                }
                if (ddtpresenti && datiddt.size() > 0) {
                    for (Integer ddtn : datiddt.keySet()) {
                        Element DatiDDT = null;
                        try {
                            ArrayList listddt = DbUtils.getListMap((Connection)Db.getConn(), (String)("select serie,numero,data from test_ddt where id = " + ddtn), (boolean)false);
                            String serieddt = cu.s(((Map)listddt.get(0)).get("serie"));
                            String numeroddt = cu.s(((Map)listddt.get(0)).get("numero"));
                            Date dataddt = cu.toDate(((Map)listddt.get(0)).get("data"));
                            String sdataddt = null;
                            if (StringUtils.isNotBlank((String)numeroddt) && DatiDDT == null) {
                                DatiDDT = DatiGenerali.addElement("DatiDDT");
                            }
                            xu.addssr(DatiDDT, "NumeroDDT", (StringUtils.isBlank((String)serieddt) ? "" : serieddt + "/") + numeroddt);
                            sdataddt = FormatUtils.formatMysqlDate((Object)dataddt);
                            xu.addssr(DatiDDT, "DataDDT", sdataddt);
                            if (datiddt.size() <= 1 || datiddt.get(ddtn) == null) continue;
                            for (Integer rifl : (List)datiddt.get(ddtn)) {
                                xu.addssr(DatiDDT, "RiferimentoNumeroLinea", rifl);
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
                if (cu.i0(fattura.get("tipo_fattura")) == 2 && StringUtils.isNotBlank((String)(string = cu.s(fattura.get("mezzo_consegna")) + cu.s(fattura.get("causale_trasporto")) + cu.s(fattura.get("aspetto_esteriore_beni")) + cu.s(fattura.get("peso_lordo_um"))))) {
                    Element DatiTrasporto = DatiGenerali.addElement("DatiTrasporto");
                    if (fattura.get("vettore") != null) {
                        Map vettore = (Map)fattura.get("vettore");
                        if (cu.sIsBlank(vettore.get("piva"))) {
                            throw new Exception("Manca la partita iva nell'anagrafica del Vettore '" + cu.s(vettore.get("nome")) + "'\nVai su Anagrafiche > Vettori, cerca il vettore in oggetto e riempi il campo Partita IVA");
                        }
                        Element DatiAnagraficiVettore = DatiTrasporto.addElement("DatiAnagraficiVettore");
                        Element IdFiscaleIVAVettore = DatiAnagraficiVettore.addElement("IdFiscaleIVA");
                        xu.add(IdFiscaleIVAVettore, "IdPaese", cu.sIsBlank(vettore.get("piva_paese")) ? "IT" : cu.s(vettore.get("piva_paese")));
                        xu.add(IdFiscaleIVAVettore, "IdCodice", cu.s(vettore.get("piva")).toUpperCase());
                        xu.addssr(DatiAnagraficiVettore, "CodiceFiscale", cu.s(vettore.get("cfiscale")).toUpperCase());
                        Element AnagraficaVettore = DatiAnagraficiVettore.addElement("Anagrafica");
                        xu.addssr(AnagraficaVettore, "Denominazione", cu.s(vettore.get("nome")));
                        if (cu.sIsBlank(vettore.get("nome"))) {
                            xu.addssr(AnagraficaVettore, "Nome", cu.s(vettore.get("nome_persona")));
                            xu.addssr(AnagraficaVettore, "Cognome", cu.s(vettore.get("cognome_persona")));
                            if (!cu.sIsBlank(vettore.get("nome_persona")) || !cu.sIsBlank(vettore.get("cognome_persona"))) {
                                xu.add(AnagraficaVettore, "Titolo", "Sig.");
                            }
                        }
                    }
                    xu.addssr(DatiTrasporto, "MezzoTrasporto", cu.s(fattura.get("mezzo_consegna")));
                    xu.addssr(DatiTrasporto, "CausaleTrasporto", cu.s(fattura.get("causale_trasporto")));
                    xu.addssr(DatiTrasporto, "NumeroColli", cu.i(fattura.get("numero_colli")));
                    xu.addssr(DatiTrasporto, "Descrizione", cu.s(fattura.get("aspetto_esteriore_beni")));
                    xu.addssr(DatiTrasporto, "UnitaMisuraPeso", cu.s(fattura.get("peso_lordo_um")));
                    xu.addssr(DatiTrasporto, "PesoLordo", fu.ne25((Object)cu.d0a(fattura.get("peso_lordo"))));
                    xu.addssr(DatiTrasporto, "PesoNetto", fu.ne25((Object)cu.d0a(fattura.get("peso_netto"))));
                    String dataoraddt = cu.s(fattura.get("dataoraddt"));
                    Date dataoraddtd = cu.toDateTimeIta((Object)dataoraddt);
                    if (dataoraddtd != null) {
                        SimpleDateFormat df2 = new SimpleDateFormat("yyyy-MM-dd");
                        xu.addssr(DatiTrasporto, "DataInizioTrasporto", df2.format(dataoraddtd));
                    }
                    if (!cu.sIsBlank(fattura.get("dest_indirizzo"))) {
                        Element IndirizzoResa = DatiTrasporto.addElement("IndirizzoResa");
                        xu.addssr(IndirizzoResa, "Indirizzo", cu.s(fattura.get("dest_indirizzo")));
                        xu.addssr(IndirizzoResa, "CAP", cu.s(fattura.get("dest_cap")));
                        xu.addssr(IndirizzoResa, "Comune", cu.s(fattura.get("dest_localita")));
                        if (this.getIdPaeseDaSigla(cu.s(fattura.get("dest_paese"))).equals("IT")) {
                            xu.addssr(IndirizzoResa, "Provincia", cu.s(fattura.get("dest_provincia")).toUpperCase());
                        }
                        xu.addssr(IndirizzoResa, "Nazione", this.getIdPaeseDaSigla(cu.s(fattura.get("dest_paese"))));
                    }
                }
                Element element = FatturaElettronicaBody.addElement("DatiBeniServizi");
                contarighe = 0;
                Double aliquota = null;
                String natura = null;
                String primaIvaAliquota = null;
                String primaIvaNatura = null;
                boolean natura35presente = false;
                boolean modalita_sconti_testata_decimali = true;
                System.out.println("parametri " + parametri);
                if (cu.s(parametri.get("fe_modalita_sconti_testata")).equals("R") && !sconto_a_importo) {
                    modalita_sconti_testata_decimali = false;
                }
                HashMap<PercIvaNatura, Double> proporzioniIva = new HashMap<PercIvaNatura, Double>();
                for (Map riga : (List)fattura.get("righe")) {
                    Element CodiceArticolo;
                    Element DettaglioLinee = element.addElement("DettaglioLinee");
                    xu.add(DettaglioLinee, "NumeroLinea", cu.s((Object)(++contarighe)));
                    if (main.fileIni.getValue("db", "nome_database", "").indexOf("toysforyou") >= 0) {
                        if (StringUtils.isNotBlank((String)cu.s(riga.get("codice_a_barre"))) || StringUtils.isNotBlank((String)cu.s(riga.get("codice_articolo")))) {
                            CodiceArticolo = DettaglioLinee.addElement("CodiceArticolo");
                            xu.add(CodiceArticolo, "CodiceTipo", this.getCodiceTipoArticolo(parametri));
                            if (StringUtils.isNotBlank((String)cu.s(riga.get("codice_a_barre")))) {
                                String codice_a_barre = cu.s(riga.get("codice_a_barre"));
                                if (codice_a_barre.length() < 13) {
                                    codice_a_barre = StringUtils.leftPad((String)codice_a_barre, (int)13, (String)"0");
                                }
                                xu.add(CodiceArticolo, "CodiceValore", codice_a_barre);
                            } else {
                                xu.add(CodiceArticolo, "CodiceValore", cu.s(riga.get("codice_articolo")));
                            }
                        }
                    } else if (StringUtils.isNotBlank((String)cu.s(riga.get("codice_articolo")))) {
                        Element CodiceArticolo2 = DettaglioLinee.addElement("CodiceArticolo");
                        xu.add(CodiceArticolo2, "CodiceTipo", this.getCodiceTipoArticolo(parametri));
                        xu.add(CodiceArticolo2, "CodiceValore", cu.s(riga.get("codice_articolo")));
                    }
                    if (StringUtils.isNotBlank((String)cu.s(riga.get("xmlpa_cod_tipo")))) {
                        CodiceArticolo = DettaglioLinee.addElement("CodiceArticolo");
                        xu.add(CodiceArticolo, "CodiceTipo", cu.s(riga.get("xmlpa_cod_tipo")));
                        xu.add(CodiceArticolo, "CodiceValore", cu.s(riga.get("xmlpa_cod_valore")));
                    }
                    if (StringUtils.isNotBlank((String)cu.s(riga.get("xmlpa_disp_med_tipo")))) {
                        CodiceArticolo = DettaglioLinee.addElement("CodiceArticolo");
                        xu.add(CodiceArticolo, "CodiceTipo", cu.s(riga.get("xmlpa_disp_med_tipo")));
                        xu.add(CodiceArticolo, "CodiceValore", cu.s(riga.get("xmlpa_disp_med_valore")));
                    }
                    if (StringUtils.isBlank((String)cu.s(riga.get("descrizione")))) {
                        xu.add(DettaglioLinee, "Descrizione", ".");
                    } else {
                        xu.add(DettaglioLinee, "Descrizione", cu.s(riga.get("descrizione")));
                    }
                    double totale_imponibile_netto = Util.round((double)cu.d0(riga.get("totale_imponibile_netto")), (int)2);
                    double quantita = cu.d0(riga.get("quantita"));
                    double d = Util.round((double)(totale_imponibile_netto / quantita), (int)5);
                    double quantitaXml = quantita;
                    if (cu.toBoolean(((Map)main.GLOB.get("dati_azienda")).get("zero_come_uno")) && quantita == 0.0 && d != 0.0) {
                        quantitaXml = 1.0;
                    }
                    double prezzo_totale = 0.0;
                    if (sconto_a_importo) {
                        prezzo_totale = Util.round((double)totale_imponibile_netto, (int)2);
                    } else if (modalita_sconti_testata_decimali) {
                        ArrayList<Double> sconti = new ArrayList<Double>();
                        ArrayList<Double> arrayList = new ArrayList<Double>();
                        boolean scontiDiTestata = false;
                        if (cu.d0(fattura.get("sconto1")) != 0.0) {
                            sconti.add(cu.d0(fattura.get("sconto1")));
                            arrayList.add(cu.d0(fattura.get("sconto1")));
                            scontiDiTestata = true;
                        }
                        if (cu.d0(fattura.get("sconto2")) != 0.0) {
                            sconti.add(cu.d0(fattura.get("sconto2")));
                            arrayList.add(cu.d0(fattura.get("sconto2")));
                            scontiDiTestata = true;
                        }
                        if (cu.d0(fattura.get("sconto3")) != 0.0) {
                            sconti.add(cu.d0(fattura.get("sconto3")));
                            arrayList.add(cu.d0(fattura.get("sconto3")));
                            scontiDiTestata = true;
                        }
                        if (cu.d0(riga.get("sconto1")) != 0.0) {
                            sconti.add(cu.d0(riga.get("sconto1")));
                            arrayList.add(cu.d0(riga.get("sconto1")));
                        }
                        if (cu.d0(riga.get("sconto2")) != 0.0) {
                            sconti.add(cu.d0(riga.get("sconto2")));
                            arrayList.add(cu.d0(riga.get("sconto2")));
                        }
                        int decimali = 2;
                        if (scontiDiTestata) {
                            decimali = 5;
                        }
                        prezzo_totale = Util.round((double)(this.getImportoNetto(cu.d0(riga.get("prezzo")), arrayList) * quantitaXml), (int)decimali);
                    } else {
                        ArrayList<Double> sconti = new ArrayList<Double>();
                        if (cu.d0(riga.get("sconto1")) != 0.0) {
                            sconti.add(cu.d0(riga.get("sconto1")));
                        }
                        if (cu.d0(riga.get("sconto2")) != 0.0) {
                            sconti.add(cu.d0(riga.get("sconto2")));
                        }
                        int n = 2;
                        prezzo_totale = Util.round((double)(this.getImportoNetto(cu.d0(riga.get("prezzo")), sconti) * quantitaXml), (int)n);
                    }
                    double prezzo_unitario_check0 = 0.0;
                    prezzo_unitario_check0 = sconto_a_importo ? d : cu.d0(riga.get("prezzo"));
                    if (quantita != 0.0) {
                        xu.add(DettaglioLinee, "Quantita", fu.ne25(riga.get("quantita")));
                        if (StringUtils.isNotBlank((String)cu.s(riga.get("um")))) {
                            xu.add(DettaglioLinee, "UnitaMisura", cu.s(riga.get("um")));
                        }
                    }
                    if (StringUtils.isNotBlank((String)cu.s(riga.get("data_inizio_periodo")))) {
                        xu.add(DettaglioLinee, "DataInizioPeriodo", FormatUtils.formatMysqlDate((Object)cu.toDateIta(riga.get("data_inizio_periodo"))));
                    }
                    if (StringUtils.isNotBlank((String)cu.s(riga.get("data_fine_periodo")))) {
                        xu.add(DettaglioLinee, "DataFinePeriodo", FormatUtils.formatMysqlDate((Object)cu.toDateIta(riga.get("data_fine_periodo"))));
                    }
                    if (sconto_a_importo) {
                        xu.add(DettaglioLinee, "PrezzoUnitario", fu.ne25((Object)d));
                    } else {
                        xu.add(DettaglioLinee, "PrezzoUnitario", fu.ne25(riga.get("prezzo")));
                    }
                    aliquota = cu.d(riga.get("perc_iva"));
                    natura = cu.s(riga.get("codice_natura_xmlpa"));
                    if (sconto_a_importo) {
                        checkTotaleImponibileRigheSconti += totale_imponibile_netto;
                        xu.add(DettaglioLinee, "PrezzoTotale", fu.ne22((Object)Util.round((double)totale_imponibile_netto, (int)2)));
                    } else if (modalita_sconti_testata_decimali) {
                        ArrayList<Double> sconti = new ArrayList<Double>();
                        ArrayList<Double> scontiXml = new ArrayList<Double>();
                        boolean scontiDiTestata = false;
                        if (cu.d0(fattura.get("sconto1")) != 0.0) {
                            sconti.add(cu.d0(fattura.get("sconto1")));
                            scontiXml.add(cu.d0(fattura.get("sconto1")));
                            scontiDiTestata = true;
                        }
                        if (cu.d0(fattura.get("sconto2")) != 0.0) {
                            sconti.add(cu.d0(fattura.get("sconto2")));
                            scontiXml.add(cu.d0(fattura.get("sconto2")));
                            scontiDiTestata = true;
                        }
                        if (cu.d0(fattura.get("sconto3")) != 0.0) {
                            sconti.add(cu.d0(fattura.get("sconto3")));
                            scontiXml.add(cu.d0(fattura.get("sconto3")));
                            scontiDiTestata = true;
                        }
                        if (cu.d0(riga.get("sconto1")) != 0.0) {
                            sconti.add(cu.d0(riga.get("sconto1")));
                            scontiXml.add(cu.d0(riga.get("sconto1")));
                        }
                        if (cu.d0(riga.get("sconto2")) != 0.0) {
                            sconti.add(cu.d0(riga.get("sconto2")));
                            scontiXml.add(cu.d0(riga.get("sconto2")));
                        }
                        if (scontiXml.size() > 0) {
                            for (Double sc : scontiXml) {
                                Element ScontoMaggiorazione = DettaglioLinee.addElement("ScontoMaggiorazione");
                                xu.add(ScontoMaggiorazione, "Tipo", sc >= 0.0 ? "SC" : "MG");
                                xu.add(ScontoMaggiorazione, "Percentuale", fu.ne25((Object)Math.abs(sc)));
                            }
                        }
                        int decimali = 2;
                        if (scontiDiTestata) {
                            decimali = 5;
                        }
                        double impxml = Util.round((double)(this.getImportoNetto(cu.d0(riga.get("prezzo")), scontiXml) * quantitaXml), (int)decimali);
                        if (!scontiDiTestata) {
                            xu.add(DettaglioLinee, "PrezzoTotale", fu.ne22((Object)impxml));
                            checkTotaleImponibileRighe += Util.round((double)cu.d0(riga.get("prezzo_netto_totale")), (int)decimali);
                        } else {
                            xu.add(DettaglioLinee, "PrezzoTotale", fu.ne25((Object)impxml));
                            checkTotaleImponibileRighe += Util.round((double)cu.d0(riga.get("prezzo_netto_totale")), (int)decimali);
                        }
                        checkTotaleImponibileRigheSconti += Util.round((double)(this.getImportoNetto(cu.d0(riga.get("prezzo")), sconti) * quantitaXml), (int)decimali);
                    } else {
                        ArrayList<Double> sconti = new ArrayList<Double>();
                        if (cu.d0(riga.get("sconto1")) != 0.0) {
                            sconti.add(cu.d0(riga.get("sconto1")));
                        }
                        if (cu.d0(riga.get("sconto2")) != 0.0) {
                            sconti.add(cu.d0(riga.get("sconto2")));
                        }
                        if (sconti.size() > 0) {
                            for (Double sc : sconti) {
                                Element ScontoMaggiorazione = DettaglioLinee.addElement("ScontoMaggiorazione");
                                xu.add(ScontoMaggiorazione, "Tipo", sc >= 0.0 ? "SC" : "MG");
                                xu.add(ScontoMaggiorazione, "Percentuale", fu.ne25((Object)Math.abs(sc)));
                            }
                        }
                        int decimali = 2;
                        double imp = Util.round((double)(this.getImportoNetto(cu.d0(riga.get("prezzo")), sconti) * quantitaXml), (int)decimali);
                        xu.add(DettaglioLinee, "PrezzoTotale", fu.ne22((Object)imp));
                        checkTotaleImponibileRigheSconti += imp;
                        PercIvaNatura k = new PercIvaNatura(aliquota, natura);
                        double somma = cu.d0(proporzioniIva.get(k));
                        proporzioniIva.put(k, somma += imp);
                        checkTotaleImponibileRighe += cu.d0(riga.get("prezzo_netto_totale")).doubleValue();
                    }
                    xu.add(DettaglioLinee, "AliquotaIVA", fu.ne22(riga.get("perc_iva")));
                    if ((cu.d0(fattura.get("aliquota_ritenuta")) != 0.0 || cu.d0(fattura.get("aliquota_ritenuta2")) != 0.0) && this.isRT01orRT02(datipa) && cu.toBoolean(riga.get("flag_ritenuta"))) {
                        xu.add(DettaglioLinee, "Ritenuta", "SI");
                    }
                    if (StringUtils.isNotBlank((String)cu.s(riga.get("codice_natura_xmlpa")))) {
                        xu.add(DettaglioLinee, "Natura", cu.s(riga.get("codice_natura_xmlpa")));
                    }
                    aliquoteIva.add(fu.ne22(riga.get("perc_iva")) + "|" + cu.s(riga.get("codice_natura_xmlpa")));
                    if (primaIvaAliquota == null) {
                        primaIvaAliquota = fu.ne22(riga.get("perc_iva"));
                        primaIvaNatura = cu.s(riga.get("codice_natura_xmlpa"));
                    }
                    if (cu.s(riga.get("codice_natura_xmlpa")).equals("N3.5")) {
                        natura35presente = true;
                    }
                    if (StringUtils.isNotBlank((String)cu.s(riga.get("xmlpa_adg_rif_amministrazione")))) {
                        xu.add(DettaglioLinee, "RiferimentoAmministrazione", cu.s(riga.get("xmlpa_adg_rif_amministrazione")));
                    } else if (StringUtils.isNotBlank((String)cu.s(datipa.get("cp_rif_amministrazione_righe")))) {
                        xu.add(DettaglioLinee, "RiferimentoAmministrazione", cu.s(datipa.get("cp_rif_amministrazione_righe")));
                    }
                    if (StringUtils.isNotBlank((String)cu.s(riga.get("xmlpa_adg_tipo")))) {
                        Element AltriDatiGestionali = DettaglioLinee.addElement("AltriDatiGestionali");
                        xu.add(AltriDatiGestionali, "TipoDato", cu.s(riga.get("xmlpa_adg_tipo")));
                        xu.addssr(AltriDatiGestionali, "RiferimentoTesto", cu.s(riga.get("xmlpa_adg_testo")));
                        xu.addssr(AltriDatiGestionali, "RiferimentoNumero", cu.s(riga.get("xmlpa_adg_numero")));
                        if (cu.toDateIta(riga.get("xmlpa_adg_data")) != null) {
                            xu.addssr(AltriDatiGestionali, "RiferimentoData", FormatUtils.formatMysqlDate((Object)cu.toDateIta(riga.get("xmlpa_adg_data"))));
                        }
                    }
                    if (StringUtils.isNotBlank((String)cu.s(riga.get("xmlpa_adg_tipo2")))) {
                        Element AltriDatiGestionali = DettaglioLinee.addElement("AltriDatiGestionali");
                        xu.add(AltriDatiGestionali, "TipoDato", cu.s(riga.get("xmlpa_adg_tipo2")));
                        xu.addssr(AltriDatiGestionali, "RiferimentoTesto", cu.s(riga.get("xmlpa_adg_testo2")));
                        xu.addssr(AltriDatiGestionali, "RiferimentoNumero", cu.s(riga.get("xmlpa_adg_numero2")));
                        if (cu.toDateIta(riga.get("xmlpa_adg_data2")) != null) {
                            xu.addssr(AltriDatiGestionali, "RiferimentoData", FormatUtils.formatMysqlDate((Object)cu.toDateIta(riga.get("xmlpa_adg_data2"))));
                        }
                    }
                    if (StringUtils.isNotBlank((String)cu.s(riga.get("xmlpa_adg_tipo3")))) {
                        Element AltriDatiGestionali = DettaglioLinee.addElement("AltriDatiGestionali");
                        xu.add(AltriDatiGestionali, "TipoDato", cu.s(riga.get("xmlpa_adg_tipo3")));
                        xu.addssr(AltriDatiGestionali, "RiferimentoTesto", cu.s(riga.get("xmlpa_adg_testo3")));
                        xu.addssr(AltriDatiGestionali, "RiferimentoNumero", cu.s(riga.get("xmlpa_adg_numero3")));
                        if (cu.toDateIta(riga.get("xmlpa_adg_data3")) != null) {
                            xu.addssr(AltriDatiGestionali, "RiferimentoData", FormatUtils.formatMysqlDate((Object)cu.toDateIta(riga.get("xmlpa_adg_data3"))));
                        }
                    }
                    if (!cu.s(riga.get("codice_natura_xmlpa")).equals("N3.5") || !StringUtils.isNotBlank((String)cu.s(destinatario.get("dich_int_data")))) continue;
                    Element AltriDatiGestionali = DettaglioLinee.addElement("AltriDatiGestionali");
                    xu.add(AltriDatiGestionali, "TipoDato", "INTENTO");
                    xu.addssr(AltriDatiGestionali, "RiferimentoTesto", cu.s(destinatario.get("dich_int_num")));
                    xu.addssr(AltriDatiGestionali, "RiferimentoData", FormatUtils.formatMysqlDate(destinatario.get("dich_int_data")));
                }
                if (!modalita_sconti_testata_decimali) {
                    double checkTotaleImponibileRigheScontiNetto;
                    double sconto_testata;
                    ArrayList<Double> sconti = new ArrayList<Double>();
                    Object scontostr = "";
                    if (cu.d0(fattura.get("sconto1")) != 0.0) {
                        sconti.add(cu.d0(fattura.get("sconto1")));
                        scontostr = scontostr + FormatUtils.formatPerc((double)cu.d0(fattura.get("sconto1"))) + "%";
                    }
                    if (cu.d0(fattura.get("sconto2")) != 0.0) {
                        sconti.add(cu.d0(fattura.get("sconto2")));
                        if (((String)scontostr).length() > 0) {
                            scontostr = scontostr + " + ";
                        }
                        scontostr = scontostr + FormatUtils.formatPerc((double)cu.d0(fattura.get("sconto2"))) + "%";
                    }
                    if (cu.d0(fattura.get("sconto3")) != 0.0) {
                        sconti.add(cu.d0(fattura.get("sconto3")));
                        if (((String)scontostr).length() > 0) {
                            scontostr = (String)scontostr + " + ";
                        }
                        scontostr = (String)scontostr + FormatUtils.formatPerc((double)cu.d0(fattura.get("sconto3"))) + "%";
                    }
                    if ((sconto_testata = checkTotaleImponibileRigheSconti - (checkTotaleImponibileRigheScontiNetto = this.getImportoNetto(checkTotaleImponibileRigheSconti, sconti))) != 0.0) {
                        double totale_imponibile = checkTotaleImponibileRigheSconti;
                        boolean i = false;
                        for (PercIvaNatura pin : proporzioniIva.keySet()) {
                            System.out.println("pin = " + pin);
                            double imp = (Double)proporzioniIva.get(pin);
                            System.out.println("imp = " + imp);
                            double percProp = imp * 100.0 / totale_imponibile;
                            System.out.println("percProp = " + percProp);
                            double scontoPerIva = sconto_testata / 100.0 * percProp;
                            System.out.println("scontoPerIva = " + scontoPerIva);
                            Element DettaglioLinee = element.addElement("DettaglioLinee");
                            xu.add(DettaglioLinee, "NumeroLinea", cu.s((Object)(++contarighe)));
                            xu.add(DettaglioLinee, "TipoCessionePrestazione", "SC");
                            xu.add(DettaglioLinee, "Descrizione", "Sconto " + (String)scontostr);
                            xu.add(DettaglioLinee, "PrezzoUnitario", fu.ne25((Object)(-scontoPerIva)));
                            xu.add(DettaglioLinee, "PrezzoTotale", fu.ne22((Object)(-scontoPerIva)));
                            xu.add(DettaglioLinee, "AliquotaIVA", fu.ne22((Object)pin.percIva));
                            if (StringUtils.isNotBlank((String)pin.natura)) {
                                xu.add(DettaglioLinee, "Natura", pin.natura);
                            }
                            if (!pin.natura.equals("N3.5")) continue;
                            Element AltriDatiGestionali = DettaglioLinee.addElement("AltriDatiGestionali");
                            xu.add(AltriDatiGestionali, "TipoDato", "INTENTO");
                            xu.addssr(AltriDatiGestionali, "RiferimentoTesto", cu.s(destinatario.get("dich_int_num")));
                            xu.addssr(AltriDatiGestionali, "RiferimentoData", FormatUtils.formatMysqlDate(destinatario.get("dich_int_data")));
                        }
                    }
                }
                List totali_iva_dettagli = (List)fattura.get("totali_iva_dettagli");
                if (cu.d0(fattura.get("spese_trasporto")) != 0.0) {
                    for (Map m : totali_iva_dettagli) {
                        if (!m.get("tipo_riga").equals("ST")) continue;
                        checkTotaleImponibileRighe += cu.d0(m.get("imponibile")).doubleValue();
                        checkTotaleImponibileRigheSconti += cu.d0(m.get("imponibile")).doubleValue();
                    }
                }
                if (cu.d0(fattura.get("spese_incasso")) != 0.0) {
                    for (Map m : totali_iva_dettagli) {
                        if (!m.get("tipo_riga").equals("SI")) continue;
                        checkTotaleImponibileRighe += cu.d0(m.get("imponibile")).doubleValue();
                        checkTotaleImponibileRigheSconti += cu.d0(m.get("imponibile")).doubleValue();
                    }
                }
                if (cu.toBoolean(fattura.get("bollo_presente")) && !cu.b(fattura.get("bollo_non_addebitare")).booleanValue()) {
                    try {
                        if (!pubblico) {
                            if (cu.i0(fattura.get("tipo_fattura")) == 3) {
                                checkTotaleImponibileRighe -= Util.round((double)cu.d0(fattura.get("marca_da_bollo")), (int)2);
                                checkTotaleImponibileRigheSconti -= Util.round((double)cu.d0(fattura.get("marca_da_bollo")), (int)2);
                            } else {
                                checkTotaleImponibileRighe += Util.round((double)cu.d0(fattura.get("marca_da_bollo")), (int)2);
                                checkTotaleImponibileRigheSconti += Util.round((double)cu.d0(fattura.get("marca_da_bollo")), (int)2);
                            }
                        }
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                }
                boolean aggiungereBloccoRivalsa = false;
                boolean rivalsaGiaAggiunta = false;
                if (!enasarco && cu.d0(fattura.get("rivalsaInpsPerc")) != 0.0 && fattura.containsKey("datipa") && fattura.get("datipa") != null && !includi_rivalsa_in_iva) {
                    aggiungereBloccoRivalsa = true;
                }
                for (Map totiva : (List)fattura.get("totali_iva")) {
                    boolean bloccoPerRivalsa = false;
                    if (aggiungereBloccoRivalsa && cu.d0(totiva.get("perc_iva")) == 0.0 && cu.s(totiva.get("codice_natura_xmlpa")).equalsIgnoreCase("N2")) {
                        bloccoPerRivalsa = true;
                    }
                    double imponibile = 0.0;
                    if (bloccoPerRivalsa) {
                        imponibile = cu.d0(totiva.get("imponibile")) + Util.round((double)cu.d0(fattura.get("totaleRivalsa")), (int)2);
                        checkTotaleImponibileRighe += Util.round((double)cu.d0(fattura.get("totaleRivalsa")), (int)2);
                        checkTotaleImponibileRigheSconti += Util.round((double)cu.d0(fattura.get("totaleRivalsa")), (int)2);
                        rivalsaGiaAggiunta = true;
                    } else {
                        imponibile = cu.d0(totiva.get("imponibile"));
                    }
                    checkTotaleImponibileRiepilogo += imponibile;
                    checkTotaleRiepilogo += imponibile + cu.d0(totiva.get("iva"));
                }
                checkTotaleRiepilogo -= cu.d0(fattura.get("totale_ritenuta")).doubleValue();
                checkTotaleRiepilogo -= cu.d0(fattura.get("totale_ritenuta2")).doubleValue();
                if (!rivalsaGiaAggiunta && cu.d0(fattura.get("rivalsaInpsPerc")) != 0.0 && fattura.containsKey("datipa") && fattura.get("datipa") != null) {
                    try {
                        checkTotaleImponibileRighe += Util.round((double)cu.d0(fattura.get("totaleRivalsa")), (int)2);
                        checkTotaleImponibileRigheSconti += Util.round((double)cu.d0(fattura.get("totaleRivalsa")), (int)2);
                        if (!includi_rivalsa_in_iva) {
                            checkTotaleImponibileRiepilogo += Util.round((double)cu.d0(fattura.get("totaleRivalsa")), (int)2);
                        }
                        if (sottrai_rivalsa_tot_da_pagare) {
                            checkTotaleRiepilogo -= Util.round((double)cu.d0(fattura.get("totaleRivalsa")), (int)2);
                        }
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                }
                checkTotaleImponibileRighe = Util.round((double)checkTotaleImponibileRighe, (int)2);
                checkTotaleImponibileRigheSconti = Util.round((double)checkTotaleImponibileRigheSconti, (int)2);
                List scadenze = (List)fattura.get("scadenze");
                if (scadenze == null || scadenze.size() == 0) {
                    HashMap scadenza = new HashMap();
                    scadenza.put("data_scadenza", fattura.get("data"));
                    double importo = checkTotaleDocumento;
                    if (split_payment) {
                        for (Map totiva : (List)fattura.get("totali_iva")) {
                            importo -= cu.d0(totiva.get("iva")).doubleValue();
                        }
                    }
                    scadenza.put("importo", importo);
                    scadenze.add(scadenza);
                }
                if (scadenze != null && scadenze.size() > 0) {
                    for (Map scadenza : scadenze) {
                        checkTotalePagamento += cu.d0(scadenza.get("importo")).doubleValue();
                    }
                }
                if (split_payment) {
                    for (Map totiva : (List)fattura.get("totali_iva")) {
                        checkTotalePagamento += cu.d0(totiva.get("iva")).doubleValue();
                    }
                }
                checkTotalePagamento += cu.d0(fattura.get("sconto_ecobonus")).doubleValue();
                rivalsaGiaAggiunta = false;
                double diffImponibileRighe = 0.0;
                if (!forzatura) {
                    System.out.println("checkTotaleDocumento xml = " + checkTotaleDocumento);
                    System.out.println("checkTotaleDocumento tot pag = " + fattura.get("totale_da_pagare"));
                    System.out.println("checkTotaleDocumento tot pag fin = " + fattura.get("totale_da_pagare_finale"));
                    String nome = cu.s(destinatario.get("ragione_sociale"));
                    if (cu.sIsBlank((Object)nome)) {
                        nome = cu.s(destinatario.get("cognome")) + "_" + cu.s(destinatario.get("nome"));
                    }
                    if (Util.round((double)checkTotaleDocumento, (int)2) != Util.round((double)cu.d0(fattura.get("totale_da_pagare")), (int)2)) {
                        String string2 = "!!! ATTENZIONE !!!\nFattura " + fattura.get("serie") + fattura.get("numero") + " - " + DateUtils.formatDateIta((Date)cu.toDate(fattura.get("data"))) + " - " + nome + "\nIl totale documento nel file xml (" + checkTotaleDocumento + ") \u00e8 diverso da quello in fattura (" + Util.round((double)cu.d0(fattura.get("totale_da_pagare")), (int)2) + ") !\nVai in modifica della fattura e confermala per allineare il totale";
                        SwingUtils.showErrorMessage((Component)parent, (String)string2, (boolean)true);
                    } else if (Util.round((double)checkTotalePagamento, (int)2) != Util.round((double)checkTotaleDocumento, (int)2)) {
                        String string3 = "!!! ATTENZIONE !!!\nFattura " + fattura.get("serie") + fattura.get("numero") + " - " + DateUtils.formatDateIta((Date)cu.toDate(fattura.get("data"))) + " - " + nome + "\nIl totale delle scadenze di pagamento (" + checkTotalePagamento + ") \u00e8 diverso dal totale documento (" + checkTotaleDocumento + ")!\nVai in modifica della fattura e confermala per allineare il totale";
                        System.out.println("msg = " + string3);
                        if (main.debug) {
                            SwingUtils.showErrorMessage((Component)parent, (String)string3, (boolean)true);
                        }
                    } else {
                        if (!sconto_a_importo && !sconto_a_importo_iva && Math.abs(diffImponibileRighe = Util.round((double)(checkTotaleImponibileRiepilogo - checkTotaleImponibileRighe), (int)2)) > 0.2) {
                            String string4 = "!!! ATTENZIONE !!!\nFattura " + fattura.get("serie") + fattura.get("numero") + " - " + DateUtils.formatDateIta((Date)cu.toDate(fattura.get("data"))) + " - " + nome + "\nIl totale imponibile delle righe (" + checkTotaleImponibileRighe + ") \u00e8 diverso dal totale imponibile nel riepilogo (" + checkTotaleImponibileRiepilogo + ")!\nVai in modifica della fattura e confermala per allineare il totale";
                            System.out.println("msg = " + string4);
                            SwingUtils.showErrorMessage((Component)parent, (String)string4, (boolean)true);
                        }
                        if (Util.round((double)checkTotaleRiepilogo, (int)2) != Util.round((double)checkTotaleDocumento, (int)2)) {
                            String string5 = "!!! ATTENZIONE !!!\nFattura " + fattura.get("serie") + fattura.get("numero") + " - " + DateUtils.formatDateIta((Date)cu.toDate(fattura.get("data"))) + " - " + nome + "\nIl totale castelletto iva (" + checkTotaleRiepilogo + ") \u00e8 diverso dal totale documento (" + checkTotaleDocumento + ")!\nVai in modifica della fattura e confermala per allineare il totale";
                            SwingUtils.showErrorMessage((Component)parent, (String)string5, (boolean)true);
                        }
                    }
                }
                if (Math.abs(diffImponibileRighe) > 0.2) {
                    diffImponibileRighe = 0.0;
                }
                if (cu.d0(fattura.get("spese_trasporto")) != 0.0 || cu.d0(fattura.get("spese_incasso")) != 0.0) {
                    String[] DettaglioLinee;
                    totali_iva_dettagli = (List)fattura.get("totali_iva_dettagli");
                    if (cu.d0(fattura.get("spese_trasporto")) != 0.0) {
                        for (Map map : totali_iva_dettagli) {
                            if (!map.get("tipo_riga").equals("ST")) continue;
                            ++contarighe;
                            double imponibile = cu.d0(map.get("imponibile"));
                            if (diffImponibileRighe != 0.0 && Math.abs(diffImponibileRighe) < imponibile) {
                                imponibile += diffImponibileRighe;
                                diffImponibileRighe = 0.0;
                            }
                            DettaglioLinee = element.addElement("DettaglioLinee");
                            xu.add((Element)DettaglioLinee, "NumeroLinea", cu.s((Object)contarighe));
                            xu.add((Element)DettaglioLinee, "TipoCessionePrestazione", "AC");
                            xu.add((Element)DettaglioLinee, "Descrizione", "Spese di trasporto");
                            xu.add((Element)DettaglioLinee, "Quantita", fu.ne25((Object)1));
                            xu.add((Element)DettaglioLinee, "PrezzoUnitario", fu.ne25((Object)imponibile));
                            xu.add((Element)DettaglioLinee, "PrezzoTotale", fu.ne22((Object)Util.round((double)imponibile, (int)2)));
                            xu.add((Element)DettaglioLinee, "AliquotaIVA", fu.ne22(map.get("percentuale")));
                            if (StringUtils.isNotBlank((String)cu.s(map.get("codice_natura_xmlpa")))) {
                                xu.add((Element)DettaglioLinee, "Natura", cu.s(map.get("codice_natura_xmlpa")));
                            }
                            aliquoteIva.add(fu.ne22(map.get("percentuale")) + "|" + cu.s(map.get("codice_natura_xmlpa")));
                            if (!cu.s(map.get("codice_natura_xmlpa")).equals("N3.5")) continue;
                            Element AltriDatiGestionali = DettaglioLinee.addElement("AltriDatiGestionali");
                            xu.add(AltriDatiGestionali, "TipoDato", "INTENTO");
                            xu.addssr(AltriDatiGestionali, "RiferimentoTesto", cu.s(destinatario.get("dich_int_num")));
                            xu.addssr(AltriDatiGestionali, "RiferimentoData", FormatUtils.formatMysqlDate(destinatario.get("dich_int_data")));
                        }
                    }
                    if (cu.d0(fattura.get("spese_incasso")) != 0.0) {
                        for (Map map : totali_iva_dettagli) {
                            if (!map.get("tipo_riga").equals("SI")) continue;
                            ++contarighe;
                            double imponibile = cu.d0(map.get("imponibile"));
                            if (diffImponibileRighe != 0.0 && Math.abs(diffImponibileRighe) < imponibile) {
                                imponibile += diffImponibileRighe;
                                diffImponibileRighe = 0.0;
                            }
                            DettaglioLinee = element.addElement("DettaglioLinee");
                            xu.add((Element)DettaglioLinee, "NumeroLinea", cu.s((Object)contarighe));
                            xu.add((Element)DettaglioLinee, "TipoCessionePrestazione", "AC");
                            xu.add((Element)DettaglioLinee, "Descrizione", "Spese di incasso");
                            xu.add((Element)DettaglioLinee, "Quantita", fu.ne25((Object)1));
                            xu.add((Element)DettaglioLinee, "PrezzoUnitario", fu.ne25((Object)imponibile));
                            xu.add((Element)DettaglioLinee, "PrezzoTotale", fu.ne22((Object)Util.round((double)imponibile, (int)2)));
                            xu.add((Element)DettaglioLinee, "AliquotaIVA", fu.ne22(map.get("percentuale")));
                            if (StringUtils.isNotBlank((String)cu.s(map.get("codice_natura_xmlpa")))) {
                                xu.add((Element)DettaglioLinee, "Natura", cu.s(map.get("codice_natura_xmlpa")));
                            }
                            aliquoteIva.add(fu.ne22(map.get("percentuale")) + "|" + cu.s(map.get("codice_natura_xmlpa")));
                            if (!cu.s(map.get("codice_natura_xmlpa")).equals("N3.5")) continue;
                            Element AltriDatiGestionali = DettaglioLinee.addElement("AltriDatiGestionali");
                            xu.add(AltriDatiGestionali, "TipoDato", "INTENTO");
                            xu.addssr(AltriDatiGestionali, "RiferimentoTesto", cu.s(destinatario.get("dich_int_num")));
                            if (cu.toDate(destinatario.get("dich_int_data")) == null) continue;
                            xu.addssr(AltriDatiGestionali, "RiferimentoData", FormatUtils.formatMysqlDate(destinatario.get("dich_int_data")));
                        }
                    }
                }
                if (enasarco) {
                    double importo_rivalsa = cu.d0(fattura.get("totaleRivalsa"));
                    if (forzatura) {
                        importo_rivalsa = cu.d0(fattura.get("forzatura_importo_rivalsa"));
                    }
                    Element DettaglioLinee = element.addElement("DettaglioLinee");
                    xu.add(DettaglioLinee, "NumeroLinea", cu.s((Object)(++contarighe)));
                    xu.add(DettaglioLinee, "Descrizione", "Contributo ENASARCO (Euro " + fu.formatEuroIta((double)Util.round((double)importo_rivalsa, (int)2)) + ")");
                    xu.add(DettaglioLinee, "PrezzoUnitario", fu.ne25((Object)0));
                    xu.add(DettaglioLinee, "PrezzoTotale", fu.ne22((Object)0));
                    xu.add(DettaglioLinee, "AliquotaIVA", "22.00");
                    aliquoteIva.add("22.00|");
                    Element AltriDatiGestionali = DettaglioLinee.addElement("AltriDatiGestionali");
                    xu.add(AltriDatiGestionali, "TipoDato", "CASSA-PREV");
                    xu.add(AltriDatiGestionali, "RiferimentoTesto", "TC07 - ENASARCO");
                    xu.add(AltriDatiGestionali, "RiferimentoNumero", fu.ne22((Object)Util.round((double)importo_rivalsa, (int)2)));
                }
                if (cu.toBoolean(fattura.get("bollo_presente")) && !cu.b(fattura.get("bollo_non_addebitare")).booleanValue() && !pubblico) {
                    String codiceIvaSpeseBollo = InvoicexUtil.getIvaSpesePerData(null, (String)"codiceIvaBollo");
                    if (StringUtils.isBlank((String)cu.s((Object)codiceIvaSpeseBollo))) {
                        codiceIvaSpeseBollo = "15";
                    }
                    Map map = (Map)dbu.getListMap((Connection)Db.getConn(), (String)("SELECT * FROM codici_iva WHERE codice = " + dbu.sql((Object)codiceIvaSpeseBollo))).get(0);
                    aliquota = cu.d(map.get("percentuale"));
                    natura = cu.s(map.get("codice_natura_xmlpa"));
                    Element DettaglioLinee = element.addElement("DettaglioLinee");
                    xu.add(DettaglioLinee, "NumeroLinea", cu.s((Object)(++contarighe)));
                    xu.add(DettaglioLinee, "TipoCessionePrestazione", "AC");
                    xu.add(DettaglioLinee, "Descrizione", "Bollo");
                    if (cu.i0(fattura.get("tipo_fattura")) == 3) {
                        xu.add(DettaglioLinee, "PrezzoUnitario", "-" + fu.ne25(fattura.get("marca_da_bollo")));
                        xu.add(DettaglioLinee, "PrezzoTotale", "-" + fu.ne22((Object)Util.round((double)cu.d0(fattura.get("marca_da_bollo")), (int)2)));
                    } else {
                        xu.add(DettaglioLinee, "PrezzoUnitario", fu.ne25(fattura.get("marca_da_bollo")));
                        xu.add(DettaglioLinee, "PrezzoTotale", fu.ne22((Object)Util.round((double)cu.d0(fattura.get("marca_da_bollo")), (int)2)));
                    }
                    xu.add(DettaglioLinee, "AliquotaIVA", fu.ne22((Object)aliquota));
                    if (StringUtils.isNotBlank((String)natura)) {
                        xu.add(DettaglioLinee, "Natura", natura);
                    }
                    aliquoteIva.add(fu.ne22((Object)aliquota) + "|" + natura);
                    if (natura.equals("N3.5")) {
                        Element AltriDatiGestionali = DettaglioLinee.addElement("AltriDatiGestionali");
                        xu.add(AltriDatiGestionali, "TipoDato", "INTENTO");
                        xu.addssr(AltriDatiGestionali, "RiferimentoTesto", cu.s(destinatario.get("dich_int_num")));
                        xu.addssr(AltriDatiGestionali, "RiferimentoData", FormatUtils.formatMysqlDate(destinatario.get("dich_int_data")));
                    }
                }
                if (cu.b(parametri.get("fe_inserisci_note")).booleanValue() && !cu.sIsBlank(fattura.get("note"))) {
                    String[] noteParts;
                    Element DettaglioLinee = element.addElement("DettaglioLinee");
                    xu.add(DettaglioLinee, "NumeroLinea", cu.s((Object)(++contarighe)));
                    xu.add(DettaglioLinee, "Descrizione", ".");
                    xu.add(DettaglioLinee, "PrezzoUnitario", "0.00");
                    xu.add(DettaglioLinee, "PrezzoTotale", "0.00");
                    xu.add(DettaglioLinee, "AliquotaIVA", primaIvaAliquota);
                    if (StringUtils.isNotBlank(primaIvaNatura)) {
                        xu.add(DettaglioLinee, "Natura", primaIvaNatura);
                    }
                    if (primaIvaNatura.equals("N3.5") && StringUtils.isNotBlank((String)cu.s(destinatario.get("dich_int_data")))) {
                        Element element2 = DettaglioLinee.addElement("AltriDatiGestionali");
                        xu.add(element2, "TipoDato", "INTENTO");
                        xu.addssr(element2, "RiferimentoTesto", cu.s(destinatario.get("dich_int_num")));
                        xu.addssr(element2, "RiferimentoData", FormatUtils.formatMysqlDate(destinatario.get("dich_int_data")));
                    }
                    String string6 = cu.s(fattura.get("note"));
                    Iterable noteIter = Splitter.fixedLength((int)60).split((CharSequence)string6);
                    for (String n : noteParts = (String[])Iterables.toArray((Iterable)noteIter, String.class)) {
                        if (!StringUtils.isNotBlank((String)n)) continue;
                        Element element3 = DettaglioLinee.addElement("AltriDatiGestionali");
                        xu.add(element3, "TipoDato", "INFO");
                        xu.add(element3, "RiferimentoTesto", n);
                    }
                }
                if (sconto_a_importo_iva) {
                    double totale_imponibile = Util.round((double)cu.d0(fattura.get("totale_imponibile")), (int)2);
                    double totale_ivato = Util.round((double)cu.d0(fattura.get("totale")), (int)2);
                    double sconto = cu.d0(fattura.get("sconto"));
                    double sconto_totale = 0.0;
                    boolean bl = false;
                    for (Map totiva : (List)fattura.get("totali_iva")) {
                        void var87_203;
                        ++var87_203;
                        String codice_iva = cu.s(totiva.get("codice_iva"));
                        double perc_iva = cu.d0(totiva.get("perc_iva"));
                        double imponibile = cu.d0(totiva.get("imponibile"));
                        double ivato = cu.d0(totiva.get("totale"));
                        double sconto_iva = 0.0;
                        if (!prezzi_ivati) {
                            if (var87_203 < ((List)fattura.get("totali_iva")).size()) {
                                sconto_iva = Util.round((double)(sconto * imponibile / totale_imponibile), (int)2);
                                sconto_totale += sconto_iva;
                            } else {
                                sconto_iva = sconto - sconto_totale;
                            }
                        } else {
                            sconto_iva = Util.round((double)(sconto * ivato / totale_ivato), (int)2);
                            sconto_iva = sconto_iva * 100.0 / (100.0 + perc_iva);
                        }
                        double sconto_iva_xml = sconto_iva;
                        Element DettaglioLinee = element.addElement("DettaglioLinee");
                        xu.add(DettaglioLinee, "NumeroLinea", cu.s((Object)(++contarighe)));
                        xu.add(DettaglioLinee, "TipoCessionePrestazione", "SC");
                        xu.add(DettaglioLinee, "Descrizione", "Sconto");
                        xu.add(DettaglioLinee, "PrezzoUnitario", fu.ne25((Object)(-sconto_iva_xml)));
                        xu.add(DettaglioLinee, "PrezzoTotale", fu.ne22((Object)(-sconto_iva_xml)));
                        xu.add(DettaglioLinee, "AliquotaIVA", fu.ne22((Object)perc_iva));
                        if (StringUtils.isNotBlank((String)cu.s(totiva.get("codice_natura_xmlpa")))) {
                            xu.add(DettaglioLinee, "Natura", cu.s(totiva.get("codice_natura_xmlpa")));
                        }
                        if (!cu.s(totiva.get("codice_natura_xmlpa")).equals("N3.5")) continue;
                        Element AltriDatiGestionali = DettaglioLinee.addElement("AltriDatiGestionali");
                        xu.add(AltriDatiGestionali, "TipoDato", "INTENTO");
                        xu.addssr(AltriDatiGestionali, "RiferimentoTesto", cu.s(destinatario.get("dich_int_num")));
                        xu.addssr(AltriDatiGestionali, "RiferimentoData", FormatUtils.formatMysqlDate(destinatario.get("dich_int_data")));
                    }
                }
                for (Object e : aliquoteIva) {
                    String aliquotak = cu.s(e);
                    boolean trovato = false;
                    for (Map totiva : (List)fattura.get("totali_iva")) {
                        String aliquotan = fu.ne22(totiva.get("perc_iva"));
                        String naturan = cu.s(totiva.get("codice_natura_xmlpa"));
                        String string7 = aliquotan + "|" + naturan;
                        System.out.println("aliquotank = " + string7 + " == " + string7);
                        if (!aliquotak.equalsIgnoreCase(string7)) continue;
                        trovato = true;
                        break;
                    }
                    if (trovato) continue;
                    HashMap<String, Object> m = new HashMap<String, Object>();
                    String aliquotanew = StringUtils.substringBefore((String)aliquotak, (String)"|");
                    String naturanew = StringUtils.substringAfter((String)aliquotak, (String)"|");
                    System.out.println("aggiungo blocco iva non trovato = " + aliquotanew + " " + naturanew);
                    m.put("perc_iva", cu.d0e((Object)aliquotanew));
                    m.put("codice_natura_xmlpa", cu.s((Object)naturanew));
                    m.put("imponibile", 0.0);
                    m.put("iva", 0.0);
                    m.put("descrizione_iva", "");
                    ((List)fattura.get("totali_iva")).add(m);
                }
                ArrayList<Map> new_totali_iva = new ArrayList<Map>();
                for (Map totiva : (List)fattura.get("totali_iva")) {
                    String aliquotan = fu.ne22(totiva.get("perc_iva"));
                    String naturan = cu.s(totiva.get("codice_natura_xmlpa"));
                    String aliquotank = aliquotan + "|" + naturan;
                    System.out.println("aliquotank = " + aliquotank + " == " + aliquotank);
                    boolean trovato = false;
                    for (Object e : aliquoteIva) {
                        String aliquotak = cu.s(e);
                        if (!aliquotak.equalsIgnoreCase(aliquotank)) continue;
                        trovato = true;
                        break;
                    }
                    if (!trovato && cu.d0(totiva.get("totale")) == 0.0 && cu.d0(totiva.get("imponibile")) == 0.0) continue;
                    new_totali_iva.add(totiva);
                }
                for (Map totiva : new_totali_iva) {
                    boolean bloccoPerRivalsa = false;
                    if (aggiungereBloccoRivalsa && cu.d0(totiva.get("perc_iva")) == 0.0 && cu.s(totiva.get("codice_natura_xmlpa")).equalsIgnoreCase("N2")) {
                        bloccoPerRivalsa = true;
                    }
                    Element DatiRiepilogo = element.addElement("DatiRiepilogo");
                    xu.add(DatiRiepilogo, "AliquotaIVA", fu.ne22(totiva.get("perc_iva")));
                    if (StringUtils.isNotBlank((String)cu.s(totiva.get("codice_natura_xmlpa")))) {
                        xu.add(DatiRiepilogo, "Natura", cu.s(totiva.get("codice_natura_xmlpa")));
                    }
                    double imponibile = 0.0;
                    if (bloccoPerRivalsa) {
                        imponibile = cu.d0(totiva.get("imponibile")) + Util.round((double)cu.d0(fattura.get("totaleRivalsa")), (int)2);
                        rivalsaGiaAggiunta = true;
                    } else {
                        imponibile = cu.d0(totiva.get("imponibile"));
                    }
                    xu.add(DatiRiepilogo, "ImponibileImporto", fu.ne22((Object)imponibile));
                    checkTotaleImponibileRiepilogo += imponibile;
                    xu.add(DatiRiepilogo, "Imposta", fu.ne22(totiva.get("iva")));
                    checkTotaleRiepilogo += imponibile + cu.d0(totiva.get("iva"));
                    if (StringUtils.isNotBlank((String)cu.s(datipa.get("fe_esigibilita_iva")))) {
                        xu.add(DatiRiepilogo, "EsigibilitaIVA", cu.s(datipa.get("fe_esigibilita_iva")));
                    } else if (StringUtils.isBlank((String)cu.s(totiva.get("codice_natura_xmlpa")))) {
                        if (split_payment) {
                            xu.add(DatiRiepilogo, "EsigibilitaIVA", "S");
                        } else {
                            String fe_esigibilita_iva = "I";
                            try {
                                fe_esigibilita_iva = cu.s((Object)dbu.getObject((Connection)Db.getConn(), (String)"select fe_esigibilita_iva from export_xml_pa_parametri", (boolean)false));
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            if (cu.sIsBlank((Object)fe_esigibilita_iva) || cu.s((Object)fe_esigibilita_iva).equals("-")) {
                                fe_esigibilita_iva = "I";
                            }
                            xu.add(DatiRiepilogo, "EsigibilitaIVA", fe_esigibilita_iva);
                        }
                    }
                    if (!StringUtils.isNotBlank((String)cu.s(totiva.get("codice_natura_xmlpa")))) continue;
                    String rifnor = cu.s(totiva.get("descrizione_iva"));
                    rifnor = StringUtils.left((String)rifnor, (int)100);
                    if (aggiungereBloccoRivalsa && bloccoPerRivalsa && StringUtils.isBlank((String)rifnor)) {
                        rifnor = "NON SOGGETTE";
                    }
                    xu.addssr(DatiRiepilogo, "RiferimentoNormativo", rifnor);
                }
                if (!rivalsaGiaAggiunta && !enasarco && cu.d0(fattura.get("rivalsaInpsPerc")) != 0.0 && fattura.containsKey("datipa") && fattura.get("datipa") != null) {
                    try {
                        if (!includi_rivalsa_in_iva) {
                            Element element4 = element.addElement("DatiRiepilogo");
                            xu.add(element4, "AliquotaIVA", "0.00");
                            xu.add(element4, "Natura", "N2");
                            xu.add(element4, "ImponibileImporto", fu.ne22((Object)Util.round((double)cu.d0(fattura.get("totaleRivalsa")), (int)2)));
                            xu.add(element4, "Imposta", "0.00");
                            xu.addssr(element4, "RiferimentoNormativo", "NON SOGGETTE");
                        }
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                    }
                }
                if (!cu.sIsBlank(fattura.get("tipo_pagamento"))) {
                    if (cu.sIsBlank(fattura.get("codice_xmlpa"))) {
                        throw new Exception("Manca il codice per f.e. del tipo di pagamento '" + cu.s(fattura.get("tipo_pagamento")) + "'\nVai su Anagrafiche > Pagamenti, cerca il pagamento in oggetto e riempi il campo Codice fattura elettronica");
                    }
                    scadenze = (List)fattura.get("scadenze");
                    if (scadenze != null && scadenze.size() > 0) {
                        for (Map scadenza : scadenze) {
                            Element DatiPagamento = FatturaElettronicaBody.addElement("DatiPagamento");
                            xu.add(DatiPagamento, "CondizioniPagamento", scadenze.size() > 1 ? "TP01" : "TP02");
                            Element DettaglioPagamento = DatiPagamento.addElement("DettaglioPagamento");
                            xu.add(DettaglioPagamento, "ModalitaPagamento", cu.s(fattura.get("codice_xmlpa")));
                            xu.add(DettaglioPagamento, "DataScadenzaPagamento", FormatUtils.formatMysqlDate(scadenza.get("data_scadenza")));
                            xu.add(DettaglioPagamento, "ImportoPagamento", fu.ne22(scadenza.get("importo")));
                            if (!fattura.containsKey("datipa") || fattura.get("datipa") == null) continue;
                            try {
                                xu.addssr(DettaglioPagamento, "IstitutoFinanziario", cu.s(datipa.get("dp_istituto_finanziario")));
                                xu.addssr(DettaglioPagamento, "IBAN", cu.s(datipa.get("dp_iban")).toUpperCase());
                            }
                            catch (Exception ex) {
                                ex.printStackTrace();
                            }
                        }
                    }
                }
                System.out.println("aggiungo allegati per xmlpa");
                List list = (List)fattura.get("allegati");
                if (list == null || list.size() <= 0) break block340;
                for (Map allegato : list) {
                    String filename;
                    File dirtmp;
                    System.out.println("allegato = " + allegato);
                    Element Allegati = FatturaElettronicaBody.addElement("Allegati");
                    String nomefile = cu.s(allegato.get("filename"));
                    nomefile = nomefile.indexOf("/") >= 0 ? StringUtils.substringAfterLast((String)nomefile, (String)"/") : StringUtils.substringAfterLast((String)nomefile, (String)"\\");
                    String formato = cu.s(allegato.get("type")).toLowerCase();
                    boolean fareZip = true;
                    if (provider.equalsIgnoreCase("Aruba")) {
                        fareZip = false;
                    }
                    if (!fareZip) {
                        xu.add(Allegati, "NomeAttachment", nomefile);
                    } else {
                        xu.add(Allegati, "NomeAttachment", nomefile + ".zip");
                    }
                    if (fareZip || formato.equalsIgnoreCase("zip")) {
                        xu.add(Allegati, "AlgoritmoCompressione", "ZIP");
                    }
                    if (!fareZip) {
                        xu.add(Allegati, "FormatoAttachment", formato);
                    } else {
                        xu.add(Allegati, "FormatoAttachment", "zip");
                    }
                    Integer n = cu.i(allegato.get("id_file"));
                    System.out.println("leggo il file id_file = " + n);
                    String sql = "select * from files where id = " + n;
                    System.out.println("sql = " + sql);
                    String dir = System.getProperty("user.home") + File.separator + ".invoicex" + File.separator + "tmp" + File.separator;
                    try {
                        dirtmp = new File(dir);
                        if (!dirtmp.exists()) {
                            dirtmp.mkdir();
                            dirtmp.mkdirs();
                        }
                    }
                    catch (Exception etmp) {
                        etmp.printStackTrace();
                    }
                    System.out.println("elimino vecchi temporanei xmlpa_att_");
                    dirtmp = new File(dir);
                    for (File ftmp : dirtmp.listFiles()) {
                        if (!ftmp.getName().startsWith("xmlpa_att_") || ftmp.lastModified() >= System.currentTimeMillis() - 86400000L) continue;
                        System.out.println("elimino ftmp = " + ftmp);
                        ftmp.delete();
                    }
                    ResultSet r = DbUtils.tryOpenResultSet((Connection)Db.getConn(), (String)sql);
                    r.next();
                    String tipoSalvataggio = SmbUtil.getDefaultValue("tipo_salvataggio");
                    File tempallegato = new File(dir + "xmlpan_att_" + n + "." + cu.s(allegato.get("type")));
                    System.out.println("scarico da [" + tipoSalvataggio + "] file e lo metto in " + tempallegato);
                    System.out.println("tempallegato = " + tempallegato);
                    if (tipoSalvataggio.equals(AllegatiUtil.GEST_ALLEGATI_DATABASE)) {
                        filename = r.getString("filename");
                        File ffilename = new File(filename);
                        String md5 = r.getString("md5");
                        String type = r.getString("type");
                        InputStream is = r.getBinaryStream("bytes");
                        IOUtils.copyLarge((InputStream)is, (OutputStream)new FileOutputStream(tempallegato));
                    } else {
                        filename = r.getString("filename_drp_smb");
                        System.out.println("filename = " + filename);
                        if (tipoSalvataggio.equals(AllegatiUtil.GEST_ALLEGATI_DROPBOX)) {
                            if (DropboxInit.init()) {
                                System.out.println("DropboxInit.init() ok");
                                DropboxUtil du = new DropboxUtil();
                                FileOutputStream out = new FileOutputStream(tempallegato);
                                du.downloadFile("/Allegati/" + filename, out);
                            } else {
                                System.out.println("DropboxInit.init() KO");
                            }
                        } else if (tipoSalvataggio.equals(AllegatiUtil.GEST_ALLEGATI_SMB)) {
                            SmbUtil.anteprimaFile(filename, tempallegato.getAbsolutePath());
                        }
                    }
                    if (tempallegato.length() <= 0L) {
                        return new Exception("L'allego '" + r.getString("filename") + "' ha dimensione 0");
                    }
                    File tempallegatozip = null;
                    if (!formato.equalsIgnoreCase("zip") && fareZip) {
                        tempallegatozip = new File(dir + "xmlpan_att_" + n + "." + cu.s(allegato.get("type")) + ".zip");
                        System.out.println("comprimo in " + tempallegatozip);
                        Zip.createZip((String)tempallegato.getAbsolutePath(), (String)nomefile, (String)tempallegatozip.getAbsolutePath());
                        System.out.println("compresso");
                    } else {
                        tempallegatozip = tempallegato;
                    }
                    xu.add(Allegati, "Attachment", new String(Base64.encodeBase64((byte[])IOUtils.toByteArray((InputStream)new FileInputStream(tempallegatozip)))));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                esito.ret = false;
                esito.ex = e;
                return esito;
            }
        }
        return true;
    }

    private double getImportoNetto(Double importo, List<Double> sconti) {
        for (Double perc : sconti) {
            importo = importo - importo / 100.0 * perc;
        }
        return importo;
    }

    private void checkRinominaDirFatturePa() {
        File pathold = new File(SystemUtils.getUserDocumentsFolder() + File.separator + "Invoicex" + File.separator + "export" + File.separator + "fatture-pa");
        File pathnew = new File(JInternalFrameExportXmlPa3.getPathFE());
        if (pathold.exists() && !pathnew.exists()) {
            pathold.renameTo(pathnew);
        }
    }

    private String getIdPaeseDaPIva(String piva) {
        if ((piva = piva.trim()).length() > 2 && Character.isLetter(piva.charAt(0)) && Character.isLetter(piva.charAt(1))) {
            return piva.substring(0, 2);
        }
        return "IT";
    }

    private String getCodiceTipoArticolo(Map param) {
        String tipo = cu.s(param.get("fe_codice_tipo_articoli"));
        if (StringUtils.isBlank((String)tipo)) {
            return "FORN";
        }
        return tipo;
    }

    private boolean isRT01orRT02(Map datipa) {
        return cu.s(datipa.get("dg_dr_tipo_ritenuta")).equalsIgnoreCase("RT01") || cu.s(datipa.get("dg_dr_tipo_ritenuta")).equalsIgnoreCase("RT02");
    }

    private static class PercIvaNatura {
        public Double percIva;
        public String natura;

        public PercIvaNatura() {
        }

        public PercIvaNatura(Double percIva, String natura) {
            this.percIva = percIva;
            this.natura = natura;
        }

        public String toString() {
            return String.valueOf(this.percIva) + "|" + this.natura;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof PercIvaNatura)) {
                return false;
            }
            PercIvaNatura n2 = (PercIvaNatura)obj;
            return String.valueOf(n2.percIva).equals(String.valueOf(this.percIva)) && n2.natura.equals(this.natura);
        }

        public int hashCode() {
            int hash = 7;
            hash = 53 * hash + (this.percIva != null ? String.valueOf(this.percIva).hashCode() : 0);
            hash = 53 * hash + (this.natura != null ? this.natura.hashCode() : 0);
            return hash;
        }
    }
}

