/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.jxlayer;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JViewport;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import org.jdesktop.jxlayer.plaf.LayerUI;

public final class JXLayer<V extends Component>
extends JComponent
implements Scrollable,
PropertyChangeListener {
    private V view;
    private LayerUI<? super V> layerUI;
    private JPanel glassPane;
    private boolean isPainting;
    private static final DefaultLayerLayout sharedLayoutInstance = new DefaultLayerLayout();
    private long eventMask;
    private static final LayerEventController eventController = new LayerEventController();
    private static final long ACCEPTED_EVENTS = 231487L;

    public JXLayer() {
        this(null);
    }

    public JXLayer(V view) {
        this(view, null);
    }

    public JXLayer(V view, LayerUI<V> ui) {
        super.setLayout(sharedLayoutInstance);
        this.setGlassPane(this.createGlassPane());
        this.setView(view);
        this.setUI(ui);
    }

    public V getView() {
        return this.view;
    }

    public void setView(V view) {
        V oldView = this.getView();
        if (oldView != null) {
            super.remove((Component)oldView);
        }
        if (view != null) {
            super.addImpl((Component)view, null, this.getComponentCount());
        }
        this.view = view;
        this.firePropertyChange("view", oldView, view);
        this.revalidate();
        this.repaint();
    }

    public void setUI(LayerUI<? super V> ui) {
        this.layerUI = ui;
        super.setUI(ui);
    }

    @Override
    public LayerUI<? super V> getUI() {
        return this.layerUI;
    }

    public JPanel getGlassPane() {
        return this.glassPane;
    }

    public void setGlassPane(JPanel glassPane) {
        JPanel oldGlassPane = this.getGlassPane();
        if (oldGlassPane != null) {
            super.remove(oldGlassPane);
        }
        if (glassPane != null) {
            super.addImpl(glassPane, null, 0);
        }
        this.glassPane = glassPane;
        this.firePropertyChange("glassPane", oldGlassPane, glassPane);
        this.revalidate();
        this.repaint();
    }

    public JPanel createGlassPane() {
        return new DefaultLayerGlassPane();
    }

    @Override
    protected void addImpl(Component comp, Object constraints, int index) {
        throw new UnsupportedOperationException("Adding components to JXLayer is not supported, use setView() or setGlassPane() instead");
    }

    @Override
    public void remove(Component comp) {
        if (comp == this.getView()) {
            this.setView(null);
        } else if (comp == this.getGlassPane()) {
            this.setGlassPane(null);
        } else {
            super.remove(comp);
        }
    }

    @Override
    public void removeAll() {
        this.setView(null);
        this.setGlassPane(null);
    }

    @Override
    public void paint(Graphics g) {
        if (!this.isPainting && this.getUI() != null) {
            this.isPainting = true;
            super.paintComponent(g);
            this.isPainting = false;
        } else {
            super.paint(g);
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
    }

    @Override
    public boolean isOptimizedDrawingEnabled() {
        return !this.glassPane.isVisible();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (this.getUI() != null) {
            this.getUI().handlePropertyChangeEvent(evt, this);
        }
    }

    public void setLayerEventMask(long layerEventMask) {
        if (layerEventMask != (layerEventMask & 0x3883FL)) {
            throw new IllegalArgumentException("The event bitmask contains unsupported event types");
        }
        long oldEventMask = this.getLayerEventMask();
        this.eventMask = layerEventMask;
        this.firePropertyChange("layerEventMask", oldEventMask, layerEventMask);
        if (layerEventMask != oldEventMask) {
            this.disableEvents(oldEventMask);
            this.enableEvents(this.eventMask);
            JXLayer.eventController.updateAWTEventListener(this);
        }
    }

    public long getLayerEventMask() {
        return this.eventMask;
    }

    @Override
    public void updateUI() {
        if (this.getUI() != null) {
            this.getUI().updateUI(this);
        }
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        if (this.getUI() != null) {
            return this.getUI().getPreferredScrollableViewportSize(this);
        }
        return this.getPreferredSize();
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        if (this.getUI() != null) {
            return this.getUI().getScrollableBlockIncrement(this, visibleRect, orientation, direction);
        }
        return orientation == 1 ? visibleRect.height : visibleRect.width;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        if (this.getUI() != null) {
            return this.getUI().getScrollableTracksViewportHeight(this);
        }
        if (this.getParent() instanceof JViewport) {
            return this.getParent().getHeight() > this.getPreferredSize().height;
        }
        return false;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        if (this.getUI() != null) {
            return this.getUI().getScrollableTracksViewportWidth(this);
        }
        if (this.getParent() instanceof JViewport) {
            return this.getParent().getWidth() > this.getPreferredSize().width;
        }
        return false;
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        if (this.getUI() != null) {
            return this.getUI().getScrollableUnitIncrement(this, visibleRect, orientation, direction);
        }
        return 1;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        if (this.getUI() != null) {
            this.setUI(this.getUI());
        }
        if (this.getLayerEventMask() != 0L) {
            JXLayer.eventController.updateAWTEventListener(this);
        }
    }

    private static class DefaultLayerGlassPane
    extends JPanel {
        public DefaultLayerGlassPane() {
            this.setOpaque(false);
        }

        @Override
        public boolean contains(int x, int y) {
            for (int i = 0; i < this.getComponentCount(); ++i) {
                Component c = this.getComponent(i);
                Point point = SwingUtilities.convertPoint(this, new Point(x, y), c);
                if (!c.isVisible() || !c.contains(point)) continue;
                return true;
            }
            if (this.getMouseListeners().length == 0 && this.getMouseMotionListeners().length == 0 && this.getMouseWheelListeners().length == 0 && !this.isCursorSet()) {
                return false;
            }
            return super.contains(x, y);
        }
    }

    private static class DefaultLayerLayout
    implements LayoutManager,
    Serializable {
        private DefaultLayerLayout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            JXLayer layer = (JXLayer)parent;
            Object view = layer.getView();
            JPanel glassPane = layer.getGlassPane();
            if (view != null) {
                Insets insets = layer.getInsets();
                ((Component)view).setLocation(insets.left, insets.top);
                ((Component)view).setSize(layer.getWidth() - insets.left - insets.right, layer.getHeight() - insets.top - insets.bottom);
            }
            if (glassPane != null) {
                glassPane.setLocation(0, 0);
                glassPane.setSize(layer.getWidth(), layer.getHeight());
            }
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            JXLayer layer = (JXLayer)parent;
            Insets insets = layer.getInsets();
            Dimension ret = new Dimension(insets.left + insets.right, insets.top + insets.bottom);
            Object view = layer.getView();
            if (view != null) {
                Dimension size = ((Component)view).getMinimumSize();
                ret.width += size.width;
                ret.height += size.height;
            }
            if (ret.width == 0 || ret.height == 0) {
                ret.height = 4;
                ret.width = 4;
            }
            return ret;
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            JXLayer layer = (JXLayer)parent;
            Insets insets = layer.getInsets();
            Dimension ret = new Dimension(insets.left + insets.right, insets.top + insets.bottom);
            Object view = layer.getView();
            if (view != null) {
                Dimension size = ((Component)view).getPreferredSize();
                if (size.width > 0 && size.height > 0) {
                    ret.width += size.width;
                    ret.height += size.height;
                }
            }
            return ret;
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }
    }

    private static class LayerEventController
    implements AWTEventListener {
        private ArrayList<WeakReference<JXLayer>> layerList = new ArrayList();
        private long currentEventMask;

        private LayerEventController() {
        }

        @Override
        public void eventDispatched(AWTEvent event) {
            Object source = event.getSource();
            if (source instanceof Component) {
                for (Component component = (Component)source; component != null; component = component.getParent()) {
                    JXLayer l;
                    LayerUI ui;
                    if (!(component instanceof JXLayer) || (ui = (l = (JXLayer)component).getUI()) == null || !this.isEventEnabled(l.getLayerEventMask(), event.getID())) continue;
                    ui.eventDispatched(event, l);
                }
            }
        }

        private boolean layerListContains(JXLayer l) {
            for (WeakReference<JXLayer> layerWeakReference : this.layerList) {
                if (layerWeakReference.get() != l) continue;
                return true;
            }
            return false;
        }

        private void updateAWTEventListener(JXLayer layer) {
            if (!this.layerListContains(layer) && layer.getLayerEventMask() != 0L) {
                this.layerList.add(new WeakReference<JXLayer>(layer));
            }
            long combinedMask = 0L;
            Iterator<WeakReference<JXLayer>> it = this.layerList.iterator();
            while (it.hasNext()) {
                WeakReference<JXLayer> weakRef = it.next();
                JXLayer currLayer = (JXLayer)weakRef.get();
                if (currLayer == null) {
                    it.remove();
                    continue;
                }
                combinedMask |= currLayer.getLayerEventMask();
            }
            if (combinedMask == 0L) {
                this.removeAWTEventListener();
                this.layerList.clear();
            } else if (this.getCurrentEventMask() != combinedMask) {
                this.removeAWTEventListener();
                this.addAWTEventListener(combinedMask);
            }
        }

        private long getCurrentEventMask() {
            return this.currentEventMask;
        }

        private void addAWTEventListener(final long eventMask) {
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    Toolkit.getDefaultToolkit().addAWTEventListener(LayerEventController.this, eventMask);
                    return null;
                }
            });
            this.currentEventMask = eventMask;
        }

        private void removeAWTEventListener() {
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    Toolkit.getDefaultToolkit().removeAWTEventListener(LayerEventController.this);
                    return null;
                }
            });
            this.currentEventMask = 0L;
        }

        private boolean isEventEnabled(long eventMask, int id) {
            return (eventMask & 1L) != 0L && id >= 100 && id <= 103 || (eventMask & 2L) != 0L && id >= 300 && id <= 301 || (eventMask & 4L) != 0L && id >= 1004 && id <= 1005 || (eventMask & 8L) != 0L && id >= 400 && id <= 402 || (eventMask & 0x20000L) != 0L && id == 507 || (eventMask & 0x20L) != 0L && (id == 503 || id == 506) || (eventMask & 0x10L) != 0L && id != 503 && id != 506 && id != 507 && id >= 500 && id <= 507 || (eventMask & 0x800L) != 0L && id >= 1100 && id <= 1101 || (eventMask & 0x8000L) != 0L && id == 1400 || (eventMask & 0x10000L) != 0L && (id == 1401 || id == 1402);
        }
    }
}

