/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.jxlayer.demo;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.GridBagLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.ButtonModel;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.SwingUtilities;
import org.jdesktop.jxlayer.JXLayer;
import org.jdesktop.jxlayer.demo.util.LafMenu;
import org.jdesktop.jxlayer.plaf.AbstractLayerUI;

public class SimpleDemo
extends JFrame {
    private SimpleButtonUI simpleButtonUI = new SimpleButtonUI();

    public SimpleDemo() {
        super("JXLayer demo");
        this.setDefaultCloseOperation(3);
        this.setLayout(new GridBagLayout());
        this.setJMenuBar(this.createMenuBar());
        JButton button = new JButton("JButton");
        JXLayer<JButton> layer = new JXLayer<JButton>(button, this.simpleButtonUI);
        this.add(layer);
        this.setSize(200, 200);
        this.setLocationRelativeTo(null);
    }

    private JMenuBar createMenuBar() {
        JMenuBar bar = new JMenuBar();
        JMenu optionsMenu = new JMenu("Options");
        final JCheckBoxMenuItem colorItem = new JCheckBoxMenuItem("Red foreground");
        optionsMenu.add(colorItem);
        colorItem.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                SimpleDemo.this.simpleButtonUI.setForeground(colorItem.isSelected() ? Color.RED : Color.GREEN);
            }
        });
        bar.add(optionsMenu);
        bar.add(new LafMenu());
        return bar;
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                new SimpleDemo().setVisible(true);
            }
        });
    }

    static class SimpleButtonUI
    extends AbstractLayerUI<JButton> {
        private Color foreground = Color.GREEN;

        SimpleButtonUI() {
        }

        public Color getForeground() {
            return this.foreground;
        }

        public void setForeground(Color foreground) {
            Color oldRolloverColor = this.getForeground();
            this.foreground = foreground;
            if (!oldRolloverColor.equals(foreground)) {
                this.setDirty(true);
            }
        }

        @Override
        protected void paintLayer(Graphics2D g2, JXLayer<? extends JButton> layer) {
            super.paintLayer(g2, layer);
            ButtonModel model = layer.getView().getModel();
            if (model.isRollover()) {
                g2.setColor(Color.ORANGE);
            } else {
                g2.setColor(this.foreground);
            }
            g2.setComposite(AlphaComposite.getInstance(3, 0.3f));
            g2.fillRect(0, 0, layer.getWidth(), layer.getHeight());
        }
    }
}

