/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.jxlayer.demo;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.jdesktop.jxlayer.JXLayer;
import org.jdesktop.jxlayer.demo.util.LafMenu;
import org.jdesktop.jxlayer.plaf.AbstractLayerUI;

public class TextValidationDemo
extends JFrame {
    private TranslucentValidationUI translucentUI = new TranslucentValidationUI();
    private IconValidationUI iconValidationUI = new IconValidationUI();

    public TextValidationDemo() {
        super("Validation layers");
        this.setDefaultCloseOperation(3);
        JPanel panel = new JPanel(new GridLayout(0, 2, 20, 10));
        panel.add(this.createLayerBox());
        panel.add(this.createTitleBox());
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 0));
        this.add(panel);
        JMenuBar bar = new JMenuBar();
        bar.add(new LafMenu());
        this.setJMenuBar(bar);
        this.setSize(300, 150);
        this.setLocationRelativeTo(null);
    }

    private JComponent createLayerBox() {
        Box layerBox = Box.createVerticalBox();
        JXLayer<JTextComponent> l1 = new JXLayer<JTextComponent>(new JTextField(10), this.translucentUI);
        layerBox.add(Box.createGlue());
        layerBox.add(l1);
        JXLayer<JTextComponent> l2 = new JXLayer<JTextComponent>(new JTextField(10), this.iconValidationUI);
        layerBox.add(Box.createGlue());
        layerBox.add(l2);
        return layerBox;
    }

    private Component createTitleBox() {
        Box titleBox = Box.createVerticalBox();
        titleBox.add(new JLabel("type \"JXLayer\""));
        titleBox.add(new JLabel("and see the result"));
        titleBox.add(Box.createGlue());
        return titleBox;
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                new TextValidationDemo().setVisible(true);
            }
        });
    }

    public static class IconValidationUI
    extends AbstractLayerUI<JTextComponent> {
        private static final BufferedImage INVALID_ICON;
        private final DocumentListener documentListener = new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                IconValidationUI.this.setDirty(true);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                IconValidationUI.this.setDirty(true);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                IconValidationUI.this.setDirty(true);
            }
        };

        @Override
        public void installUI(JComponent c) {
            super.installUI(c);
            JXLayer l = (JXLayer)c;
            ((JTextComponent)l.getView()).getDocument().addDocumentListener(this.documentListener);
            l.setBorder(BorderFactory.createEmptyBorder(2, 0, 0, 3));
        }

        @Override
        public void uninstallUI(JComponent c) {
            super.uninstallUI(c);
            JXLayer l = (JXLayer)c;
            ((JTextComponent)l.getView()).getDocument().removeDocumentListener(this.documentListener);
            l.setBorder(null);
        }

        @Override
        protected void paintLayer(Graphics2D g2, JXLayer<? extends JTextComponent> l) {
            super.paintLayer(g2, l);
            if (!l.getView().getText().toLowerCase().equals("jxlayer")) {
                g2.drawImage((Image)INVALID_ICON, l.getWidth() - INVALID_ICON.getWidth() - 1, 0, null);
            }
        }

        static {
            int width = 7;
            int height = 8;
            INVALID_ICON = new BufferedImage(width, height, 2);
            Graphics2D g2 = (Graphics2D)INVALID_ICON.getGraphics();
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
            g2.setColor(Color.RED);
            g2.fillRect(0, 0, width, height);
            g2.setColor(Color.WHITE);
            g2.drawLine(0, 0, width, height);
            g2.drawLine(0, height, width, 0);
            g2.dispose();
        }
    }

    public static class TranslucentValidationUI
    extends AbstractLayerUI<JTextComponent> {
        @Override
        protected void paintLayer(Graphics2D g2, JXLayer<? extends JTextComponent> l) {
            super.paintLayer(g2, l);
            Insets layerInsets = l.getInsets();
            g2.translate(layerInsets.left, layerInsets.top);
            JTextComponent view = l.getView();
            Insets insets = view.getInsets();
            g2.clip(new Rectangle(insets.left, insets.top, view.getWidth() - insets.left - insets.right, view.getHeight() - insets.top - insets.bottom));
            g2.setColor(view.getText().toLowerCase().equals("jxlayer") ? Color.GREEN : Color.RED);
            g2.setComposite(AlphaComposite.getInstance(3, 0.2f));
            g2.fillRect(0, 0, l.getWidth(), l.getHeight());
        }
    }
}

