/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.jxlayer.plaf.ext;

import java.awt.AWTEvent;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.InputEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.jdesktop.jxlayer.JXLayer;
import org.jdesktop.jxlayer.plaf.AbstractLayerUI;

public class MouseScrollableUI
extends AbstractLayerUI<JScrollPane>
implements ActionListener {
    private JXLayer<? extends JScrollPane> currentLayer;
    private Point scrollOrigin;
    private Point mousePoint;
    private Timer timer;
    private JLabel indicator;
    private Icon crissCrossIcon;
    private Icon horizontalIcon;
    private Icon verticalIcon;
    private Map<Icon, Cursor> cursorMap;
    private final MouseListener emptyMouseListener = new MouseAdapter(){};
    private ComponentListener componentListener = new ComponentAdapter(){

        @Override
        public void componentResized(ComponentEvent e) {
            JXLayer layer = (JXLayer)e.getComponent();
            if (MouseScrollableUI.this.indicator.isShowing() && layer == MouseScrollableUI.this.currentLayer) {
                MouseScrollableUI.this.deactivateMouseScrolling(layer);
            }
        }
    };

    public MouseScrollableUI() {
        this.timer = new Timer(20, this);
        this.cursorMap = new HashMap<Icon, Cursor>();
        this.crissCrossIcon = new ImageIcon(this.getClass().getResource("images/criss-cross.png"));
        this.cursorMap.put(this.crissCrossIcon, Cursor.getPredefinedCursor(13));
        this.horizontalIcon = new ImageIcon(this.getClass().getResource("images/horizontal.png"));
        this.cursorMap.put(this.horizontalIcon, Cursor.getPredefinedCursor(11));
        this.verticalIcon = new ImageIcon(this.getClass().getResource("images/vertical.png"));
        this.cursorMap.put(this.verticalIcon, Cursor.getPredefinedCursor(8));
        this.indicator = new JLabel(this.crissCrossIcon);
        this.indicator.addMouseListener(this.emptyMouseListener);
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        c.addComponentListener(this.componentListener);
        JXLayer l = (JXLayer)c;
        l.getGlassPane().setLayout(null);
    }

    @Override
    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
        c.removeComponentListener(this.componentListener);
        JXLayer l = (JXLayer)c;
        l.getGlassPane().setLayout(new FlowLayout());
    }

    @Override
    protected void processMouseEvent(MouseEvent e, JXLayer<? extends JScrollPane> l) {
        super.processMouseEvent(e, l);
        Icon icon = this.getIconForIndicator(l);
        if (this.isMouseScrollingTrigger(e) && icon != null) {
            this.currentLayer = l;
            this.scrollOrigin = SwingUtilities.convertPoint(e.getComponent(), e.getPoint(), this.currentLayer);
            this.activateMouseScrolling(this.scrollOrigin, this.currentLayer, icon);
            this.mousePoint = this.scrollOrigin;
            e.consume();
        }
    }

    protected boolean isMouseScrollingTrigger(MouseEvent mouseEvent) {
        return mouseEvent.getID() == 501 && mouseEvent.getButton() == 2 && !mouseEvent.isPopupTrigger();
    }

    @Override
    protected void processMouseMotionEvent(MouseEvent e, JXLayer<? extends JScrollPane> l) {
        super.processMouseMotionEvent(e, l);
        if (this.indicator.isShowing()) {
            this.mousePoint = SwingUtilities.convertPoint(e.getComponent(), e.getPoint(), this.currentLayer);
            this.updateViewPosition(this.scrollOrigin, this.mousePoint, this.currentLayer);
        }
    }

    private void updateViewPosition(Point scrollOrigin, Point mousePoint, JXLayer<? extends JScrollPane> layer) {
        JViewport viewport = layer.getView().getViewport();
        Point indicatorPoint = SwingUtilities.convertPoint(layer, mousePoint, this.indicator);
        if (!this.indicator.contains(indicatorPoint)) {
            Point viewPosition = viewport.getViewPosition();
            int x = mousePoint.x - scrollOrigin.x;
            int y = mousePoint.y - scrollOrigin.y;
            viewPosition.x += x / 5;
            viewPosition.y += y / 5;
            if (viewPosition.x > viewport.getView().getWidth() - viewport.getWidth()) {
                viewPosition.x = viewport.getView().getWidth() - viewport.getWidth();
            }
            if (viewPosition.x < 0) {
                viewPosition.x = 0;
            }
            if (viewPosition.y > viewport.getView().getHeight() - viewport.getHeight()) {
                viewPosition.y = viewport.getView().getHeight() - viewport.getHeight();
            }
            if (viewPosition.y < 0) {
                viewPosition.y = 0;
            }
            viewport.setViewPosition(viewPosition);
        }
    }

    @Override
    public void eventDispatched(AWTEvent e, JXLayer<? extends JScrollPane> l) {
        if (this.indicator.isShowing()) {
            MouseEvent mouseEvent;
            if (e instanceof MouseEvent && (mouseEvent = (MouseEvent)e).getID() != 507 && mouseEvent.getID() != 501 && (mouseEvent.getID() != 502 && mouseEvent.getID() != 500 || this.scrollOrigin.equals(this.mousePoint))) {
                super.eventDispatched(e, l);
                return;
            }
            this.deactivateMouseScrolling(this.currentLayer);
            if (e instanceof InputEvent) {
                InputEvent inputEvent = (InputEvent)e;
                inputEvent.consume();
            }
        } else {
            super.eventDispatched(e, l);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.updateViewPosition(this.scrollOrigin, this.mousePoint, this.currentLayer);
    }

    private void activateMouseScrolling(Point point, JXLayer<? extends JScrollPane> layer, Icon icon) {
        layer.getGlassPane().addMouseListener(this.emptyMouseListener);
        layer.getGlassPane().add(this.indicator);
        Dimension prefSize = this.indicator.getPreferredSize();
        this.indicator.setBounds(point.x - prefSize.width / 2, point.y - prefSize.height / 2, prefSize.width, prefSize.height);
        this.indicator.setIcon(icon);
        this.indicator.setCursor(this.cursorMap.get(icon));
        layer.getGlassPane().repaint();
        this.timer.start();
    }

    private Icon getIconForIndicator(JXLayer<? extends JScrollPane> layer) {
        JViewport viewport = layer.getView().getViewport();
        Dimension extentSize = viewport.getExtentSize();
        Icon icon = null;
        if (extentSize.width >= viewport.getView().getWidth() && extentSize.height >= viewport.getView().getHeight() || extentSize.width < viewport.getView().getWidth() && extentSize.height < viewport.getView().getHeight()) {
            icon = this.crissCrossIcon;
        } else if (extentSize.width < viewport.getView().getWidth()) {
            icon = this.horizontalIcon;
        } else if (extentSize.height < viewport.getView().getHeight()) {
            icon = this.verticalIcon;
        }
        return icon;
    }

    private void deactivateMouseScrolling(JXLayer<? extends JScrollPane> layer) {
        layer.getGlassPane().removeMouseListener(this.emptyMouseListener);
        this.indicator.setCursor(null);
        layer.getGlassPane().remove(this.indicator);
        layer.getGlassPane().repaint();
        this.timer.stop();
    }
}

