﻿<?xml version="1.0"?>
<xsl:stylesheet 
	version="1.1" 
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
	xmlns:a="http://ivaservizi.agenziaentrate.gov.it/docs/xsd/fatture/v1.2">
	<xsl:output method="html" />

	<xsl:template name="FormatDate">
		<xsl:param name="DateTime" />

		<xsl:variable name="year" select="substring($DateTime,1,4)" />
		<xsl:variable name="month" select="substring($DateTime,6,2)" />
		<xsl:variable name="day" select="substring($DateTime,9,2)" />

		<xsl:value-of select="' ('" />
		<xsl:value-of select="$day" />
		<xsl:value-of select="' '" />
		<xsl:choose>
			<xsl:when test="$month = '1' or $month = '01'">
				Gennaio
			</xsl:when>
			<xsl:when test="$month = '2' or $month = '02'">
				Febbraio
			</xsl:when>
			<xsl:when test="$month = '3' or $month = '03'">
				Marzo
			</xsl:when>
			<xsl:when test="$month = '4' or $month = '04'">
				Aprile
			</xsl:when>
			<xsl:when test="$month = '5' or $month = '05'">
				Maggio
			</xsl:when>
			<xsl:when test="$month = '6' or $month = '06'">
				Giugno
			</xsl:when>
			<xsl:when test="$month = '7' or $month = '07'">
				Luglio
			</xsl:when>
			<xsl:when test="$month = '8' or $month = '08'">
				Agosto
			</xsl:when>
			<xsl:when test="$month = '9' or $month = '09'">
				Settembre
			</xsl:when>
			<xsl:when test="$month = '10'">
				Ottobre
			</xsl:when>
			<xsl:when test="$month = '11'">
				Novembre
			</xsl:when>
			<xsl:when test="$month = '12'">
				Dicembre
			</xsl:when>
			<xsl:otherwise>
				Mese non riconosciuto
			</xsl:otherwise>
		</xsl:choose>
		<xsl:value-of select="' '" />
		<xsl:value-of select="$year" />

		<xsl:variable name="time" select="substring($DateTime,12)" />
		<xsl:if test="$time != ''">
			<xsl:variable name="hh" select="substring($time,1,2)" />
			<xsl:variable name="mm" select="substring($time,4,2)" />
			<xsl:variable name="ss" select="substring($time,7,2)" />

			<xsl:value-of select="' '" />
			<xsl:value-of select="$hh" />
			<xsl:value-of select="':'" />
			<xsl:value-of select="$mm" />
			<xsl:value-of select="':'" />
			<xsl:value-of select="$ss" />
		</xsl:if>
		<xsl:value-of select="')'" />
	</xsl:template>

	<xsl:template match="/">
		<html>
			<head>
				<meta http-equiv="X-UA-Compatible" content="IE=edge" />
				<style type="text/css">
					#fattura-container { width: 100%; position: relative; }

					#fattura-elettronica { font-family: sans-serif; margin-left: auto; margin-right: auto; max-width: 1280px; min-width: 930px; padding: 0; }
					#fattura-elettronica .versione { font-size: 11px; float:right; color: #777777; }
					#fattura-elettronica h1 { padding: 20px 0 0 0; margin: 0; font-size: 30px; }
					#fattura-elettronica h2 { padding: 20px 0 0 0; margin: 0; font-size: 20px; }
					#fattura-elettronica h3 { padding: 20px 0 0 0; margin: 0; font-size: 25px; }
					#fattura-elettronica h4 { padding: 20px 0 0 0; margin: 0; font-size: 20px; }
					#fattura-elettronica h5 { padding: 15px 0 0 0; margin: 0;
					font-size: 17px; font-style: italic; }
					#fattura-elettronica ul { list-style-type: none; margin: 0 !important; padding: 15px 0 0 40px !important; }
					#fattura-elettronica ul li {}
					#fattura-elettronica ul li span { font-weight: bold; }
					#fattura-elettronica div { padding: 0; margin: 0; }

					#fattura-elettronica
					div.page {
					background-color: #fff !important;
					position: relative;

					margin: 20px 0
					50px 0;
					padding: 60px;

					background: -moz-linear-gradient(0% 0 360deg, #FFFFFF, #F2F2F2 20%, #FFFFFF) repeat scroll 0 0 transparent;
					border: 1px solid #CCCCCC;
					-webkitbox-shadow: 0 0 10px rgba(0, 0, 0,
					0.3);
					-mozbox-shadow: 0
					0 10px rgba(0, 0, 0, 0.3);
					box-shadow: 0 0 10px rgba(0, 0, 0, 0.3);

					/*background: url('../classpath/invoicexplugininvoicex/xmlpa/xsl/logo_sdi_trasparente.png') 98% 50px no-repeat;*/
					background: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAV4AAADICAMAAACXvXnCAAAABGdBTUEAALGPC/xhBQAAAAFzUkdCAK7OHOkAAAMAUExURUxpcfn5+fz8/Pz8/Obm5vT09P39/cvP0dHY2+7u7vv6+vv7+/39/f39/fn5+fz8/Pv7+/z8/P39/f39/eTj5Obm5snIyP7+/re1ttfX17W1teXl5f39/v39/cbFxsPDw/7+/ujo6MnIyfv8/f39/cnIyNPT0/39/bW1tf39/eXl5f7+/qmpqbKyssfGxtPT0////9TU1Pz9/vX19paWlrq6usnIyP7+/qWlpdLS0vr7+/7+/rKyssrMzdjY2M7Ozvv9/tLR0d/f39TU1JKSkqenp9jZ2dfX152dncC/wM/Pz+Tk5WqcrtTU1L6/v9TU1MzLzLKysuTk5L6+vvb19Z+fn6qqqsnIydnZ2bS0tPT09NbW1sTExJ+fn/3+/re3t/7//9PS0/j4+ePj4+fn58fHx729vbCwsP3+/v7//ri3t/Hx8YaGhvr6+oqKir29vbm4uf3+/t3d3dzc2/7///b29u3s7ff39/j4+fz9/c7Nzdra2v3+/uvr6/7+/vz9/f39/ufn5+Xl5ZeXl6mpqfT09OTk5Obm5u7t7vb29urq6uLi4r6+vv7//////9DP0PHx8vDw8KOjo/z8/N/f39jZ2Xx8fPb39+jn5+vr69/f35mZmf7+/u3t7evr6+/v7/X29vHx8oaGhttosaWlpY6OjpycnOSOxeXl5fHx8X5+fu/x8i2/6wqy5tLR0urq6nDT8Y3d9AWx5omJiZSUlNfY2QOx59v0+07J7nx8fF7O7+Hi4jzE7NHT1IaGhvXW6trc3MvNzenp6uvr63/Y8/DC4N3c3aHi9s/w+sDs+ej4/Aaw5uHi4vPR5wey5rXo+PDF4A+z5ark9vDE4MyAsAqy5tROo910t8cnjNTV1s4yleWcys2Fs83v+bnq+D/F7dBmqdOCtRC26Mgsj1LK7nnW8s9InZTd8+iv08cWht6ex9A7meGFv9lvst3u83jW8pTe9QCx5gWz58MCfMAAdwCu5sXHyMUMgcLExQCr5RG26B+76dNGoL0Acb0AcLwAbS/Ca3sAAADxdFJOUwAHFBcDBREBAgQJCw4gGiQcHi4oKiMwWDEgOi9ePG06TDWDiDN4G2VLR4xSTVUoMzcpedg+b2FBVxGXu2v8Vm2AYnQWSThugk9BP4IIOAxGV2FEYd9EQVCLRLFNR2COILR7zZdMjVcYwakol0P1UU940D5jm7uR5fFqjpV0PKLZb3ixNWDNVmSx7Ka9g67Hlte+LPqjo03CoWqsWOFYuqekhSv7a1kh+sZ6OMn+Ep/K9vIgDmL7Ltv8IPvp/PcV793u99X56bjz7+TmXffYRfT3U+SXiTrYv2HV5a5x1p+moER1h9irrsvG9pT3693HgVRvPP9ZAAB2j0lEQVR42ty9eVDUd7ouDt3Q3dAr0N30ArSA7GsDIoth35F97QZFFgFBREBoEJBFWY0KBsOibF71ilgupakYk3g15pilksqpTNVMZabm/nV/dc7U+Z2pijMmk+R3pn7P++1mU7Lcqhkx51NhDbI8/fbzed/n3czMXoHD5ZmZ1eg8y2r8dul2m5X5Hd7hqcvZtWtXju6swu/w67t8E3137Trhm4hPnvAtVJRlcjMTw1KO1+CfWdx5UHPleMH5lCv4PjyumdmVhEMJxy++8+AOj7f7nYMJF/Epi927d79z7eC1d+4wP4zevYhXB9+5s5v+hRn3wbU3r72zm7v7wYM7+MqDb76Dz3HN/tscBl5Pv7oyvJhlqnIO78gBujl+nooaYP36YT/diV05hWU1ql2H/RLLaiwB5JXEsLDEKw+unD2eGBJSkJIS8oDgxcuD4wkJCSHHj1+8ePH4wYPH3+EZobpz8RoDL9eMe4fwvXbwzYPv4APu7jt4IN65du3iA3zEw1e/86YR3v9WAO8uU3l66nR1u7llfrt27Nhx+HCOqi7RBO/hXTmeinjreN2uXQq+Nd+cZ2YZfjbs0glf3z2X9oSlpBSEnH2wm74LXnY/uHI85CAgPnT57t2DF8lgCagHgJS+Bu/DSi8C3TffvPiAZ8Z7cJFMHfi+g//L2w2o33zz2h0u978Bvsa/gf6MzLK6MoVftcLCLFMHaAFpjq6urO7sFUUOwAVLlGVaWcWn7sjzN7MScAQCPr9Md+JEWNgJoFsQcvzKA97qN+XduXLxOCF86PKh4/R5k00eImM1Yk34Al5ihN0P3iF8iR7wSMCUdxO8qw/WrxteCysrC8ZKalSqmrLGan8zC0XO63R2qerOni2rKQNT7PJUKdzD+XxrTpqTUxqbw2axWBx+eJ2qMDHx7NkrNTUP7tyxWPddeQDpAc6VK+8YP48fwLt46CDog8djsL7zzsVrjAEfvAi2vfPgnXcu4oOLd7i8O2TIbxpZmh74/wYEQX8woFWUpabGW5RV7yB0DzeWlelUNZl1fjsO+9WFW1sL2GwOJ8DJLTRNaiOSiFgcQbx7WU0m7xca2e6Llw8ZLyx8OVHttYuMAeOOu8NYMH1w8Q5dbgy8D3bvvrP7Vw6rBc/01sysLs+pWiNXmoeXurmFhjo55aUqFY2p4ZmqHUC6LhPo2ghFbHWUm1tst53YTmwjggUL+Oa/zLq4BO/dhCu7V665Q4cO0iETJocCAD8AqgffwdlNlyDuxWsHL+7+lROEhXlmeKYlz4qXKQ91cyvSCjgZbvujs7KjnYrS0kob5fz4otf3vx6aphWxbcR2dra5LeXJ5VXbbbfbMgBz+Nbm5lYWvOefw9x1xwQv70rC3fMFZ2syd/MsHlxMuEzn0HG4dIfuXr7GEDcPDtlBwtSCfLaDB988dPAKfrdfLbT4i+I12aFZ7lbm8dqsWDeXKCm7OenM0Sjn2KNJzs2xsWkisMH+/S4u0SVqoVhs1z0Y13mjM3nWa6djoK2tnVAE87U2t7T6eXiZ+y4x5TyuwbM1NYlw4xLuAu26ssQUvA2pMacvuXMlBFiH1PCvHE+4fCghJAT+3ZVMPHo87q8T3swMtxs33DL4fG1JdHl5UpTt9qQbnXFVVXGdcblR5dFqjjbb5YyL29GjSVXbtwfuHOqrnJlpW/Kw99m203E74csCvpYW3F9EDxbhdb4n4MYVJoZd8q1ThOE9VWHYnj0IU9wF5niMzLhXCu7eTVHExx8/f/d8olJZCOTLrLm/QoKgOIIbrom+MXMuuUTCcU46cyZ5yMtrqPNc+tBQX3p6X1xcUpVYmFV+5kxSbNLRo3Ets0PplRNTEXtjujo8HOx9vGDARnzNN38CP+e2UuxWU6fy9Dtx4sSlEyqRTBdGXt2lE7oAqVbEYcwX3mHB3T0qEafu/KUwuUSkSDmfkhj+q/TIrPDHpEUfvXHuRnKLrbiqeGYi3WfbtPeEt4f90kRlX3pn+qytXW7SmRvFLbmDccWdxX3eM/399a44MUFdHQ4w4EBbsYQNeK1+2ZOXZ2FpzVHKPYGup9zGRqvCe5cu+QUIbWzYAmtLMIyFVXjinj2eMoF7yh5PqVDrr0i5m+KP//drM18uF3GtMvpMcXLxueKhqp3TE09m0u092vqnFnuX2vonvL0r030CAweTgf6so+Ns8rlzlVOj8/O/+cPvcP7wm6Bewnc78OXwiXrXmezG5whvlTi59B6P7y5P9UwNkApFIiXegy2n2dmAw2uu4Jy9Ulew55KfnOVeGKYRS+VK98K7d30T62qsflUeBJdnxeWZx2cl34gbjDvXOT07DcusXOpdHL4671oPFPtH6xc77LfhJjvXGTe7M9ALZj1VX1//m9/99vc4v/3dbxaBr5cj4GUxhvdLgxhzawGLLRGKhRJ4dSyWRHPiUk6qlG1tXQPpAqcwBXSRKpOofOVCLShZgZibCALMzf3VWC7PClQXnpVUHFflGAcmwPP+5GjbYv383Pjwgn6y9ZheHxHk4eAAUCeKh8ACjqCNtr17f/Pb3//pW5w//f63fwjysPcKtJMgfosPt9zs4szM3M1d+4lGYYyHINEKFMFi06NiacWXgx/85BxEHTVXyurqFIpC3H5+Ulmhr1yiVZRZl/nuCQvbk1KHq4/7azFdC/yFVjxtEnyEQK++icqlxdGrc/N79+qXl1tbJwfGJltbW4+59np0eM/MTPSRG+a408ehK6b+d3/661//Quevf/pdW6+Hz87tYqE0QOMfblQiuVa7rUxw0i2lqAu3evGW4/IsrfmIr4GXhbW7iuDNEFlb0acFHA7HXet54oQmwDNMzvZPLOPHJ6o0nnvOFyoF5r8O74zQNbc0FyhLkjuHAm23LU1NLdbP3ZxbOHKgtqnpdPDbb3/y5b/R+d9dMVNPZrynt+0EvI5ePh2Lf/jtt39n4P3r3//62z8s9npMD7XEhobmpbrjuQvvgRdeU8PEAeSWhBfm+OlUijrEzZZmq6AbmQl2a0H/oCbRz4/wTcWXlZ09W8ey5llx5H4nPD39fLUi/8S68PAyf7nON8xX5W7N4/1KTNecb24ui4orjpv1cvRZBNUOLy+P6/fVNvVcMHz8xe1b99/74fvv3/t/6iOGT06kO2wjdHdus+/9ze9+/63RevH696DfRe/OzjNHXdyyZZZcK4K3TKVSMFowQed3+PCOHZCMdQoKGrjP6+P0NVfCcjxT/aDT+/n6hu054atw51tZK1W47zw1MpG/QlEWL3BX6Ahff4GlFe9Xgi7H2to5ubNv1sdnm0Pb3Pj4ZEVFbW0F7Paj2x/evwdwn3333dP/87/14yenvD0AbyDIwQjvX4znr9/+/j//fbS+srOzOHm/S6iab2kOHrBQVOd4+vNxgxG81QQvA7Cnqq4snPccxIyMdGKXnya1sdoPRgx3jfIg8dZ8fwidqVIRK75MAXooK9TJdXv2yDnW5rxXHVwiBms+rmxRVeXMko+9h0NvxPLYWHB+T1PwJx99eP86zPb7p0+//vrZs2fX/+3P43P9lRvhXbXe//jPf++v9+6bnh2MdnNyxuMFo7VS7Ticp2HhhzDWuyMvLS2rtDpn1w5Gi7ci4WEtvmUs3DcnpzHDzi5Do/Pz02lS/U6EqeL57ipfzwwhm2MdriioE5T56rTwHzSIX6xedYGMTBcXCFvcPT0xtYTrqivmQP7IBcOnbxO47/0AqwWwX3/99OmzZz/c+vLq3HBlxzbH9fCarJfgnXddGvJyzI11i3Zm8QnezFSI8KUSc0vi35rGvCKpUKzOaKxG7mMXOKIs3GKd+8pcf3WeObuK1BKRNtVTJxdKdfAaFO5loAO5SOJuxT1boODU+eqU/mEn5AJzc4tX3dtlTFfElnRPe1e2BfUGxbhGTF5oaP/0iw/vwXAJVAbdr8l8f7j/5Z/Hh9s8CN5AcG/HenhBDr9x7fLwWYGXMa2aRqhr2VIOn4CoadxRpBYKbWQyaUBaI6VF/VTxlqs+mvFY13nu2lUdINR4emoQashSwboqBaxXy1bWZXKvQI1Q+OpE/r5hBC/vFbddI7pCiXiwcrQtyHVvRMSRfRWf4ja7f/0p2S2s9ilRA8H79Q/3wA7ziyCHwO0MvOnwHP7rr8QMf/2vv/wekZuHPYiDgRfCpIXZ7rpqEi+bJQJrI7zVATJEHXy+QCRNrTZacHymxQbZI1OBm60x1c8vVSoNUArcdSdA1b5hfhqZkpyJQpWiMEwnUvqeSNUq4zNf3fwQuUNAlwN07ewCp/vn6mMWxvUHIps+vg1SwGW2ardfr8J7+8961177bY6AF46ZB9jhT3//r7/S+fu3v/1NDOI2hMXNsS4MvFxejQbi5X6nEjXL2moFXmINitSU0oxSkMQuT3/mjjPecJS2EMiBb86unFQbrcZfIPD3vHTpBHkOcmVdYoEvTtgJnUQbdulSmG8hYuNX1TuDnkLosiViu+2Os4tzcxF79zVVTL79ye17P8Bwv1412xV4GXJA7IbnP9TzwJ1eDr2uf/j9t0zQ9u23v/+Daxei5kBbNXTiWGeOwNrMqq7azWW/C5JFIr65kRwCRCAK+rk4HJmmesfhXY2qsrUrigtTDpeDOQ7vShNKUxXh1u66S7uqG+FJaJSgBQIXMbKN1g/az6UwBX7IKwgv8R0CNVxqSDnY2jraL86Pj+tPne55+0tw7vdfM7yw4RALX7/1xwXXXgcSbmwJX/uYhZP//p+//S2jOfzhN12gBkc7sXNJdHS2miUwN7NMdXKh45Ql41uTY7ajSCriIDzkWdCxFijladV5u8iATfUMDD3wwrWNgLdUHAB4zeMBbymuQz+dlu1ep9ARrqlCqecJPz+omBxLa6tXEl4LQpdF6AYGevXOjyP4Bbof3br+9YuGyxjvd8/eI+PtgLCAvI/YLnC2bwoecv+/M4pZWwyhuzNQbOMcFR1bImVxLM0yi1xc3Nzwki0V8BnrzQ6QAF6uKVKEDbO0pUDSTx5vzVu1Xy6P79+4C/6DWoNsdLzCrxGJkTQ/TzkHopO/Z86lnFKpWKMJyPA7kSp5JZ0z7uqlZmfr6LXN3nV5bDKy6dOPbr33w1PguNFsGa8X9vz9/T+27gW9ghrEIpFdVd9Ef//oXte23+As9nY4ELq2EuQ2CV4OrNc9dL9LbKwbXqk5Rnjz0mQckxRDTyBYMMMQO3JSlZlMSn7FfuU5h/OcpXKExuHx/nKpUKoBOwiQCIyXe8IzVtvIlCJYcKmUJbB8BXl3Fd3tuKIcehcq8isq3v7o3vfPc8Iqxl8//eHel38+4NrhA1VMLBGJq+IqZ6a8l3p7u4K6eglcUtO327FZ6uzo6BKpwNo6Ux591C27JNplf3SzhMM1C0/NyyuVctalMiDaWFuz5I1gYLrhVq83q3BFzq5qtUSpUNWF86zdtXKt5kROqkiA7xoO+8X/Ermz/D1x34kEr5yyzmOYgWNEd5uPR1d9a9OFTz/5EOiS5T5dZ7hktt89e/rD9ff+z+0v/zh+JIiYV8ziSAeLz51L75t2YI49sN1mzAVxOFIGXr5VeFmjy9HorOYot/1uJVI2zyxck4e4grMuGIDzwjOziteW5u3Y1SgnD4L0dWiRZbqc6jQxh6XQqeLNrNwVKn8VouUArTKTayZQ5VRnIG/hjjydX4CS86o5v4xHtmK72+w9uva2VvR8+gXDupua7g/v3bv1b39cDh7Q1/fa79xuJxHYRBWfm0if9drmg7MN0FKmmFLx4EKtEV6g6bT/aKyzOisaGkSGyAqfqM4rCmBZr4+1uFwrK3OBSFN9eEe1PBy0a/R9gWBqgJjDUXiqUMYG0bdOgYLBxlRVmbmZRZ1fY4BUoyqr052AN8wxf7Vkde56ZkBs0OV6oMnwCcUR65mBCBeGC2jv37p9+8tP/nwqsmJgfgmKri2bI4tKRs5ikEJjRptEEMeAK5Qgy6AtinYqkVqbxRchpRxlK1KH7kedhMx8Fd6Ndz2lg83dGQLWQIVgClgyPXc1BgRkKAV1gFdQp6iLd6fCK7hnujJzixqVRq7Be+6FJ07o5GzrV6vwgfzddegGuR6JvPDxh+9tSrvfX79/+4tPDT3BFQeOtQ6M15PbIDSi27LdDpiSi8YcOwZcNsfS3L8I1qvGxZZ99IxblB2fneUCCgbeDDm8AC8jp/NZcshpeZp4o0ycWZjTqEktlUN6VLkrVap483gVyBhikJ/Knc/HZeeZo3NnqSjYYL9SuhklXzegu/fIqYpPgC4FEquma7Tc6/du3f7i4097eppqD0REzN0cXoJjKxYZ0e0WC23JQTMdoY1ExEa2jGthJAdrM//oM0ejc+2sBRnR+/fHOvPN4jV5oZvByyPZjmPC15Lc3911Or/GUo1GpdOp5BpPVbhVvMqvOi2jFE6DHA9BjS4nR6dkIcXsp2HzXyHPl2u0XQ57Fd1j+05/cuv60xd499nT67e++LT9QlNkZEXFAdcY5C/mPbxADWLwbmeLWghztRGx6YiYNywOilARPWhD3aKzpAJBhhu4oVksEKDw5KhbM8fqx+BlnDRrjhb4VsvjrYh8zVEm2EjOmE7nCY/MHRK6SiMVI7ho1PhbU7kxWJcNmd1PI3ql4GUcXsRq8HeNtrvvz18C3fUOA3kL3zOWy6B77NjyckTvUv3cXL09PC+b3OKJzhZnG5EYAqwAh2M8VN/Lp9hXHl0em2HD9gf1lpc4izl89zS3oy5RQr57KuBVbw4vHnbY7w7gK0BWCPTgd7g6QJ7aSMJaY4CI5V7mzmbbBJR6pmo0/mVwIxrlNhJ/lKCkyjiWr5TTwKArNvEubPfLe99vDNHIkq9/CGwNhp6mfcciFvTDix5LU/1T6T62YnVz0sTEkNpGaMNmqvUY9YASkdb4wJwyFAHR5ahMk6RFnznT4iwWcqwz/UP3H43OYP04vAzA5mS/Oxq1yPGYUcF2XqlMJmeiYympbPi1lRpCN1WlosgiwEYih+TuqVHyea+IrGOiBpZEjFjN3oNsd+DL+xsvtWfk5d778OP29gsX8gf0e13r5+fbPHyW5vsrp73sJM1JnefictlsoQiZcAuo8ZbmzEEuEh9awvAC3MqjZBwZStGODtraSFDMFJ4FH6LEhh2Q55Sd8WPwIoTjyPN27GhUWoOKyzx35ZVCjkzddXhHqdSGY2VZU1aGgilPjVwuV/mRJGwj0fidyMnxVCnDX5HIwnStAd1AyInwGch2f/h6HbxPSRi7d/vjT9tHenoMFXrXrqD54frpndsW5/r7qgLtpIOdE3G5qKhhC8yNNfxGeYZqFqlmjGuCVyCLPXMjucqOzRYATNDwUVi0tsjJqZllbm25+Z1rZh4fkHd4RyrLKrMMN1ljAIxW6bkDGryNADIwkhsqvxw/jQTh2q7DeRmAl+lU8tPV8Y0dMq9ELEzXWiBVKbiSzwDbXc+6sN3r9z/6uKenJ3hsbKw1osthaX5u0Wu7V9vc1BDUsEEQb5TMRiwyosvlrpSWGj8wwpsMeKVJN84k5YrBIBZEx2fORDuLZEVOblksc/6PwMu1skSnxuE8uSBc4elXGiATiqy5dX55BK9FjQ5JIVKCS7UsNr1tlAFe5vipOK8EPTD1GozTsHMbtFqUMXyyMVR7+vV3T9+D6fbU7oscGBgYh7hrvzTa3+e4vaWy33snh1XlPdPZ0oxqsB8JRRl4y5OjpKLm8hvJUc5iVOLhC5WhR8+U5wplpU7RWSxrvuWP/Xpmlv7kPsggQ3hqtDIZdJ6aVJixjBNep9P5syD0UPTMZoOTqwMkSBilIqsEMQIVxdytpwaGeCFB4lrrjYk4UPv2h9efEx6/B7rkLrS2Dowtzwc52E+nT1XO2ub2TUxMb2dJhyYmWqToojCWL77YRGKEtzwqIyDq6I2kXLWYxaeYKr7U7UxylFqa9aPw0jcjCzRXNu7YkYYrrboxQ6aV17mXwX1IVbLqVCp/DiuVGpQQPbNZmpy8DIkWD4E0Dal+ifXWl0wywTDiCeZa64jZeywS0cTTje7uDyAGw4WeioGBseCx8TYHL58+78o4Z/HsxEx6ldgOOk6fM0RayjhQgb/Zj8HbXFJ+o7PFVihkUZLNLFMbe/RodHNAFsiBzd8EXkactGDo2796R3WaBiJPdYCW8plymK+SrdIpONbKRuqnI++Co/XLS7MRKZVKWYBfTqOM/0s7Ov6pxrtKvB5drsci37793vcbognQ7hft7Qy4YwNjj4eXdtp6eU+l5wqd+/rJanPTUWBWZSeWCXjrcufPw5tRXl7S3IIq4EE7kcRIItz4LLBDSdrm8K49Cywyzfly3G7VGRl43VjaWF3dmAoeULJTPessrYk5YL9IKbGUsGkZR+Dur4Q+2SgTbDm8ZLx8NPOAeJlrbV/Fl/fW2y7e/+HDj0cuXOiZ1C+PLQ8Pz9V72EqqKvunxbJBMG+3NSe388nJGe+4wWZ3U3kCj5yx9UZM8KYVJ2c1l5+7UY6LjU0XG4k2GeU3jsZmZUUD3g3kYBTVeaaELzyG0jxYaF6GNKMaTlpedWkpxRoyUWqjv7UAcceOvLzQ7GYxCzXBGi2b5a8oU+oY67XeaniZSlryeLc5dMREnKJr7dl6r+HpD/c/brgQHBw8qdePD9e3tS352AoHJ6YGRd3pM5VDYp7AOalyChWSxUlRGbL48MxN3Fe6YLI6i5ubk8+R38Di0MVG6GnhOySVlLwA7+rjkpmZWYNMGsA87ORUpBaJAhoJ30ZqqQPaqan+Ao6icdeO7KzubtyYHHd/jUbuD3jrPF8FeFeoAR4vxcK41m6tVyDJdm993NDQhGrTZf18PdDtmw207R6q9M6VTvfPxOXa8AUS59yqofROOumAeMWGIdmuELER3s6qElS4x3YLOQySBK8y9uiN5Fi0wBG85itxhAUj1VLHa5nCE+aah1Od1dzsLGWz2LKAImpjpn7FvKJSlDxYI+zbkZdlp04LcOeZQeTxS/V394e6Uwpy2Fp4jdTAWqEGEO9H7339nO1+cqFhZAAZzWV9W8fiVNvQdrHtYFx6XNVg5VwlRRICCNfWktyWuOKJmZlzZMPKcBTl8l6w3s6W2M5z0BsQEFsYFV2zeHS8HG2JLXcpMcG7+ouheDqzRqHL22HEMS1AIpIwEbe5QNvIdIPi7CiViQTIcMK4s23Vaah/MHdHNU+jvztCCz+NDWeLuZdnQQGFiKGG3pgjp5Y/uvfDKjUY68c+6em5kD+5MD88Pr64rW+0zYvNcR5KTmqJ84bxqtkSNp/Asxapc6tmp5OLO6kWMikqzX+lIpqImILiZkTNSTfOQW+wMV1sXMZ3gAQR63K0RMTHw8SzsDCl1TLLNKVEszih2VlpGVIbKG/Un2xJCfm0olAnxn6zhMjsm8N8D4M5tHKNSqWjy08OOs5Dpwv8v62GF/cavAYKhkENf7z//UZ/9/7HF5oqgoNbF+pH5+aWvKZH2xzNrdRx6UlJlSdn+qrELDawYpL3HKi6bOeopORKIw9nacOhN/BWrbe5c6IYgvCgnURiTDNSRGdmDd8hKfromSiCd9UZg9024i5Drj60KA0OtcSkGpPjx9TFitRFoW6vv+5UYsfmxMe7QxR+HW6xtrS6Gl35eaWaUlx8Uuah39qyBkvmXoNORl6DkRqerhaIfAd/99Om0wNjA+Og3fnR9KG+qfRuMzM1Ygrvk1e9q9T0bLWE3wxdzBImaslW5w4OxTE8DBseLMlwz1yDd+Zc57niKqHRbzDFY3CHbySjJS5KKDDCywv3h92iVfmwm5tTaEkWY7csFssELjkU8DisWdo0wje02UYpV9X5NxKDlJaWepaS+p6WhiQzkvsIIi22mnlX7jV4Dcsf3f9hnY7z7Ot7X3zaFFlL8A7Pj44CU+/0IVuemdr76tX+k1PTtugzW2U3Y6qOek1Eathwp5GIS7QoJuUa4X0y04keTiFrNXKm/Bl6us6cuXF00ASvZZmm2un1/fsZu1ULbVA5KWHs1npdUxwl6gWSDODrVERBhkpeDR7eAVYI0MJus5tRpgb3Ik3Ct7TYYuaF8dK9hrzwMVDDD+sVSETCn16I1E9CxHl8c3h0dHhurm2oW8w3b658/PjqKKhBJDKGX+sfMryYs6VkxOggZEy4OYCKQZo7TxLe8BtWSxAo3HWPSj5zA0Yt4se7+8vTSsGqTk7RsdkwWxEkdEbUfC7nS6U8PHSzpIWCHkoDAlJTcdc5ZTvRVReQlrcju1kdkMaIFOaWW0kO64wX99q+pi+vf7dKDV9/9+z67Y8bepCrDA4eezw+OjU69/hxfZWILZK2TD1+PJxehaIczgt3x0rOTmSjrkpKhjMxQc5EANfMufPkk87kQWcbweojwjSupCUVA95BsUiblk2VfS5OxLewW5sVut2s0wc1fZbKUiAaWqqFxeJtSTYuO6estKK8bMyRkMGK88T8LdUcjMzLGC/utclPbv2wCq/xWmtor42IaM3PHxhum572Hn58s83R2hzB2tWbc96z6KViCyx44bLm3Krc5u7c7u7c3ObmXNPBR3DfOieenHzCkETu0LknTzqTclENYb0+djbXIkeHYCOqJDba5egZanCB6To7Ozc3N6elZWQEQCdHnICjkGOu1Iq/x2TeGHzzpBJm1EFuiRPB64zqvyKID2DfbPFWBsVIDjNuA+OUIRr+4/qsO1XtfvTphZ5WV9dWQ/74oo9jFSrz+vsC+fxc75uP59IHt9tSV4OZhXtJXOVE5crxxmFe0Vs6EzPAF75E5QS6ZfGYCEVrBs/IweEI5c6dOZoMaM8QuuXlbm5u0cxxWj2h6NoCm6YC31UpArOLlNmv73fKEK6DN9dOjZI1OTsDxpslhte2hfASN6waLxIUT79eo4av3yP1PFgPePPzx5dmZ5dGh/u9Iceo4+YeX62cdRajSxiGaB7fDB/tKp2TJ/tPrj/9/f0zExMz/U+ePMFHAHkivcpOxN7A1jBCafm5czeMh+B12X+UOftNh6lVdcE7IIA0JTnHXBOzgVlK3fa/niVsdnrdDeRA8JbYSkshXWqLkCxSk7q/dfDSxUbMyxgvhDJ4DavwPvv+Fnm8qG+qHx/LX27rq4eeMzWkljhP99+8WTnUbSc0JhKhQzq3gC1uAt/+F8+M6UxMTJxDBY8jZIH1fzGVRbvHFp8pZiyXOclGZF1WD2pVGZxfD83CbcdfoWKmKkqe9/rrJWJpVnZodnaokxtQbpam5R0uwkse8qqiLQwrmItNJDYZ75+Ru1xl3mfQzz9qv3B6clJfj07M5fEp79HHHzxuq5IIZ6du3hydxpAcI7pwp8wRxbUNA+Cbw1Pe6enpJmpoa2tjXuhTfRj6gDM0uB1R1voEgvFyi21pSUpqoZOUZHonduVEhYKTCW632Cw1/czV2jGK7ZSNbqj4EWoDADDm+ryOmuGAjNDX84rydhSJ2S/6NS/xWNDFZsO4DcS8a1IOQw3kNUTqW/VtS0ttw3NT3t6jN+eWAiXN6XOPT+I5biNBMwRsl8oZ2OLts0v9Nx/fnJtCXzFV79nb2zuYjj3V8qGUDzVn3d3wNdYuthWMrMKVUrUzBC+8dNObDUfdnO0GutjvFpVra8d01ZvgZVKkqAd0iUUWShKQTQSNmmGntDQneGnV2WlC1lZSL+CFV0ZqA3zeA7VfvreeeZ/Ca2gIhlOmr++b7msbhVl6T41O26mn+5fHvQdtKSVsTbaLclUb+P62g0ujczdvziGRwfSv7PTy8tpGh7q4qYzPjimHEiHIez77RdcbDRdgynqM5T0sFttU38OyQUuGy9H9LtFReGwwkmedOdL3sZQ77UehGouvLHJzy8YDsd+tqAjwFhVlZSB+2TrjJb+BpDImYIPPe3uDU3b99qcNDRUREePjo0uYMjA11eadXomLzQse79Ss2AbPcWumfYgtsRFi8BOi6um2uZtwj5fsMXWAoPXxmaVe2W3MsCKq46O4VrBp3SLXip4Hzx+EH1bxASXRZLqxVUDX5nk3m6IS1Fk6pbG4mEPlVsLAG0rBXHYRmISzhcwLv8Ha5JVBiET2cj3zoten6UL75N6I8eV5Ys+2qfnRtvTpXOfpubGr6d1oveBYMzVpLDb1CdiiItLOcbpteHns8VxbB4qmfVbYAe8z9dNiJrRFDe+LeU4KREi1WH+obgqfdA8IdTlzBqabS+O6GBGeZ7mq1zPtQtlAtETMUVa7uGSXxMKnc8IN5xSaXZQh4ltvXR0UaWWmiw1qAxX4m+Alarj30du1TQbA27o8DMtNTx8dv4kg2Hmwbflx//R2NgdKH1PIzqKqtEB6+ttu3+axOI+24/F5Atjew3gcjKN0TKOKNp+lw2Umvaw7NCqDGruVpdGEbmxuNzOrC2BxLcPrmIkuPBO8aINBFXZWQCpZcUl3LtwHJzcCOTsDcsjWhcQUU5i4AV7ZJ8ZyvRV4b33ctK82fzJifpnEnLa+vilEEtO23bjXbk4NddugAcXCqLUxpuvoNTs0NLttm/0S4TuGOojepSXqXPnN0pKpdUXMZOl/MRUyyoV/kRu8NeSXGdblmyMxFO+P8j1/awZZo2tGTVxu4NpQ6iWwtc0m8yX7zQ7YUnh5a9xgutjW6p1+uG2oPaAfaF3QDwQDX8DbNvd4bkhcNfr48VzlkDOufwseqJdtWzU7i0l7O+Mo4J1GO0YQecnBFafm//A76mvDKB1j49V2OyElGn5ZPT6XSWKGa2IpRqY7zU5ClmtepoHeg8GK1ApktRIY+xc5kf0CX7TNNWdFu7xOHgT5v/gtrbbOeC1Xnd6I5y42+LxN+44s6PXDwGoM8Kantw3fHB3qnh7PfwyxwZYFoGD8fEnutLf3ksM2h3OP/vbNV94O9g4evRGtY8GG/M//8/d/Qk/xt7//3R8Wge/KqCKrXzpHkmcZn+Z25saZ8ugSW6oXZgnC3eWloW4UvyEvhykpppEPFvFy4AsuyMoqCg3NDiWRGAEGojcb9lZ2r6xyQy9dbLfWXWxP3/vwk9MHIuoX5ufHg/OX5+ZG09On5iDqDC3ezB8bhv/Awv1vgevHpsobKSL9fP9Xj/72t0fnOhwAbwzwNXzwP//jL9RR/Jdv//TbP8R0oPMiEOb7SyZBkdhIY+Lk2eWIkZOictUSAa44pH9gt+DVbDQUhdqYW5uv5Dss47VpWZCDsgMCshBZhGaXlJALnGUnokqgrZo6C71BwFrhhuUv7z9dudiefff9/S/ejjziGoN5T8vBY8Pz48Pe6cPLo319lcPjj5fnKQMEFrXC5S6cBRdArnz4iOB90tbV29WF+srJsX/5H9QRz4zL+NPv9lJPMcyX2OEXTBFiArlUjKW7cTS6xNmOwkOlBhZ69CgU9gyJNHp/tNh6TQlDAwaHI852i23OyMrOhkxMvctO2ZSU38KQjWuMKYx+wx9vU+XIKrwfftx0KgI2tzg8MDY+Oo84In18rG02HV0UMOJZWxs0soNbBHzx9PBNjIRafvf91/72t9cezkVg7F5QzN4Dn//P/28F3r9/+59Trl3UEY+Q62fhNZaOZMJ0z2DqXFQ3Ck6kzSVR0YyGFlvSnCGzFsUejbbjU+y3YpnIDnEyQp1is7OLkFBWp4W67HdqlrH/L6am/RPSQEaxjIkpNvgNz+hiO31gb5CP15IeVTn1o8vLbQy8i8vj8IGnAyUUDfEsESLYLc2Nz7u6zl9l4H338aT+yN69EUcOfP7//sfqsJdvf/vv9THMJDMbluDnyZCmT6O2BMRQHuWMYI8J2qCjhWYxmSHRCrz8tWEllNuMh4Ps4kS2S+i6RKkRtIeHY5L91sx14DHUaxTLjtVSrfS6Ysgve8ANvV6OveNj4/XpbePL9d5zy/V9bbDcqkGqsQFMPHO8Fi+Nj9d3BdWffMTAC56omGzdty9yDd6/ELzz1C7vaCtkP6c3bOIwYDiyexrS9TfKY3Odu6sGW2C4LuVJLVHNUnRssNgCM1bo0WgxM+/IVEZMzY7mVu5F+88QvpTxAKeoM9I0iuOYpmxpwdsSeI1umVHpvX19Q+PPJ6eJG3YGdoyPzbWlLw6Pj7bNj8+NTqUjiS6GA0vPcVgvh9XdtrxcHxRTf/IrhhweB+ePjORjmNE66/0vwHtsb5cDQ77w537Klui5nOmfTep6eWy3c3dsOXlmbtlpajRwUVTNQceAdejRJLE1Y70rszTQLG9mmYHhti6x2UVOZLvqrKKiRl3Cm9euhCMdxN2Cmw3wGt0y0hu+/26Nee/dfrsW3ODhuL0DoVrb6Nz43Dzl2W62DcpY1PDD5MpQo8fq7tMHDyzExLj2f/UNrraHGMPVZDAYLlz4X+DeVXj/x+f6vV3MHD4R56c8M6ZWzz0jFugWl5MqmVSenFxeDsNlfixS8egxQidA6JlosUjun2mxO9O054LmC5tB2zkKu80CN8SWQP5NC1AlvPnm8bJw8y2oUKf7lvIUDPUG33q6Dt77H5Hf0OsQaOswj4j45hgliefHxwYWbenZyWcSt1ywqGh6Lh9ucYQrrJeBV3/gAFpgey60b4T3XyaPxHTYG+H9CeslEJRF5Z1AN6kFSdDOM8nRUVnOTJucscrBinw2y9AzSc4Z2UX+WO+QiWbjFXi1DLxZGSXo5nLDJA4Rx/0s7Rpx529BczHBS16vg9HrXQ/vrY+D90Wgw93WdrZteJ7OVFv9/DiCYrFAJKLIltpRUJ9h1zZmGBsYQGPmCrxHjhw7heEa663374A3+NTeXmZK50/AS58PD4gqv0HVEcnlyUjhl7eUOMtIlETPLKNXMDhaZp85GltEHi7KULWYSWnpLtfgZLswknsUzYlwi87OcI93d68LeTNE+YuDmX+o4ACv187o9Q58cX8dvD/c/rTpAMjSa7tt7vTosn5pOh38C+9sasiWTeNImX4qK9Rx5NaPDejHEQHrrz58jYH32LEDp2gC4kZ4/3Uk+ECQEV6+1U/AG55FpkunsxPlEbnOoFxGZzM9Y6jaB/8VnbmxH/hSyt4l1B+SZKmTG5OL20+vKXkUW9Kt1iQeL3N3P/7mQf8tkCUJXkZwwM3GeL3r4P3oQuSxva5BDo427O62sbH6Pm/vvvThMVCvkBp7SQqibkCOFDHFcL0+31AxwPi9DDkA3sjTPRvJ4V/bDZMRHdvgmf0ovCQ0oljyHHL2wJaKT6KcmdonY6XD6r+i7GU2anpim1ESHA0RJ40TrwllMnLllFouJx8utsRZJEosCCnjsACv9pe4g//4m201qKAE/EpQAan3vS96Th2JWBiunxWacYbGDWP64fq+dH3+2PyQDRUwWvGNt4xNVR+qfV31hnZD/mdvMZ6DEd7a089bb/tIsH7RB2Hxj8JLnJpWfg4pz3OdxXEtVczcGPyUjbVP5Czs9kdjnEuUs50zdbw4FWWkMSEwpY0Qf8DXYEI9iSwx5Ky7IP7iwRDAa70V8JKewyQqNnRZPX3vi6ZTR/Torqq3F5lJl5YNhrHhtvpxw8hyvQcSECTOwL9n8+36RjEnGUUQIz3BJnjHjfA2XXgB3vzJens4vqwfgZfGs1tmJZ+bALpxLXCtUQpEuaDndgWQjdegmehMdBZaki0slFlQzaHfYGAXHgiOjOI7FxfsIhHKaMsOh1N27WCIbCvgxVxnEROzQev98v46eL+/B69X3zo2trysn2abqZeWR0YGhoeXDSP5YwPLAwOt89NQIG3FrMB6PAKLEZMjIId18O7bFN7gVleHnbZUlb75X0qeXkB0J4w3eRDSPMQu456LjTchfZUcrXDJsc42VJjpnkHpYcCLkTywdBHSxdEublG2EtHZ4xdrMEAZ61iOy9hbA69kRS77EoV7z9aagD45vU/fOqlfGDDovSx53fVjI/nj4wOG/IGx/HyEDWOj016BSD9sW8gP1kcsDIz07Gt99+fgrTgW4+D1E/CSXbpnJc88megbpJwaa9PSMsr9lCJ9UR7VjTYAvnW8vDQ7NDY2NNtZSM6Fe0BaUawLlVn5H792RWDNKQO8If4izhbAy0dtWSA5DhQSr/RZMUWRb9fu0+sXujwWgsfaujlCcm5b9WOGyXrXiL2u+gGmrW2n17YlPUrP8CC090Qur1jvKXDDpvDWYpbRT8HLhBQBSTMoUY2rskH4sElOjlnwRsx7NCkqKjZbHm6VqQSebtFU/8BBMWW8Ji0j2wVdnsrj165d4fAF4VeuvZmQqGTxLbYAXpuVTAW1sX29GrMhqNinX3D1cfSAt7BkS95D/vj8mEHv4eOwbVvvwvLyQpePF9I+4wMw34XJkQtNYz8LbyTmnP00vABP2QJ4J84lOXPMN3OlmIdAjt0vydGxSSgX0fLNAS/chlhGHoOHlpoWUAR4JWcRTZSBLawzL755KMSfzX/ZU3Wgl7FW/LKKDfBSzHYK8Drs9FoaDx724rOmJw0E7zHAa2/fi2QaeHRbx8LA8mRwfuuRyPaGC4afg9cQSXGFrQ3nx/9QXG78qAkq9itGY7flJjoXPQRc/+gbN+CCJZUfdckW8bWlYAO0dQJelF6XlRalFR2GFnn24PE6Fie+xtzinYOAl3prXrL1mvNNgk4E4F1pIDbBu+8A4F2yd6yqD17ukPB9JkcA78iBXofe3t6giMn8iggPB9cBw0BrRX7kscj2N95o/8AIb+upU5vD27MP8O78OXitcjupFK0zrkRkYbaZiwGQ4tHpUo7KKKjtSVJWRnY2umZbnEU0mRIRdWhR9a4cZ1niwZA6JW2Is8J+00St5KXr6jzzFb0sYl/Fre9Xtd7vfvjwkwrAG+Hahs7WjuWx+iqhz2R763zwSGtXRxeyEa6RF5oiulz3XWivOBVsqDhQux7efYA38kV4R4IBr89Ou5+Bl5cRd26mMr24M06NqPBFfLmMhcN6cbOhN7lcLYJjBngHhZB/ker0D43O9rubopWFHDqYmHj87JVwkEOCAqWG/JccFhO8K2nMiltfr4vZPvz49KkDCxGIGGbtfBbGlhd32k+2T+qDRyJjumJw9k6O5B+I0Ae3o9Wtp71p3+l18C7/GLwVp/Z2+Dj+JLzUBCuL6pzpHMJylyglAtkXHAemaoTgrbIVOkefKXcWlsSG0ugYOxaLJvVpndyqUw4lyKUFhw4lJBzEeknsJQzR2oi2xHpXooqmF+A9BniH5x1sHdse5w/bO7SODIzn43ZyjZjv7z/58LO3Hn718N3PPnu8bGjoqW36BfAiq+/6HLw86tjkvhAWF6OLNqkYm7XcSfLclBxwtbXkSjOizyQ7ixl4kTRqlsbj3/vnOXmGHDpUoCrA7tiEgjolrrgQhQy7oF52Id86eCOfh7f2wLGFBcybXgrcPj0+MhDUoTcET0JZOLAw99VXXz169M3fvvnmtdfef//hux+M9DT1NKzC++5A5L5N4QVFu/6c9TJ+gTRuZiKuhfBtxpRf3gtfwcV0T8CZhCbvpBsEb3RobDLIOLooIB5LJv1yCkOwMragMLEgoUClVR6H3qslbrB81eBFVFzvZbez3pC/QNXpTcHBjx8+BLavvQbpEYdB+K233h0zbIR33+bwHonB3PoVeLkrSxM2bLAh+OJbJp4UD+a2nDuXJOXzzDbSg7FmxO1ocnlSdBTS9Iz1ZiMHn+RCCqTM4kFBWEHIofMpmgCtoqCgUGvjH0LWyxa89Iwxz1oAycGYx+zZBF7ojGML9na2XRUjA/rJ4J78MYhi37x4XnvrA8DbsAJvLcF7+kfgDVyz3k2X3tLlVlL55FyLbTeaN2Ol5mYb0mRMQVkaNh1GI4/REp0MUR3Wi0QRkp2oRDtawnoQkgJaKMiwtZNqFQkJiTaSuhCSdF5++wrBy8TEMcc2gfcIuGFgQL/kFejRajBURNYGf0bo/m3VboG06YPX3voM5GuCd6w2cl/kJvAG71uF14ra3ak4L6M5gDrn123/oORkc/GTmThbYRUa50tYlpa8Fy625PLYKGSJyqGMtdjalVB23lmtbo5F/Z4/9mYmpKQUqu0CFEplyKFEGRzgg4myLegr5hklB3RpH6t9Ad5jERELra16/XzvNoeF4JGeyHFoCoyxMoCCdt9nwCYSBtiftTf8X8BL9Y/ACVue4rLiaY4Gd93FZSZFXOydy5YNonM+zd16vZWTWxYffSYpKwsrZOlAnChxSz6ajOJ0IYaU5BQeDyF4NXbqwpAy1vFDBXIF0PVH3+jWwev6Arxv1x5zhbSgrx9ujXCwX5xsbx+7+ug1I7K4zx4+fBfns8/eAsRGg37/sw+MUdu7wacjIzeHl5JLVOjA5L144dLBdMS/6YPqcN7a9g+aAqGNPfekskXGcYZ3lqS2NFvfVIn/719+I0ktjSqH3F6e3KKWNEdTGRrqc1L9sAqvoABLd30z7LQhUNKP44pjHIctgJdrsZZpO214Ht4jQTGt0L8XBvS99r0HLjR89shoua+99e5jjHUIzg/Ob4eE++4KHcOeX/speP9lDV5KHHDjm/uMDVozcc3hVK1nsZrKdC8pnsFnRZjHBe+XwzW3XOc3WGDyTuegUJKVhGQGFvQ5s6TZ5bjpyt2ccs5fTinUFRy6fB7rShWJx+M5x+FCHEpIlEF9e9lBBZ5oDLxUl35gE3i7YiYNxzrqgyeD7DuOBH/wPhEuTPezDz4IPnXkVM8F8sbae/KD333r/ddMjPGNEd7aF+ClTHEFA68jgmIaxiCNSu9n2rSuXp2Jq5LS6GNjPQh+MUst2KE4SipglXTCO4u3YCrOVi62jOij5c1sWVQ5BN+oM8W5ElkGEhRQ0A+fuHy5QJOhgb+QoVaFHD/rzqqDB5xQIKcNqC/fcYBgZkxkbgpvUMxk/oKHa8XA3o6u+YcM7/7tm/c/G2mAeHAM4XBPE7309OTnMzeeiZZ/At5Texl4hSzMYsnqmzI2GTJthpUwYKoSY/gBryyrJk5iooa1mbQF3fPO5mZWVmvMi4stSi3MTSrGoLmS5OTYDAlGvziXYD6176HLviiZkkql4oCCBCgObJa7IrGgUM50PW+F3LsimDV9uim8xzpiWicX9rqOfsXcYiCG/AtvvIFIeJIqcVDtFBxMEw9X/bWfhzdQjL9ZOujdTy2G/VNTU/2AGSM3cmWocmZc4JWxBARreEbSuXMtMtpsxzXBqyzvTMqQYmMvWsBzS1owFk1macmSYSCnb2EC4EUJO9pj/BNIJIPa664oLJTL2C8/kUlRhQneiFNNH9/fjHtbY4IiWlGf/uSRkXY/CK7tQQDRUzFZgeTlZOtkRXATTvCaU/HT8Hr4BApF0qq+0avghZtXp/qGptHKyRhwUjNCWszOYaY+qJOfPEnv5ltahzcXT0CbNNX542LbnVZ8blCaVU7FfVGxUVmxyUlqfrxMqShI8dWlELxMI2NZSEKiP4pP+TVnQxLlspfPvKagzdZUmP7FBnhvB0cCXn3F5MJi0LH8/KtfMffa+x80NO2raH+joR0BcoUhv3WhdaCCFg/W5pNT9vPwdtl7bd+eO1R59TE6Y+eunvQedM7t67+KtuOTV5/AgJnBOyRCaJMmnnhXQYXBoAcSH1g0U8PY3xp7ozhX3HIDQxIxUiZKnZVc7szyV/lj25UuFfBmSJXxqHiqOQ53QekeXnPleEiI4qdKK/6pVQ4kmJGi0/PFvXXwXv+yCfcQVN2BVtfeIz0fPHxEN9f78G17ImG27Q3t+bBcOMXY8zowMLkvsqfhg/c3Wm9tT8ML8EZ0+Tg6DqGx892blelTV09WDgVKxFXpMyf7J2bQiuwNAyYRmoaTRHU+mUD3hjUmEbRguFEAbc62MHUet0jFceeSnTkYO1UiUUcnOYMA6sLdMUgSO8xT5f6QeM3uXAvxR7LtCuCFXybaEnhNeWLMyIj8dB283xnhjQlyXagIXuh1PQ2vAci99tkIzTicHMhvbxhBgi1ifnwZIE9Oth441fRGw2evmeAdMzpmF954zjGrQEWgg33H1FVqfIkDP0xN59qK2NKq9H5s6a7sJxeimc0Mn0eDcfLMTHKJjI+y0oC4CQTHAhAHTVdOPlfezLKLO9fCthbnlqg5spLsDEViYpkAIw0LU+CSyf3rzj7g3bmW4C9JDLlYcxEpIX/RVtToWK3liWli5AZ4qfg0qBfZiFO9Xa3v0hP/b+9/0H4h32CYXECMgVtNv9g2mT8wjmVNB44cO42Q+P1vmAeBorZIUnRehJc6CYZvjr07PI19TScxmdaOqlHZVZjVhfFH/Q+vzni3qPmMTuneMnMSE+4FuO/jS5LPFUexKLiwcI/CGDSRlV0cwg0p0GWZx2safQsS69wF1oKyRMbj1SpCLprfuXYosQ4VUJyLBxMUMtEWhMTGRGagMZGJcadfP1tHDmhaQbF+b+tIbUzQ/EOC99HDkYYeMMNkRCvl5Mda25CcHxjWYwN0xJHTcIE/e80I7wAFxRUXGt54gRyOROgf0zyevu6qtqv9GJoqwqIQM64M438rhwb74EScnMBTnaDg5U7Q+wJEFJZgiolkZ0r0uFMUnSswEydhoElWVEmAMp6lLDx/PlGJjo1wOLnnfVPVMkXC8fiag5cTEhXItR1/M8GfCSq2qMDMxwGl09hNcX1t7B6KSGoJXnsP/UjwQn0/XWyPvrqa307wVugn8wHt8vK83mDQ11PfW8SxigbGfNfghb7+AvfWRg4E5+ffrJ/2qkqfu+qdK7ZhMxupLGUtE8C3ajCdCCK9pVkJLJyLyXcQMOPsZfDOksis05LPYdCvwEzSUow5qllF2aUKd87Zy+dVIhSh1YQcSlEFqO2gQB4vO0vw+svYZdfeLNCiRfxlFzlweaul0ygwq/hiXY0OJhr+EfV7MYD3SHD+5PATpqHqyfAACkiC4SnkB4/X1+tRVDKSP982HtwasVdP8I68ZYzaSO+tNcB9ew7efDCLYQwlltu9MP2srYrNghBghaJ9aDhxM1crd+KWmzh59SSmr7OYT8F3wKR6GK15M20akZkrIQG3qMVsLiu2uDjWWdocmudZF3/20HkNKtFqziZcLpSK0dnlfvbsWcpXyIW43KDniEUv3+1lGgYl4kBT6fRHa0UkqNG5xcDb6+AB1zd/uf8JA2/EsYERQ2tEKxxerF9CKXWwYWAeLVet9bgCoUeOfLYKb21Pe0PDc47Zv46MtI+MDS92eHVPz6HQEqkxNtku+QN8576TJ/u61d2z3owBDyrN3AfPPZmYFTLZSS6JEMUlGbHFncm5Ehs2JMlOMmOhOrUw8WzI5fNyEbsMSlmBSi5FgIbCEYqFVWqJ7PjBN0MU4q3hBmPDIKOXBX+4sa/ij/uOuAb1Ojh01A+MVIzOEDmMQkEbGTkWtGBohwcxubg4DitG2RlUNRO8xsard8ciQQ20eOH5AlSmRNJ+27bpqZvzszZs4YpNIRbD4CNcdd1sFFxOQOXBtGVZCRO4YVQf7eBmwW7Lk1HwG4VdbBwzflbyjTNuaUqWO/aPptxNCRBr4d4mKlQqOVxcC24NGW+AnbDu4JsHFZhhz9mC4tOVmA032+lPb63OQkYJ1L3bfzwF6u3wcPDpONWev1A58/Czz/RdHRH57a2LEWMGSGX6ob7J9uC5eYIXuAPe9nwjvJ/l19ZilXFPzwvwjmATQ4eX4/QoZss5c1gSlokQLWCgrNz0k/1xapbEuYUMeCIuKip5pj+9BKOsLeCy8tRYiDHzpHMQrVRsPm67EjeXw35wGOCNnb97XhNQmHC8rg7xr4JFezcfXIPxSsXakDeRIxZuhRiJ4WXG2l6MNdzX8/H9Z9+t1PYyK1sPgBs8HOy97CPyDa2uQccM7a1BDkGTsL95/XKwIbh+1mNyZHl0ahj5DNf6VrjChrHHRnhH8psuNBiaXkzE5++j5pXZtpvjfc40JHZdDwDZbyW5ChwrSVXxDBjYO6lv5mQlXDMLcnctwgPAxRNx3ahJpRVsqCTLubRnT5hKKVIUnD+PcDihju1fkFKgEAkYeBOg40gTyXhpvMbLr94jbjB5vUi0fXHv2WrMRtNkJ4/tDeogeLfFtOY3HemN2ddTG9HRC19hYKF+GIWS89N9w631i20meA3YB7C8Ai/I40LT6dMvJOLh+Hr4eCzO3ZyqEok2VPnyYL/sWbhiQzJkiEricPWdrKycgdLTLbBAFIdQI7ykuDKOFomALigRiqG+YYQv1IaUu+dTfFVKliLlckKBwl0AeA8mqMRCeQjQlYptNo5Fenl+w+qggY/XBRWMoIOmoCBmwaUP2NdQuzfmSC3knd69cBb0i/B3Da1ti1P1S32Lw2MDw1hsDnhrW2+a4MWt1lR7+oXeimAk4h18FscxCsIZu9vWlx2QmmAta5k6WTkoE5iz1HDRmGlo5DtQbyDtf5ZGDeZSZ7HxiY5+RaXGl/CVyArv3kXyR+hfcPkykhOKeIL3kByl6QnItAm3hHnXhpBQfZnR610pgbr+EYXEvR72zDQnmOwHV2dmbhqaIjqW9IYRSMD57fnL4+PLw4uAF6WSDLw9+/RGeN8FM/fURr4AL2UrYnoX9WNz087iFztfrcws1XFTmEDHMuPyZblxlUAXJjwooY1gTMOQVmojktA+F0pZoJsZe4yBr69W63v3vE4qlheeB7yXEWJYclFUJmejwOFQolBiswWVpzTJ2DRogHHL1kqnQQ7vfULNxIzxbkORacTYZ+8/QszWc6zLY29++4K9q6F9YHnMAB6ur8ekgfl61FiPNJ3SP2RaV65ONhlO73uut+K/GHj3xtSPo+/QS4jRyM+3bQNsgXNcf3+fGiPBBWwYMBj4KibSEYnQl1oZRy8bCRupOSsrgbIwbE+YTpcSpkNeWMegezlFhY0K7xws8BcRvIXiLajOMW1RWPMbNqxXeXoPXq8rplv4MCOyfNoeU4ry/XebIiM6gira9R4RIwa9HoV72F8xPqwfjqjXVxgMp1fhPRBZG3nqFMz3+ajtAGYe5T+un6X5XC9YFApIuJnO6f1Tcc4cnpUFX4ZVvJAq03NlAupaIaEHABub/0h0JxMuKyT6DTOhe/fyeXBwaoZYVHYxJNFfxD578FAhpiq/dLGMdljTxcZUkEDrXZPSmcJ/8noRU2B4EyZledkvXn2fwoWHA8GTMV37wLp6w0D9fPBAW/0AkYQew1FhyZGnxh9SWPFo7sgR6l2BqPMcvChMaR3L1ztsJyFnE08JALJK0vtHp5F9MLfks50HvU+S78CxsFjJtFkZ+4MIXvrUFZAD8PXMYNDFBZfiW9ptK1SePX5c4S9hlR1E5Gbz8kfwETesm6514Yt73625ZfB6/0zcYO/jxQx5s1+aYYLir24aeo7EHMNUnQpD6+J8cKvD7EL+CLW7RkyiUPLUqZuM5P5oLmLvkWPoroh8AV6MPQoeX9yJ0RecTSY6UKLHIr4K7tmgzJyHJUp8JOorO5OaOTwr4354nnEtGfOy+8EDrtmVFILXL00doCPvIYXgbbaTlCEShvmy3I3wvmTqpUEqxlHpxikZFR/fvr7e67315SRxAyZj4WCFeUcbExR/9XDkwr6IhcmK/PaR1sUFw4CHowdVoFYsLFQ0XJg80Eo9md+89tUwzXJA2+sL8FZU9IxMxjBdxZv+xYxFKocmcJ+xzSzNzXjYhDEYl9TNsdg4OorcsjtXjifWmJcB3jC/UucM2C54wdcXL6lSUd1BSg8rRGS9WEX40uE1TZt2NM08XXexAd7rt99muGEbrRgmeB26Zh4xguRYT1PrwkIttMfWenjAEfbbllrb30DGLbjhQmTrTYL3tUdXF/YSvscORJ7+/DlJp8cQvIB1pdi1u7mnxIX3ayUdmjnpncuyQCxnxTOX5VY5czaUQXHJidt9JSQlJfFsIuD1y+p2Tg27ezfMM9UTAPsWKpTQdlAfqfA/S96v6GXDa1xtxQzspQUrp9++9cP6jXfvfdnE5By9aHuz485t9vYdE4+o1OnRzYoL+cf27mt4o2FgodXQgCy9x0I+8m758HpPo+WVYeiTEa6urjSLZN/z8MJfo34MR1uJ4Cc6gyykcU+AL5/ptufyRTLRhomITDn17iuI1EAFYXAcSru7S8NgvAQvLjZoPAoIDoUBYjmK/xVa4UuvmkZEsWK8tEWh5+N76xZbPYPfgPonMl5sccaUTS9M0mv7iupEvvnqsQH0sA/qTXDrJBTHYJT/6/MbGki/6TFW9z36an6vawzhe+x5eP+VRoSDcwLtfrxHhyDlOac/OZmOJDz2w0PthQe5YfI5g27I+bBClY651tK2p+GCOw94S31TUtVqFYqgEiBMiuUFVJ1j85K1yHX7a8htgFf20Xtg3rWtYbeIG7Av25FWZG9n4F18QqME/vbo/Q8unI6sGHnjDUNFMElkAxHUBdBgqu1lLrb+va6uaA5w3XvsVO3nz3cG7aOHbbtpCd6mhwwtPNf76kkqcmAq0yE9rXVlMsU6VrDdFJVWqvGka805I5Xxznw9PX11AXZSVQKKnrRivIWcbiP66dkc/wynbG1/DW0HCv7i1tqSCpJzPlqmISQ+NPERowsDd9JGXYzJMWYioIj39KBOx2CAoAt/IcL1WEV7A5X2vs+UmTwcdg3CAbzYBfn5i5oDNV4JWT9VMYN6HEEVsygHqTW6hi3WVafS9XeHbFclYYsDUn3DSp1t8XoPmLfRMwyJIDEyQXAXpPJCKiOB7b7kJJtpE7HQGLBFnDpNq63WdmE+e48uNqCwjcaVYjQkma9HR8zoV0wJFOpI2ntOU22ZgQEY6joqUBoaGNslveGDSQyO7O0Cvi/CS8X/P914RYtszMEKnO70/pkhKZ/WYa3nBSKGmuMpQFcrsZGrfH09M2zVvuf3AN7SLM/zKTqpUKYISSgMkBccSgC6tFdyq6iBxhMxPu9aEgjw3vsEw8vIeOH8CzGSl3bqOnh0Gc2XScbnV1AjxQXAi4J0Q+2xA6dHjMyAyO4DBMquvR3A1zXiBXhJc0BvxU/2tRmfX2asof6TaAx6rq+N4L2TeJ5kMplcUxhG5qrWhDGhRXO353koD0L/xJBElQpNQYkmdF/iiBfyeNe23tEs7yb4vGtjI58++/7+25HHjAOxMMpYgr2kWPtqj5mFo0Z6oCqzsXwClhgXh4Syd98ylvg+ejhAvldMR0dHFy3b/HyTOgfjHD5rZiv0yhxZZpCspaXR/2Jmdash7p6LDhBYrWvYJnB5d86mhPmqZMIAT3gNezwz1Ixq5udXut0Z8KaKhYqCEH/UQxUkaqnoVGD+MomXZ1oBv7IdCFvvkGNbtx4IrdrLKHDwsKdhj5ilQEOPaWkx4Bo11kGhVuetDwwjDLYEcUP+44em8r1HV+chzIOPuzw8NoF3tTr9x2fpcGmGmWW4NiupuBOzDWn07kZ44TOQBMmSktewZw+MlxF9PbO6bTN80a0ihgiZKPM/dEglpJFcmJ/z8qiBy2Vsd2XdKDbAR/Z8sn5zGPbXGCM2xsZoDDcL+BrZt8vViC/VQr31Fmp8Teezt0ztFq+9j2uta2/FSPBwkINDb9CL8I40RS4s2m9nm/+Yz8vLdJc2V9FkLXSmxEaVqGnQ9OqgMmbQaU3inhMatkCm23Npz4mwNHWGL+OdNW9H4HbeN0BK3hi77tBlFa1wInS5L912bZg9z7RutOnTdRNlmUH/X75No+GYWYQYjQAFULJCD0Gu80b7ZSrR3wfGxuYKU+HpN299MHak18N10jC20OVACyGPRH7+fCoTqY6lWdtN6+mYIbzSEmzXwyySM2j1ybCzEz4/kgvFqWfDLjVKWZJCYOrZmMY4ZcA3zTkVkYUuACm3AoUExacqKTm8LxFd7hq6xp2C5DWszfI27iG+RS0VRuOlWRVQWNmg30AGX9jvya8efbPW0Pbaa2ttQo+++qy9AmXWGFmkD8Iobw8KWD5/PhGPYRuY+b00PVuV2+2sdY/HCY9XSjOcsW5ocBYL3oqTMVqrOLmlJEOrpJn/tFyFxzPJOMyrmsIT2AMvUkEmy8hIS2UkM0Ct8wW8qWpNCpxdbeIhBt6XmXxfQdd4rdGe5wO1yLCtowZmPVDFivEKqUiWFq+xGfpl7DdmL1OvY+oFWqmXpo8enRyuaGhyDVpAWZSrzzaaj4wnx/OaQ1NFBWZ+jy3PjVZ6p/cNReVmZWGxaFRSXF+6d+UEClL7zxXT9FgaZmhcz2ZutbZg3rT2sc73RJhcqfJNtRPaZXiS8Yb5NfqGnUeUnOqsu5ygksNvQAXJy81fMrzLZ5wG4zLXY5FNH3/4w7MN64FuU3mDyXgxIMic+ReiFXw7eoPq+09+ZaSEv610tDGNryfr9+67gAUMA/mtrvY74co5bAJvBSZEYAnv+PjcHLbcTE0wK5sAbCXtacLL1JR3HNltvIDWVzALAozxGm9F76U31nVhJzTaQl+VDUfCOGVhjc3wee+e9/VMpYRFQWFBQYFKKnyZQ6dhu5ZGZmDQpWsNPhlN1lrn8z69zySBGJ/XhgbBWTL/ZhVfByLgvfPww95a7R4kEqZYogtF1hX6VkOwK6nE2+BrvEAOVMJHtRMeZKuVZK0njfuEmO2FALbb2VbNzDKkIZzMvD0jMfAyazItzFbvuDLfE55ynS/2t4IiLsF2s7aTzxtWmuZJ6aCUgkKVVvZSW4hN/i6Hzdgu7Sina+2j9zbsG316/XYFBWwrxmtc92lN1xuDL4UXCBhiIsYfU0Ob8aC57YP29tNHentpZFHriGHBg4RMrJJ2PbBJMoieGYGOVYNDQ0PTK0uF0vumh2YxvRtbrJgVGCyj4a5cSxaZZYmFiXXhlgw5cDNrEsPCUjWevhoJq64Q/oNfViDcBii9np5hVPCg02nkkBp+bszqP9Af4zI6g4lGjeieOv3pF/e/f7Z2rT37GhNlUVi2znhxq5hsnuwX/hkZMBjCdaGVOtpGqEZ9YDKY8u6Trh0LhvxhNG/m65e2OTp6OSxFnH6+hG+ACSt20mobJCzwHbcz24Bs6WOxcXAsnBVcqCvYMlmJmkS/E5dOhCnCrSwYodf3xAlPDeCVS1DgAG7w7N6epivU6Tx9wb66DGwXws5keoBeUkBhutSMJOoIZuhyjWDQvb6WYKPNYfc/WbnXbJntB/gTGU4hixIJ4Z9B+/UBwB4dQRGQ1BFTNMBsj9QC5QbDQi+qefT1Eaj4G2+b9trps9h64Y1N4F2ZMIv5kxamvR+WtFuFdjox803XjS3jYpFumULnl5OTc+mSL1Y7W2XWnC1g0E311GlF/gXnSZBsTvNNKVDpyIBTA6CTMA/Uy5l3SveuafUqiIFW+hDvMrZ7a/0y16cr1GCKKOA2mG4V4gc8NCBtWqsChqA1Nb1HmgjcCz2nYmL2Ad432vVBba1jy/UODqNj+QPzfdtQO9WwifV2GfvaQDyWDPWsLrFh3qFtoyZ5zLjHqk7nt2vXCc+AAM+cEzp/TvxZ37ATviqpVKPTySVsBYXFzc4Q08G3Ol2qJiBADXCZfbCWL4UZuKY7zei/bmfERRO6a+k1st111BDIrO4w/YIrdyKLHh1bZocVU1pSP2kAvpi5iRWaI4B3sm1pcXxs3lE4OzqQP6Zvc21Fl8vnm8JLqxWMXsnKYZAF1VtsjIAz63Q5u3blNGrYLC3w9VQkAl0/jYwl0/nqZCyRCjUkaQy6OhotC3SxXdufTXey1aqv/M+1XBO4rBXxAMGqyXa/XjNeeA3fm0Z5EzUwmzvMV50hq5VvYbMCsBeKH2KoYLrBgCnpSG2+0V5R7+C1OKDfxrKbXRqmhSuoZD/9+Y9ZL91cdCyYY5R1VhSetR2CNbqcnMbUALVUwhbJPS+BgMN8NXKpEPCGqdgc/4IwX2zPBboqasPUqgpTUs4nJMYTc/O4pvPPtVwiNoHxqU3SAWK1vUjSbLRdEtGfIsFmpAa61xjmtVj9Q40PEb6LRMjsBgLCO32C9GgYNFDZ6UAwavby9bNC+9aBJVsWy3l6YcxgyA+ujdwMXi90Zf6CcIqqRmo8d/lplLSrjC1gyf0ugXXl9KGS+ixFaAPy1ZAciSISLIlmSxJTzsMxC3F/CaxL7fsWK5Zr5E0KDOBVwd9dsd21sWVPMSgd1NC1nhrW5rnSo2T6TiLaymYrtrWv1+vru7oiBoAsGl8NmN85Ldk5PzaM6bMsRwdX/SSGmb3g95LnAHg5Fs+vOeBu0MyZOf4MvDnVqVo2i2Jja3dFampahhR6hbuqUOXvL/eFMCknORJCDm4zjnsIKDjlcoHknx8LEyKrkDBeK5luB2nckUD3Q9ju0/XJ4R+YMfTrqWH9fKYVfBmnVISh/wKbDkx/QdLXYRGjtwxjy3DO8ut3dvdho5AXS2Bj67VUHxFx7EV4UT3hMFvVTX2TmZnm6/O/+AlYZJUZXlNWVkbrzpnp/wrgm2FDbgCyr/EiZpM5S1BW6KtQKnzDIKozJXwaxCJsDur9U6inOEUui8/cvXL+4ZIOl9lzZmm+am5iI7gkieNSq2365PY9Zhvmuo2Nph0KTEBhx6z5tLJ4bj4Q+Wc07p/23tlYszqCGwyT+iCvndML+e3BywMjDYbxxVzp9PjyYjdLIAm0731RMSN4e5ewvRhTLjBbKE3jH262Mkhgd02dvzy1sbo6Ly+vWs5HASS1F4ercrDgHb8O81TkM5Ey3IfCQpWCbNdGIg/bg4QFo6xlIgN3PuXQZVT4hhy/aDzvvPNg3T7jfxC6zNI+vslwjeAaBUXKjfd8zCx53mi7tz4x+mQ+poVf66nhhbpVcwHfzNwhGH3F7eP2YtsOTO4dQLn6iGF5qdteHzy3lCsW05qRvZtYb0xXW/9JjN/sPIoBkKFF/ubEsYwOpmlsrM7bgfXjr79+uNEdVz+zqU2xa0cpBqFarTzAyCKFn01EC4WOUhYiqL5hKtgu6fNWNQRvyvnLGA2XcNB0rl28kvkPpOL1T2Oj4ZrA7YDadYQhhlvXge46nwG7cu99SehS4QgCCtH6gHTTQ6G8TwVFFQOL3WzH+nxMPdYPwPsd0y+Mo2Zycdt2W0f7zTQHdGVOnRxNn46LS4qOdnNxy1IaC0QwlyzPKQ+WG0pLnA/nBcQzJaNWNbpdh4ukTOubmdVuJI7x6ZoCX4W7QqdTybXIZUJBF6NWmLqH7hzHVadJTf3/y/v64DbLK3tLsj4syZIV6xV6LWKhJFaNGkuI2CYCj4Mlf0myLFuOLQeLNUbCbuxMbOTWvyWpAdlBcr0pIZ4AMqwcnAVPDWQDpAOFYfIP7FLKbHZTPtoZQhZKs7TMdqEsmc7CdPZ37vPK3wnLEofdmX2YziQuJPHJ1X3uc++55+wqKioCb3rvQ3T2jPdhfXt94le+/BJigbtFIDHR5ItYM/f8YkUHcpGx98JtRPVniVdQJF77F45rkt4A7H2lziuY30bcnAcGMgW6zMRO2s2EaPL/+9EDh2eeum9i9prrNjJhvzXw3jgwOWa7FsVHPA4PoE01DquKfqumbqj2V0Z8AYdeo/O1tQ0axPgzNPUZ8aiIwMUG7P/cvrk+EWkO9DVut4M37eQA7vZHt4KUjsYuLXk3jTeC7y+8r3lM4x96CBDvLe/3qNapqb5Uoi5kBXrFYo5zM+WF7237+T+++rMviTGyNHgXhJBph00w+9IJ6K758zSbMvM4s9kz8gOMfLB3NZDUqTWZw3/5l/C0mQe3YWCSvC0mE6iLv7MSXjbK/PFjR8cm/Tdo87Ucx8V3bNrh4zHUlCua+wdLioN6fFGikhnCFW0RJ28sKi0rK+sdDORj3XKqrgPksak+AV4j3vcSvohtVmBzQqJmNTrBq5Po0G9D4wICW3v3Qs4MjV+26bI+w57sAw0dgkKiL6EvyJrg39+NK+2eX7z2s2VcskUXbQFdutaEilcpXTn+Y3USn7ll54+QX7fdJ5xt244mBnbunLXoVDmS+W2oG65FvaaL+f3JmD8dTVx11Vp4/2nbw7dMTI4krsGIHxR+rqanxscxApgU0Vtpkkgw2pXBlK0N+HrLqiDeUmrGbpoGZcKBx/Gq2Gp05TZPNW41iMWw+qBuWakDoSoTJmpNTz7RkS/RMH8Ldfd47d5Gr68D+0HE75WvR2rIdm7Y83UFuNDSfeH1156h0L2wrAGJnwHd927azdAVrrW1iZfglZrmd1Ky/dEts7MDOCMjs5nR+W3b7sV/kSMdnX3qgYnpUb2Vj6eSesloIhqdvQsrG6uHQTtvv+/E0VlIrhdqZNhzh3WdSdhsU/R5KytNsOmWUfLhB4eG2npbUUL49Lp8fYCIj4jk1gPAF8I4dKcZiuqIHLkdrBwdMxNUCPDqxGJ0hqVMIqPDvMFSBBmddRIikWebAxpqLmzMptzNNzJw72FX2qrQXcgMu6kkY++JhcS7siYjI5TQ7APEeTo8rZVgaRdHKymYvu++q2UqACTST0/C6XE4mXKnYhadZmMinZ69HrtEq+Hd9sBTR+dRnoBHAsWhlh6IDMlobCy1UvSi6FLmgcmrNLcNVbQNevUoc3WQyGltLSuycwZv2QG8ig9s77BLuK23bqetilIfuaETkZLg3QN44YUFL7IXnyRupFarN5YTi1q1HtN4xm5i71/hEcFGC6gW7t+GyH31paeh0nDhj8t9XFHvvvTsew8L6C671hRrn6fWpG3iFkgezsxvFOcwNZZcKT89M5FRK8VqDBL0GRhwH0nD4zwxndRqr51PHz362I/vXxO9D2Mr87s3bGCbfa4WCJ8HcZ0ZDOZIG8GrxkYAUaO7veGIz6SRyTiHz4tGrtfBy9S8uQz5gd7FGrGThhSMvof+BX30F6NXpWo6eerFY+PjU3auQFPQjyjuFyul6wKvaMVgl+pcVAt3/vXPX3sJkbsqdInv9DQkpm+6Oxu79FpD4s1bI7VP8HIpWzSRyfjHZtIpTsQatC6EbPpamYrCTyHSjKZsY7Acm5iAV55lwzWzcHe82F4bteQ2FjKJc1e4ZxO8GYvZgaslNoCyPGeRR0NNBAlnHmxtRZsBlvEysX0X8u+BUp8JdUGRMH2PsCROPmwL8EJ/uu/FJ5+ETZAEShEymau7fM+4RLUeRroC5ZyaugJrCZ2xh//tvdd/+Sxy7h9Z5H62IjHQW+3229itxmK3gK410VpTPgbvMO4sEzc6PYKrKRPiCB2Hm8GLb48UAzyWzPwI7NxOvIJdqeuuu2pg5r571iig4uENhuQWLYNXZICyJqwvBXwrg/qskBv9fkqJ3hHASKK0rLTU7OScBo5ewWWDEUd+AYc5G+A9UDaI1MAIP8uiV9J9jELXynrzqNf6oDutUa/H1E1BdteMVMOauijFnmJJ4YsvvvhsWfNx8TXx8quL6C7G7sXeEwvwDlskMm1oOj0xmYgjdTY73RNHr1GLWM2fI1eC7T6apFWpEzPp6WuvuWvg8BolqJ3boCsF1xUtewbIRVZHsKsrKJyAfsHjkVk/G7y9vWWlu4qcBiDsLS0rMnZsLTWb8P7lGKlsa+lgML6hcGGpajF6YQRybM5K0zoZI103A15etg4sSVqzFLh5bJg2cO6jj5595qWXUSz8B1W6KyP3wmdfYukdk9vF2GUlmSjvIiUMwat32+DgKNGaOH1qBHVX0sK7rCnkXpVUeFJJablEycVBsknPzKTnr7r63hu/t3ptcOftP5gYmM9sYZZMTAzSqafjdKLgFQtMXKY+jQlQ6eBgKTSdnObSQRRprWUoHsycJl/vAKcMOQLNM8uGZaamRJ188olGoxE6JC6YnAmuecAcZkz29ZAikQvrKIWsZ7558qPfPv3llxS4Fy6sjNzPPhMSwy/hS8H2hplzu5AZLvq8oWiy2GiZT5tKhNTi0Yw/fXRk2GBPzcxk1CJ29bO2CbZ8NVpLaDo6NnN09t57oZu4RkPy7hvhtAl/Y+EhJcdKvoaORJhiMllU/Dr9g72lkN7leYnTWxZxcE4vZpllXojLc+bSA2yPbQM9zhbIu6xtrji15wlSz7Fb1Wz6IbyNcl98snyKF1/+WJPkGRjnnFgM5z767RcUttQY+2zlrcZC9+VnXr8TBdnXQZcR8EfTY9OccnRkxmbJk1tjtsnJqDvpPzyREa62hbJQSX7xWPab+MkMPMbWPIqxZb95IB11055lHi2t5sqFt7YazwQrbcFS3dDcjTakGXJFeN/Yy1q9EqW4iGZCEZPeWbQVoVsG2imox5olO2n6qzp5DPC2G2FL6OmGjlnWPjP3lFA7XHZpRqaixIom+tjseTAYLlxYHbgENavHELrfo7SLvVZ6TSyge/HHDcEbmpiZ5vnk5CszfotSylmw7zs2OUGSImKxaKlXJyfjV7EWluYnDk88Rj7Fq+DdfP38vA2LgGL8bhhlZum8chdvMBuszbm0Hphn7MV0jaNJulRkL+sFx1fiZSM3n9lLI/lSn8WULdHzliTCwUzFwgoa6zL1XPmeY9CJE/jAp0jGTGhKXDa8yA1EOv/hud8SMW913AqR+8WXL7+KxLD7+8vQFWgbl2hCktRNDGmW6/JPThy1pUY1KqknlEjPvPLKxDSqKcXyvrsU7UqVFvF74sThH9+2Ct4fYCPmu9ekoFnqcLEd4rxmlwssPqshgiea1+5iMg2lVb0GCaOSeLoxbPNKRNZdVYC3FS0IKs0CJkadVC1+2FjsvkhaLwZkDJlqDhoZx+b6mpvolxNR7UA+mZcLrzS7MYFmigDv6sD9jMozXGmvv/DUbZQY6FJDn4EFwiVjlyIgx5WaGAiZ/BPpRCbpTsQkLp4zJW0/eWXG1mWFTkDeSoBVkg0Z1L333X/7Cp9iwEuTzBs2xup7ajj2F+cxeCNhnMpiavP2OpVojBWV9ZolsgIeFqLGUsA66FR7BHhbUfhiA3MD+7QtOJML40pkBlKYRquIl4nm9uxlrV6K4ByqHWqNl798JcBLJJy7CN5lD7SFwAXEXzyN7uOdN/34MZZ22fIP0XipjXOJ2KWveuLuaCKWOXoi2qUP2fCw0CdDGk3IPzmTToQ0UvmKyVmuCMU34fvUPTtXw0sMq8wNG4cPNXTxVqvHHqksoYOyF93fTcVhp8daVNY66OD0Xm8RWmaUEzBtsxPMrSyAI5bCQjatWj6rakIGqMUNpnMajd0u6alj5eXo9+6BfuTJppw8crvqv+y2zjJ4Z1fAK+SICyxyn3nt9fe+d1s2MVybTbtIYpeKXUGN1OT2p4anB04ctiVj7smxVEFsJJrUayyp6NiYLWYl7Ypl36yUbtiNmMLdvvPvVsL7yi2PDYCr525gblXUUGe+rCWVLcF4EGaM6KgPAsW2wUhvRQWFa1kkEIgMljKY6fQGLdj4yCaGhUG74iS0MeBtxXP2jtrybpUIDZ069CMfQgQ/eaxZBHj3GDWXK468OnpXJgdA/MWXLz37wj333wQnoM03LyUGSruiSw5/GLyx9JFUKn14Jk1s0cloTD8NCb3qQglpHEOpkBMtn/wq8pix9LVXz+5enRxeeWpm7JEj5ODauY8Oud1uKimGEzYnk3CBFqSIoTYatmEshDNUNRgwmSLAluWG3jA9JFbJmMgp7e7BniCeErAjRgx71C60h2HwWgtz7b0YVlD0GnWXy0Zlpq1C7r2ecu8fs1fbBfau+PLll5559pcv3I7QfWxg9l52p7G3BDn6XTIzCKB5UhMzI9GJCZt/ZDId9U/HkraZv/KjOcZpRqejj0SnTUzrLcsJweXGOMTXfGfz3QK8f/r3f//T5//5pz/8w8O3HAXX1N/grscZTlZ3dVVXQz+6sjLMEQMuUAl4W+JxH51IGLOhXgzgWquGGLy9IVD/WKkrX/6na5p7cg/4/jxx/zxQQga+StQO7XUGA9Yz8X/AaRBU9fzL3dvOVg7sVTFyfmnbh0CmlPuPL0BWF/6BlHWvomI3mxiUX4GuoKeN1thTE5MTI6nUyEzaHaJnBbqP7qg/JJZRgjiS0rukisX4VSypz0387m8Wo/f3fzi8++jILMimw8lYKA41HR36jflaXWEXdcvwJLfCdaI4WEjTdomkgDMhL/QKoUsnC+8CtTCbGppeRBqAUK8OGqculcgzBcF0FS430oHS15Ub8Ep+6KF2FHKSdYA3W/d+5+bzL1OvHGFLddjPnnkVgfuLOykvDNw8f5eQF8jok6pdqfQrRlEkwIK6AcpYtrQtmRw5Oj/KWxJjM7akKeTH2zhkMkGSJZrosipylicIlW4LwXvLP/zr7z//8+ef//nPn//+nd/d/f2B+btA5U3GguQgKg7EOZVKrJYEWa9XlSeyetuKyU4UhCANx2GpTu8weyMAua2NwjccMRv6+7vn+vrm6NLCQTlGicFewBmhdTg11+eBJl9dt7IP8GIpz46lVyOqtCJhlnzZrzaB2f/dq1H4vsxE9T57+mcvvfraz39xz523QyqaIhdpAUICiIOF0CVq11dcqnks9475pxPuZCqazuTjXpuZ8McKN0ApJAq1XYmpPvqIP2jFhlSuwMekjWVTKJOwDex++Hfv/J4F75/eeTf9F5tn56cpeKvh/KWWOmtKutBoVKoDlS0O2pGCgFnvEAydC/AxtxuKnBpQVrC3qA9Qpuilm660o0448EyArHQflCKfqDXyEo0TW5jYckWvDCuv41bIScJcEHtjErjD19bpC/MvvzJjyln5rB151/y587+l88xHH/3yvRfuv/+m23bffePm2R+yyKW8wO40ITHkLvHdFEs/XOj60tWmpwBNjqJbBgPzEFLDEb8byz3o8I5Fp0N6UzJh86e6Ag6HIxCIUz5NDqfcCVt04Ma7x979wzt0fvXum9ffS7R/v7t+uL6+Wp+b4yw5VBLg1WRfFQ7wNA3OcdGcIsipVc0ofwfNBrPZ4ETXx2TCDlAkEkG1VlRHmxPtjY215XRqobqHDSKNHYKnYP3TlwD4OD0x7CC7q7qRGsoNWu2lFxX/Wx0zYXWC6E4j6Jh99G9wnoI13e7dd1MpdhdJO91AvuCMYMyYyiJKDstP7uIR+Ip4EstdgcRYOqNFno1mICSfTrj90UnkCsx8Jh+xxfK5UOJItAG3FTyo3J109tNKim12lobH6d+9++6bIzfTK+a7CWhs1g/37Nthkuc4d+y7o9KhzlHQcAKTd8ArsporwHIgjUgQSFppDFQK1q4BUm9anHzOabcb6zo6Okg1pxGuVuVGOzK1xupB3xz+d/Bn20th3F5eV0etHQh7k8ihYOO4DvAuLFGiHzh77ty5G+lAemXzzdcjcJEWCFzKull0Ga12+ZEuOwuAS0W5rlg0PR8zYUaZcE+esIUsGdukPxazpf0JiutQbDjhxzYaqwjc4Ijgf9M436Fz780jb745AoGS2flUxr0fFoGhGswwVdhshRV2mM+VegyDYR+vpAs2jx+sqBh0qnKai6qGWlE39Jahoe414NkuJjMKtNbEfL8dQqcgQhUVGe08mpkSUt9yTdE+EL5Owd0Bjgkv8aBoeIikHdZFMUMhXdj8oSWTxLnz58+dG9hM2hXX//BeJvl2A/LCIrpq1UWO8qInV8klbZOzG/UZv982MQPT4i0pvzuWmpycDg0jAwsIu93D1bGuEJ5VG0jEhDgWtCqQ+JjOm+mjk9HEtLtheIsu39IFy1un2RzesakYa8Mu+2BbGCMmKeujtw21+SSqbjzUBgN6xyAaDYhgu1jt4VnxJfCPNAUch7AtYHeaFcUEGH797dA8zc/ncB8aiDIJ/WkUvnV67frIvbBhkJiGQdfdkKn/5LxwEMP+eZYWsrFLJBYKBDG1WL/GAW0PnwpTKj2JhkMmMz2Snr0KfYPU9DTUz6djqejkGIQ1Ry2xZGjURLOvPBF8iDagMQqJLgL3fXbe/ftHWMkbgygyp+c0Gkck3FJcUlLpkMk9kYo2ki4jxoPVW1XRq+fwIO71aTXOUgyAIqVmA9/dj+UgkbKvu7/bSsEhk/BIFTzoOHhKUP9R6plqL3IgdjQ6rMJL+H4IIzMNX+36OLwiOyiFUeaG6z795J8Xzvnzn3wyDUmyGxC7lBnY3tjXOeJlR4YXsG1yZHp0w8ZMIjriTyVTaJn9ZNKfsE3ClWbSnxzdyPQfSEJBrLOEYrEMdquuTrz7q3f+hZ1fvXvIb9vfWR/bgBklGbnjkYZmQwmqhxypd6hYj7Yv8U5FfC+RSLwYUpgKJIA3ghvT6bTjSjO65Mo5khLoBh1CDTTbO/qt/TAPw1O4GaJGpJQM7T22uGWl0H0I4Vy4HlVDtqFNFB00VDSFn/7mn5fOJ5988umnn1IhD+1bgu1rhu3SQaKWmTJR4BvbUoiZMOLQj37DCHLFkSP4ISYQhVpLDBVtLBbCGUWqqEf14O5B4QBsP/zww395/2N3AsxTKMQyr2aXr7KmpaureFOxT6Y0DxUH8HvkUuUs2lVR0TuIQZsZ5DJnWWsEn24JBpkgPHnkyikoQHX0U73eN177aKPR2t9OilAIYJdS6hnfWwt5WUDfTaFbWw5xWaSGddIjYZebMg/KPsff/s2q88aZt58/jpeVdE2pcJGz4t/IFcQs5Mi//knUCyaNDuqkR7ChCr5TqgHblEi/01vUGsjKY7uywd3TUB9Ei80dhDHV2fcFcAnft2AdCvukfBWbi3vClUGdxNRC6UHsaKuIgEzDXn55RVUV1HfAEEiGdnpVKfIobKswv9zFS0V9dbjAeDzdcpqmUJXZJf3t7Yaixif2lk+55M1wcQS8StcchS7ARbJiDDT5esGrYnPbpuff+M0bq87pt5873iT/xr800iIP9tgR3PwcHx9G2EZhZhlKVofi1Q22pEYch+8tNoM76+s7O7t8DUfqnfGeTWffeh/o/hrnww/f2lTTtWPfDgtCr9llNRcX+9RSja+yuDKgAby9Do1Kgb01jIIqKtqAsE+fr87p3l4V4SQaK1S7t99aqpcpwe7tKOIo/uVztY0ddo29Dt2FRsjKtk/1USsHBQOVYyT7T6FbwHbq14eASrUDwSs//vyZN944sxLeM2dOn37+uePf8Deixp9KA8nB/UdsqQCvsyRhz2GR5Ou1nKm6E95JcTfEzqEhUm8ZdXdWBzuPDGtM9QTv+wK8vwa81fGafZta9GKP3duLxBvWyySOcItPz/nA6Q1wamVfUemuXa1gQFUNtVnyC1Q5fYBXo5KgPAC+ZY4CZNxyOA8TT0JB8Dp1fB2rxDoa0XqY6rZqNNap8mzWpfJ+Pb1sAC/N9uW5ArwLh2HLwD6DCD7ehLUkCIzKc+QXP4o81v5d89U8ph/vjqaj9SGtBsIWw6NEn5OZkp22FLzphvVO+P8NM3jj7gdTlhCLXuDL4P31W3dUm/AlWDU7Ii2VlWjymrCv5gOr19cyNNTi0IitbGTZ1tYSbqui3oPMVXegClWatQjKhYDXy8noQiN4pQK8Bh0JP8FOwQB8IesNfiW1evcKWZdCdx0FMwhexpM//vxpBKvwz+kzAtSn6X+nT7+NCM7Nc1ld8tXbOYt5AOMv19q/c/ZMFlEA42ZLxXneNIrGDBTlA8NM4qI+yJlqGqB0Ub+/M2Spf7Bz2N256Szh+5YA78eHarQwbN5R0xIORwKgN+BhbrWbw5WVxUNDlXGdjPe2ViBywz6LJRgOx/XIuNsfr4rkAzI8IrCqsssp7i5v7CBH57wcxTEGr6af+gtavaGIPO+Yd+Ne5l6RL0yM1nFrZQFe+fHn3j69dM4wYLNfOUM5uNljdeVcCl5gb3Vd7M9FYZ0r8qBEQ96NWcB25sXSHFe8vqEzCiMfriA+DHjdsE8iePfjfdwwdPYtnCy8yLu6/ECwJRz0OV3ouesgluUdbCsuOXgQ3GmNztwLdKt6wSLDG9jk4NSeOixh+kwGvMVoZXj7Vuh1tzcWofZC9OYK8MJhpa7OCSYl5Ax1cIMndA1aIXTXWUlnAd4cxXPPv73sUNAu+yHi1/UVk1MFNqAuetmCQEwBLNaHUg37bYlqvSoXovHNvvr9+/2ZUXzSTTU9PcPVw53wH3c/iMZwsufjjwnes79mKG8qqca/xDk5RpI2AGgELmYVSMMQJdJHcKENoSgLCi1JxF5zd78BVDPQe2mRwrwVq5gELy+WuZrzTgJeiMWp1aggjCSphTZbeS29gpdCd323rhbhzTn+3POXPoSv4hsu3KLdqFQo+S4/agQYsRITz0F4gu4rUzmr6+u79KPw+qrpfDCl1YV6/laA9yzBe7alsiWODiReFRouEG6pxPRy0x2bKsNhZGGtCej2Uvgi80JHx+oh1o4C1DVi7O0y8JIC7Anu4pztuM801u65U6h7KXrVKuTgIobu1FLW1YivgJoDbqwsXUJx/PhzX4Hwc6jRvlmRhuUY/HcQ5k/54cAa4zHodlQPxywFYsxi+a76+qBE697fA4cUt8UyvO/Qx2+dZfCePfvBBwa9nuN5ZyDYRWPLEgwyCd7iMB48+ZYWLKx4I+hHUtFL5D2jvZucHXNhcme386D72zu27zIYsAtUZKyrrZ2ag9ZhO6jnHgwu0ZJwzbGXRAeFrm69s+5qeFH6EsBfdb7xwqKcCTBo8PlHAPMiFe9wagqwLZmbQ/BWmxC9PcOd+6lOgzHz2Sy2H3xg5DB+CERAaqAJsTDFJGJvZdBSaApTo0znoPClUwXOCBDu9rhc9GrEM5fMgTqoQsAKSx0aknAMQyATvH19VonEOpcNXbz6Wda9Asva8rwleOWYlRxn5xLwokJTXHJL46ufGDSaI8J0J3oIQdxSsGjAS1ee50TuRbO8AQm43l2Ptnp18IOl4w3Cqxm5FkcAuGQHDTOpRKvEskqvo0Ci97UNDRHAbdSJxP77VuxfYv7DI1l4+qyoajW8nY4RTXRENTUj0chEt2Gc5LxZ1iXnuyuztL0c3uxHeQHji55v/odAlhepuKA7+iDZWYrURESBNTZq4foGOIvH4/FQKB4P6Dm7wQh8jB980FoBTPft27SjMujzhfFjQncUCsFxxtGpGAQxWlLgjLRR/KI480XKytg60PattOPaj1Vjj4z1eyWaxZaUhtH4lH00qxCyLnPTlirkVxjehV+fAL4kxMi/8m+Ygcn0WsrjMYH+eBx2rIKwJucIxGMxC8c632jJ8k7GcqJUe5AoI5sQr3GT3teCjcySmtgoqJk67E+EW1qCDg5SuzIP7+2l4EU+hlJDaVmrAPAuapKXsymbkZ3+fjsFNTxHp6aOHSun0BWyroapvFwZwYE10bu4rNl0ifPNSxdaUVTJnF1ujHe6eKUwxSQmC+Primm64Az4gizTMsrIHXeU7OiyFNImVUsJAR0SGFjUHS/AQJ4VquCnUf6tagvToJ5zeGmfYjtTnG98lPYpmGI6Rm3t7XV14zRTA1tkL0K3vWgh60qvmK4hvuOlC3P5PJIBrFA0Cf8IwNJPFZcBby7xpiDMzwK4y2FtFomgV4jFSpMlFGIEkRriOWE5BfgeOoS0UB0HLVdToMeQ4o6SmtCWwqy0AcZNJCbDaim5EvhWVVS1RUwalQojjVJSgcK8ArvCwHg75WM2aAO8Ar5QSm+kZ5ogRnAlpTLoM/vtSi0j2kzVPfsf7NwRNPB2FLMtLdU19T09eCXvP3Sos6GnBG/glpYd2AGqCW3QFlqwZ4URG37WtYVxQmjjL49pGTC7GoxOVVbHILFyIgYZbeIYShkzHX8x+JvT6w0GesN1wDXBiPTAjtHo5BaeadIrKclJOuMX7xVcoU9LLr4dFUsQh3pqWirRzmUH8rANDQ09GB3XYDOlqxL7PzVdcW2+KUhlQjEVu0gT2qxoPFsmFdSFmBaFUmwgXllrqdEjop/s2k7SWnoNCYZSQscMyGjEyjbKCXbY8gCcsMRXXFtLnpv77RqT0aItC2DMiRmwDUR9pDEEiDhak0mvKzB1lexrqA4gvgItO6jYpXoXqbVguXjsMlEh4sqhuVPFVojl4ANii+0AljCx2c7GmELFwBK8jOl3CNOqb0Nb61uHFxUabQTx8erhmpqaalbq+nwBhBbrGeVIxaaumhIIC6jVHNULjHBaHPY5Ci4lk0f607kqvoho/lvZCryoG1uCP0W7vLvPRcwMFYWxmo26FwQQmG5f7pXX6pUrvm2nbkaUUmFKTh9VT/YspNIcpaOmZEdLxOmSesyV9AimxGDmPQSO6BL3hJz2WVyQkcUKcd1JYh/1QY0elkDlU3PNZEoqKEuQ7tnS7CpX8e2own378Cpy13xvTFXRg6o3EC4ujtib85qhIkAPtYMlxb1mj4IgunTtL6dtjuYpLAE93jh1CgRziAzc+lPYhdWOH5s7dVJB/wIBmpU9+5/4nv9nD9v9s0dqMKeMkB5Rs6G3mHVwDhZHunMZ7/K/hKR56tHHH78VIXuq6eRULczYfvpTGGHWlh9rutLyev/74MzK6C1K6tFae6QY5e4ObzfUswxtJayJc/BgmzGP9jX+K3hoE/TUOBQbHr+1fRyG5I0E7xMM4vGT/+fgXXrGCN84+QobivGa2FfSBmZjCwtdEnmqKO1WML+1rxH+ilMgNQjvtEcfpdBl8O499n8T3uWH4DUX34EODi3+HKRygcC942CvEWIhOYqv9YHAOtWcELYLh5LD+ItXPDn8f4oX27fkH5p9AAAAAElFTkSuQmCC") 98% 50px no-repeat;;
							
					}
					#fattura-elettronica div.footer { padding: 50px 0 0 0; margin: 0; font-size: 11px; text-align: center; color: #777777; }
				</style>
			</head>
			<body>
				<div id="fattura-container">
					<!--INIZIO DATI HEADER-->
					<xsl:if test="a:FatturaElettronica">

						<div id="fattura-elettronica">

							<h1>FATTURA ELETTRONICA</h1>

							<xsl:if test="a:FatturaElettronica/FatturaElettronicaHeader">
								<div class="page">
									<div class="versione">
										Versione <xsl:value-of select="a:FatturaElettronica/@versione"/>
									</div>

									<xsl:if test="a:FatturaElettronica/FatturaElettronicaHeader/DatiTrasmissione">
										<!--INIZIO DATI DELLA TRASMISSIONE-->
										<div id="dati-trasmissione">
											<h3>Dati relativi alla trasmissione</h3>
											<ul>
												<xsl:for-each select="a:FatturaElettronica/FatturaElettronicaHeader/DatiTrasmissione">

													<xsl:if test="IdTrasmittente">
														<li>
															Identificativo del trasmittente:
															<span>
																<xsl:value-of select="IdTrasmittente/IdPaese" />
																<xsl:value-of select="IdTrasmittente/IdCodice" />
															</span>
														</li>
													</xsl:if>
													<xsl:if test="ProgressivoInvio">
														<li>
															Progressivo di invio:
															<span>
																<xsl:value-of select="ProgressivoInvio" />
															</span>
														</li>
													</xsl:if>
													<xsl:if test="FormatoTrasmissione">
														<li>
															Formato Trasmissione:
															<span>
																<xsl:value-of select="FormatoTrasmissione" />
															</span>
														</li>
													</xsl:if>
													<xsl:if test="CodiceDestinatario">
														<li>
															Codice identificativo destinatario:
															<span>
																<xsl:value-of select="CodiceDestinatario" />
															</span>
														</li>
													</xsl:if>
													<xsl:if test="ContattiTrasmittente/Telefono">
														<li>
															Telefono del trasmittente:
															<span>
																<xsl:value-of select="ContattiTrasmittente/Telefono" />
															</span>
														</li>
													</xsl:if>
													<xsl:if test="ContattiTrasmittente/Email">
														<li>
															E-mail del trasmittente:
															<span>
																<xsl:value-of select="ContattiTrasmittente/Email" />
															</span>
														</li>
													</xsl:if>
													<xsl:if test="PECDestinatario">
														<li>
															Destinatario PEC:
															<span>
																<xsl:value-of select="PECDestinatario" />
															</span>
														</li>
													</xsl:if>
												</xsl:for-each>
											</ul>
										</div>
									</xsl:if>
									<!--FINE DATI DELLA TRASMISSIONE-->

									<!--INIZIO DATI CEDENTE PRESTATORE-->
									<xsl:if test="a:FatturaElettronica/FatturaElettronicaHeader/CedentePrestatore">
										<div id="cedente">
											<h3>Dati del cedente / prestatore</h3>

											<xsl:if test="a:FatturaElettronica/FatturaElettronicaHeader/CedentePrestatore/DatiAnagrafici">
												<h4>Dati anagrafici</h4>

												<ul>
													<xsl:for-each select="a:FatturaElettronica/FatturaElettronicaHeader/CedentePrestatore/DatiAnagrafici">
														<xsl:if test="IdFiscaleIVA">
															<li>
																Identificativo fiscale ai fini IVA:
																<span>
																	<xsl:value-of select="IdFiscaleIVA/IdPaese" />
																	<xsl:value-of select="IdFiscaleIVA/IdCodice" />
																</span>
															</li>
														</xsl:if>
														<xsl:if test="CodiceFiscale">
															<li>
																Codice fiscale:
																<span>
																	<xsl:value-of select="CodiceFiscale" />
																</span>
															</li>
														</xsl:if>
														<xsl:if test="Anagrafica/Denominazione">
															<li>
																Denominazione:
																<span>
																	<xsl:value-of select="Anagrafica/Denominazione" />
																</span>
															</li>
														</xsl:if>
														<xsl:if test="Anagrafica/Nome">
															<li>
																Nome:
																<span>
																	<xsl:value-of select="Anagrafica/Nome" />
																</span>
															</li>
														</xsl:if>
														<xsl:if test="Anagrafica/Cognome">
															<li>
																Cognome:
																<span>
																	<xsl:value-of select="Anagrafica/Cognome" />
																</span>
															</li>
														</xsl:if>
														<xsl:if test="Anagrafica/Titolo">
															<li>
																Titolo:
																<span>
																	<xsl:value-of select="Anagrafica/Titolo" />
																</span>
															</li>
														</xsl:if>
														<xsl:if test="Anagrafica/CodEORI">
															<li>
																Codice EORI:
																<span>
																	<xsl:value-of select="Anagrafica/CodEORI" />
																</span>
															</li>
														</xsl:if>
														<xsl:if test="AlboProfessionale">
															<li>
																Albo professionale di appartenenza:
																<span>
																	<xsl:value-of select="AlboProfessionale" />
																</span>
															</li>
														</xsl:if>
														<xsl:if test="ProvinciaAlbo">
															<li>
																Provincia di competenza dell'Albo:
																<span>
																	<xsl:value-of select="ProvinciaAlbo" />
																</span>
															</li>
														</xsl:if>
														<xsl:if test="NumeroIscrizioneAlbo">
															<li>
																Numero iscrizione all'Albo:
																<span>
																	<xsl:value-of select="NumeroIscrizioneAlbo" />
																</span>
															</li>
														</xsl:if>
														<xsl:if test="DataIscrizioneAlbo">
															<li>
																Data iscrizione all'Albo:
																<span>
																	<xsl:value-of select="DataIscrizioneAlbo" />
																</span>
																<xsl:call-template name="FormatDate">
																	<xsl:with-param name="DateTime" select="DataIscrizioneAlbo" />
																</xsl:call-template>
															</li>
														</xsl:if>
														<xsl:if test="RegimeFiscale">
															<li>
																Regime fiscale:
																<span>
																	<xsl:value-of select="RegimeFiscale" />
																</span>

																<xsl:variable name="RF">
																	<xsl:value-of select="RegimeFiscale" />
																</xsl:variable>
																<xsl:choose>
																	<xsl:when test="$RF='RF01'">
																		(ordinario)
																	</xsl:when>
																	<xsl:when test="$RF='RF02'">
																		(contribuenti minimi)
																	</xsl:when>
																	<xsl:when test="$RF='RF03'">
																		(nuove iniziative produttive) - Non più valido in quanto abrogato dalla legge di stabilità 2015																	
																	</xsl:when>
																	<xsl:when test="$RF='RF04'">
																		(agricoltura e attività connesse e pesca)
																	</xsl:when>
																	<xsl:when test="$RF='RF05'">
																		(vendita sali e tabacchi)
																	</xsl:when>
																	<xsl:when test="$RF='RF06'">
																		(commercio fiammiferi)
																	</xsl:when>
																	<xsl:when test="$RF='RF07'">
																		(editoria)
																	</xsl:when>
																	<xsl:when test="$RF='RF08'">
																		(gestione servizi telefonia pubblica)
																	</xsl:when>
																	<xsl:when test="$RF='RF09'">
																		(rivendita documenti di trasporto pubblico e di sosta)
																	</xsl:when>
																	<xsl:when test="$RF='RF10'">
																		(intrattenimenti, giochi e altre attività di cui alla tariffa allegata al DPR 640/72)
																	</xsl:when>
																	<xsl:when test="$RF='RF11'">
																		(agenzie viaggi e turismo)
																	</xsl:when>
																	<xsl:when test="$RF='RF12'">
																		(agriturismo)
																	</xsl:when>
																	<xsl:when test="$RF='RF13'">
																		(vendite a domicilio)
																	</xsl:when>
																	<xsl:when test="$RF='RF14'">
																		(rivendita beni usati, oggetti d’arte,
																		d’antiquariato o da collezione)
																	</xsl:when>
																	<xsl:when test="$RF='RF15'">
																		(agenzie di vendite all’asta di oggetti d’arte,
																		antiquariato o da collezione)
																	</xsl:when>
																	<xsl:when test="$RF='RF16'">
																		(IVA per cassa P.A.)
																	</xsl:when>
																	<xsl:when test="$RF='RF17'">
																		(IVA per cassa - art. 32-bis, D.L. 83/2012)
																	</xsl:when>
																	<xsl:when test="$RF='RF19'">
																		(Regime forfettario)
																	</xsl:when>
																	<xsl:when test="$RF='RF18'">
																		(altro)
																	</xsl:when>
																	<xsl:when test="$RF=''">
																	</xsl:when>
																	<xsl:otherwise>
																		<span>(!!! codice non previsto !!!)</span>
																	</xsl:otherwise>
																</xsl:choose>
															</li>
														</xsl:if>
													</xsl:for-each>
												</ul>
											</xsl:if>

											<xsl:if test="a:FatturaElettronica/FatturaElettronicaHeader/CedentePrestatore/Sede">
												<h4>Dati della sede</h4>
												<ul>
													<xsl:for-each select="a:FatturaElettronica/FatturaElettronicaHeader/CedentePrestatore/Sede">
														<xsl:if test="Indirizzo">
															<li>
																Indirizzo:
																<span>
																	<xsl:value-of select="Indirizzo" />
																</span>
															</li>
														</xsl:if>
														<xsl:if test="NumeroCivico">
															<li>
																Numero civico:
																<span>
																	<xsl:value-of select="NumeroCivico" />
																</span>
															</li>
														</xsl:if>
														<xsl:if test="CAP">
															<li>
																CAP:
																<span>
																	<xsl:value-of select="CAP" />
																</span>
															</li>
														</xsl:if>
														<xsl:if test="Comune">
															<li>
																Comune:
																<span>
																	<xsl:value-of select="Comune" />
																</span>
															</li>
														</xsl:if>
														<xsl:if test="Provincia">
															<li>
																Provincia:
																<span>
																	<xsl:value-of select="Provincia" />
																</span>
															</li>
														</xsl:if>
														<xsl:if test="Nazione">
															<li>
																Nazione:
																<span>
																	<xsl:value-of select="Nazione" />
																</span>
															</li>
														</xsl:if>
													</xsl:for-each>
												</ul>
											</xsl:if>

											<xsl:if test="a:FatturaElettronica/FatturaElettronicaHeader/CedentePrestatore/StabileOrganizzazione">
												<h4>Dati della stabile organizzazione</h4>
												<ul>
													<xsl:for-each select="a:FatturaElettronica/FatturaElettronicaHeader/CedentePrestatore/StabileOrganizzazione">
														<xsl:if test="Indirizzo">
															<li>
																Indirizzo:
																<span>
																	<xsl:value-of select="Indirizzo" />
																</span>
															</li>
														</xsl:if>
														<xsl:if test="NumeroCivico">
															<li>
																Numero civico:
																<span>
																	<xsl:value-of select="NumeroCivico" />
																</span>
															</li>
														</xsl:if>
														<xsl:if test="CAP">
															<li>
																CAP:
																<span>
																	<xsl:value-of select="CAP" />
																</span>
															</li>
														</xsl:if>
														<xsl:if test="Comune">
															<li>
																Comune:
																<span>
																	<xsl:value-of select="Comune" />
																</span>
															</li>
														</xsl:if>
														<xsl:if test="Provincia">
															<li>
																Provincia:
																<span>
																	<xsl:value-of select="Provincia" />
																</span>
															</li>
														</xsl:if>
														<xsl:if test="Nazione">
															<li>
																Nazione:
																<span>
																	<xsl:value-of select="Nazione" />
																</span>
															</li>
														</xsl:if>
													</xsl:for-each>
												</ul>
											</xsl:if>

											<xsl:if test="a:FatturaElettronica/FatturaElettronicaHeader/CedentePrestatore/IscrizioneREA">
												<h4>Dati di iscrizione nel registro delle imprese</h4>

												<ul>
													<xsl:for-each select="a:FatturaElettronica/FatturaElettronicaHeader/CedentePrestatore/IscrizioneREA">
														<xsl:if test="Ufficio">
															<li>
																Provincia Ufficio Registro Imprese:
																<span>
																	<xsl:value-of select="Ufficio" />
																</span>
															</li>
														</xsl:if>
														<xsl:if test="NumeroREA">
															<li>
																Numero di iscrizione:
																<span>
																	<xsl:value-of select="NumeroREA" />
																</span>
															</li>
														</xsl:if>
														<xsl:if test="CapitaleSociale">
															<li>
																Capitale sociale:
																<span>
																	<xsl:value-of select="CapitaleSociale" />
																</span>
															</li>
														</xsl:if>
														<xsl:if test="SocioUnico">
															<li>
																Numero soci:
																<span>
																	<xsl:value-of select="SocioUnico" />
																</span>

																<xsl:variable name="NS">
																	<xsl:value-of select="SocioUnico" />
																</xsl:variable>
																<xsl:choose>
																	<xsl:when test="$NS='SU'">
																		(socio unico)
																	</xsl:when>
																	<xsl:when test="$NS='SM'">
																		(più soci)
																	</xsl:when>
																	<xsl:when test="$NS=''">
																	</xsl:when>
																	<xsl:otherwise>
																		<span>(!!! codice non previsto !!!)</span>
																	</xsl:otherwise>
																</xsl:choose>
															</li>
														</xsl:if>
														<xsl:if test="StatoLiquidazione">
															<li>
																Stato di liquidazione:
																<span>
																	<xsl:value-of select="StatoLiquidazione" />
																</span>

																<xsl:variable name="SL">
																	<xsl:value-of select="StatoLiquidazione" />
																</xsl:variable>
																<xsl:choose>
																	<xsl:when test="$SL='LS'">
																		(in liquidazione)
																	</xsl:when>
																	<xsl:when test="$SL='LN'">
																		(non in liquidazione)
																	</xsl:when>
																	<xsl:when test="$SL=''">
																	</xsl:when>
																	<xsl:otherwise>
																		<span>(!!! codice non previsto !!!)</span>
																	</xsl:otherwise>
																</xsl:choose>
															</li>
														</xsl:if>
													</xsl:for-each>
												</ul>
											</xsl:if>

											<xsl:for-each select="a:FatturaElettronica/FatturaElettronicaHeader/CedentePrestatore/Contatti">
												<xsl:if test="Telefono or Fax or Email">
													<h4>Recapiti</h4>
													<ul>
														<xsl:if test="Telefono">
															<li>
																Telefono:
																<span>
																	<xsl:value-of select="Telefono" />
																</span>
															</li>
														</xsl:if>
														<xsl:if test="Fax">
															<li>
																Fax:
																<span>
																	<xsl:value-of select="Fax" />
																</span>
															</li>
														</xsl:if>
														<xsl:if test="Email">
															<li>
																E-mail:
																<span>
																	<xsl:value-of select="Email" />
																</span>
															</li>
														</xsl:if>
													</ul>
												</xsl:if>
											</xsl:for-each>

											<xsl:if test="a:FatturaElettronica/FatturaElettronicaHeader/CedentePrestatore/RiferimentoAmministrazione">
												<h4>Riferimento amministrativo</h4>
												<ul>
													<li>
														Riferimento:
														<span>
															<xsl:value-of select="a:FatturaElettronica/FatturaElettronicaHeader/CedentePrestatore/RiferimentoAmministrazione" />
														</span>
													</li>
												</ul>
											</xsl:if>
										</div>
									</xsl:if>
									<!--FINE DATI CEDENTE PRESTATORE-->

									<!--INIZIO DATI RAPPRESENTANTE FISCALE-->
									<xsl:if test="a:FatturaElettronica/FatturaElettronicaHeader/RappresentanteFiscale">
										<div id="rappresentante-fiscale">
											<h3>Dati del rappresentante fiscale del cedente / prestatore</h3>

											<xsl:if test="a:FatturaElettronica/FatturaElettronicaHeader/RappresentanteFiscale/DatiAnagrafici">
												<h4>Dati anagrafici</h4>

												<ul>
													<xsl:for-each select="a:FatturaElettronica/FatturaElettronicaHeader/RappresentanteFiscale/DatiAnagrafici">
														<xsl:if test="IdFiscaleIVA">
															<li>
																Identificativo fiscale ai fini IVA:
																<span>
																	<xsl:value-of select="IdFiscaleIVA/IdPaese" />
																	<xsl:value-of select="IdFiscaleIVA/IdCodice" />
																</span>
															</li>
														</xsl:if>
														<xsl:if test="CodiceFiscale">
															<li>
																Codice fiscale:
																<span>
																	<xsl:value-of select="CodiceFiscale" />
																</span>
															</li>
														</xsl:if>
														<xsl:if test="Anagrafica/Denominazione">
															<li>
																Denominazione:
																<span>
																	<xsl:value-of select="Anagrafica/Denominazione" />
																</span>
															</li>
														</xsl:if>
														<xsl:if test="Anagrafica/Nome">
															<li>
																Nome:
																<span>
																	<xsl:value-of select="Anagrafica/Nome" />
																</span>
															</li>
														</xsl:if>
														<xsl:if test="Anagrafica/Cognome">
															<li>
																Cognome:
																<span>
																	<xsl:value-of select="Anagrafica/Cognome" />
																</span>
															</li>
														</xsl:if>
														<xsl:if test="Anagrafica/Titolo">
															<li>
																Titolo onorifico:
																<span>
																	<xsl:value-of select="Anagrafica/Titolo" />
																</span>
															</li>
														</xsl:if>
														<xsl:if test="Anagrafica/CodEORI">
															<li>
																Codice EORI:
																<span>
																	<xsl:value-of select="Anagrafica/CodEORI" />
																</span>
															</li>
														</xsl:if>
													</xsl:for-each>
												</ul>
											</xsl:if>

										</div>
									</xsl:if>
									<!--FINE DATI RAPPRESENTANTE FISCALE-->

									<!--INIZIO DATI CESSIONARIO COMMITTENTE-->
									<xsl:if test="a:FatturaElettronica/FatturaElettronicaHeader/CessionarioCommittente">
										<div id="cessionario">
											<h3>Dati del cessionario / committente</h3>

											<xsl:if test="a:FatturaElettronica/FatturaElettronicaHeader/CessionarioCommittente/DatiAnagrafici">
												<h4>Dati anagrafici</h4>

												<ul>
													<xsl:for-each select="a:FatturaElettronica/FatturaElettronicaHeader/CessionarioCommittente/DatiAnagrafici">
														<xsl:if test="IdFiscaleIVA">
															<li>
																Identificativo fiscale ai fini IVA:
																<span>
																	<xsl:value-of select="IdFiscaleIVA/IdPaese" />
																	<xsl:value-of select="IdFiscaleIVA/IdCodice" />
																</span>
															</li>
														</xsl:if>
														<xsl:if test="CodiceFiscale">
															<li>
																Codice Fiscale:
																<span>
																	<xsl:value-of select="CodiceFiscale" />
																</span>
															</li>
														</xsl:if>
														<xsl:if test="Anagrafica/Denominazione">
															<li>
																Denominazione:
																<span>
																	<xsl:value-of select="Anagrafica/Denominazione" />
																</span>
															</li>
														</xsl:if>
														<xsl:if test="Anagrafica/Nome">
															<li>
																Nome:
																<span>
																	<xsl:value-of select="Anagrafica/Nome" />
																</span>
															</li>
														</xsl:if>
														<xsl:if test="Anagrafica/Cognome">
															<li>
																Cognome:
																<span>
																	<xsl:value-of select="Anagrafica/Cognome" />
																</span>
															</li>
														</xsl:if>
														<xsl:if test="Anagrafica/Titolo">
															<li>
																Titolo onorifico:
																<span>
																	<xsl:value-of select="Anagrafica/Titolo" />
																</span>
															</li>
														</xsl:if>
														<xsl:if test="Anagrafica/CodEORI">
															<li>
																Codice EORI:
																<span>
																	<xsl:value-of select="Anagrafica/CodEORI" />
																</span>
															</li>
														</xsl:if>
													</xsl:for-each>
												</ul>
											</xsl:if>


											<xsl:if test="a:FatturaElettronica/FatturaElettronicaHeader/CessionarioCommittente/Sede">
												<h4>Dati della sede</h4>

												<ul>
													<xsl:for-each select="a:FatturaElettronica/FatturaElettronicaHeader/CessionarioCommittente/Sede">
														<xsl:if test="Indirizzo">
															<li>
																Indirizzo:
																<span>
																	<xsl:value-of select="Indirizzo" />
																</span>
															</li>
														</xsl:if>
														<xsl:if test="NumeroCivico">
															<li>
																Numero civico:
																<span>
																	<xsl:value-of select="NumeroCivico" />
																</span>
															</li>
														</xsl:if>
														<xsl:if test="CAP">
															<li>
																CAP:
																<span>
																	<xsl:value-of select="CAP" />
																</span>
															</li>
														</xsl:if>
														<xsl:if test="Comune">
															<li>
																Comune:
																<span>
																	<xsl:value-of select="Comune" />
																</span>
															</li>
														</xsl:if>
														<xsl:if test="Provincia">
															<li>
																Provincia:
																<span>
																	<xsl:value-of select="Provincia" />
																</span>
															</li>
														</xsl:if>
														<xsl:if test="Nazione">
															<li>
																Nazione:
																<span>
																	<xsl:value-of select="Nazione" />
																</span>
															</li>
														</xsl:if>
													</xsl:for-each>
												</ul>
											</xsl:if>


											<xsl:if test="a:FatturaElettronica/FatturaElettronicaHeader/CessionarioCommittente/StabileOrganizzazione">
												<h4>Stabile organizzazione del cessionario / committente</h4>

												<ul>
													<xsl:for-each select="a:FatturaElettronica/FatturaElettronicaHeader/CessionarioCommittente/StabileOrganizzazione">
														<xsl:if test="Indirizzo">
															<li>
																Indirizzo:
																<span>
																	<xsl:value-of select="Indirizzo" />
																</span>
															</li>
														</xsl:if>
														<xsl:if test="NumeroCivico">
															<li>
																Numero civico:
																<span>
																	<xsl:value-of select="NumeroCivico" />
																</span>
															</li>
														</xsl:if>
														<xsl:if test="CAP">
															<li>
																CAP:
																<span>
																	<xsl:value-of select="CAP" />
																</span>
															</li>
														</xsl:if>
														<xsl:if test="Comune">
															<li>
																Comune:
																<span>
																	<xsl:value-of select="Comune" />
																</span>
															</li>
														</xsl:if>
														<xsl:if test="Provincia">
															<li>
																Provincia:
																<span>
																	<xsl:value-of select="Provincia" />
																</span>
															</li>
														</xsl:if>
														<xsl:if test="Nazione">
															<li>
																Nazione:
																<span>
																	<xsl:value-of select="Nazione" />
																</span>
															</li>
														</xsl:if>
													</xsl:for-each>
												</ul>
											</xsl:if>
											
											<xsl:if test="a:FatturaElettronica/FatturaElettronicaHeader/CessionarioCommittente/RappresentanteFiscale">
												<div id="rappresentante-fiscale">
													<h4>Dati del rappresentante fiscale del cessionario / committente</h4>
		
													<ul>
															<xsl:for-each select="a:FatturaElettronica/FatturaElettronicaHeader/CessionarioCommittente/RappresentanteFiscale">
																<xsl:if test="IdFiscaleIVA">
																	<li>
																		Identificativo fiscale ai fini IVA:
																		<span>
																			<xsl:value-of select="IdFiscaleIVA/IdPaese" />
																			<xsl:value-of select="IdFiscaleIVA/IdCodice" />
																		</span>
																	</li>
																</xsl:if>
																<xsl:if test="Denominazione">
																	<li>
																		Denominazione:
																		<span>
																			<xsl:value-of select="Denominazione" />
																		</span>
																	</li>
																</xsl:if>
																<xsl:if test="Nome">
																	<li>
																		Nome:
																		<span>
																			<xsl:value-of select="Nome" />
																		</span>
																	</li>
																</xsl:if>
																<xsl:if test="Cognome">
																	<li>
																		Cognome:
																		<span>
																			<xsl:value-of select="Cognome" />
																		</span>
																	</li>
																</xsl:if>
															</xsl:for-each>
														</ul>
												</div>
											</xsl:if>
											<!--FINE DATI RAPPRESENTANTE FISCALE-->
											
										</div>
									</xsl:if>
									<!--FINE DATI CESSIONARIO COMMITTENTE-->

									<!--INIZIO DATI TERZO INTERMEDIARIO SOGGETTO EMITTENTE-->
									<xsl:if test="a:FatturaElettronica/FatturaElettronicaHeader/TerzoIntermediarioOSoggettoEmittente">
										<div id="terzointermediario">

											<xsl:for-each select="a:FatturaElettronica/FatturaElettronicaHeader/TerzoIntermediarioOSoggettoEmittente">
												<h3>Dati del terzo intermediario soggetto emittente</h3>

												<xsl:if test="DatiAnagrafici">
													<h4>Dati anagrafici</h4>

													<ul>
														<xsl:if test="DatiAnagrafici/IdFiscaleIVA">
															<li>
																Identificativo fiscale ai fini IVA:
																<span>
																	<xsl:value-of select="DatiAnagrafici/IdFiscaleIVA/IdPaese" />
																	<xsl:value-of select="DatiAnagrafici/IdFiscaleIVA/IdCodice" />
																</span>
															</li>
														</xsl:if>
														<xsl:if test="DatiAnagrafici/CodiceFiscale">
															<li>
																Codice Fiscale:
																<span>
																	<xsl:value-of select="DatiAnagrafici/CodiceFiscale" />
																</span>
															</li>
														</xsl:if>
														<xsl:if test="DatiAnagrafici/Anagrafica/Denominazione">
															<li>
																Denominazione:
																<span>
																	<xsl:value-of select="DatiAnagrafici/Anagrafica/Denominazione" />
																</span>
															</li>
														</xsl:if>
														<xsl:if test="DatiAnagrafici/Anagrafica/Nome">
															<li>
																Nome:
																<span>
																	<xsl:value-of select="DatiAnagrafici/Anagrafica/Nome" />
																</span>
															</li>
														</xsl:if>
														<xsl:if test="DatiAnagrafici/Anagrafica/Cognome">
															<li>
																Cognome:
																<span>
																	<xsl:value-of select="DatiAnagrafici/Anagrafica/Cognome" />
																</span>
															</li>
														</xsl:if>
														<xsl:if test="DatiAnagrafici/Anagrafica/Titolo">
															<li>
																Titolo onorifico:
																<span>
																	<xsl:value-of select="DatiAnagrafici/Anagrafica/Titolo" />
																</span>
															</li>
														</xsl:if>
														<xsl:if test="DatiAnagrafici/Anagrafica/CodEORI">
															<li>
																Codice EORI:
																<span>
																	<xsl:value-of select="DatiAnagrafici/Anagrafica/CodEORI" />
																</span>
															</li>
														</xsl:if>
													</ul>
												</xsl:if>
											</xsl:for-each>
										</div>
									</xsl:if>
									<!--FINE DATI TERZO INTERMEDIARIO SOGGETTO EMITTENTE-->

									<!--INIZIO DATI SOGGETTO EMITTENTE-->
									<xsl:if test="a:FatturaElettronica/FatturaElettronicaHeader/SoggettoEmittente">
										<div id="soggetto-emittente">
											<h3>Soggetto emittente la fattura</h3>
											<ul>
												<li>
													Soggetto emittente:
													<span>
														<xsl:value-of select="a:FatturaElettronica/FatturaElettronicaHeader/SoggettoEmittente" />
													</span>
													<xsl:variable name="SC">
														<xsl:value-of select="a:FatturaElettronica/FatturaElettronicaHeader/SoggettoEmittente" />
													</xsl:variable>
													<xsl:choose>
														<xsl:when test="$SC='CC'">
															(cessionario/committente)
														</xsl:when>
														<xsl:when test="$SC='TZ'">
															(terzo)
														</xsl:when>
														<xsl:when test="$SC=''">
														</xsl:when>
														<xsl:otherwise>
															<span>(!!! codice non previsto !!!)</span>
														</xsl:otherwise>
													</xsl:choose>
												</li>
											</ul>
										</div>
									</xsl:if>
									<!--FINE DATI SOGGETTO EMITTENTE-->

									<div class="footer">
										Versione prodotta con foglio di stile SdI
										<a href="http://www.fatturapa.gov.it">www.fatturapa.gov.it</a>
									</div>
								</div>
							</xsl:if>
							<!--FINE DATI HEADER-->

							<!--INIZIO DATI BODY-->

							<xsl:variable name="TOTALBODY">
								<xsl:value-of select="count(a:FatturaElettronica/FatturaElettronicaBody)" />
							</xsl:variable>

							<xsl:for-each select="a:FatturaElettronica/FatturaElettronicaBody">
								<xsl:if test="$TOTALBODY>1">
									<h2>
										Numero documento nel lotto:
										<xsl:value-of select="position()" />
									</h2>
								</xsl:if>

								<div class="page">
									<div class="versione">
										Versione <xsl:value-of select="../@versione"/>
									</div>

									<xsl:if test="DatiGenerali">
										<!--INIZIO DATI GENERALI-->
										<div id="dati-generali">

											<xsl:if test="DatiGenerali/DatiGeneraliDocumento">

												<!--INIZIO DATI GENERALI DOCUMENTO-->
												<div id="dati-generali-documento">
													<h3>Dati generali del documento</h3>

													<ul>
														<xsl:if test="DatiGenerali/DatiGeneraliDocumento/TipoDocumento">
															<li>
																Tipologia documento:
																<span>
																	<xsl:value-of select="DatiGenerali/DatiGeneraliDocumento/TipoDocumento" />
																</span>

																<xsl:variable name="TD">
																	<xsl:value-of select="DatiGenerali/DatiGeneraliDocumento/TipoDocumento" />
																</xsl:variable>
																<xsl:choose>
																	<xsl:when test="$TD='TD01'">
																		(fattura)
																	</xsl:when>
																	<xsl:when test="$TD='TD02'">
																		(acconto/anticipo su fattura)
																	</xsl:when>
																	<xsl:when test="$TD='TD03'">
																		(acconto/anticipo su parcella)
																	</xsl:when>
																	<xsl:when test="$TD='TD04'">
																		(nota di credito)
																	</xsl:when>
																	<xsl:when test="$TD='TD05'">
																		(nota di debito)
																	</xsl:when>
																	<xsl:when test="$TD='TD06'">
																		(parcella)
																	</xsl:when>
																	<xsl:when test="$TD='TD20'">
																		(autofattura)
																	</xsl:when>                                                                                                                                        
																	<xsl:when test="$TD=''">
																	</xsl:when>
																	<xsl:otherwise>
																		<span>(!!! codice non previsto !!!)</span>
																	</xsl:otherwise>
																</xsl:choose>
															</li>
														</xsl:if>
														<xsl:if test="DatiGenerali/DatiGeneraliDocumento/Divisa">
															<li>
																Valuta importi:
																<span>
																	<xsl:value-of select="DatiGenerali/DatiGeneraliDocumento/Divisa" />
																</span>
															</li>
														</xsl:if>
														<xsl:if test="DatiGenerali/DatiGeneraliDocumento/Data">
															<li>
																Data documento:
																<span>
																	<xsl:value-of select="DatiGenerali/DatiGeneraliDocumento/Data" />
																</span>
																<xsl:call-template name="FormatDate">
																	<xsl:with-param name="DateTime" select="DatiGenerali/DatiGeneraliDocumento/Data" />
																</xsl:call-template>
															</li>
														</xsl:if>
														<xsl:if test="DatiGenerali/DatiGeneraliDocumento/Numero">
															<li>
																Numero documento:
																<span>
																	<xsl:value-of select="DatiGenerali/DatiGeneraliDocumento/Numero" />
																</span>
															</li>
														</xsl:if>
														<xsl:if test="DatiGenerali/DatiGeneraliDocumento/ImportoTotaleDocumento">
															<li>
																Importo totale documento:
																<span>
																	<xsl:value-of select="DatiGenerali/DatiGeneraliDocumento/ImportoTotaleDocumento" />
																</span>
															</li>
														</xsl:if>
														<xsl:if test="DatiGenerali/DatiGeneraliDocumento/Arrotondamento">
															<li>
																Arrotondamento su Importo totale documento:
																<span>
																	<xsl:value-of select="DatiGenerali/DatiGeneraliDocumento/Arrotondamento" />
																</span>
															</li>
														</xsl:if>
														<xsl:for-each select="DatiGenerali/DatiGeneraliDocumento/Causale">
															
															<li>
																Causale:
																<span>
																	<xsl:value-of select="current()" />
																</span>
															</li>
															
														</xsl:for-each>
														<xsl:if test="DatiGenerali/DatiGeneraliDocumento/Art73">
															<li>
																Art. 73 DPR 633/72:
																<span>
																	<xsl:value-of select="DatiGenerali/DatiGeneraliDocumento/Art73" />
																</span>
															</li>
														</xsl:if>
													</ul>

													<!--INIZIO DATI DELLA RITENUTA-->
													<xsl:if test="DatiGenerali/DatiGeneraliDocumento/DatiRitenuta">
														<div id="dati-ritenuta">
															<xsl:for-each select="DatiGenerali/DatiGeneraliDocumento/DatiRitenuta">
																<h4>Ritenuta</h4>
																<ul>
																	<xsl:if test="TipoRitenuta">
																		<li>
																			Tipologia ritenuta:
																			<span>
																				<xsl:value-of select="TipoRitenuta" />
																			</span>
																			<xsl:variable name="TR">
																				<xsl:value-of select="TipoRitenuta" />
																			</xsl:variable>
																			<xsl:choose>
																				<xsl:when test="$TR='RT01'">
																					(ritenuta persone fisiche)
																				</xsl:when>
																				<xsl:when test="$TR='RT02'">
																					(ritenuta persone giuridiche)
																				</xsl:when>
																				<xsl:when test="$TR=''">
																				</xsl:when>
																				<xsl:otherwise>
																					<span>(!!! codice non previsto !!!)</span>
																				</xsl:otherwise>
																			</xsl:choose>
																		</li>
																	</xsl:if>
																	<xsl:if test="ImportoRitenuta">
																		<li>
																			Importo ritenuta:
																			<span>
																				<xsl:value-of select="ImportoRitenuta" />
																			</span>
																		</li>
																	</xsl:if>
																	<xsl:if test="AliquotaRitenuta">
																		<li>
																			Aliquota ritenuta (%):
																			<span>
																				<xsl:value-of select="AliquotaRitenuta" />
																			</span>
																		</li>
																	</xsl:if>
																	<xsl:if test="CausalePagamento">
																		<li>
																			Causale di pagamento:
																			<span>
																				<xsl:value-of select="CausalePagamento" />
																			</span>
																			<xsl:variable name="CP">
																				<xsl:value-of select="CausalePagamento" />
																			</xsl:variable>
																			<xsl:if test="$CP!=''">
																				(decodifica come da modello 770S)
																			</xsl:if>
																		</li>
																	</xsl:if>
																</ul>
															</xsl:for-each>
														</div>
													</xsl:if>
													<!--FINE DATI DELLA RITENUTA-->

													<!--INIZIO DATI DEL BOLLO-->
													<xsl:if test="DatiGenerali/DatiGeneraliDocumento/DatiBollo">
														<div id="dati-bollo">
															<xsl:for-each select="DatiGenerali/DatiGeneraliDocumento/DatiBollo">
																<h4>Bollo</h4>
																<ul>
																	<xsl:if test="BolloVirtuale">
																		<li>
																			Bollo virtuale:
																			<span>
																				<xsl:value-of select="BolloVirtuale" />
																			</span>
																		</li>
																	</xsl:if>
																	<xsl:if test="ImportoBollo">
																		<li>
																			Importo bollo:
																			<span>
																				<xsl:value-of select="ImportoBollo" />
																			</span>
																		</li>
																	</xsl:if>
																</ul>
															</xsl:for-each>
														</div>
													</xsl:if>
													<!--FINE DATI DEL BOLLO-->

													<!--INIZIO DATI DELLA CASSA PREVIDENZIALE-->
													<xsl:if test="DatiGenerali/DatiGeneraliDocumento/DatiCassaPrevidenziale">
														<div id="dati-cassa-previdenziale">
															<h4>Cassa previdenziale</h4>
															<xsl:for-each select="DatiGenerali/DatiGeneraliDocumento/DatiCassaPrevidenziale">
																<ul>
																	<xsl:if test="TipoCassa">
																		<li>
																			Tipologia cassa previdenziale:
																			<span>
																				<xsl:value-of select="TipoCassa" />
																			</span>
																			<xsl:variable name="TC">
																				<xsl:value-of select="TipoCassa" />
																			</xsl:variable>
																			<xsl:choose>
																				<xsl:when test="$TC='TC01'">
																					(Cassa Nazionale Previdenza e Assistenza Avvocati
																					e Procuratori legali)
																				</xsl:when>
																				<xsl:when test="$TC='TC02'">
																					(Cassa Previdenza Dottori Commercialisti)
																				</xsl:when>
																				<xsl:when test="$TC='TC03'">
																					(Cassa Previdenza e Assistenza Geometri)
																				</xsl:when>
																				<xsl:when test="$TC='TC04'">
																					(Cassa Nazionale Previdenza e Assistenza
																					Ingegneri e Architetti liberi profess.)
																				</xsl:when>
																				<xsl:when test="$TC='TC05'">
																					(Cassa Nazionale del Notariato)
																				</xsl:when>
																				<xsl:when test="$TC='TC06'">
																					(Cassa Nazionale Previdenza e Assistenza
																					Ragionieri e Periti commerciali)
																				</xsl:when>
																				<xsl:when test="$TC='TC07'">
																					(Ente Nazionale Assistenza Agenti e Rappresentanti
																					di Commercio-ENASARCO)
																				</xsl:when>
																				<xsl:when test="$TC='TC08'">
																					(Ente Nazionale Previdenza e Assistenza Consulenti
																					del Lavoro-ENPACL)
																				</xsl:when>
																				<xsl:when test="$TC='TC09'">
																					(Ente Nazionale Previdenza e Assistenza
																					Medici-ENPAM)
																				</xsl:when>
																				<xsl:when test="$TC='TC10'">
																					(Ente Nazionale Previdenza e Assistenza
																					Farmacisti-ENPAF)
																				</xsl:when>
																				<xsl:when test="$TC='TC11'">
																					(Ente Nazionale Previdenza e Assistenza
																					Veterinari-ENPAV)
																				</xsl:when>
																				<xsl:when test="$TC='TC12'">
																					(Ente Nazionale Previdenza e Assistenza Impiegati
																					dell'Agricoltura-ENPAIA)
																				</xsl:when>
																				<xsl:when test="$TC='TC13'">
																					(Fondo Previdenza Impiegati Imprese di Spedizione
																					e Agenzie Marittime)
																				</xsl:when>
																				<xsl:when test="$TC='TC14'">
																					(Istituto Nazionale Previdenza Giornalisti
																					Italiani-INPGI)
																				</xsl:when>
																				<xsl:when test="$TC='TC15'">
																					(Opera Nazionale Assistenza Orfani Sanitari
																					Italiani-ONAOSI)
																				</xsl:when>
																				<xsl:when test="$TC='TC16'">
																					(Cassa Autonoma Assistenza Integrativa
																					Giornalisti Italiani-CASAGIT)
																				</xsl:when>
																				<xsl:when test="$TC='TC17'">
																					(Ente Previdenza Periti Industriali e Periti
																					Industriali Laureati-EPPI)
																				</xsl:when>
																				<xsl:when test="$TC='TC18'">
																					(Ente Previdenza e Assistenza
																					Pluricategoriale-EPAP)
																				</xsl:when>
																				<xsl:when test="$TC='TC19'">
																					(Ente Nazionale Previdenza e Assistenza
																					Biologi-ENPAB)
																				</xsl:when>
																				<xsl:when test="$TC='TC20'">
																					(Ente Nazionale Previdenza e Assistenza
																					Professione Infermieristica-ENPAPI)
																				</xsl:when>
																				<xsl:when test="$TC='TC21'">
																					(Ente Nazionale Previdenza e Assistenza
																					Psicologi-ENPAP)
																				</xsl:when>
																				<xsl:when test="$TC='TC22'">
																					(INPS)
																				</xsl:when>
																				<xsl:when test="$TC=''">
																				</xsl:when>
																				<xsl:otherwise>
																					<span>(!!! codice non previsto !!!)</span>
																				</xsl:otherwise>
																			</xsl:choose>
																		</li>
																	</xsl:if>
																	<xsl:if test="AlCassa">
																		<li>
																			Aliquota contributo cassa (%):
																			<span>
																				<xsl:value-of select="AlCassa" />
																			</span>
																		</li>
																	</xsl:if>
																	<xsl:if test="ImportoContributoCassa">
																		<li>
																			Importo contributo cassa:
																			<span>
																				<xsl:value-of select="ImportoContributoCassa" />
																			</span>
																		</li>
																	</xsl:if>
																	<xsl:if test="ImponibileCassa">
																		<li>
																			Imponibile previdenziale:
																			<span>
																				<xsl:value-of select="ImponibileCassa" />
																			</span>
																		</li>
																	</xsl:if>
																	<xsl:if test="AliquotaIVA">
																		<li>
																			Aliquota IVA applicata:
																			<span>
																				<xsl:value-of select="AliquotaIVA" />
																			</span>
																		</li>
																	</xsl:if>
																	<xsl:if test="Ritenuta">
																		<li>
																			Contributo cassa soggetto a ritenuta:
																			<span>
																				<xsl:value-of select="Ritenuta" />
																			</span>
																		</li>
																	</xsl:if>
																	<xsl:if test="Natura">
																		<li>
																			Tipologia di non imponibilità del contributo:
																			<span>
																				<xsl:value-of select="Natura" />
																			</span>
																			<xsl:variable name="NT">
																				<xsl:value-of select="Natura" />
																			</xsl:variable>
																			<xsl:choose>
																				<xsl:when test="$NT='N1'">
																					(escluse ex art. 15)
																				</xsl:when>
																				<xsl:when test="$NT='N2'">
																					(non soggette)
																				</xsl:when>
																				<xsl:when test="$NT='N3'">
																					(non imponibili)
																				</xsl:when>
																				<xsl:when test="$NT='N4'">
																					(esenti)
																				</xsl:when>
																				<xsl:when test="$NT='N5'">
																					(regime del margine / IVA non esposta in fattura)
																				</xsl:when>
																				<xsl:when test="$NT='N6'">
																					(inversione contabile)
																				</xsl:when>
																				<xsl:when test="$NT='N7'">
																					(IVA assolta in altro Stato UE)
																				</xsl:when>
																				<xsl:when test="$NT=''">
																				</xsl:when>
																				<xsl:otherwise>
																					<span>(!!! codice non previsto !!!)</span>
																				</xsl:otherwise>
																			</xsl:choose>
																		</li>
																	</xsl:if>
																	<xsl:if test="RiferimentoAmministrazione">
																		<li>
																			Riferimento amministrativo / contabile:
																			<span>
																				<xsl:value-of select="RiferimentoAmministrazione" />
																			</span>
																		</li>
																	</xsl:if>
																</ul>
															</xsl:for-each>
														</div>
													</xsl:if>
													<!--FINE DATI DELLA CASSA PREVIDENZIALE-->

													<!--INIZIO DATI SCONTO / MAGGIORAZIONE-->
													<xsl:if test="DatiGenerali/DatiGeneraliDocumento/ScontoMaggiorazione">
														<h4>Sconto/maggiorazione</h4>
														<div id="dati-sconto-maggiorazione">
															<xsl:for-each select="DatiGenerali/DatiGeneraliDocumento/ScontoMaggiorazione">
																<ul>
																	<xsl:if test="Tipo">
																		<li>
																			Tipologia:
																			<span>
																				<xsl:value-of select="Tipo" />
																			</span>
																			<xsl:variable name="TSM">
																				<xsl:value-of select="Tipo" />
																			</xsl:variable>
																			<xsl:choose>
																				<xsl:when test="$TSM='SC'">

																					(sconto)
																				</xsl:when>
																				<xsl:when test="$TSM='MG'">

																					(maggiorazione)
																				</xsl:when>
																				<xsl:otherwise>

																					<span>(!!! codice non previsto !!!)</span>
																				</xsl:otherwise>
																			</xsl:choose>
																		</li>
																	</xsl:if>
																	<xsl:if test="Percentuale">
																		<li>
																			Percentuale:
																			<span>
																				<xsl:value-of select="Percentuale" />
																			</span>
																		</li>
																	</xsl:if>
																	<xsl:if test="Importo">
																		<li>
																			Importo:
																			<span>
																				<xsl:value-of select="Importo" />
																			</span>
																		</li>
																	</xsl:if>
																</ul>
															</xsl:for-each>
														</div>
													</xsl:if>
													<!--FINE DATI SCONTO / MAGGIORAZIONE-->

												</div>
											</xsl:if>
											<!--FINE DATI GENERALI DOCUMENTO-->

											<!--INIZIO DATI DELL'ORDINE DI ACQUISTO-->
											<xsl:if test="DatiGenerali/DatiOrdineAcquisto">
												<div id="dati-ordine-acquisto">
													<h3>Dati dell'ordine di acquisto</h3>

													<xsl:for-each select="DatiGenerali/DatiOrdineAcquisto">
														<ul>
															<xsl:if test="RiferimentoNumeroLinea">
																<li>
																	Numero linea di fattura a cui si riferisce:
																	<xsl:for-each select="RiferimentoNumeroLinea">
																		<span>
																			<xsl:if test="(position( )) > 1">
																				,
																			</xsl:if>
																			<xsl:value-of select="." />
																		</span>
																	</xsl:for-each>
																</li>
															</xsl:if>
															<xsl:if test="IdDocumento">
																<li>
																	Identificativo ordine di acquisto:
																	<span>
																		<xsl:value-of select="IdDocumento" />
																	</span>
																</li>
															</xsl:if>
															<xsl:if test="Data">
																<li>
																	Data ordine di acquisto:
																	<span>
																		<xsl:value-of select="Data" />
																	</span>
																	<xsl:call-template name="FormatDate">
																		<xsl:with-param name="DateTime" select="Data" />
																	</xsl:call-template>
																</li>
															</xsl:if>
															<xsl:if test="NumItem">
																<li>
																	Numero linea ordine di acquisto:
																	<span>
																		<xsl:value-of select="NumItem" />
																	</span>
																</li>
															</xsl:if>
															<xsl:if test="CodiceCommessaConvenzione">
																<li>
																	Codice commessa/convenzione:
																	<span>
																		<xsl:value-of select="CodiceCommessaConvenzione" />
																	</span>
																</li>
															</xsl:if>
															<xsl:if test="CodiceCUP">
																<li>
																	Codice Unitario Progetto (CUP):
																	<span>
																		<xsl:value-of select="CodiceCUP" />
																	</span>
																</li>
															</xsl:if>
															<xsl:if test="CodiceCIG">
																<li>
																	Codice Identificativo Gara (CIG):
																	<span>
																		<xsl:value-of select="CodiceCIG" />
																	</span>
																</li>
															</xsl:if>
														</ul>
													</xsl:for-each>
												</div>
											</xsl:if>
											<!--FINE DATI DELL'ORDINE DI ACQUISTO-->

											<!--INIZIO DATI DEL CONTRATTO-->
											<xsl:if test="DatiGenerali/DatiContratto">
												<div id="dati-contratto">
													<h3>Dati del contratto</h3>
													<xsl:for-each select="DatiGenerali/DatiContratto">
														<ul>
															<xsl:if test="RiferimentoNumeroLinea">
																<li>
																	Numero linea di fattura a cui si riferisce:
																	<xsl:for-each select="RiferimentoNumeroLinea">
																		<span>
																			<xsl:if test="(position( )) > 1">
																				,
																			</xsl:if>
																			<xsl:value-of select="." />
																		</span>
																	</xsl:for-each>
																</li>
															</xsl:if>
															<xsl:if test="IdDocumento">
																<li>
																	Identificativo contratto:
																	<span>
																		<xsl:value-of select="IdDocumento" />
																	</span>
																</li>
															</xsl:if>
															<xsl:if test="Data">
																<li>
																	Data contratto:
																	<span>
																		<xsl:value-of select="Data" />
																	</span>
																	<xsl:call-template name="FormatDate">
																		<xsl:with-param name="DateTime" select="Data" />
																	</xsl:call-template>
																</li>
															</xsl:if>
															<xsl:if test="NumItem">
																<li>
																	Numero linea contratto:
																	<span>
																		<xsl:value-of select="NumItem" />
																	</span>
																</li>
															</xsl:if>
															<xsl:if test="CodiceCommessaConvenzione">
																<li>
																	Codice commessa/convenzione:
																	<span>
																		<xsl:value-of select="CodiceCommessaConvenzione" />
																	</span>
																</li>
															</xsl:if>
															<xsl:if test="CodiceCUP">
																<li>
																	Codice Unitario Progetto (CUP):
																	<span>
																		<xsl:value-of select="CodiceCUP" />
																	</span>
																</li>
															</xsl:if>
															<xsl:if test="CodiceCIG">
																<li>
																	Codice Identificativo Gara (CIG):
																	<span>
																		<xsl:value-of select="CodiceCIG" />
																	</span>
																</li>
															</xsl:if>
														</ul>
													</xsl:for-each>
												</div>
											</xsl:if>
											<!--FINE DATI DEL CONTRATTO-->

											<!--INIZIO DATI CONVENZIONE-->
											<xsl:if test="DatiGenerali/DatiConvenzione">
												<div id="dati-convenzione">
													<h3>Dati della convenzione</h3>
													<xsl:for-each select="DatiGenerali/DatiConvenzione">
														<ul>
															<xsl:if test="RiferimentoNumeroLinea">
																<li>
																	Numero linea di fattura a cui si riferisce:
																	<xsl:for-each select="RiferimentoNumeroLinea">
																		<span>
																			<xsl:if test="(position( )) > 1">
																				,
																			</xsl:if>
																			<xsl:value-of select="." />
																		</span>

																	</xsl:for-each>
																</li>
															</xsl:if>
															<xsl:if test="IdDocumento">
																<li>
																	Identificativo convenzione:
																	<span>
																		<xsl:value-of select="IdDocumento" />
																	</span>
																</li>
															</xsl:if>
															<xsl:if test="Data">
																<li>
																	Data convenzione:
																	<span>
																		<xsl:value-of select="Data" />
																	</span>
																	<xsl:call-template name="FormatDate">
																		<xsl:with-param name="DateTime" select="Data" />
																	</xsl:call-template>
																</li>
															</xsl:if>
															<xsl:if test="NumItem">
																<li>
																	Numero linea convenzione:
																	<span>
																		<xsl:value-of select="NumItem" />
																	</span>
																</li>
															</xsl:if>
															<xsl:if test="CodiceCommessaConvenzione">
																<li>
																	Codice commessa/convenzione:
																	<span>
																		<xsl:value-of select="CodiceCommessaConvenzione" />
																	</span>
																</li>
															</xsl:if>
															<xsl:if test="CodiceCUP">
																<li>
																	Codice Unitario Progetto (CUP):
																	<span>
																		<xsl:value-of select="CodiceCUP" />
																	</span>
																</li>
															</xsl:if>
															<xsl:if test="CodiceCIG">
																<li>
																	Codice Identificativo Gara (CIG):
																	<span>
																		<xsl:value-of select="CodiceCIG" />
																	</span>
																</li>
															</xsl:if>
														</ul>
													</xsl:for-each>
												</div>
											</xsl:if>
											<!--FINE DATI CONVENZIONE-->

											<!--INIZIO DATI RICEZIONE-->
											<xsl:if test="DatiGenerali/DatiRicezione">
												<div id="dati-ricezione">
													<h3>Dati della ricezione</h3>
													<xsl:for-each select="DatiGenerali/DatiRicezione">
														<ul>
															<xsl:if test="RiferimentoNumeroLinea">
																<li>
																	Numero linea di fattura a cui si riferisce:
																	<xsl:for-each select="RiferimentoNumeroLinea">
																		<span>
																			<xsl:if test="(position( )) > 1">
																				,
																			</xsl:if>
																			<xsl:value-of select="." />
																		</span>

																	</xsl:for-each>
																</li>
															</xsl:if>
															<xsl:if test="IdDocumento">
																<li>
																	Identificativo ricezione:
																	<span>
																		<xsl:value-of select="IdDocumento" />
																	</span>
																</li>
															</xsl:if>
															<xsl:if test="Data">
																<li>
																	Data ricezione:
																	<span>
																		<xsl:value-of select="Data" />
																	</span>
																	<xsl:call-template name="FormatDate">
																		<xsl:with-param name="DateTime" select="Data" />
																	</xsl:call-template>
																</li>
															</xsl:if>
															<xsl:if test="NumItem">
																<li>
																	Numero linea ricezione:
																	<span>
																		<xsl:value-of select="NumItem" />
																	</span>
																</li>
															</xsl:if>
															<xsl:if test="CodiceCommessaConvenzione">
																<li>
																	Codice commessa/convenzione:
																	<span>
																		<xsl:value-of select="CodiceCommessaConvenzione" />
																	</span>
																</li>
															</xsl:if>
															<xsl:if test="CodiceCUP">
																<li>
																	Codice Unitario Progetto (CUP):
																	<span>
																		<xsl:value-of select="CodiceCUP" />
																	</span>
																</li>
															</xsl:if>
															<xsl:if test="CodiceCIG">
																<li>
																	Codice Identificativo Gara (CIG):
																	<span>
																		<xsl:value-of select="CodiceCIG" />
																	</span>
																</li>
															</xsl:if>
														</ul>
													</xsl:for-each>
												</div>
											</xsl:if>
											<!--FINE DATI RICEZIONE-->

											<!--INIZIO DATI FATTURE COLLEGATE-->
											<xsl:if test="DatiGenerali/DatiFattureCollegate">
												<div id="dati-fatture-collegate">
													<h3>Dati della fattura collegata</h3>
													<xsl:for-each select="DatiGenerali/DatiFattureCollegate">
														<ul>
															<xsl:if test="RiferimentoNumeroLinea">
																<li>
																	Numero linea di fattura a cui si riferisce:
																	<xsl:for-each select="RiferimentoNumeroLinea">
																		<span>
																			<xsl:if test="(position( )) > 1">
																				,
																			</xsl:if>
																			<xsl:value-of select="." />
																		</span>

																	</xsl:for-each>
																</li>
															</xsl:if>
															<xsl:if test="IdDocumento">
																<li>
																	Identificativo fattura collegata:
																	<span>
																		<xsl:value-of select="IdDocumento" />
																	</span>
																</li>
															</xsl:if>
															<xsl:if test="Data">
																<li>
																	Data fattura collegata:
																	<span>
																		<xsl:value-of select="Data" />
																	</span>
																	<xsl:call-template name="FormatDate">
																		<xsl:with-param name="DateTime" select="Data" />
																	</xsl:call-template>
																</li>
															</xsl:if>
															<xsl:if test="NumItem">
																<li>
																	Numero linea fattura collegata:
																	<span>
																		<xsl:value-of select="NumItem" />
																	</span>
																</li>
															</xsl:if>
															<xsl:if test="CodiceCommessaConvenzione">
																<li>
																	Codice commessa/convenzione:
																	<span>
																		<xsl:value-of select="CodiceCommessaConvenzione" />
																	</span>
																</li>
															</xsl:if>
															<xsl:if test="CodiceCUP">
																<li>
																	Codice Unitario Progetto (CUP):
																	<span>
																		<xsl:value-of select="CodiceCUP" />
																	</span>
																</li>
															</xsl:if>
															<xsl:if test="CodiceCIG">
																<li>
																	Codice Identificativo Gara (CIG):
																	<span>
																		<xsl:value-of select="CodiceCIG" />
																	</span>
																</li>
															</xsl:if>
														</ul>
													</xsl:for-each>
												</div>
											</xsl:if>
											<!--FINE DATI FATTURE COLLEGATE-->

											<!--INIZIO DATI RIFERIMENTO SAL-->
											<xsl:if test="DatiGenerali/DatiSAL">
												<div id="dati-sal">
													<h3>Stato avanzamento lavori</h3>
													<ul>
														<xsl:if test="DatiGenerali/DatiSAL/RiferimentoFase">
															<li>
																Numero fase avanzamento:
																<xsl:for-each select="DatiGenerali/DatiSAL/RiferimentoFase">
																	<span>
																		<xsl:if test="(position( )) > 1">
																			,
																		</xsl:if>
																		<xsl:value-of select="." />
																	</span>
																</xsl:for-each>
															</li>
														</xsl:if>
													</ul>
												</div>
											</xsl:if>
											<!--FINE DATI RIFERIMENTO SAL-->

											<!--INIZIO DATI  DDT-->
											<xsl:if test="DatiGenerali/DatiDDT">
												<div id="dati-ddt">
													<h3>Dati del documento di trasporto</h3>
													<xsl:for-each select="DatiGenerali/DatiDDT">
														<ul>
															<xsl:if test="NumeroDDT">
																<li>
																	Numero DDT:
																	<span>
																		<xsl:value-of select="NumeroDDT" />
																	</span>
																</li>
															</xsl:if>
															<xsl:if test="DataDDT">
																<li>
																	Data DDT:
																	<span>
																		<xsl:value-of select="DataDDT" />
																	</span>
																	<xsl:call-template name="FormatDate">
																		<xsl:with-param name="DateTime" select="DataDDT" />
																	</xsl:call-template>
																</li>
															</xsl:if>
															<xsl:if test="RiferimentoNumeroLinea">
																<li>
																	Numero linea di fattura a cui si riferisce:
																	<xsl:for-each select="RiferimentoNumeroLinea">
																		<span>
																			<xsl:if test="(position( )) > 1">
																				,
																			</xsl:if>
																			<xsl:value-of select="." />
																		</span>
																	</xsl:for-each>
																</li>
															</xsl:if>
														</ul>
													</xsl:for-each>
												</div>
											</xsl:if>
											<!--FINE DATI DDT-->

											<!--INIZIO DATI  TRASPORTO-->
											<xsl:if test="DatiGenerali/DatiTrasporto">
												<div id="dati-trasporto">
													<h3>Dati relativi al trasporto</h3>

													<xsl:if test="DatiGenerali/DatiTrasporto/DatiAnagraficiVettore">
														<h4>Dati del vettore</h4>

														<ul>
															<xsl:for-each select="DatiGenerali/DatiTrasporto/DatiAnagraficiVettore">
																<xsl:if test="IdFiscaleIVA/IdPaese">
																	<li>
																		Identificativo fiscale ai fini IVA:
																		<span>
																			<xsl:value-of select="IdFiscaleIVA/IdPaese" />
																			<xsl:value-of select="IdFiscaleIVA/IdCodice" />
																		</span>
																	</li>
																</xsl:if>
																<xsl:if test="CodiceFiscale">
																	<li>
																		Codice Fiscale:
																		<span>
																			<xsl:value-of select="CodiceFiscale" />
																		</span>
																	</li>
																</xsl:if>
																<xsl:if test="Anagrafica/Denominazione">
																	<li>
																		Denominazione:
																		<span>
																			<xsl:value-of select="Anagrafica/Denominazione" />
																		</span>
																	</li>
																</xsl:if>
																<xsl:if test="Anagrafica/Nome">
																	<li>
																		Nome:
																		<span>
																			<xsl:value-of select="Anagrafica/Nome" />
																		</span>
																	</li>
																</xsl:if>
																<xsl:if test="Anagrafica/Cognome">
																	<li>
																		Cognome:
																		<span>
																			<xsl:value-of select="Anagrafica/Cognome" />
																		</span>
																	</li>
																</xsl:if>
																<xsl:if test="Anagrafica/Titolo">
																	<li>
																		Titolo onorifico:
																		<span>
																			<xsl:value-of select="Anagrafica/Titolo" />
																		</span>
																	</li>
																</xsl:if>
																<xsl:if test="Anagrafica/CodEORI">
																	<li>
																		Codice EORI:
																		<span>
																			<xsl:value-of select="Anagrafica/CodEORI" />
																		</span>
																	</li>
																</xsl:if>
																<xsl:if test="NumeroLicenzaGuida">
																	<li>
																		Numero licenza di guida:
																		<span>
																			<xsl:value-of select="NumeroLicenzaGuida" />
																		</span>
																	</li>
																</xsl:if>
															</xsl:for-each>
														</ul>
													</xsl:if>

													<xsl:if
														test="DatiGenerali/DatiTrasporto/MezzoTrasporto or DatiGenerali/DatiTrasporto/CausaleTrasporto or DatiGenerali/DatiTrasporto/NumeroColli or DatiGenerali/DatiTrasporto/Descrizione or DatiGenerali/DatiTrasporto/UnitaMisuraPeso or DatiGenerali/DatiTrasporto/PesoLordo or DatiGenerali/DatiTrasporto/PesoNetto or DatiGenerali/DatiTrasporto/DataOraRitiro or DatiGenerali/DatiTrasporto/DataInizioTrasporto or DatiGenerali/DatiTrasporto/TipoResa or DatiGenerali/DatiTrasporto/IndirizzoResa">
														<h4>Altri dati</h4>

														<ul>
															<xsl:for-each select="DatiGenerali/DatiTrasporto">
																<xsl:if test="MezzoTrasporto">
																	<li>
																		Mezzo di trasporto:
																		<span>
																			<xsl:value-of select="MezzoTrasporto" />
																		</span>
																	</li>
																</xsl:if>
																<xsl:if test="CausaleTrasporto">
																	<li>
																		Causale trasporto:
																		<span>
																			<xsl:value-of select="CausaleTrasporto" />
																		</span>
																	</li>
																</xsl:if>
																<xsl:if test="NumeroColli">
																	<li>
																		Numero colli trasportati:
																		<span>
																			<xsl:value-of select="NumeroColli" />
																		</span>
																	</li>
																</xsl:if>
																<xsl:if test="Descrizione">
																	<li>
																		Descrizione beni trasportati:
																		<span>
																			<xsl:value-of select="Descrizione" />
																		</span>
																	</li>
																</xsl:if>
																<xsl:if test="UnitaMisuraPeso">
																	<li>
																		Unità di misura del peso merce:
																		<span>
																			<xsl:value-of select="UnitaMisuraPeso" />
																		</span>
																	</li>
																</xsl:if>
																<xsl:if test="PesoLordo">
																	<li>
																		Peso lordo:
																		<span>
																			<xsl:value-of select="PesoLordo" />
																		</span>
																	</li>
																</xsl:if>
																<xsl:if test="PesoNetto">
																	<li>
																		Peso netto:
																		<span>
																			<xsl:value-of select="PesoNetto" />
																		</span>
																	</li>
																</xsl:if>
																<xsl:if test="DataOraRitiro">
																	<li>
																		Data e ora ritiro merce:
																		<span>
																			<xsl:value-of select="DataOraRitiro" />
																		</span>
																		<xsl:call-template name="FormatDate">
																			<xsl:with-param name="DateTime" select="DataOraRitiro" />
																		</xsl:call-template>
																	</li>
																</xsl:if>
																<xsl:if test="DataInizioTrasporto">
																	<li>
																		Data inizio trasporto:
																		<span>
																			<xsl:value-of select="DataInizioTrasporto" />
																		</span>
																		<xsl:call-template name="FormatDate">
																			<xsl:with-param name="DateTime" select="DataInizioTrasporto" />
																		</xsl:call-template>
																	</li>
																</xsl:if>
																<xsl:if test="TipoResa">
																	<li>
																		Tipologia di resa:
																		<span>
																			<xsl:value-of select="TipoResa" />
																		</span>

																		(codifica secondo standard ICC)
																	</li>
																</xsl:if>
																<xsl:if test="IndirizzoResa/Indirizzo">
																	<li>
																		Indirizzo di resa:
																		<span>
																			<xsl:value-of select="IndirizzoResa/Indirizzo" />
																		</span>
																	</li>
																</xsl:if>
																<xsl:if test="IndirizzoResa/NumeroCivico">
																	<li>
																		Numero civico indirizzo di resa:
																		<span>
																			<xsl:value-of select="IndirizzoResa/NumeroCivico" />
																		</span>
																	</li>
																</xsl:if>
																<xsl:if test="IndirizzoResa/CAP">
																	<li>
																		CAP indirizzo di resa:
																		<span>
																			<xsl:value-of select="IndirizzoResa/CAP" />
																		</span>
																	</li>
																</xsl:if>
																<xsl:if test="IndirizzoResa/Comune">
																	<li>
																		Comune di resa:
																		<span>
																			<xsl:value-of select="IndirizzoResa/Comune" />
																		</span>
																	</li>
																</xsl:if>
																<xsl:if test="IndirizzoResa/Provincia">
																	<li>
																		Provincia di resa:
																		<span>
																			<xsl:value-of select="IndirizzoResa/Provincia" />
																		</span>
																	</li>
																</xsl:if>
																<xsl:if test="IndirizzoResa/Nazione">
																	<li>
																		Nazione di resa:
																		<span>
																			<xsl:value-of select="IndirizzoResa/Nazione" />
																		</span>
																	</li>
																</xsl:if>
															</xsl:for-each>
														</ul>
													</xsl:if>

												</div>
											</xsl:if>
											<!--FINE DATI TRASPORTO-->

											<!--INIZIO FATTURA PRINCIPALE-->
											<xsl:if test="DatiGenerali/FatturaPrincipale">
												<div id="fattura-principale">
													<h3>Dati relativi alla fattura principale</h3>
													<ul>
														<xsl:if test="DatiGenerali/FatturaPrincipale/NumeroFatturaPrincipale">
															<li>
																Numero fattura principale:
																<span>
																	<xsl:value-of select="DatiGenerali/FatturaPrincipale/NumeroFatturaPrincipale" />
																</span>
															</li>
														</xsl:if>
														<xsl:if test="DatiGenerali/FatturaPrincipale/DataFatturaPrincipale">
															<li>
																Data fattura principale:
																<span>
																	<xsl:value-of select="DatiGenerali/FatturaPrincipale/DataFatturaPrincipale" />
																</span>
																<xsl:call-template name="FormatDate">
																	<xsl:with-param name="DateTime" select="DatiGenerali/FatturaPrincipale/DataFatturaPrincipale" />
																</xsl:call-template>
															</li>
														</xsl:if>
													</ul>
												</div>
											</xsl:if>
											<!--FINE FATTURA PRINCIPALE-->

										</div>
									</xsl:if>
									<!--FINE DATI GENERALI-->

									<!--INIZIO DATI BENI E SERVIZI-->
									<xsl:if test="DatiBeniServizi">
										<div id="dati-dettaglio-linee">

											<!--INIZIO DATI DI DETTAGLIO DELLE LINEE-->
											<xsl:if test="DatiBeniServizi/DettaglioLinee">
												<div id="righe">
													<h3>Dati relativi alle linee di dettaglio della fornitura</h3>

													<xsl:for-each select="DatiBeniServizi/DettaglioLinee">
														<h5>
															Nr. linea:
															<span>
																<xsl:value-of select="NumeroLinea" />
															</span>
														</h5>

														<ul>
															<xsl:if test="TipoCessionePrestazione">
																<li>
																	Tipo cessione/prestazione:
																	<span>
																		<xsl:value-of select="TipoCessionePrestazione" />
																	</span>
																	<xsl:variable name="TCP">
																		<xsl:value-of select="TipoCessionePrestazione" />
																	</xsl:variable>
																	<xsl:choose>
																		<xsl:when test="$TCP='SC'">
																			(sconto)
																		</xsl:when>
																		<xsl:when test="$TCP='PR'">
																			(premio)
																		</xsl:when>
																		<xsl:when test="$TCP='AB'">
																			(abbuono)
																		</xsl:when>
																		<xsl:when test="$TCP='AC'">
																			(spesa accessoria)
																		</xsl:when>
																		<xsl:otherwise>
																			<span>(!!! codice non previsto !!!)</span>
																		</xsl:otherwise>
																	</xsl:choose>
																</li>
															</xsl:if>
															<xsl:if test="CodiceArticolo">
																<li>
																	<h5>Codifica articolo</h5>
																	<xsl:for-each select="CodiceArticolo">
																		<ul>
																			<xsl:if test="CodiceTipo">
																				<li>
																					Tipo:
																					<span>
																						<xsl:value-of select="CodiceTipo" />
																					</span>
																				</li>
																			</xsl:if>
																			<xsl:if test="CodiceValore">
																				<li>
																					Valore:
																					<span>
																						<xsl:value-of select="CodiceValore" />
																					</span>
																				</li>
																			</xsl:if>
																		</ul>
																	</xsl:for-each>
																</li>
															</xsl:if>
															<xsl:if test="Descrizione">
																<li>
																	Descrizione bene/servizio:
																	<span>
																		<xsl:value-of select="Descrizione" />
																	</span>
																</li>
															</xsl:if>
															<xsl:if test="Quantita">
																<li>
																	Quantità:
																	<span>
																		<xsl:value-of select="Quantita" />
																	</span>
																</li>
															</xsl:if>
															<xsl:if test="UnitaMisura">
																<li>
																	Unità di misura:
																	<span>
																		<xsl:value-of select="UnitaMisura" />
																	</span>
																</li>
															</xsl:if>
															<xsl:if test="DataInizioPeriodo">
																<li>
																	Data inizio periodo di riferimento:
																	<span>
																		<xsl:value-of select="DataInizioPeriodo" />
																	</span>
																	<xsl:call-template name="FormatDate">
																		<xsl:with-param name="DateTime" select="DataInizioPeriodo" />
																	</xsl:call-template>
																</li>
															</xsl:if>
															<xsl:if test="DataFinePeriodo">
																<li>
																	Data fine periodo di riferimento:
																	<span>
																		<xsl:value-of select="DataFinePeriodo" />
																	</span>
																	<xsl:call-template name="FormatDate">
																		<xsl:with-param name="DateTime" select="DataFinePeriodo" />
																	</xsl:call-template>
																</li>
															</xsl:if>
															<xsl:if test="PrezzoUnitario">
																<li>
																	Valore unitario:
																	<span>
																		<xsl:value-of select="PrezzoUnitario" />
																	</span>
																</li>
															</xsl:if>
															<xsl:if test="ScontoMaggiorazione">
																<li>
																	<h5>Sconto/Maggiorazione</h5>

																	<xsl:for-each select="ScontoMaggiorazione">
																		<ul>
																			<xsl:if test="Tipo">
																				<li>
																					Tipo:
																					<span>
																						<xsl:value-of select="Tipo" />
																					</span>
																					<xsl:variable name="TSCM">
																						<xsl:value-of select="Tipo" />
																					</xsl:variable>
																					<xsl:choose>
																						<xsl:when test="$TSCM='SC'">

																							(sconto)
																						</xsl:when>
																						<xsl:when test="$TSCM='MG'">

																							(maggiorazione)
																						</xsl:when>
																						<xsl:otherwise>

																							<span>(!!! codice non previsto !!!)</span>
																						</xsl:otherwise>
																					</xsl:choose>
																				</li>
																			</xsl:if>
																			<xsl:if test="Percentuale">
																				<li>
																					Percentuale (%):
																					<span>
																						<xsl:value-of select="Percentuale" />
																					</span>
																				</li>
																			</xsl:if>
																			<xsl:if test="Importo">
																				<li>
																					Importo:
																					<span>
																						<xsl:value-of select="Importo" />
																					</span>
																				</li>
																			</xsl:if>
																		</ul>
																	</xsl:for-each>
																</li>
															</xsl:if>
															<xsl:if test="PrezzoTotale">
																<li>
																	Valore totale:
																	<span>
																		<xsl:value-of select="PrezzoTotale" />
																	</span>
																</li>
															</xsl:if>
															<xsl:if test="AliquotaIVA">
																<li>
																	IVA (%):
																	<span>
																		<xsl:value-of select="AliquotaIVA" />
																	</span>
																</li>
															</xsl:if>
															<xsl:if test="Ritenuta">
																<li>
																	Soggetta a ritenuta:
																	<span>
																		<xsl:value-of select="Ritenuta" />
																	</span>
																</li>
															</xsl:if>
															<xsl:if test="Natura">
																<li>
																	Natura operazione:
																	<span>
																		<xsl:value-of select="Natura" />
																	</span>
																	<xsl:variable name="NAT">
																		<xsl:value-of select="Natura" />
																	</xsl:variable>
																	<xsl:choose>
																		<xsl:when test="$NAT='N1'">
																			(esclusa ex art.15)
																		</xsl:when>
																		<xsl:when test="$NAT='N2'">
																			(non soggetta)
																		</xsl:when>
																		<xsl:when test="$NAT='N3'">
																			(non imponibile)
																		</xsl:when>
																		<xsl:when test="$NAT='N4'">
																			(esente)
																		</xsl:when>
																		<xsl:when test="$NAT='N5'">
																			(regime del margine / IVA non esposta in fattura)
																		</xsl:when>
																		<xsl:when test="$NAT='N6'">
																			(inversione contabile)
																		</xsl:when>
																		<xsl:when test="$NAT='N7'">
																			(IVA assolta in altro Stato UE)
																		</xsl:when>
																		<xsl:otherwise>
																			<span>(!!! codice non previsto !!!)</span>
																		</xsl:otherwise>
																	</xsl:choose>
																</li>
															</xsl:if>
															<xsl:if test="RiferimentoAmministrazione">
																<li>
																	Riferimento amministrativo/contabile:
																	<span>
																		<xsl:value-of select="RiferimentoAmministrazione" />
																	</span>
																</li>
															</xsl:if>
															<xsl:if test="AltriDatiGestionali">
																<li>
																	<h5>Altri dati gestionali</h5>
																	<ul>
																		<xsl:for-each select="AltriDatiGestionali">
																			<xsl:if test="TipoDato">
																				<li>
																					Tipo dato:
																					<span>
																						<xsl:value-of select="TipoDato" />
																					</span>
																				</li>
																			</xsl:if>
																			<xsl:if test="RiferimentoTesto">
																				<li>
																					Valore testo:
																					<span>
																						<xsl:value-of select="RiferimentoTesto" />
																					</span>
																				</li>
																			</xsl:if>
																			<xsl:if test="RiferimentoNumero">
																				<li>
																					Valore numerico:
																					<span>
																						<xsl:value-of select="RiferimentoNumero" />
																					</span>
																				</li>
																			</xsl:if>
																			<xsl:if test="RiferimentoData">
																				<li>
																					Valore data:
																					<span>
																						<xsl:value-of select="RiferimentoData" />
																					</span>
																					<xsl:call-template name="FormatDate">
																						<xsl:with-param name="DateTime" select="RiferimentoData" />
																					</xsl:call-template>
																				</li>
																			</xsl:if>
																		</xsl:for-each>
																	</ul>
																</li>
															</xsl:if>
														</ul>
													</xsl:for-each>
												</div>
											</xsl:if>
											<!--FINE DATI DI DETTAGLIO DELLE LINEE-->

											<!--INIZIO DATI DI RIEPILOGO ALIQUOTE E NATURE-->
											<xsl:if test="DatiBeniServizi/DatiRiepilogo">
												<div id="riepilogo-aliquote-nature">
													<h3>Dati di riepilogo per aliquota IVA e natura</h3>
													<xsl:for-each select="DatiBeniServizi/DatiRiepilogo">
														<ul>
															<xsl:if test="AliquotaIVA">
																<li>
																	Aliquota IVA (%):
																	<span>
																		<xsl:value-of select="AliquotaIVA" />
																	</span>
																</li>
															</xsl:if>
															<xsl:if test="Natura">
																<li>
																	Natura operazioni:
																	<span>
																		<xsl:value-of select="Natura" />
																	</span>
																	<xsl:variable name="NAT1">
																		<xsl:value-of select="Natura" />
																	</xsl:variable>
																	<xsl:choose>
																		<xsl:when test="$NAT1='N1'">
																			(escluse ex art.15)
																		</xsl:when>
																		<xsl:when test="$NAT1='N2'">
																			(non soggette)
																		</xsl:when>
																		<xsl:when test="$NAT1='N3'">
																			(non imponibili)
																		</xsl:when>
																		<xsl:when test="$NAT1='N4'">
																			(esenti)
																		</xsl:when>
																		<xsl:when test="$NAT1='N5'">
																			(regime del margine / IVA non esposta in fattura)
																		</xsl:when>
																		<xsl:when test="$NAT1='N6'">
																			(inversione contabile)
																		</xsl:when>
																		<xsl:when test="$NAT1='N7'">
																			(IVA assolta in altro Stato UE)
																		</xsl:when>
																		<xsl:otherwise>
																			<span>(!!! codice non previsto !!!)</span>
																		</xsl:otherwise>
																	</xsl:choose>
																</li>
															</xsl:if>
															<xsl:if test="SpeseAccessorie">
																<li>
																	Spese accessorie:
																	<span>
																		<xsl:value-of select="SpeseAccessorie" />
																	</span>
																</li>
															</xsl:if>
															<xsl:if test="Arrotondamento">
																<li>
																	Arrotondamento:
																	<span>
																		<xsl:value-of select="Arrotondamento" />
																	</span>
																</li>
															</xsl:if>
															<xsl:if test="ImponibileImporto">
																<li>
																	Totale imponibile/importo:
																	<span>
																		<xsl:value-of select="ImponibileImporto" />
																	</span>
																</li>
															</xsl:if>
															<xsl:if test="Imposta">
																<li>
																	Totale imposta:
																	<span>
																		<xsl:value-of select="Imposta" />
																	</span>
																</li>
															</xsl:if>
															<xsl:if test="EsigibilitaIVA">
																<li>
																	Esigibilità IVA:
																	<span>
																		<xsl:value-of select="EsigibilitaIVA" />
																	</span>
																	<xsl:variable name="EI">
																		<xsl:value-of select="EsigibilitaIVA" />
																	</xsl:variable>
																	<xsl:choose>
																		<xsl:when test="$EI='I'">
																			(esigibilità immediata)
																		</xsl:when>
																		<xsl:when test="$EI='D'">
																			(esigibilità differita)
																		</xsl:when>
																		<xsl:when test="$EI='S'">
																			(scissione dei pagamenti)
																		</xsl:when>
																		<xsl:otherwise>
																			<span>(!!! codice non previsto !!!)</span>
																		</xsl:otherwise>
																	</xsl:choose>
																</li>
															</xsl:if>
															<xsl:if test="RiferimentoNormativo">
																<li>
																	Riferimento normativo:
																	<span>
																		<xsl:value-of select="RiferimentoNormativo" />
																	</span>
																</li>
															</xsl:if>
														</ul>
													</xsl:for-each>
												</div>
											</xsl:if>
											<!--FINE DATI RIEPILOGO ALIQUOTE E NATURE-->

										</div>
									</xsl:if>
									<!--FINE DATI BENI E SERVIZI-->

									<!--INIZIO DATI VEICOLI-->
									<xsl:if test="DatiVeicoli">
										<div id="dati-veicoli">
											<h3>Dati Veicoli ex art. 38 dl 331/1993</h3>
											<ul>
												<xsl:for-each select="DatiVeicoli">
													<xsl:if test="Data">
														<li>
															Data prima immatricolazione / iscrizione PR:
															<span>
																<xsl:value-of select="Data" />
															</span>
															<xsl:call-template name="FormatDate">
																<xsl:with-param name="DateTime" select="Data" />
															</xsl:call-template>
														</li>
													</xsl:if>
													<xsl:if test="TotalePercorso">
														<li>
															Totale percorso:
															<span>
																<xsl:value-of select="TotalePercorso" />
															</span>
														</li>
													</xsl:if>
												</xsl:for-each>
											</ul>
										</div>
									</xsl:if>
									<!--FINE DATI VEICOLI-->

									<!--INIZIO DATI PAGAMENTO-->
									<xsl:if test="DatiPagamento">
										<div id="dati-pagamento-condizioni">
											<h3>Dati relativi al pagamento</h3>
											<ul>
												<xsl:for-each select="DatiPagamento">
													<xsl:if test="CondizioniPagamento">
														<li>
															Condizioni di pagamento:
															<span>
																<xsl:value-of select="CondizioniPagamento" />
															</span>
															<xsl:variable name="CP">
																<xsl:value-of select="CondizioniPagamento" />
															</xsl:variable>
															<xsl:choose>
																<xsl:when test="$CP='TP01'">
																	(pagamento a rate)
																</xsl:when>
																<xsl:when test="$CP='TP02'">
																	(pagamento completo)
																</xsl:when>
																<xsl:when test="$CP='TP03'">
																	(anticipo)
																</xsl:when>
																<xsl:when test="$CP=''">
																</xsl:when>
																<xsl:otherwise>
																	<span>(!!! codice non previsto !!!)</span>
																</xsl:otherwise>
															</xsl:choose>
														</li>
													</xsl:if>

													<xsl:if test="DettaglioPagamento">
														<h5>Dettaglio pagamento</h5>

														<xsl:for-each select="DettaglioPagamento">
															<ul>
																<xsl:if test="Beneficiario">
																	<li>
																		Beneficiario del pagamento:
																		<span>
																			<xsl:value-of select="Beneficiario" />
																		</span>
																	</li>
																</xsl:if>
																<xsl:if test="ModalitaPagamento">
																	<li>
																		Modalità:
																		<span>
																			<xsl:value-of select="ModalitaPagamento" />
																		</span>
																		<xsl:variable name="MP">
																			<xsl:value-of select="ModalitaPagamento" />
																		</xsl:variable>
																		<xsl:choose>
																			<xsl:when test="$MP='MP01'">
																				(contanti)
																			</xsl:when>
																			<xsl:when test="$MP='MP02'">
																				(assegno)
																			</xsl:when>
																			<xsl:when test="$MP='MP03'">
																				(assegno circolare)
																			</xsl:when>
																			<xsl:when test="$MP='MP04'">
																				(contanti presso Tesoreria)
																			</xsl:when>
																			<xsl:when test="$MP='MP05'">
																				(bonifico)
																			</xsl:when>
																			<xsl:when test="$MP='MP06'">
																				(vaglia cambiario)
																			</xsl:when>
																			<xsl:when test="$MP='MP07'">
																				(bollettino bancario)
																			</xsl:when>
																			<xsl:when test="$MP='MP08'">
																				(carta di pagamento)
																			</xsl:when>
																			<xsl:when test="$MP='MP09'">
																				(RID)
																			</xsl:when>
																			<xsl:when test="$MP='MP10'">
																				(RID utenze)
																			</xsl:when>
																			<xsl:when test="$MP='MP11'">
																				(RID veloce)
																			</xsl:when>
																			<xsl:when test="$MP='MP12'">
																				(RIBA)
																			</xsl:when>
																			<xsl:when test="$MP='MP13'">
																				(MAV)
																			</xsl:when>
																			<xsl:when test="$MP='MP14'">
																				(quietanza erario)
																			</xsl:when>
																			<xsl:when test="$MP='MP15'">
																				(giroconto su conti di contabilità speciale)
																			</xsl:when>
																			<xsl:when test="$MP='MP16'">
																				(domiciliazione bancaria)
																			</xsl:when>
																			<xsl:when test="$MP='MP17'">
																				(domiciliazione postale)
																			</xsl:when>
																			<xsl:when test="$MP='MP18'">
																				(bollettino di c/c postale)
																			</xsl:when>
																			<xsl:when test="$MP='MP19'">
																				(SEPA Direct Debit)
																			</xsl:when>
																			<xsl:when test="$MP='MP20'">
																				(SEPA Direct Debit CORE)
																			</xsl:when>
																			<xsl:when test="$MP='MP21'">
																				(SEPA Direct Debit B2B)
																			</xsl:when>
																			<xsl:when test="$MP='MP22'">
																				(Trattenuta su somme già riscosse)
																			</xsl:when>
																			<xsl:when test="$MP=''">
																			</xsl:when>
																			<xsl:otherwise>
																				<span>(!!! codice non previsto !!!)</span>
																			</xsl:otherwise>
																		</xsl:choose>
																	</li>
																</xsl:if>
																<xsl:if test="DataRiferimentoTerminiPagamento">
																	<li>
																		Decorrenza termini di pagamento:
																		<span>
																			<xsl:value-of select="DataRiferimentoTerminiPagamento" />
																		</span>
																		<xsl:call-template name="FormatDate">
																			<xsl:with-param name="DateTime" select="DataRiferimentoTerminiPagamento" />
																		</xsl:call-template>
																	</li>
																</xsl:if>
																<xsl:if test="GiorniTerminiPagamento">
																	<li>
																		Termini di pagamento (in giorni):
																		<span>
																			<xsl:value-of select="GiorniTerminiPagamento" />
																		</span>
																	</li>
																</xsl:if>
																<xsl:if test="DataScadenzaPagamento">
																	<li>
																		Data scadenza pagamento:
																		<span>
																			<xsl:value-of select="DataScadenzaPagamento" />
																		</span>
																		<xsl:call-template name="FormatDate">
																			<xsl:with-param name="DateTime" select="DataScadenzaPagamento" />
																		</xsl:call-template>
																	</li>
																</xsl:if>
																<xsl:if test="ImportoPagamento">
																	<li>
																		Importo:
																		<span>
																			<xsl:value-of select="ImportoPagamento" />
																		</span>
																	</li>
																</xsl:if>
																<xsl:if test="CodUfficioPostale">
																	<li>
																		Codice Ufficio Postale:
																		<span>
																			<xsl:value-of select="CodUfficioPostale" />
																		</span>
																	</li>
																</xsl:if>
																<xsl:if test="CognomeQuietanzante">
																	<li>
																		Cognome del quietanzante:
																		<span>
																			<xsl:value-of select="CognomeQuietanzante" />
																		</span>
																	</li>
																</xsl:if>
																<xsl:if test="NomeQuietanzante">
																	<li>
																		Nome del quietanzante:
																		<span>
																			<xsl:value-of select="NomeQuietanzante" />
																		</span>
																	</li>
																</xsl:if>
																<xsl:if test="CFQuietanzante">
																	<li>
																		CF del quietanzante:
																		<span>
																			<xsl:value-of select="CFQuietanzante" />
																		</span>
																	</li>
																</xsl:if>
																<xsl:if test="TitoloQuietanzante">
																	<li>
																		Titolo del quietanzante:
																		<span>
																			<xsl:value-of select="TitoloQuietanzante" />
																		</span>
																	</li>
																</xsl:if>
																<xsl:if test="IstitutoFinanziario">
																	<li>
																		Istituto finanziario:
																		<span>
																			<xsl:value-of select="IstitutoFinanziario" />
																		</span>
																	</li>
																</xsl:if>
																<xsl:if test="IBAN">
																	<li>
																		Codice IBAN:
																		<span>
																			<xsl:value-of select="IBAN" />
																		</span>
																	</li>
																</xsl:if>
																<xsl:if test="ABI">
																	<li>
																		Codice ABI:
																		<span>
																			<xsl:value-of select="ABI" />
																		</span>
																	</li>
																</xsl:if>
																<xsl:if test="CAB">
																	<li>
																		Codice CAB:
																		<span>
																			<xsl:value-of select="CAB" />
																		</span>
																	</li>
																</xsl:if>
																<xsl:if test="BIC">
																	<li>
																		Codice BIC:
																		<span>
																			<xsl:value-of select="BIC" />
																		</span>
																	</li>
																</xsl:if>
																<xsl:if test="ScontoPagamentoAnticipato">
																	<li>
																		Sconto per pagamento anticipato:
																		<span>
																			<xsl:value-of select="ScontoPagamentoAnticipato" />
																		</span>
																	</li>
																</xsl:if>
																<xsl:if test="DataLimitePagamentoAnticipato">
																	<li>
																		Data limite per il pagamento anticipato:
																		<span>
																			<xsl:value-of select="DataLimitePagamentoAnticipato" />
																		</span>
																		<xsl:call-template name="FormatDate">
																			<xsl:with-param name="DateTime" select="DataLimitePagamentoAnticipato" />
																		</xsl:call-template>
																	</li>
																</xsl:if>
																<xsl:if test="PenalitaPagamentiRitardati">
																	<li>
																		Penale per ritardato pagamento:
																		<span>
																			<xsl:value-of select="PenalitaPagamentiRitardati" />
																		</span>
																	</li>
																</xsl:if>
																<xsl:if test="DataDecorrenzaPenale">
																	<li>
																		Data di decorrenza della penale:
																		<span>
																			<xsl:value-of select="DataDecorrenzaPenale" />
																		</span>
																		<xsl:call-template name="FormatDate">
																			<xsl:with-param name="DateTime" select="DataDecorrenzaPenale" />
																		</xsl:call-template>
																	</li>
																</xsl:if>
																<xsl:if test="CodicePagamento">
																	<li>
																		Codice pagamento:
																		<span>
																			<xsl:value-of select="CodicePagamento" />
																		</span>
																	</li>
																</xsl:if>
															</ul>
														</xsl:for-each>
													</xsl:if>
												</xsl:for-each>
											</ul>

										</div>
									</xsl:if>
									<!--FINE DATI PAGAMENTO-->

									<!--INIZIO ALLEGATI-->
									<xsl:if test="Allegati">
										<div id="allegati">
											<h3>Dati relativi agli allegati</h3>

											<xsl:for-each select="Allegati">
												<ul>
													<xsl:if test="NomeAttachment">
														<li>
															Nome dell'allegato:
															<span>
																<xsl:value-of select="NomeAttachment" />
															</span>
														</li>
													</xsl:if>
													<xsl:if test="AlgoritmoCompressione">
														<li>
															Algoritmo di compressione:
															<span>
																<xsl:value-of select="AlgoritmoCompressione" />
															</span>
														</li>
													</xsl:if>
													<xsl:if test="FormatoAttachment">
														<li>
															Formato:
															<span>
																<xsl:value-of select="FormatoAttachment" />
															</span>
														</li>
													</xsl:if>
													<xsl:if test="DescrizioneAttachment">
														<li>
															Descrizione:
															<span>
																<xsl:value-of select="DescrizioneAttachment" />
															</span>
														</li>
													</xsl:if>
												</ul>
											</xsl:for-each>
										</div>
									</xsl:if>
									<!--FINE ALLEGATI-->

									<div class="footer">
										Versione prodotta con foglio di stile SdI
										<a href="http://www.fatturapa.gov.it">www.fatturapa.gov.it</a>
									</div>
								</div>
							</xsl:for-each>
							<!--FINE BODY-->

						</div>
					</xsl:if>
				</div>
			</body>
		</html>
	</xsl:template>
</xsl:stylesheet>