/*
 * Decompiled with CFR 0.152.
 */
package invoicexpluginritenute;

import it.tnx.commons.CastUtils;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Locale;

public class FormatUtils {
    public static NumberFormat nf1;
    public static NumberFormat nf2;
    public static NumberFormat nf3;
    public static NumberFormat nf4;
    public static SimpleDateFormat mysqlf1;
    public static SimpleDateFormat mysqlf2;

    public static String formatEuroIta(double value) {
        value = FormatUtils.round(value, 2);
        return nf1.format(value);
    }

    public static String formatEuroItaMax5(double value) {
        value = FormatUtils.round(value, 5);
        return nf3.format(value);
    }

    public static String formatPerc(double value) {
        value = FormatUtils.round(value, 2);
        return nf2.format(value);
    }

    public static String formatNumNoDec(double value) {
        return nf4.format(value);
    }

    public static String formatHHMMIta(long millis) {
        int ore = (int)(millis / 1000L / 60L / 60L);
        int min = (int)(millis / 1000L / 60L) - ore * 60;
        return ore + ":" + (String.valueOf(min).length() == 1 ? "0" + min : Integer.valueOf(min));
    }

    public static String formatMysqlDate(Object date) {
        return mysqlf1.format(CastUtils.toDate((Object)date));
    }

    public static String formatMysqlTimestamp(Date date) {
        return mysqlf2.format(date);
    }

    public static String formatMysqlTimestamp(Timestamp timestamp) {
        return mysqlf2.format(timestamp);
    }

    public static double round(double x, int decimals) {
        int factor = 1;
        x = Double.parseDouble(String.format(Locale.ENGLISH, "%f", x));
        for (int i = 0; i < Math.abs(decimals); ++i) {
            factor *= 10;
        }
        x = decimals < 0 ? (double)((long)factor * Math.round(x / (double)factor)) : (double)Math.round((double)factor * x) / (double)factor;
        return x;
    }

    public static double round_old(double x, int decimals) {
        int i;
        int factor = 1;
        ++decimals;
        for (i = 0; i < Math.abs(decimals); ++i) {
            factor *= 10;
        }
        x = decimals < 0 ? (double)((long)factor * Math.round(x / (double)factor)) : (double)Math.round((double)factor * x) / (double)factor;
        --decimals;
        factor = 1;
        for (i = 0; i < Math.abs(decimals); ++i) {
            factor *= 10;
        }
        if (decimals < 0) {
            return (long)factor * Math.round(x / (double)factor);
        }
        return (double)Math.round((double)factor * x) / (double)factor;
    }

    public static String fill(String str, int chars) {
        if (str == null) {
            str = "";
        }
        if (str.length() > chars) {
            str = str.substring(0, chars);
        }
        int strlen = str.length();
        int fillerlen = chars;
        if (strlen <= chars) {
            fillerlen = chars - strlen;
        }
        char[] filler = new char[fillerlen];
        Arrays.fill(filler, ' ');
        return str + new String(filler);
    }

    public static String zeroFill(Number number, int size) {
        return String.format("%0" + size + "d", number);
    }

    public static String zeroFill(String number, int size) {
        return String.format("%0" + size + "d", CastUtils.toInteger0((Object)number));
    }

    static {
        mysqlf1 = new SimpleDateFormat("yyyy-MM-dd");
        mysqlf2 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss:S");
        nf1 = NumberFormat.getNumberInstance(Locale.ITALIAN);
        nf1.setMaximumFractionDigits(2);
        nf1.setMinimumFractionDigits(2);
        nf2 = new DecimalFormat("0.##");
        nf3 = NumberFormat.getNumberInstance(Locale.ITALIAN);
        nf3.setMaximumFractionDigits(5);
        nf3.setMinimumFractionDigits(2);
        nf4 = NumberFormat.getNumberInstance(Locale.ITALIAN);
        nf4.setMaximumFractionDigits(0);
    }
}

